/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Throwables;
import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class AbstractStructReaderTypesTest {
    private static List<String> NON_VALUE_GETTERS = Arrays.asList("getType", "getColumnCount", "getColumnIndex", "getColumnType");
    @Parameterized.Parameter(value=0)
    public Type type;
    @Parameterized.Parameter(value=1)
    public String implMethodName;
    @Parameterized.Parameter(value=2)
    public Object value;
    @Parameterized.Parameter(value=3)
    public String getterMethodName;
    @Parameterized.Parameter(value=4)
    @Nullable
    public List<String> otherAllowedGetters;
    private TestStructReader reader;

    @Parameterized.Parameters(name="{index}: {0}: {3}()={4}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Type.bool(), "getBooleanInternal", false, "getBoolean", Collections.singletonList("getValue")}, {Type.int64(), "getLongInternal", 123L, "getLong", Collections.singletonList("getValue")}, {Type.float64(), "getDoubleInternal", 2.0, "getDouble", Collections.singletonList("getValue")}, {Type.numeric(), "getBigDecimalInternal", BigDecimal.valueOf(21L, 1), "getBigDecimal", Collections.singletonList("getValue")}, {Type.string(), "getStringInternal", "a", "getString", Collections.singletonList("getValue")}, {Type.bytes(), "getBytesInternal", ByteArray.copyFrom((byte[])new byte[]{0}), "getBytes", Collections.singletonList("getValue")}, {Type.json(), "getJsonInternal", "{\"color\":\"red\",\"value\":\"#f00\"}", "getJson", Collections.singletonList("getValue")}, {Type.timestamp(), "getTimestampInternal", Timestamp.parseTimestamp((String)"2015-09-15T00:00:00Z"), "getTimestamp", Collections.singletonList("getValue")}, {Type.date(), "getDateInternal", Date.parseDate((String)"2015-09-15"), "getDate", Collections.singletonList("getValue")}, {Type.array((Type)Type.bool()), "getBooleanArrayInternal", new boolean[]{true, false}, "getBooleanArray", Arrays.asList("getBooleanList", "getValue")}, {Type.array((Type)Type.bool()), "getBooleanListInternal", Arrays.asList(false, true), "getBooleanList", Arrays.asList("getBooleanArray", "getValue")}, {Type.array((Type)Type.int64()), "getLongArrayInternal", new long[]{1L, 2L}, "getLongArray", Arrays.asList("getLongList", "getValue")}, {Type.array((Type)Type.int64()), "getLongListInternal", Arrays.asList(3L, 4L), "getLongList", Arrays.asList("getLongArray", "getValue")}, {Type.array((Type)Type.float64()), "getDoubleArrayInternal", new double[]{1.0, 2.0}, "getDoubleArray", Arrays.asList("getDoubleList", "getValue")}, {Type.array((Type)Type.float64()), "getDoubleListInternal", Arrays.asList(2.0, 4.0), "getDoubleList", Arrays.asList("getDoubleArray", "getValue")}, {Type.array((Type)Type.numeric()), "getBigDecimalListInternal", Arrays.asList(BigDecimal.valueOf(21L, 1), BigDecimal.valueOf(41L, 1)), "getBigDecimalList", Collections.singletonList("getValue")}, {Type.array((Type)Type.string()), "getStringListInternal", Arrays.asList("a", "b", "c"), "getStringList", Collections.singletonList("getValue")}, {Type.array((Type)Type.json()), "getJsonListInternal", Arrays.asList("{}", "{\"color\":\"red\",\"value\":\"#f00\"}", "[]"), "getJsonList", Collections.singletonList("getValue")}, {Type.array((Type)Type.bytes()), "getBytesListInternal", Arrays.asList(ByteArray.copyFrom((String)"a"), ByteArray.copyFrom((String)"b"), ByteArray.copyFrom((String)"c")), "getBytesList", Collections.singletonList("getValue")}, {Type.array((Type)Type.timestamp()), "getTimestampListInternal", Arrays.asList(Timestamp.parseTimestamp((String)"2015-09-15T00:00:00Z"), Timestamp.parseTimestamp((String)"2015-09-14T00:00:00Z")), "getTimestampList", Collections.singletonList("getValue")}, {Type.array((Type)Type.date()), "getDateListInternal", Arrays.asList(Date.parseDate((String)"2015-09-15"), Date.parseDate((String)"2015-09-14")), "getDateList", Collections.singletonList("getValue")}, {Type.array((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64())})), "getStructListInternal", Arrays.asList(((Struct.Builder)Struct.newBuilder().set("f1").to(1L)).build(), ((Struct.Builder)Struct.newBuilder().set("f1").to(2L)).build(), ((Struct.Builder)Struct.newBuilder().set("f1").to(3L)).build()), "getStructList", Collections.singletonList("getValue")});
    }

    @Before
    public void setUp() {
        this.reader = (TestStructReader)((Object)Mockito.spy((Object)((Object)new TestStructReader())));
    }

    private Object getterByIndex(int columnIndex) {
        return this.getterByIndex(this.getterMethodName, columnIndex);
    }

    private Object getterByIndex(String methodName, int columnIndex) {
        try {
            return ((Object)((Object)this.reader)).getClass().getMethod(methodName, Integer.TYPE).invoke((Object)this.reader, columnIndex);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getterByName(String columnName) {
        return this.getterByName(this.getterMethodName, columnName);
    }

    private Object getterByName(String methodName, String columnName) {
        try {
            return ((Object)((Object)this.reader)).getClass().getMethod(methodName, String.class).invoke((Object)this.reader, columnName);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void getter() throws Exception {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F0", (Type)Type.int64()), Type.StructField.of((String)"F1", (Type)this.type)}));
        int columnIndex = 1;
        Mockito.when((Object)this.reader.isNull(columnIndex)).thenReturn((Object)false);
        Mockito.when((Object)((Object)((Object)this.reader)).getClass().getDeclaredMethod(this.implMethodName, Integer.TYPE).invoke((Object)this.reader, columnIndex)).thenReturn(this.value);
        Truth.assertThat((Object)this.getterByIndex(columnIndex)).isEqualTo(this.value);
        Truth.assertThat((Object)this.getterByName("F1")).isEqualTo(this.value);
    }

    @Test
    public void getterForIncorrectType() {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F1", (Type)this.type)}));
        int columnIndex = 0;
        Mockito.when((Object)this.reader.isNull(columnIndex)).thenReturn((Object)false);
        for (Method method : StructReader.class.getMethods()) {
            if (NON_VALUE_GETTERS.contains(method.getName()) || !method.getName().startsWith("get") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE || method.getName().equals(this.getterMethodName) || this.otherAllowedGetters != null && this.otherAllowedGetters.contains(method.getName())) continue;
            IllegalStateException getterByIndexException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.getterByIndex(method.getName(), columnIndex));
            Truth.assertWithMessage((String)("Exception for " + method)).that(getterByIndexException.getMessage()).contains((CharSequence)("was " + this.type));
            Truth.assertWithMessage((String)("Exception for " + method)).that(getterByIndexException.getMessage()).contains((CharSequence)("Column " + columnIndex));
            IllegalStateException getterByNameException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.getterByName(method.getName(), "F1"));
            Truth.assertWithMessage((String)("Exception for " + method)).that(getterByNameException.getMessage()).contains((CharSequence)("was " + this.type));
            Truth.assertWithMessage((String)("Exception for " + method)).that(getterByNameException.getMessage()).contains((CharSequence)"Column F1");
        }
    }

    @Test
    public void getterWhenNull() {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F1", (Type)this.type)}));
        Mockito.when((Object)this.reader.isNull(0)).thenReturn((Object)true);
        NullPointerException ex = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.getterByIndex(0));
        Assert.assertNotNull((Object)ex.getMessage());
    }

    @Test
    public void getterByNameWhenNull() {
        Mockito.when((Object)this.reader.getType()).thenReturn((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"F1", (Type)this.type)}));
        Mockito.when((Object)this.reader.isNull(0)).thenReturn((Object)true);
        NullPointerException ex = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> this.getterByName("F1"));
        Assert.assertNotNull((Object)ex.getMessage());
    }

    private static class TestStructReader
    extends AbstractStructReader {
        private TestStructReader() {
        }

        protected boolean getBooleanInternal(int columnIndex) {
            return false;
        }

        protected long getLongInternal(int columnIndex) {
            return 0L;
        }

        protected double getDoubleInternal(int columnIndex) {
            return 0.0;
        }

        protected BigDecimal getBigDecimalInternal(int columnIndex) {
            return null;
        }

        protected String getStringInternal(int columnIndex) {
            return null;
        }

        protected String getJsonInternal(int columnIndex) {
            return null;
        }

        protected ByteArray getBytesInternal(int columnIndex) {
            return null;
        }

        protected Timestamp getTimestampInternal(int columnIndex) {
            return null;
        }

        protected Date getDateInternal(int columnIndex) {
            return null;
        }

        protected Value getValueInternal(int columnIndex) {
            return null;
        }

        protected boolean[] getBooleanArrayInternal(int columnIndex) {
            return null;
        }

        protected List<Boolean> getBooleanListInternal(int columnIndex) {
            return null;
        }

        protected long[] getLongArrayInternal(int columnIndex) {
            return null;
        }

        protected List<Long> getLongListInternal(int columnIndex) {
            return null;
        }

        protected double[] getDoubleArrayInternal(int columnIndex) {
            return null;
        }

        protected List<Double> getDoubleListInternal(int columnIndex) {
            return null;
        }

        protected List<BigDecimal> getBigDecimalListInternal(int columnIndex) {
            return null;
        }

        protected List<String> getStringListInternal(int columnIndex) {
            return null;
        }

        protected List<String> getJsonListInternal(int columnIndex) {
            return null;
        }

        protected List<ByteArray> getBytesListInternal(int columnIndex) {
            return null;
        }

        protected List<Timestamp> getTimestampListInternal(int columnIndex) {
            return null;
        }

        protected List<Date> getDateListInternal(int columnIndex) {
            return null;
        }

        protected List<Struct> getStructListInternal(int columnIndex) {
            return null;
        }

        public Type getType() {
            return null;
        }

        public boolean isNull(int columnIndex) {
            return false;
        }
    }
}

