/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.BackupInfo;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.encryption.EncryptionInfo;
import com.google.common.truth.Truth;
import com.google.rpc.Code;
import com.google.rpc.Status;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class BackupTest {
    private static final String NAME = "projects/test-project/instances/test-instance/backups/backup-1";
    private static final String DB = "projects/test-project/instances/test-instance/databases/db-1";
    private static final Timestamp EXP_TIME = Timestamp.ofTimeSecondsAndNanos((long)1000L, (int)1000);
    private static final Timestamp VERSION_TIME = Timestamp.ofTimeSecondsAndNanos((long)2000L, (int)2000);
    public static final String KMS_KEY_VERSION = "key-version";
    private static final com.google.spanner.admin.database.v1.EncryptionInfo ENCRYPTION_INFO = com.google.spanner.admin.database.v1.EncryptionInfo.newBuilder().setEncryptionType(EncryptionInfo.Type.CUSTOMER_MANAGED_ENCRYPTION).setEncryptionStatus(Status.newBuilder().setCode(Code.OK.getNumber())).setKmsKeyVersion("key-version").build();
    @Mock
    DatabaseAdminClient dbClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.dbClient.newBackupBuilder((BackupId)Mockito.any(BackupId.class))).thenAnswer(invocation -> new Backup.Builder(this.dbClient, (BackupId)invocation.getArguments()[0]));
    }

    @Test
    public void build() {
        Timestamp expireTime = Timestamp.now();
        Timestamp versionTime = Timestamp.ofTimeMicroseconds((long)10L);
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"instance-id", (String)"backup-id")).setDatabase(DatabaseId.of((String)"test-project", (String)"instance-id", (String)"src-database")).setExpireTime(expireTime).setVersionTime(versionTime).setSize(100L).setState(BackupInfo.State.CREATING).build();
        Backup copy = backup.toBuilder().build();
        Truth.assertThat((Object)copy.getId()).isEqualTo((Object)backup.getId());
        Truth.assertThat((Object)copy.getDatabase()).isEqualTo((Object)backup.getDatabase());
        Truth.assertThat((Comparable)copy.getExpireTime()).isEqualTo((Object)backup.getExpireTime());
        Truth.assertThat((Comparable)copy.getVersionTime()).isEqualTo((Object)backup.getVersionTime());
        Truth.assertThat((Long)copy.getSize()).isEqualTo((Object)backup.getSize());
        Truth.assertThat((Comparable)copy.getState()).isEqualTo((Object)backup.getState());
    }

    @Test
    public void create() {
        Timestamp expireTime = Timestamp.now();
        Timestamp versionTime = Timestamp.ofTimeMicroseconds((long)10L);
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"instance-id", (String)"backup-id")).setDatabase(DatabaseId.of((String)"test-project", (String)"instance-id", (String)"src-database")).setExpireTime(expireTime).setVersionTime(versionTime).build();
        backup.create();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).createBackup(backup);
    }

    @Test
    public void createWithoutVersionTimeShouldSucceed() {
        Timestamp expireTime = Timestamp.now();
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"instance-id", (String)"backup-id")).setDatabase(DatabaseId.of((String)"test-project", (String)"instance-id", (String)"src-database")).setExpireTime(expireTime).build();
        backup.create();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).createBackup(backup);
    }

    @Test
    public void exists() {
        Mockito.when((Object)this.dbClient.getBackup("test-instance", "test-backup")).thenReturn((Object)new Backup.Builder(this.dbClient, BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build());
        Mockito.when((Object)this.dbClient.getBackup("other-instance", "other-backup")).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.NOT_FOUND, (String)"backup not found")});
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        Truth.assertThat((Boolean)backup.exists()).isTrue();
        Backup otherBackup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"other-instance", (String)"other-backup")).build();
        Truth.assertThat((Boolean)otherBackup.exists()).isFalse();
    }

    @Test
    public void isReady() {
        Mockito.when((Object)this.dbClient.getBackup("test-instance", "test-backup")).thenReturn((Object)new Backup.Builder(this.dbClient, BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).setState(BackupInfo.State.READY).build());
        Mockito.when((Object)this.dbClient.getBackup("other-instance", "other-backup")).thenReturn((Object)new Backup.Builder(this.dbClient, BackupId.of((String)"test-project", (String)"other-instance", (String)"other-backup")).setState(BackupInfo.State.CREATING).build());
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).setState(BackupInfo.State.UNSPECIFIED).build();
        Truth.assertThat((Boolean)backup.isReady()).isTrue();
        Truth.assertThat((Comparable)backup.getState()).isEqualTo((Object)BackupInfo.State.UNSPECIFIED);
        Backup otherBackup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"other-instance", (String)"other-backup")).setState(BackupInfo.State.READY).build();
        Truth.assertThat((Boolean)otherBackup.isReady()).isFalse();
        Truth.assertThat((Comparable)otherBackup.getState()).isEqualTo((Object)BackupInfo.State.READY);
    }

    @Test
    public void reload() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        backup.reload();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).getBackup("test-instance", "test-backup");
    }

    @Test
    public void delete() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        backup.delete();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).deleteBackup("test-instance", "test-backup");
    }

    @Test
    public void updateExpireTime() {
        Timestamp expireTime = Timestamp.now();
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).setExpireTime(expireTime).build();
        backup.updateExpireTime();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).updateBackup("test-instance", "test-backup", expireTime);
    }

    @Test
    public void updateExpireTimeWithoutExpireTime() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> backup.updateExpireTime());
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void restore() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"backup-instance", (String)"test-backup")).build();
        backup.restore(DatabaseId.of((String)"test-project", (String)"db-instance", (String)"test-database"));
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).restoreDatabase("backup-instance", "test-backup", "db-instance", "test-database");
    }

    @Test
    public void restoreWithoutDestination() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> backup.restore(null));
        Assert.assertNull((Object)e.getMessage());
    }

    @Test
    public void listBackupOperations() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"backup-id")).build();
        backup.listBackupOperations();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listBackupOperations("test-instance", new Options.ListOption[]{Options.filter((String)"name:backups/backup-id")});
    }

    @Test
    public void getIAMPolicy() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        backup.getIAMPolicy();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).getBackupIAMPolicy("test-instance", "test-backup");
    }

    @Test
    public void setIAMPolicy() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        Policy policy = Policy.newBuilder().addIdentity(Role.editor(), Identity.user((String)"joe@example.com"), new Identity[0]).build();
        backup.setIAMPolicy(policy);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).setBackupIAMPolicy("test-instance", "test-backup", policy);
    }

    @Test
    public void testIAMPermissions() {
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).build();
        List<String> permissions = Collections.singletonList("read");
        backup.testIAMPermissions(permissions);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).testBackupIAMPermissions("test-instance", "test-backup", permissions);
    }

    @Test
    public void fromProto() {
        Backup backup = this.createBackup();
        Truth.assertThat((String)backup.getId().getName()).isEqualTo((Object)NAME);
        Truth.assertThat((Comparable)backup.getState()).isEqualTo((Object)BackupInfo.State.CREATING);
        Truth.assertThat((Comparable)backup.getExpireTime()).isEqualTo((Object)EXP_TIME);
        Truth.assertThat((Comparable)backup.getVersionTime()).isEqualTo((Object)VERSION_TIME);
        Truth.assertThat((Object)backup.getEncryptionInfo()).isEqualTo((Object)EncryptionInfo.fromProtoOrNull((com.google.spanner.admin.database.v1.EncryptionInfo)ENCRYPTION_INFO));
    }

    @Test
    public void testEqualsAndHashCode() {
        Backup backup1 = this.createBackup();
        Backup backup2 = this.createBackup();
        Assert.assertEquals((Object)backup1, (Object)backup2);
        Assert.assertEquals((long)backup1.hashCode(), (long)backup2.hashCode());
    }

    private Backup createBackup() {
        com.google.spanner.admin.database.v1.Backup proto = com.google.spanner.admin.database.v1.Backup.newBuilder().setName(NAME).setDatabase(DB).setExpireTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(1000L).setNanos(1000).build()).setVersionTime(com.google.protobuf.Timestamp.newBuilder().setSeconds(2000L).setNanos(2000).build()).setEncryptionInfo(ENCRYPTION_INFO).setState(Backup.State.CREATING).build();
        return Backup.fromProto((com.google.spanner.admin.database.v1.Backup)proto, (DatabaseAdminClient)this.dbClient);
    }
}

