/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.BackupInfo;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseAdminClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.OperationFutureUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Restore;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.encryption.BackupEncryptionConfig;
import com.google.cloud.spanner.encryption.EncryptionConfigs;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.iam.v1.Binding;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DatabaseAdminClientImplTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String INSTANCE_NAME = "projects/my-project/instances/my-instance";
    private static final String DB_ID = "my-db";
    private static final String DB_NAME = "projects/my-project/instances/my-instance/databases/my-db";
    private static final String DB_NAME2 = "projects/my-project/instances/my-instance/databases/my-db2";
    private static final String BK_ID = "my-bk";
    private static final String BK_NAME = "projects/my-project/instances/my-instance/backups/my-bk";
    private static final String BK_NAME2 = "projects/my-project/instances/my-instance/backups/my-bk2";
    private static final Timestamp EARLIEST_VERSION_TIME = Timestamp.now();
    private static final String VERSION_RETENTION_PERIOD = "7d";
    private static final String KMS_KEY_NAME = "projects/my-project/locations/some-location/keyRings/my-keyring/cryptoKeys/my-key";
    private static final String KMS_KEY_VERSION = "1";
    @Mock
    SpannerRpc rpc;
    DatabaseAdminClientImpl client;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.client = new DatabaseAdminClientImpl(PROJECT_ID, this.rpc);
    }

    private com.google.spanner.admin.database.v1.Database getDatabaseProto() {
        return com.google.spanner.admin.database.v1.Database.newBuilder().setName(DB_NAME).setState(Database.State.READY).setEarliestVersionTime(EARLIEST_VERSION_TIME.toProto()).setVersionRetentionPeriod(VERSION_RETENTION_PERIOD).build();
    }

    private com.google.spanner.admin.database.v1.Database getEncryptedDatabaseProto() {
        return this.getDatabaseProto().toBuilder().setEncryptionConfig(EncryptionConfig.newBuilder().setKmsKeyName(KMS_KEY_NAME).build()).build();
    }

    private com.google.spanner.admin.database.v1.Database getAnotherDatabaseProto() {
        return com.google.spanner.admin.database.v1.Database.newBuilder().setName(DB_NAME2).setState(Database.State.READY).build();
    }

    static Any toAny(Message message) {
        return Any.newBuilder().setTypeUrl("type.googleapis.com/" + message.getDescriptorForType().getFullName()).setValue(message.toByteString()).build();
    }

    private com.google.spanner.admin.database.v1.Backup getBackupProto() {
        return com.google.spanner.admin.database.v1.Backup.newBuilder().setName(BK_NAME).setDatabase(DB_NAME).setState(Backup.State.READY).build();
    }

    private com.google.spanner.admin.database.v1.Backup getEncryptedBackupProto() {
        return com.google.spanner.admin.database.v1.Backup.newBuilder().setName(BK_NAME).setDatabase(DB_NAME).setState(Backup.State.READY).setEncryptionInfo(EncryptionInfo.newBuilder().setKmsKeyVersion(KMS_KEY_VERSION).build()).build();
    }

    private com.google.spanner.admin.database.v1.Backup getAnotherBackupProto() {
        return com.google.spanner.admin.database.v1.Backup.newBuilder().setName(BK_NAME2).setDatabase(DB_NAME2).setState(Backup.State.READY).build();
    }

    @Test
    public void getDatabase() {
        Mockito.when((Object)this.rpc.getDatabase(DB_NAME)).thenReturn((Object)this.getDatabaseProto());
        Database db = this.client.getDatabase(INSTANCE_ID, DB_ID);
        Truth.assertThat((String)db.getId().getName()).isEqualTo((Object)DB_NAME);
        Truth.assertThat((Comparable)db.getState()).isEqualTo((Object)DatabaseInfo.State.READY);
        Truth.assertThat((Comparable)db.getEarliestVersionTime()).isEqualTo((Object)EARLIEST_VERSION_TIME);
        Truth.assertThat((String)db.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
    }

    @Test
    public void createDatabase() throws Exception {
        OperationFuture<com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createDatabase", this.getDatabaseProto(), CreateDatabaseMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.createDatabase(INSTANCE_NAME, "CREATE DATABASE `my-db`", Collections.emptyList(), new Database(DatabaseId.of((String)DB_NAME), DatabaseInfo.State.UNSPECIFIED, (DatabaseAdminClient)this.client))).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createDatabase(INSTANCE_ID, DB_ID, Collections.emptyList());
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Database)op.get()).getId().getName()).isEqualTo((Object)DB_NAME);
    }

    @Test
    public void createEncryptedDatabase() throws Exception {
        Database database = this.client.newDatabaseBuilder(DatabaseId.of((String)DB_NAME)).setEncryptionConfig(EncryptionConfigs.customerManagedEncryption((String)KMS_KEY_NAME)).build();
        OperationFuture<com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createDatabase", this.getEncryptedDatabaseProto(), CreateDatabaseMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.createDatabase(INSTANCE_NAME, "CREATE DATABASE `my-db`", Collections.emptyList(), database)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createDatabase(database, Collections.emptyList());
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Database)op.get()).getId().getName()).isEqualTo((Object)DB_NAME);
    }

    @Test
    public void updateDatabaseDdl() throws Exception {
        String opName = "projects/my-project/instances/my-instance/databases/my-db/operations/myop";
        String opId = "myop";
        ImmutableList ddl = ImmutableList.of();
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture(opName, Empty.getDefaultInstance(), UpdateDatabaseDdlMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateDatabaseDdl(DB_NAME, (Iterable)ddl, opId)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.updateDatabaseDdl(INSTANCE_ID, DB_ID, (Iterable)ddl, opId);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)op.getName()).isEqualTo((Object)opName);
    }

    @Test
    public void updateDatabaseDdlOpAlreadyExists() throws Exception {
        String originalOpName = "projects/my-project/instances/my-instance/databases/my-db/operations/originalop";
        ImmutableList ddl = ImmutableList.of();
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> originalOp = OperationFutureUtil.immediateOperationFuture(originalOpName, Empty.getDefaultInstance(), UpdateDatabaseDdlMetadata.getDefaultInstance());
        String newOpId = "newop";
        Mockito.when((Object)this.rpc.updateDatabaseDdl(DB_NAME, (Iterable)ddl, newOpId)).thenReturn(originalOp);
        OperationFuture op = this.client.updateDatabaseDdl(INSTANCE_ID, DB_ID, (Iterable)ddl, newOpId);
        Truth.assertThat((String)op.getName()).isEqualTo((Object)originalOpName);
    }

    @Test
    public void dropDatabase() {
        this.client.dropDatabase(INSTANCE_ID, DB_ID);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).dropDatabase(DB_NAME);
    }

    @Test
    public void getDatabaseDdl() {
        ImmutableList ddl = ImmutableList.of((Object)"CREATE TABLE mytable()");
        Mockito.when((Object)this.rpc.getDatabaseDdl(DB_NAME)).thenReturn((Object)ddl);
        Truth.assertThat((Iterable)this.client.getDatabaseDdl(INSTANCE_ID, DB_ID)).isEqualTo((Object)ddl);
    }

    @Test
    public void listDatabases() {
        String pageToken = "token";
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, null)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getDatabaseProto()), pageToken));
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, pageToken)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getAnotherDatabaseProto()), ""));
        ArrayList dbs = Lists.newArrayList((Iterable)this.client.listDatabases(INSTANCE_ID, new Options.ListOption[]{Options.pageSize((int)1)}).iterateAll());
        Truth.assertThat((String)((Database)dbs.get(0)).getId().getName()).isEqualTo((Object)DB_NAME);
        Truth.assertThat((String)((Database)dbs.get(1)).getId().getName()).isEqualTo((Object)DB_NAME2);
        Truth.assertThat((Integer)dbs.size()).isEqualTo((Object)2);
    }

    @Test
    public void listDatabasesError() {
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, null)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Test error")});
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.client.listDatabases(INSTANCE_ID, new Options.ListOption[]{Options.pageSize((int)1)}));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)INSTANCE_NAME);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"with pageToken <null>");
    }

    @Test
    public void listDatabaseErrorWithToken() {
        String pageToken = "token";
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, null)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getDatabaseProto()), pageToken));
        Mockito.when((Object)this.rpc.listDatabases(INSTANCE_NAME, 1, pageToken)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Test error")});
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Lists.newArrayList((Iterable)this.client.listDatabases(INSTANCE_ID, new Options.ListOption[]{Options.pageSize((int)1)}).iterateAll()));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)INSTANCE_NAME);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)String.format("with pageToken %s", pageToken));
    }

    @Test
    public void getDatabaseIAMPolicy() {
        Mockito.when((Object)this.rpc.getDatabaseAdminIAMPolicy(DB_NAME)).thenReturn((Object)com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().addMembers("user:joe@example.com").setRole("roles/viewer").build()).build());
        Policy policy = this.client.getDatabaseIAMPolicy(INSTANCE_ID, DB_ID);
        Truth.assertThat((Map)policy.getBindings()).containsExactly((Object)Role.viewer(), (Object)Sets.newHashSet((Object[])new Identity[]{Identity.user((String)"joe@example.com")}), new Object[0]);
        Mockito.when((Object)this.rpc.getDatabaseAdminIAMPolicy(DB_NAME)).thenReturn((Object)com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().addAllMembers(Arrays.asList("allAuthenticatedUsers", "domain:google.com")).setRole("roles/viewer").build()).build());
        policy = this.client.getDatabaseIAMPolicy(INSTANCE_ID, DB_ID);
        Truth.assertThat((Map)policy.getBindings()).containsExactly((Object)Role.viewer(), (Object)Sets.newHashSet((Object[])new Identity[]{Identity.allAuthenticatedUsers(), Identity.domain((String)"google.com")}), new Object[0]);
    }

    @Test
    public void setDatabaseIAMPolicy() {
        ByteString etag = ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)"v1"));
        String etagEncoded = BaseEncoding.base64().encode(etag.toByteArray());
        com.google.iam.v1.Policy proto = com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/viewer").addMembers("user:joe@example.com").build()).setEtag(etag).build();
        Mockito.when((Object)this.rpc.setDatabaseAdminIAMPolicy(DB_NAME, proto)).thenReturn((Object)proto);
        Policy policy = Policy.newBuilder().addIdentity(Role.viewer(), Identity.user((String)"joe@example.com"), new Identity[0]).setEtag(etagEncoded).build();
        Policy updated = this.client.setDatabaseIAMPolicy(INSTANCE_ID, DB_ID, policy);
        Truth.assertThat((Object)updated).isEqualTo((Object)policy);
    }

    @Test
    public void testDatabaseIAMPermissions() {
        List<String> permissions = Arrays.asList("spanner.databases.select", "spanner.databases.write");
        Mockito.when((Object)this.rpc.testDatabaseAdminIAMPermissions(DB_NAME, permissions)).thenReturn((Object)TestIamPermissionsResponse.newBuilder().addPermissions("spanner.databases.select").build());
        Iterable allowed = this.client.testDatabaseIAMPermissions(INSTANCE_ID, DB_ID, permissions);
        Truth.assertThat((Iterable)allowed).containsExactly(new Object[]{"spanner.databases.select"});
    }

    @Test
    public void createBackupWithParams() throws Exception {
        OperationFuture<com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createBackup", this.getBackupProto(), CreateBackupMetadata.getDefaultInstance());
        Timestamp t = Timestamp.ofTimeMicroseconds((long)(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) + TimeUnit.HOURS.toMicros(28L)));
        Backup backup = this.client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID)).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(t).build();
        Mockito.when((Object)this.rpc.createBackup(backup)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createBackup(INSTANCE_ID, BK_ID, DB_ID, t);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Backup)op.get()).getId().getName()).isEqualTo((Object)BK_NAME);
    }

    @Test
    public void createBackupWithBackupObject() throws ExecutionException, InterruptedException {
        OperationFuture<com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createBackup", this.getBackupProto(), CreateBackupMetadata.getDefaultInstance());
        Timestamp expireTime = Timestamp.ofTimeMicroseconds((long)(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) + TimeUnit.HOURS.toMicros(28L)));
        Timestamp versionTime = Timestamp.ofTimeMicroseconds((long)(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) - TimeUnit.DAYS.toMicros(2L)));
        Backup requestBackup = this.client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID)).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(expireTime).setVersionTime(versionTime).build();
        Mockito.when((Object)this.rpc.createBackup(requestBackup)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createBackup(requestBackup);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Backup)op.get()).getId().getName()).isEqualTo((Object)BK_NAME);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBackupNoExpireTime() {
        Backup requestBackup = this.client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID)).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).build();
        this.client.createBackup(requestBackup);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBackupNoDatabase() {
        Backup requestBackup = this.client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID)).setExpireTime(Timestamp.now()).build();
        this.client.createBackup(requestBackup);
    }

    @Test
    public void createEncryptedBackup() throws ExecutionException, InterruptedException {
        OperationFuture<com.google.spanner.admin.database.v1.Backup, CreateBackupMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createBackup", this.getEncryptedBackupProto(), CreateBackupMetadata.getDefaultInstance());
        Timestamp t = Timestamp.ofTimeMicroseconds((long)(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) + TimeUnit.HOURS.toMicros(28L)));
        Backup backup = this.client.newBackupBuilder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID)).setDatabase(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).setExpireTime(t).setEncryptionConfig((BackupEncryptionConfig)EncryptionConfigs.customerManagedEncryption((String)KMS_KEY_NAME)).build();
        Mockito.when((Object)this.rpc.createBackup(backup)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createBackup(backup);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Backup)op.get()).getId().getName()).isEqualTo((Object)BK_NAME);
        Truth.assertThat((String)((Backup)op.get()).getEncryptionInfo().getKmsKeyVersion()).isEqualTo((Object)KMS_KEY_VERSION);
    }

    @Test
    public void deleteBackup() {
        this.client.deleteBackup(INSTANCE_ID, BK_ID);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).deleteBackup(BK_NAME);
    }

    @Test
    public void getBackup() {
        Mockito.when((Object)this.rpc.getBackup(BK_NAME)).thenReturn((Object)this.getBackupProto());
        Backup bk = this.client.getBackup(INSTANCE_ID, BK_ID);
        BackupId bid = BackupId.of((String)bk.getId().getName());
        Truth.assertThat((String)bid.getName()).isEqualTo((Object)BK_NAME);
        Truth.assertThat((Comparable)bk.getState()).isEqualTo((Object)BackupInfo.State.READY);
    }

    @Test
    public void listBackups() {
        String pageToken = "token";
        Mockito.when((Object)this.rpc.listBackups(INSTANCE_NAME, 1, null, null)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getBackupProto()), pageToken));
        Mockito.when((Object)this.rpc.listBackups(INSTANCE_NAME, 1, null, pageToken)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getAnotherBackupProto()), ""));
        ArrayList backups = Lists.newArrayList((Iterable)this.client.listBackups(INSTANCE_ID, new Options.ListOption[]{Options.pageSize((int)1)}).iterateAll());
        Truth.assertThat((String)((Backup)backups.get(0)).getId().getName()).isEqualTo((Object)BK_NAME);
        Truth.assertThat((String)((Backup)backups.get(1)).getId().getName()).isEqualTo((Object)BK_NAME2);
        Truth.assertThat((Integer)backups.size()).isEqualTo((Object)2);
    }

    @Test
    public void updateBackup() {
        Timestamp t = Timestamp.ofTimeMicroseconds((long)(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) + TimeUnit.HOURS.toMicros(28L)));
        com.google.spanner.admin.database.v1.Backup backup = com.google.spanner.admin.database.v1.Backup.newBuilder().setName(BK_NAME).setExpireTime(t.toProto()).build();
        Mockito.when((Object)this.rpc.updateBackup(backup, FieldMask.newBuilder().addPaths("expire_time").build())).thenReturn((Object)com.google.spanner.admin.database.v1.Backup.newBuilder().setName(BK_NAME).setDatabase(DB_NAME).setExpireTime(t.toProto()).build());
        Backup updatedBackup = this.client.updateBackup(INSTANCE_ID, BK_ID, t);
        Truth.assertThat((Comparable)updatedBackup.getExpireTime()).isEqualTo((Object)t);
    }

    @Test
    public void restoreDatabase() throws Exception {
        OperationFuture<com.google.spanner.admin.database.v1.Database, RestoreDatabaseMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("restoreDatabase", this.getDatabaseProto(), RestoreDatabaseMetadata.getDefaultInstance());
        Restore restore = new Restore.Builder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID), DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).build();
        Mockito.when((Object)this.rpc.restoreDatabase(restore)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.restoreDatabase(restore);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Database)op.get()).getId().getName()).isEqualTo((Object)DB_NAME);
    }

    @Test
    public void restoreEncryptedDatabase() throws Exception {
        OperationFuture<com.google.spanner.admin.database.v1.Database, RestoreDatabaseMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("restoreEncryptedDatabase", this.getEncryptedDatabaseProto(), RestoreDatabaseMetadata.getDefaultInstance());
        Restore restore = new Restore.Builder(BackupId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)BK_ID), DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DB_ID)).build();
        Mockito.when((Object)this.rpc.restoreDatabase(restore)).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.restoreDatabase(restore);
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Database)op.get()).getId().getName()).isEqualTo((Object)DB_NAME);
        Truth.assertThat((String)((Database)op.get()).getEncryptionConfig().getKmsKeyName()).isEqualTo((Object)KMS_KEY_NAME);
    }
}

