/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.encryption.EncryptionConfigs;
import com.google.common.truth.Truth;
import com.google.rpc.Code;
import com.google.rpc.Status;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DatabaseTest {
    private static final String NAME = "projects/test-project/instances/test-instance/databases/database-1";
    private static final Timestamp EARLIEST_VERSION_TIME = Timestamp.now();
    private static final String VERSION_RETENTION_PERIOD = "7d";
    private static final String KMS_KEY_NAME = "kms-key-name";
    private static final String KMS_KEY_VERSION = "kms-key-version";
    private static final EncryptionConfig ENCRYPTION_CONFIG = EncryptionConfig.newBuilder().setKmsKeyName("kms-key-name").build();
    private static final List<EncryptionInfo> ENCRYPTION_INFOS = Collections.singletonList(EncryptionInfo.newBuilder().setEncryptionType(EncryptionInfo.Type.CUSTOMER_MANAGED_ENCRYPTION).setEncryptionStatus(Status.newBuilder().setCode(Code.OK.getNumber())).setKmsKeyVersion("kms-key-version").build());
    private static final String DEFAULT_LEADER = "default-leader";
    @Mock
    DatabaseAdminClient dbClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.dbClient.newBackupBuilder((BackupId)Mockito.any(BackupId.class))).thenAnswer(invocation -> new Backup.Builder(this.dbClient, (BackupId)invocation.getArguments()[0]));
        Mockito.when((Object)this.dbClient.newDatabaseBuilder((DatabaseId)Mockito.any(DatabaseId.class))).thenAnswer(invocation -> new Database.Builder(this.dbClient, (DatabaseId)invocation.getArguments()[0]));
    }

    @Test
    public void backup() {
        Timestamp expireTime = Timestamp.now();
        Database db = this.createDatabase();
        Backup backup = this.dbClient.newBackupBuilder(BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup")).setExpireTime(expireTime).build();
        db.backup(backup);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).createBackup(backup.toBuilder().setDatabase(db.getId()).build());
    }

    @Test
    public void listDatabaseOperations() {
        Database db = this.createDatabase();
        db.listDatabaseOperations();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listDatabaseOperations("test-instance", new Options.ListOption[]{Options.filter((String)"name:databases/database-1")});
    }

    @Test
    public void fromProto() {
        Database db = this.createDatabase();
        Assert.assertEquals((Object)NAME, (Object)db.getId().getName());
        Assert.assertEquals((Object)DatabaseInfo.State.CREATING, (Object)db.getState());
        Assert.assertEquals((Object)VERSION_RETENTION_PERIOD, (Object)db.getVersionRetentionPeriod());
        Assert.assertEquals((Object)EARLIEST_VERSION_TIME, (Object)db.getEarliestVersionTime());
        Assert.assertEquals((Object)EncryptionConfigs.customerManagedEncryption((String)KMS_KEY_NAME), (Object)db.getEncryptionConfig());
        Assert.assertEquals((Object)DEFAULT_LEADER, (Object)db.getDefaultLeader());
    }

    @Test
    public void testBuildWithEncryptionConfig() {
        Database db = this.dbClient.newDatabaseBuilder(DatabaseId.of((String)"my-project", (String)"my-instance", (String)"my-database")).setEncryptionConfig(EncryptionConfigs.customerManagedEncryption((String)"projects/my-project/locations/some-location/keyRings/my-keyring/cryptoKeys/my-key")).build();
        Truth.assertThat((Object)db.getEncryptionConfig()).isNotNull();
        Truth.assertThat((String)db.getEncryptionConfig().getKmsKeyName()).isEqualTo((Object)"projects/my-project/locations/some-location/keyRings/my-keyring/cryptoKeys/my-key");
    }

    @Test
    public void testBuildWithDefaultLeader() {
        Database db = this.dbClient.newDatabaseBuilder(DatabaseId.of((String)"my-project", (String)"my-instance", (String)"my-database")).setDefaultLeader(DEFAULT_LEADER).build();
        Assert.assertEquals((Object)DEFAULT_LEADER, (Object)db.getDefaultLeader());
    }

    @Test
    public void getIAMPolicy() {
        Database database = new Database(DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"), DatabaseInfo.State.READY, this.dbClient);
        database.getIAMPolicy();
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).getDatabaseIAMPolicy("test-instance", "test-database");
    }

    @Test
    public void setIAMPolicy() {
        Database database = new Database(DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"), DatabaseInfo.State.READY, this.dbClient);
        Policy policy = Policy.newBuilder().addIdentity(Role.editor(), Identity.user((String)"joe@example.com"), new Identity[0]).build();
        database.setIAMPolicy(policy);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).setDatabaseIAMPolicy("test-instance", "test-database", policy);
    }

    @Test
    public void testIAMPermissions() {
        Database database = new Database(DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"), DatabaseInfo.State.READY, this.dbClient);
        List<String> permissions = Collections.singletonList("read");
        database.testIAMPermissions(permissions);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).testDatabaseIAMPermissions("test-instance", "test-database", permissions);
    }

    @Test
    public void testEqualsAndHashCode() {
        Database database1 = this.createDatabase();
        Database database2 = this.createDatabase();
        Assert.assertEquals((Object)database1, (Object)database2);
        Assert.assertEquals((long)database1.hashCode(), (long)database2.hashCode());
    }

    private Database createDatabase() {
        com.google.spanner.admin.database.v1.Database proto = com.google.spanner.admin.database.v1.Database.newBuilder().setName(NAME).setState(Database.State.CREATING).setEarliestVersionTime(EARLIEST_VERSION_TIME.toProto()).setVersionRetentionPeriod(VERSION_RETENTION_PERIOD).setEncryptionConfig(ENCRYPTION_CONFIG).addAllEncryptionInfo(ENCRYPTION_INFOS).setDefaultLeader(DEFAULT_LEADER).build();
        return Database.fromProto((com.google.spanner.admin.database.v1.Database)proto, (DatabaseAdminClient)this.dbClient);
    }
}

