/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClientImpl;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.OperationFutureUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.iam.v1.Binding;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class InstanceAdminClientImplTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String INSTANCE_NAME = "projects/my-project/instances/my-instance";
    private static final String INSTANCE_NAME2 = "projects/my-project/instances/my-instance2";
    private static final String CONFIG_ID = "my-config";
    private static final String CONFIG_NAME = "projects/my-project/instanceConfigs/my-config";
    private static final String CONFIG_NAME2 = "projects/my-project/instanceConfigs/my-config2";
    @Mock
    SpannerRpc rpc;
    @Mock
    DatabaseAdminClient dbClient;
    InstanceAdminClientImpl client;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.client = new InstanceAdminClientImpl(PROJECT_ID, this.rpc, this.dbClient);
    }

    @Test
    public void getInstanceConfig() {
        Mockito.when((Object)this.rpc.getInstanceConfig(CONFIG_NAME)).thenReturn((Object)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(CONFIG_NAME).build());
        Truth.assertThat((String)this.client.getInstanceConfig(CONFIG_ID).getId().getName()).isEqualTo((Object)CONFIG_NAME);
    }

    @Test
    public void listInstanceConfigs() {
        String nextToken = "token";
        Mockito.when((Object)this.rpc.listInstanceConfigs(1, null)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(CONFIG_NAME).build()), nextToken));
        Mockito.when((Object)this.rpc.listInstanceConfigs(1, nextToken)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(CONFIG_NAME2).build()), ""));
        ArrayList configs = Lists.newArrayList((Iterable)this.client.listInstanceConfigs(new Options.ListOption[]{Options.pageSize((int)1)}).iterateAll());
        Truth.assertThat((String)((InstanceConfig)configs.get(0)).getId().getName()).isEqualTo((Object)CONFIG_NAME);
        Truth.assertThat((String)((InstanceConfig)configs.get(1)).getId().getName()).isEqualTo((Object)CONFIG_NAME2);
        Truth.assertThat((Integer)configs.size()).isEqualTo((Object)2);
    }

    private com.google.spanner.admin.instance.v1.Instance getInstanceProto() {
        return com.google.spanner.admin.instance.v1.Instance.newBuilder().setConfig(CONFIG_NAME).setName(INSTANCE_NAME).setNodeCount(1).setProcessingUnits(1000).build();
    }

    private com.google.spanner.admin.instance.v1.Instance getInstanceProtoWithProcessingUnits() {
        return com.google.spanner.admin.instance.v1.Instance.newBuilder().setConfig(CONFIG_NAME).setName(INSTANCE_NAME).setProcessingUnits(10).build();
    }

    private com.google.spanner.admin.instance.v1.Instance getAnotherInstanceProto() {
        return com.google.spanner.admin.instance.v1.Instance.newBuilder().setConfig(CONFIG_NAME).setName(INSTANCE_NAME2).setNodeCount(2).setProcessingUnits(2000).build();
    }

    @Test
    public void createInstance() throws Exception {
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, CreateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createInstance", this.getInstanceProto(), CreateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.createInstance("projects/my-project", INSTANCE_ID, this.getInstanceProto().toBuilder().setProcessingUnits(0).build())).thenReturn(rawOperationFuture);
        OperationFuture op = this.client.createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).setInstanceConfigId(InstanceConfigId.of((String)PROJECT_ID, (String)CONFIG_ID)).setNodeCount(1).build());
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Instance)op.get()).getId().getName()).isEqualTo((Object)INSTANCE_NAME);
    }

    @Test
    public void testCreateInstanceWithProcessingUnits() throws Exception {
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, CreateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("createInstance", this.getInstanceProtoWithProcessingUnits(), CreateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.createInstance("projects/my-project", INSTANCE_ID, this.getInstanceProtoWithProcessingUnits())).thenReturn(rawOperationFuture);
        OperationFuture operation = this.client.createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).setInstanceConfigId(InstanceConfigId.of((String)PROJECT_ID, (String)CONFIG_ID)).setProcessingUnits(10).build());
        Assert.assertTrue((boolean)operation.isDone());
        Assert.assertEquals((Object)INSTANCE_NAME, (Object)((Instance)operation.get()).getId().getName());
    }

    @Test
    public void testCreateInstanceWithBothNodeCountAndProcessingUnits() throws Exception {
        try {
            this.client.createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)PROJECT_ID, (String)INSTANCE_ID)).setInstanceConfigId(InstanceConfigId.of((String)PROJECT_ID, (String)CONFIG_ID)).setNodeCount(1).setProcessingUnits(100).build());
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Only one of nodeCount and processingUnits can be set when creating a new instance"));
        }
    }

    @Test
    public void testGetInstance() {
        Mockito.when((Object)this.rpc.getInstance(INSTANCE_NAME)).thenReturn((Object)this.getInstanceProto());
        Instance instance = this.client.getInstance(INSTANCE_ID);
        Assert.assertEquals((Object)INSTANCE_NAME, (Object)instance.getId().getName());
        Assert.assertEquals((long)1000L, (long)instance.getProcessingUnits());
    }

    @Test
    public void dropInstance() {
        this.client.deleteInstance(INSTANCE_ID);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).deleteInstance(INSTANCE_NAME);
    }

    @Test
    public void updateInstanceMetadata() throws Exception {
        com.google.spanner.admin.instance.v1.Instance instance = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(INSTANCE_NAME).setConfig(CONFIG_NAME).setNodeCount(2).build();
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, UpdateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("updateInstance", this.getInstanceProto(), UpdateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateInstance(instance, FieldMask.newBuilder().addPaths("node_count").build())).thenReturn(rawOperationFuture);
        InstanceInfo instanceInfo = InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)INSTANCE_NAME)).setInstanceConfigId(InstanceConfigId.of((String)CONFIG_NAME)).setNodeCount(2).build();
        OperationFuture op = this.client.updateInstance(instanceInfo, new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.NODE_COUNT});
        Truth.assertThat((Boolean)op.isDone()).isTrue();
        Truth.assertThat((String)((Instance)op.get()).getId().getName()).isEqualTo((Object)INSTANCE_NAME);
    }

    @Test
    public void testUpdateInstanceProcessingUnits() throws Exception {
        com.google.spanner.admin.instance.v1.Instance instance = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(INSTANCE_NAME).setConfig(CONFIG_NAME).setProcessingUnits(10).build();
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, UpdateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("updateInstance", this.getInstanceProtoWithProcessingUnits(), UpdateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateInstance(instance, FieldMask.newBuilder().addPaths("processing_units").build())).thenReturn(rawOperationFuture);
        InstanceInfo instanceInfo = InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)INSTANCE_NAME)).setInstanceConfigId(InstanceConfigId.of((String)CONFIG_NAME)).setProcessingUnits(10).build();
        OperationFuture operationWithFieldMask = this.client.updateInstance(instanceInfo, new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.PROCESSING_UNITS});
        Assert.assertTrue((boolean)operationWithFieldMask.isDone());
        Assert.assertEquals((Object)INSTANCE_NAME, (Object)((Instance)operationWithFieldMask.get()).getId().getName());
        Mockito.when((Object)this.rpc.updateInstance(instance, FieldMask.newBuilder().addAllPaths(Arrays.asList("display_name", "processing_units", "labels")).build())).thenReturn(rawOperationFuture);
        OperationFuture operation = this.client.updateInstance(instanceInfo, new InstanceInfo.InstanceField[0]);
        Assert.assertTrue((boolean)operation.isDone());
        Assert.assertEquals((Object)INSTANCE_NAME, (Object)((Instance)operation.get()).getId().getName());
    }

    @Test
    public void testUpdateInstanceWithNodeCountAndProcessingUnits() throws Exception {
        com.google.spanner.admin.instance.v1.Instance instance = com.google.spanner.admin.instance.v1.Instance.newBuilder().setName(INSTANCE_NAME).setConfig(CONFIG_NAME).setNodeCount(3).setProcessingUnits(3000).build();
        OperationFuture<com.google.spanner.admin.instance.v1.Instance, UpdateInstanceMetadata> rawOperationFuture = OperationFutureUtil.immediateOperationFuture("updateInstance", this.getInstanceProtoWithProcessingUnits(), UpdateInstanceMetadata.getDefaultInstance());
        Mockito.when((Object)this.rpc.updateInstance(instance, FieldMask.newBuilder().addAllPaths(Arrays.asList("display_name", "node_count", "labels")).build())).thenReturn(rawOperationFuture);
        InstanceInfo instanceInfo = InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)INSTANCE_NAME)).setInstanceConfigId(InstanceConfigId.of((String)CONFIG_NAME)).setNodeCount(3).setProcessingUnits(3000).build();
        OperationFuture operationWithFieldMask = this.client.updateInstance(instanceInfo, new InstanceInfo.InstanceField[0]);
        Assert.assertTrue((boolean)operationWithFieldMask.isDone());
        Assert.assertEquals((Object)INSTANCE_NAME, (Object)((Instance)operationWithFieldMask.get()).getId().getName());
    }

    @Test
    public void testListInstances() {
        String nextToken = "token";
        String filter = "env:dev";
        Mockito.when((Object)this.rpc.listInstances(1, null, filter)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getInstanceProto()), nextToken));
        Mockito.when((Object)this.rpc.listInstances(1, nextToken, filter)).thenReturn((Object)new SpannerRpc.Paginated((Iterable)ImmutableList.of((Object)this.getAnotherInstanceProto()), ""));
        ArrayList instances = Lists.newArrayList((Iterable)this.client.listInstances(new Options.ListOption[]{Options.pageSize((int)1), Options.filter((String)filter)}).iterateAll());
        Assert.assertEquals((Object)INSTANCE_NAME, (Object)((Instance)instances.get(0)).getId().getName());
        Assert.assertEquals((long)1000L, (long)((Instance)instances.get(0)).getProcessingUnits());
        Assert.assertEquals((Object)INSTANCE_NAME2, (Object)((Instance)instances.get(1)).getId().getName());
        Assert.assertEquals((long)2000L, (long)((Instance)instances.get(1)).getProcessingUnits());
        Assert.assertEquals((long)2L, (long)instances.size());
    }

    @Test
    public void getInstanceIAMPolicy() {
        Mockito.when((Object)this.rpc.getInstanceAdminIAMPolicy(INSTANCE_NAME)).thenReturn((Object)com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().addMembers("user:joe@example.com").setRole("roles/viewer").build()).build());
        Policy policy = this.client.getInstanceIAMPolicy(INSTANCE_ID);
        Truth.assertThat((Map)policy.getBindings()).containsExactly((Object)Role.viewer(), (Object)Sets.newHashSet((Object[])new Identity[]{Identity.user((String)"joe@example.com")}), new Object[0]);
        Mockito.when((Object)this.rpc.getInstanceAdminIAMPolicy(INSTANCE_NAME)).thenReturn((Object)com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().addAllMembers(Arrays.asList("allAuthenticatedUsers", "domain:google.com")).setRole("roles/viewer").build()).build());
        policy = this.client.getInstanceIAMPolicy(INSTANCE_ID);
        Truth.assertThat((Map)policy.getBindings()).containsExactly((Object)Role.viewer(), (Object)Sets.newHashSet((Object[])new Identity[]{Identity.allAuthenticatedUsers(), Identity.domain((String)"google.com")}), new Object[0]);
    }

    @Test
    public void setInstanceIAMPolicy() {
        ByteString etag = ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)"v1"));
        String etagEncoded = BaseEncoding.base64().encode(etag.toByteArray());
        com.google.iam.v1.Policy proto = com.google.iam.v1.Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/viewer").addMembers("user:joe@example.com").build()).setEtag(etag).build();
        Mockito.when((Object)this.rpc.setInstanceAdminIAMPolicy(INSTANCE_NAME, proto)).thenReturn((Object)proto);
        Policy policy = Policy.newBuilder().addIdentity(Role.viewer(), Identity.user((String)"joe@example.com"), new Identity[0]).setEtag(etagEncoded).build();
        Policy updated = this.client.setInstanceIAMPolicy(INSTANCE_ID, policy);
        Truth.assertThat((Object)updated).isEqualTo((Object)policy);
    }

    @Test
    public void testInstanceIAMPermissions() {
        List<String> permissions = Arrays.asList("spanner.instances.list", "spanner.instances.create");
        Mockito.when((Object)this.rpc.testInstanceAdminIAMPermissions(INSTANCE_NAME, permissions)).thenReturn((Object)TestIamPermissionsResponse.newBuilder().addPermissions("spanner.instances.list").build());
        Iterable allowed = this.client.testInstanceIAMPermissions(INSTANCE_ID, permissions);
        Truth.assertThat((Iterable)allowed).containsExactly(new Object[]{"spanner.instances.list"});
    }
}

