/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.ReplicaInfo;
import com.google.spanner.admin.instance.v1.ReplicaInfo;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class InstanceConfigTest {
    private InstanceAdminClient client;

    @Before
    public void setUp() {
        this.client = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
    }

    @Test
    public void testInstanceConfigFromProto() {
        InstanceConfig instanceConfig = InstanceConfig.fromProto((com.google.spanner.admin.instance.v1.InstanceConfig)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setDisplayName("Display Name").setName("projects/my-project/instanceConfigs/my-instance-config").addAllLeaderOptions(Arrays.asList("Leader Option 1", "Leader Option 2")).addAllReplicas(Arrays.asList(com.google.spanner.admin.instance.v1.ReplicaInfo.newBuilder().setLocation("Replica Location 1").setType(ReplicaInfo.ReplicaType.READ_WRITE).setDefaultLeaderLocation(true).build(), com.google.spanner.admin.instance.v1.ReplicaInfo.newBuilder().setLocation("Replica Location 2").setType(ReplicaInfo.ReplicaType.READ_ONLY).setDefaultLeaderLocation(false).build(), com.google.spanner.admin.instance.v1.ReplicaInfo.newBuilder().setLocation("Replica Location 3").setType(ReplicaInfo.ReplicaType.WITNESS).setDefaultLeaderLocation(false).build())).build(), (InstanceAdminClient)this.client);
        Assert.assertEquals((Object)new InstanceConfig(InstanceConfigId.of((String)"my-project", (String)"my-instance-config"), "Display Name", Arrays.asList(ReplicaInfo.newBuilder().setLocation("Replica Location 1").setType(ReplicaInfo.ReplicaType.READ_WRITE).setDefaultLeaderLocation(true).build(), ReplicaInfo.newBuilder().setLocation("Replica Location 2").setType(ReplicaInfo.ReplicaType.READ_ONLY).setDefaultLeaderLocation(false).build(), ReplicaInfo.newBuilder().setLocation("Replica Location 3").setType(ReplicaInfo.ReplicaType.WITNESS).setDefaultLeaderLocation(false).build()), Arrays.asList("Leader Option 1", "Leader Option 2"), this.client), (Object)instanceConfig);
    }

    @Test
    public void testInstanceConfigFromProtoWithoutReplicasAndLeaderOptions() {
        InstanceConfig instanceConfig = InstanceConfig.fromProto((com.google.spanner.admin.instance.v1.InstanceConfig)com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setDisplayName("Display Name").setName("projects/my-project/instanceConfigs/my-instance-config").build(), (InstanceAdminClient)this.client);
        Assert.assertEquals((Object)new InstanceConfig(InstanceConfigId.of((String)"my-project", (String)"my-instance-config"), "Display Name", this.client), (Object)instanceConfig);
    }
}

