/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstanceInfoTest {
    @Test
    public void testEmptyBuilder() {
        InstanceId id = InstanceId.of((String)"test-project", (String)"test-instance");
        InstanceInfo.Builder builder = InstanceInfo.newBuilder((InstanceId)id);
        InstanceInfo info = builder.build();
        Assert.assertNull((Object)info.getDisplayName());
        Assert.assertEquals((Object)InstanceId.of((String)"test-project", (String)"test-instance"), (Object)info.getId());
        Assert.assertNull((Object)info.getInstanceConfigId());
        Assert.assertNull((Object)info.getState());
        Assert.assertEquals((long)0L, (long)info.getNodeCount());
        Assert.assertEquals((long)0L, (long)info.getProcessingUnits());
        Assert.assertTrue((boolean)info.getLabels().isEmpty());
    }

    @Test
    public void testBuildInstanceInfo() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        InstanceInfo info = InstanceInfo.newBuilder((InstanceId)id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").build();
        Truth.assertThat((Object)info.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)info.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)info.getDisplayName()).isEqualTo((Object)"test instance");
        Truth.assertThat((Integer)info.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)info.getProcessingUnits()).isEqualTo((Object)2000);
        Truth.assertThat((Comparable)info.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)info.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
        info = info.toBuilder().setDisplayName("new test instance").build();
        Truth.assertThat((Object)info.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)info.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)info.getDisplayName()).isEqualTo((Object)"new test instance");
        Truth.assertThat((Integer)info.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)info.getProcessingUnits()).isEqualTo((Object)2000);
        Truth.assertThat((Comparable)info.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)info.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
    }

    @Test
    public void testToBuilder() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        InstanceInfo info = InstanceInfo.newBuilder((InstanceId)id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").build();
        InstanceInfo rebuilt = info.toBuilder().setDisplayName("new test instance").build();
        Truth.assertThat((Object)rebuilt.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)rebuilt.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)rebuilt.getDisplayName()).isEqualTo((Object)"new test instance");
        Truth.assertThat((Integer)rebuilt.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)rebuilt.getProcessingUnits()).isEqualTo((Object)2000);
        Truth.assertThat((Comparable)rebuilt.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)rebuilt.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
    }

    @Test
    public void testEquals() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId1 = new InstanceConfigId("test-project", "test-instance-config");
        InstanceConfigId configId2 = new InstanceConfigId("test-project", "other-test-instance-config");
        InstanceInfo instance = InstanceInfo.newBuilder((InstanceId)id).setInstanceConfigId(configId1).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").build();
        InstanceInfo instance2 = InstanceInfo.newBuilder((InstanceId)id).setInstanceConfigId(configId1).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("region", "us").addLabel("env", "prod").build();
        InstanceInfo instance3 = InstanceInfo.newBuilder((InstanceId)id).setInstanceConfigId(configId2).setDisplayName("other test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("env", "prod").build();
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{instance, instance2});
        tester.addEqualityGroup(new Object[]{instance3});
        tester.testEquals();
    }
}

