/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactoryTest;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class SessionPoolStressTest
extends BaseSessionPoolTest {
    @Parameterized.Parameter(value=0)
    public boolean shouldBlock;
    DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    SessionPool pool;
    SessionPoolOptions options;
    ExecutorService createExecutor = Executors.newSingleThreadExecutor();
    Object lock = new Object();
    Random random = new Random();
    BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
    Map<String, Boolean> sessions = new HashMap<String, Boolean>();
    Map<String, Exception> closedSessions = new HashMap<String, Exception>();
    Set<String> expiredSessions = new HashSet<String>();
    SpannerImpl mockSpanner;
    SpannerOptions spannerOptions;
    int maxAliveSessions;
    int minSessionsWhenSessionClosed = Integer.MAX_VALUE;
    Exception e;

    @Parameterized.Parameters(name="should block = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{true});
        params.add(new Object[]{false});
        return params;
    }

    private void setupSpanner(DatabaseId db) {
        this.mockSpanner = (SpannerImpl)Mockito.mock(SpannerImpl.class);
        this.spannerOptions = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        SessionClient sessionClient = (SessionClient)Mockito.mock(SessionClient.class);
        Mockito.when((Object)this.mockSpanner.getSessionClient(db)).thenReturn((Object)sessionClient);
        Mockito.when((Object)this.mockSpanner.getOptions()).thenReturn((Object)this.spannerOptions);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.createExecutor.submit(() -> {
                int sessionCount = (Integer)invocation.getArgumentAt(0, Integer.class);
                for (int s = 0; s < sessionCount; ++s) {
                    SessionImpl session;
                    Object object = this.lock;
                    synchronized (object) {
                        session = this.mockSession();
                        this.setupSession(session);
                        this.sessions.put(session.getName(), false);
                        if (this.sessions.size() > this.maxAliveSessions) {
                            this.maxAliveSessions = this.sessions.size();
                        }
                    }
                    SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgumentAt(2, SessionPool.SessionConsumerImpl.class);
                    consumer.onSessionReady(session);
                }
            });
            return null;
        }).when((Object)sessionClient)).asyncBatchCreateSessions(Mockito.anyInt(), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
    }

    private void setupSession(SessionImpl session) {
        ReadContext mockContext = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet mockResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)session.singleUse((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)mockContext);
        Mockito.when((Object)mockContext.executeQuery((Statement)Matchers.any(Statement.class), new Options.QueryOption[0])).thenAnswer(invocation -> {
            this.resetTransaction(session);
            return mockResult;
        });
        Mockito.when((Object)mockResult.next()).thenReturn((Object)true);
        ((SessionImpl)Mockito.doAnswer(invocation -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.expiredSessions.contains(session.getName())) {
                    return ApiFutures.immediateFailedFuture((Throwable)SpannerExceptionFactoryTest.newSessionNotFoundException(session.getName()));
                }
                if (this.sessions.remove(session.getName()) == null) {
                    this.setFailed(this.closedSessions.get(session.getName()));
                }
                this.closedSessions.put(session.getName(), new Exception("Session closed at:"));
                if (this.sessions.size() < this.minSessionsWhenSessionClosed) {
                    this.minSessionsWhenSessionClosed = this.sessions.size();
                }
            }
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }).when((Object)session)).asyncClose();
        ((SessionImpl)Mockito.doAnswer(invocation -> {
            if (this.random.nextInt(100) < 10) {
                this.expireSession((Session)session);
                throw SpannerExceptionFactoryTest.newSessionNotFoundException(session.getName());
            }
            String name = session.getName();
            Object object = this.lock;
            synchronized (object) {
                if (this.sessions.put(name, true).booleanValue()) {
                    this.setFailed();
                }
                session.readyTransactionId = ByteString.copyFromUtf8((String)"foo");
            }
            return null;
        }).when((Object)session)).prepareReadWriteTransaction();
        Mockito.when((Object)session.hasReadyTransaction()).thenCallRealMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSession(Session session) {
        String name = session.getName();
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(name);
            this.expiredSessions.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTransaction(SessionImpl session) {
        String name = session.getName();
        Object object = this.lock;
        synchronized (object) {
            session.readyTransactionId = null;
            this.sessions.put(name, false);
        }
    }

    private void setFailed(Exception cause) {
        this.e = new Exception(cause);
    }

    private void setFailed() {
        this.e = new Exception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception getFailedError() {
        Object object = this.lock;
        synchronized (object) {
            return this.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stressTest() throws Exception {
        int concurrentThreads = 10;
        int numOperationsPerThread = 1000;
        CountDownLatch releaseThreads = new CountDownLatch(1);
        CountDownLatch threadsDone = new CountDownLatch(concurrentThreads);
        this.setupSpanner(this.db);
        int minSessions = 2;
        int maxSessions = concurrentThreads / 2;
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder().setMinSessions(minSessions).setMaxSessions(maxSessions);
        if (this.shouldBlock) {
            builder.setBlockIfPoolExhausted();
        } else {
            builder.setFailIfPoolExhausted();
        }
        this.pool = SessionPool.createPool((SessionPoolOptions)builder.build(), (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(this), (SessionClient)this.mockSpanner.getSessionClient(this.db), (SessionPool.Clock)this.clock);
        this.pool.idleSessionRemovedListener = pooled -> {
            String name = pooled.getName();
            Object object = this.lock;
            synchronized (object) {
                this.sessions.remove(name);
                return null;
            }
        };
        for (int i = 0; i < concurrentThreads; ++i) {
            new Thread(() -> {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)releaseThreads);
                for (int j = 0; j < 1000; ++j) {
                    try {
                        SessionPool.PooledSessionFuture session = this.pool.getSession();
                        session.get();
                        Uninterruptibles.sleepUninterruptibly((long)this.random.nextInt(2), (TimeUnit)TimeUnit.MILLISECONDS);
                        this.resetTransaction(session.get().delegate);
                        session.close();
                        continue;
                    }
                    catch (SpannerException e) {
                        if (e.getErrorCode() == ErrorCode.RESOURCE_EXHAUSTED && !this.shouldBlock) continue;
                        this.setFailed((Exception)((Object)e));
                        continue;
                    }
                    catch (Exception e) {
                        this.setFailed(e);
                    }
                }
                threadsDone.countDown();
            }).start();
        }
        AtomicBoolean stopMaintenance = new AtomicBoolean(false);
        new Thread(() -> {
            while (!stopMaintenance.get()) {
                this.runMaintenanceLoop(this.clock, this.pool, 1L);
            }
        }).start();
        releaseThreads.countDown();
        threadsDone.await();
        Object object = this.lock;
        synchronized (object) {
            Truth.assertThat((Integer)this.maxAliveSessions).isAtMost((Comparable)Integer.valueOf(maxSessions));
        }
        stopMaintenance.set(true);
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get();
        Exception e = this.getFailedError();
        if (e != null) {
            throw e;
        }
    }
}

