/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadOnlyStalenessUtilTest {
    @Test
    public void testParseRfc3339() {
        HashMap<String, Timestamp> timestamps = new HashMap<String, Timestamp>();
        timestamps.put("2018-03-01T10:11:12.999Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)999000000));
        timestamps.put("2018-10-28T02:00:00+02:00", Timestamp.ofTimeSecondsAndNanos((long)1540684800L, (int)0));
        timestamps.put("2018-10-28T03:00:00+01:00", Timestamp.ofTimeSecondsAndNanos((long)1540692000L, (int)0));
        timestamps.put("2018-01-01T00:00:00.000000001Z", Timestamp.ofTimeSecondsAndNanos((long)1514764800L, (int)1));
        timestamps.put("2018-10-28T02:00:00Z", Timestamp.ofTimeSecondsAndNanos((long)1540692000L, (int)0));
        timestamps.put("2018-12-31T23:59:59.999999999Z", Timestamp.ofTimeSecondsAndNanos((long)1546300799L, (int)999999999));
        timestamps.put("2018-03-01T10:11:12.9999Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)999900000));
        timestamps.put("2018-03-01T10:11:12.000000001Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)1));
        timestamps.put("2018-03-01T10:11:12.100000000Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)100000000));
        timestamps.put("2018-03-01T10:11:12.100000001Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)100000001));
        timestamps.put("2018-03-01T10:11:12-10:00", Timestamp.ofTimeSecondsAndNanos((long)1519935072L, (int)0));
        timestamps.put("2018-03-01T10:11:12.999999999Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)999999999));
        timestamps.put("2018-03-01T10:11:12-12:00", Timestamp.ofTimeSecondsAndNanos((long)1519942272L, (int)0));
        timestamps.put("2018-10-28T03:00:00Z", Timestamp.ofTimeSecondsAndNanos((long)1540695600L, (int)0));
        timestamps.put("2018-10-28T02:30:00Z", Timestamp.ofTimeSecondsAndNanos((long)1540693800L, (int)0));
        timestamps.put("2018-03-01T10:11:12.123Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)123000000));
        timestamps.put("2018-10-28T02:30:00+02:00", Timestamp.ofTimeSecondsAndNanos((long)1540686600L, (int)0));
        timestamps.put("2018-03-01T10:11:12.123456789Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)123456789));
        timestamps.put("2018-03-01T10:11:12.1000Z", Timestamp.ofTimeSecondsAndNanos((long)1519899072L, (int)100000000));
        for (Map.Entry ts : timestamps.entrySet()) {
            Timestamp gTimestamp = ReadOnlyStalenessUtil.parseRfc3339((String)((String)ts.getKey()));
            MatcherAssert.assertThat((String)("Seconds for timestamp " + ts + " do not match"), (Object)gTimestamp.getSeconds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Timestamp)ts.getValue()).getSeconds())));
            MatcherAssert.assertThat((String)("Nanos for timestamp " + ts + " do not match"), (Object)gTimestamp.getNanos(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Timestamp)ts.getValue()).getNanos())));
        }
    }

    @Test
    public void testParseTimeUnit() {
        MatcherAssert.assertThat((Object)((Object)ReadOnlyStalenessUtil.parseTimeUnit((String)"s")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Object)TimeUnit.SECONDS))));
        MatcherAssert.assertThat((Object)((Object)ReadOnlyStalenessUtil.parseTimeUnit((String)"ms")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Object)TimeUnit.MILLISECONDS))));
        MatcherAssert.assertThat((Object)((Object)ReadOnlyStalenessUtil.parseTimeUnit((String)"us")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Object)TimeUnit.MICROSECONDS))));
        MatcherAssert.assertThat((Object)((Object)ReadOnlyStalenessUtil.parseTimeUnit((String)"ns")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Object)TimeUnit.NANOSECONDS))));
    }

    @Test
    public void testGetTimeUnitAbbreviation() {
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"s")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"ms")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)TimeUnit.MICROSECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"us")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)TimeUnit.NANOSECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"ns")));
        List<TimeUnit> supportedTimeUnits = Arrays.asList(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS);
        for (TimeUnit unit : TimeUnit.values()) {
            String value;
            block4: {
                if (supportedTimeUnits.contains((Object)unit)) {
                    MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                    continue;
                }
                value = null;
                try {
                    value = ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit);
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() != ErrorCode.INVALID_ARGUMENT) break block4;
                    value = "unsupported";
                }
            }
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"unsupported")));
        }
    }

    @Test
    public void testStalenessToString() {
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.NANOSECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"10ns")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)1000L, (TimeUnit)TimeUnit.NANOSECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1us")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)100000L, (TimeUnit)TimeUnit.NANOSECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"100us")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)999999L, (TimeUnit)TimeUnit.NANOSECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"999999ns")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)1L, (TimeUnit)TimeUnit.SECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1s")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1s")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)1001L, (TimeUnit)TimeUnit.MILLISECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1001ms")));
        MatcherAssert.assertThat((Object)ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)new ReadOnlyStalenessUtil.MaxStalenessGetter(TimestampBound.ofMaxStaleness((long)1000000000L, (TimeUnit)TimeUnit.NANOSECONDS))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1s")));
    }
}

