/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.SingleUseTransaction;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ResultSetStats;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class SingleUseTransactionTest {
    private static final String VALID_QUERY = "SELECT * FROM FOO";
    private static final String INVALID_QUERY = "SELECT * FROM BAR";
    private static final String SLOW_QUERY = "SELECT * FROM SLOW_TABLE";
    private static final String VALID_UPDATE = "UPDATE FOO SET BAR=1";
    private static final String INVALID_UPDATE = "UPDATE BAR SET FOO=1";
    private static final String SLOW_UPDATE = "UPDATE SLOW_TABLE SET FOO=1";
    private static final String VALID_DDL = "CREATE TABLE FOO";
    private static final long VALID_UPDATE_COUNT = 99L;
    private final StatementExecutor executor = new StatementExecutor();

    static StatementExecutor.StatementTimeout nullTimeout() {
        return new StatementExecutor.StatementTimeout();
    }

    static StatementExecutor.StatementTimeout timeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit((TimeUnit)unit));
        StatementExecutor.StatementTimeout res = new StatementExecutor.StatementTimeout();
        res.setTimeoutValue(timeout, unit);
        return res;
    }

    private DdlClient createDefaultMockDdlClient() {
        try {
            DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
            OperationFuture operation = (OperationFuture)Mockito.mock(OperationFuture.class);
            Mockito.when((Object)operation.get()).thenReturn(null);
            Mockito.when((Object)ddlClient.executeDdl(Matchers.anyString())).thenCallRealMethod();
            Mockito.when((Object)ddlClient.executeDdl(Matchers.anyListOf(String.class))).thenReturn((Object)operation);
            return ddlClient;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SingleUseTransaction createSubject() {
        return this.createSubject(this.createDefaultMockDdlClient(), false, TimestampBound.strong(), AutocommitDmlMode.TRANSACTIONAL, CommitBehavior.SUCCEED, 0L);
    }

    private SingleUseTransaction createSubject(AutocommitDmlMode dmlMode) {
        return this.createSubject(this.createDefaultMockDdlClient(), false, TimestampBound.strong(), dmlMode, CommitBehavior.SUCCEED, 0L);
    }

    private SingleUseTransaction createSubject(CommitBehavior commitBehavior) {
        return this.createSubject(this.createDefaultMockDdlClient(), false, TimestampBound.strong(), AutocommitDmlMode.TRANSACTIONAL, commitBehavior, 0L);
    }

    private SingleUseTransaction createDdlSubject(DdlClient ddlClient) {
        return this.createSubject(ddlClient, false, TimestampBound.strong(), AutocommitDmlMode.TRANSACTIONAL, CommitBehavior.SUCCEED, 0L);
    }

    private SingleUseTransaction createReadOnlySubject(TimestampBound staleness) {
        return this.createSubject(this.createDefaultMockDdlClient(), true, staleness, AutocommitDmlMode.TRANSACTIONAL, CommitBehavior.SUCCEED, 0L);
    }

    private SingleUseTransaction createSubject(DdlClient ddlClient, boolean readOnly, TimestampBound staleness, AutocommitDmlMode dmlMode, final CommitBehavior commitBehavior, long timeout) {
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        SimpleReadOnlyTransaction singleUse = new SimpleReadOnlyTransaction(staleness);
        Mockito.when((Object)dbClient.singleUseReadOnlyTransaction(staleness)).thenReturn((Object)singleUse);
        final TransactionContext txContext = (TransactionContext)Mockito.mock(TransactionContext.class);
        Mockito.when((Object)txContext.executeUpdate(Statement.of((String)VALID_UPDATE), new Options.UpdateOption[0])).thenReturn((Object)99L);
        Mockito.when((Object)txContext.executeUpdate(Statement.of((String)SLOW_UPDATE), new Options.UpdateOption[0])).thenAnswer(invocation -> {
            Thread.sleep(1000L);
            return 99L;
        });
        Mockito.when((Object)txContext.executeUpdate(Statement.of((String)INVALID_UPDATE), new Options.UpdateOption[0])).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"invalid update")});
        SimpleTransactionManager txManager = new SimpleTransactionManager(txContext, commitBehavior);
        Mockito.when((Object)dbClient.transactionManager(new Options.TransactionOption[0])).thenReturn((Object)txManager);
        Mockito.when((Object)dbClient.executePartitionedUpdate(Statement.of((String)VALID_UPDATE), new Options.UpdateOption[0])).thenReturn((Object)99L);
        Mockito.when((Object)dbClient.executePartitionedUpdate(Statement.of((String)INVALID_UPDATE), new Options.UpdateOption[0])).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"invalid update")});
        Mockito.when((Object)dbClient.readWriteTransaction(new Options.TransactionOption[0])).thenAnswer((Answer)new Answer<TransactionRunner>(){

            public TransactionRunner answer(InvocationOnMock invocation) {
                return new TransactionRunner(){
                    private CommitResponse commitResponse;

                    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
                        if (commitBehavior == CommitBehavior.SUCCEED) {
                            Object res;
                            try {
                                res = callable.run(txContext);
                            }
                            catch (Exception e) {
                                throw SpannerExceptionFactory.newSpannerException((Throwable)e);
                            }
                            this.commitResponse = new CommitResponse(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)1));
                            return (T)res;
                        }
                        if (commitBehavior == CommitBehavior.FAIL) {
                            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"commit failed");
                        }
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"commit aborted");
                    }

                    public Timestamp getCommitTimestamp() {
                        if (this.commitResponse == null) {
                            throw new IllegalStateException("no commit timestamp");
                        }
                        return this.commitResponse.getCommitTimestamp();
                    }

                    public CommitResponse getCommitResponse() {
                        if (this.commitResponse == null) {
                            throw new IllegalStateException("no commit response");
                        }
                        return this.commitResponse;
                    }

                    public TransactionRunner allowNestedTransaction() {
                        return this;
                    }
                };
            }
        });
        return ((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)SingleUseTransaction.newBuilder().setDatabaseClient(dbClient).setDdlClient(ddlClient).setAutocommitDmlMode(dmlMode).setReadOnly(readOnly).setReadOnlyStaleness(staleness).setStatementTimeout(timeout == 0L ? SingleUseTransactionTest.nullTimeout() : SingleUseTransactionTest.timeout(timeout, TimeUnit.MILLISECONDS))).withStatementExecutor(this.executor)).build();
    }

    private StatementParser.ParsedStatement createParsedDdl(String sql) {
        StatementParser.ParsedStatement statement = (StatementParser.ParsedStatement)Mockito.mock(StatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)StatementParser.StatementType.DDL);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)sql));
        Mockito.when((Object)statement.getSqlWithoutComments()).thenReturn((Object)sql);
        return statement;
    }

    private StatementParser.ParsedStatement createParsedQuery(String sql) {
        StatementParser.ParsedStatement statement = (StatementParser.ParsedStatement)Mockito.mock(StatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)StatementParser.StatementType.QUERY);
        Mockito.when((Object)statement.isQuery()).thenReturn((Object)true);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)sql));
        return statement;
    }

    private StatementParser.ParsedStatement createParsedUpdate(String sql) {
        StatementParser.ParsedStatement statement = (StatementParser.ParsedStatement)Mockito.mock(StatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)StatementParser.StatementType.UPDATE);
        Mockito.when((Object)statement.isUpdate()).thenReturn((Object)true);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)sql));
        return statement;
    }

    private List<TimestampBound> getTestTimestampBounds() {
        return Arrays.asList(TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofExactStaleness((long)1L, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofMaxStaleness((long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Test
    public void testCommit() {
        SingleUseTransaction subject = this.createSubject();
        try {
            subject.commitAsync();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testRollback() {
        SingleUseTransaction subject = this.createSubject();
        try {
            subject.rollbackAsync();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testRunBatch() {
        SingleUseTransaction subject = this.createSubject();
        try {
            subject.runBatchAsync();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testAbortBatch() {
        SingleUseTransaction subject = this.createSubject();
        try {
            subject.abortBatch();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testExecuteDdl() {
        String sql = VALID_DDL;
        StatementParser.ParsedStatement ddl = this.createParsedDdl(sql);
        DdlClient ddlClient = this.createDefaultMockDdlClient();
        SingleUseTransaction subject = this.createDdlSubject(ddlClient);
        SpannerApiFutures.get((ApiFuture)subject.executeDdlAsync(ddl));
        ((DdlClient)Mockito.verify((Object)ddlClient)).executeDdl(sql);
    }

    @Test
    public void testExecuteQuery() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            for (AnalyzeMode analyzeMode : AnalyzeMode.values()) {
                SingleUseTransaction subject = this.createReadOnlySubject(staleness);
                ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)subject.executeQueryAsync(this.createParsedQuery(VALID_QUERY), analyzeMode, new Options.QueryOption[0]));
                Truth.assertThat((Object)rs).isNotNull();
                Truth.assertThat((Comparable)subject.getReadTimestamp()).isNotNull();
                Truth.assertThat((Comparable)subject.getState()).isEqualTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED);
                while (rs.next()) {
                }
                if (analyzeMode == AnalyzeMode.NONE) {
                    Truth.assertThat((Object)rs.getStats()).isNull();
                    continue;
                }
                Truth.assertThat((Object)rs.getStats()).isNotNull();
            }
        }
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            SingleUseTransaction subject = this.createReadOnlySubject(staleness);
            try {
                SpannerApiFutures.get((ApiFuture)subject.executeQueryAsync(this.createParsedQuery(INVALID_QUERY), AnalyzeMode.NONE, new Options.QueryOption[0]));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            }
            Truth.assertThat((Comparable)subject.getState()).isEqualTo((Object)UnitOfWork.UnitOfWorkState.COMMIT_FAILED);
        }
    }

    @Test
    public void testExecuteQueryWithOptionsTest() {
        String sql = VALID_QUERY;
        Options.ReadAndQueryOption option = Options.prefetchChunks((int)10000);
        StatementParser.ParsedStatement parsedStatement = (StatementParser.ParsedStatement)Mockito.mock(StatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)StatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)sql);
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        ReadOnlyTransaction tx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)tx.executeQuery(Statement.of((String)sql), new Options.QueryOption[]{option})).thenReturn(Mockito.mock(ResultSet.class));
        Mockito.when((Object)client.singleUseReadOnlyTransaction(TimestampBound.strong())).thenReturn((Object)tx);
        SingleUseTransaction transaction = ((SingleUseTransaction.Builder)SingleUseTransaction.newBuilder().setDatabaseClient(client).setDdlClient((DdlClient)Mockito.mock(DdlClient.class)).setAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL).withStatementExecutor(this.executor)).setReadOnlyStaleness(TimestampBound.strong()).build();
        Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[]{option}))).isNotNull();
    }

    @Test
    public void testExecuteUpdate_Transactional_Valid() {
        StatementParser.ParsedStatement update = this.createParsedUpdate(VALID_UPDATE);
        SingleUseTransaction subject = this.createSubject();
        long updateCount = (Long)SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
        Truth.assertThat((Long)updateCount).isEqualTo((Object)99L);
        Truth.assertThat((Comparable)subject.getCommitTimestamp()).isNotNull();
        Truth.assertThat((Comparable)subject.getState()).isEqualTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED);
    }

    @Test
    public void testExecuteUpdate_Transactional_Invalid() {
        StatementParser.ParsedStatement update = this.createParsedUpdate(INVALID_UPDATE);
        SingleUseTransaction subject = this.createSubject();
        try {
            SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalid update");
        }
    }

    @Test
    public void testExecuteUpdate_Transactional_Valid_FailedCommit() {
        StatementParser.ParsedStatement update = this.createParsedUpdate(VALID_UPDATE);
        SingleUseTransaction subject = this.createSubject(CommitBehavior.FAIL);
        try {
            SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"commit failed");
        }
    }

    @Test
    public void testExecuteUpdate_Partitioned_Valid() {
        StatementParser.ParsedStatement update = this.createParsedUpdate(VALID_UPDATE);
        SingleUseTransaction subject = this.createSubject(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
        long updateCount = (Long)SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
        Truth.assertThat((Long)updateCount).isEqualTo((Object)99L);
        Truth.assertThat((Comparable)subject.getState()).isEqualTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED);
    }

    @Test
    public void testExecuteUpdate_Partitioned_Invalid() {
        StatementParser.ParsedStatement update = this.createParsedUpdate(INVALID_UPDATE);
        SingleUseTransaction subject = this.createSubject(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
        try {
            SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalid update");
        }
    }

    @Test
    public void testWriteIterable() {
        SingleUseTransaction subject = this.createSubject();
        Mutation mutation = Mutation.newInsertBuilder((String)"FOO").build();
        SpannerApiFutures.get((ApiFuture)subject.writeAsync(Arrays.asList(mutation, mutation)));
        Truth.assertThat((Comparable)subject.getCommitTimestamp()).isNotNull();
        Truth.assertThat((Comparable)subject.getState()).isEqualTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED);
    }

    @Test
    public void testWriteIterableFail() {
        SingleUseTransaction subject = this.createSubject(CommitBehavior.FAIL);
        Mutation mutation = Mutation.newInsertBuilder((String)"FOO").build();
        try {
            SpannerApiFutures.get((ApiFuture)subject.writeAsync(Arrays.asList(mutation, mutation)));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"commit failed");
        }
    }

    @Test
    public void testMultiUse() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            SingleUseTransaction subject = this.createReadOnlySubject(staleness);
            ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)subject.executeQueryAsync(this.createParsedQuery(VALID_QUERY), AnalyzeMode.NONE, new Options.QueryOption[0]));
            Truth.assertThat((Object)rs).isNotNull();
            Truth.assertThat((Comparable)subject.getReadTimestamp()).isNotNull();
            try {
                SpannerApiFutures.get((ApiFuture)subject.executeQueryAsync(this.createParsedQuery(VALID_QUERY), AnalyzeMode.NONE, new Options.QueryOption[0]));
                Assert.fail((String)"missing expected exception");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        String sql = VALID_DDL;
        StatementParser.ParsedStatement ddl = this.createParsedDdl(sql);
        DdlClient ddlClient = this.createDefaultMockDdlClient();
        SingleUseTransaction subject = this.createDdlSubject(ddlClient);
        SpannerApiFutures.get((ApiFuture)subject.executeDdlAsync(ddl));
        ((DdlClient)Mockito.verify((Object)ddlClient)).executeDdl(sql);
        try {
            SpannerApiFutures.get((ApiFuture)subject.executeDdlAsync(ddl));
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StatementParser.ParsedStatement update = this.createParsedUpdate(VALID_UPDATE);
        subject = this.createSubject();
        long updateCount = (Long)SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
        Truth.assertThat((Long)updateCount).isEqualTo((Object)99L);
        Truth.assertThat((Comparable)subject.getCommitTimestamp()).isNotNull();
        try {
            SpannerApiFutures.get((ApiFuture)subject.executeUpdateAsync(update, new Options.UpdateOption[0]));
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        subject = this.createSubject();
        SpannerApiFutures.get((ApiFuture)subject.writeAsync(Collections.singleton(Mutation.newInsertBuilder((String)"FOO").build())));
        Truth.assertThat((Comparable)subject.getCommitTimestamp()).isNotNull();
        try {
            SpannerApiFutures.get((ApiFuture)subject.writeAsync(Collections.singleton(Mutation.newInsertBuilder((String)"FOO").build())));
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        subject = this.createSubject();
        Mutation mutation = Mutation.newInsertBuilder((String)"FOO").build();
        SpannerApiFutures.get((ApiFuture)subject.writeAsync(Arrays.asList(mutation, mutation)));
        Truth.assertThat((Comparable)subject.getCommitTimestamp()).isNotNull();
        try {
            SpannerApiFutures.get((ApiFuture)subject.writeAsync(Arrays.asList(mutation, mutation)));
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCommitResponseAfterUpdate() {
        StatementParser.ParsedStatement update = this.createParsedUpdate(VALID_UPDATE);
        SingleUseTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(update, new Options.UpdateOption[0]));
        Assert.assertNotNull((Object)transaction.getCommitResponse());
        Assert.assertNotNull((Object)transaction.getCommitResponseOrNull());
    }

    @Test
    public void testGetCommitResponseAfterQuery() {
        StatementParser.ParsedStatement query = this.createParsedQuery(VALID_QUERY);
        SingleUseTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(query, AnalyzeMode.NONE, new Options.QueryOption[0]));
        try {
            transaction.getCommitResponse();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
        Assert.assertNull((Object)transaction.getCommitResponseOrNull());
    }

    @Test
    public void testGetCommitResponseAfterDdl() {
        StatementParser.ParsedStatement ddl = this.createParsedDdl(VALID_DDL);
        SingleUseTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.executeDdlAsync(ddl));
        try {
            transaction.getCommitResponse();
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
        Assert.assertNull((Object)transaction.getCommitResponseOrNull());
    }

    private static final class SimpleReadOnlyTransaction
    implements ReadOnlyTransaction {
        private Timestamp readTimestamp = null;
        private final TimestampBound staleness;

        private SimpleReadOnlyTransaction(TimestampBound staleness) {
            this.staleness = staleness;
        }

        public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public Struct readRow(String table, Key key, Iterable<String> columns) {
            return null;
        }

        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            return null;
        }

        public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
            if (statement.equals((Object)Statement.of((String)SingleUseTransactionTest.VALID_QUERY))) {
                if (this.readTimestamp == null) {
                    switch (this.staleness.getMode()) {
                        case STRONG: {
                            this.readTimestamp = Timestamp.now();
                            break;
                        }
                        case READ_TIMESTAMP: {
                            this.readTimestamp = this.staleness.getReadTimestamp();
                            break;
                        }
                        case MIN_READ_TIMESTAMP: {
                            this.readTimestamp = this.staleness.getMinReadTimestamp();
                            break;
                        }
                        case EXACT_STALENESS: {
                            Calendar cal = Calendar.getInstance();
                            cal.add(14, (int)(-this.staleness.getExactStaleness(TimeUnit.MILLISECONDS)));
                            this.readTimestamp = Timestamp.of((Date)cal.getTime());
                            break;
                        }
                        case MAX_STALENESS: {
                            Calendar cal = Calendar.getInstance();
                            cal.add(14, (int)(-this.staleness.getMaxStaleness(TimeUnit.MILLISECONDS)));
                            this.readTimestamp = Timestamp.of((Date)cal.getTime());
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                return (ResultSet)Mockito.mock(ResultSet.class);
            }
            if (statement.equals((Object)Statement.of((String)SingleUseTransactionTest.SLOW_QUERY))) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.readTimestamp = Timestamp.now();
                return (ResultSet)Mockito.mock(ResultSet.class);
            }
            if (statement.equals((Object)Statement.of((String)SingleUseTransactionTest.INVALID_QUERY))) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"invalid query");
            }
            throw new IllegalArgumentException();
        }

        public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
            ResultSet rs = this.executeQuery(statement, new Options.QueryOption[0]);
            Mockito.when((Object)rs.getStats()).thenReturn((Object)ResultSetStats.getDefaultInstance());
            return rs;
        }

        public void close() {
        }

        public Timestamp getReadTimestamp() {
            return this.readTimestamp;
        }

        public AsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public AsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            return null;
        }

        public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
            return null;
        }

        public AsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return null;
        }
    }

    private static class SimpleTransactionManager
    implements TransactionManager {
        private TransactionManager.TransactionState state;
        private CommitResponse commitResponse;
        private TransactionContext txContext;
        private CommitBehavior commitBehavior;

        private SimpleTransactionManager(TransactionContext txContext, CommitBehavior commitBehavior) {
            this.txContext = txContext;
            this.commitBehavior = commitBehavior;
        }

        public TransactionContext begin() {
            this.state = TransactionManager.TransactionState.STARTED;
            return this.txContext;
        }

        public void commit() {
            switch (this.commitBehavior) {
                case SUCCEED: {
                    this.commitResponse = new CommitResponse(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)1));
                    this.state = TransactionManager.TransactionState.COMMITTED;
                    break;
                }
                case FAIL: {
                    this.state = TransactionManager.TransactionState.COMMIT_FAILED;
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"commit failed");
                }
                case ABORT: {
                    this.state = TransactionManager.TransactionState.COMMIT_FAILED;
                    this.commitBehavior = CommitBehavior.SUCCEED;
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"commit aborted");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void rollback() {
            this.state = TransactionManager.TransactionState.ROLLED_BACK;
        }

        public TransactionContext resetForRetry() {
            return this.txContext;
        }

        public Timestamp getCommitTimestamp() {
            return this.commitResponse.getCommitTimestamp();
        }

        public CommitResponse getCommitResponse() {
            return this.commitResponse;
        }

        public TransactionManager.TransactionState getState() {
            return this.state;
        }

        public void close() {
            if (this.state != TransactionManager.TransactionState.COMMITTED) {
                this.state = TransactionManager.TransactionState.ROLLED_BACK;
            }
        }
    }

    private static enum CommitBehavior {
        SUCCEED,
        FAIL,
        ABORT;

    }
}

