/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.StatementResultImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class StatementResultImplTest {
    @Test
    public void testNoResultGetResultSet() {
        StatementResult subject = StatementResultImpl.noResult();
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
        try {
            subject.getResultSet();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testNoResultGetUpdateCount() {
        StatementResult subject = StatementResultImpl.noResult();
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
        try {
            subject.getUpdateCount();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.of((ResultSet)((ResultSet)Mockito.mock(ResultSet.class)));
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testResultSetGetUpdateCount() {
        StatementResult subject = StatementResultImpl.of((ResultSet)((ResultSet)Mockito.mock(ResultSet.class)));
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        try {
            subject.getUpdateCount();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testUpdateCountGetResultSet() {
        StatementResult subject = StatementResultImpl.of((Long)1L);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.UPDATE_COUNT)));
        try {
            subject.getResultSet();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testUpdateCountGetUpdateCount() {
        StatementResult subject = StatementResultImpl.of((Long)1L);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.UPDATE_COUNT)));
        MatcherAssert.assertThat((Object)subject.getUpdateCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testBooleanResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.resultSet((String)"foo", (Boolean)Boolean.TRUE, (StatementResult.ClientSideStatementType)StatementResult.ClientSideStatementType.SHOW_AUTOCOMMIT);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getClientSideStatementType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ClientSideStatementType.SHOW_AUTOCOMMIT)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().getBoolean("foo"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testLongResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.resultSet((String)"foo", (Long)10L, (StatementResult.ClientSideStatementType)StatementResult.ClientSideStatementType.SHOW_READ_ONLY_STALENESS);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getClientSideStatementType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ClientSideStatementType.SHOW_READ_ONLY_STALENESS)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().getLong("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)10L)));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testLongArrayResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.resultSet((String)"foo", (long[])new long[]{1L, 2L, 3L}, (StatementResult.ClientSideStatementType)StatementResult.ClientSideStatementType.SHOW_RETRY_ABORTS_INTERNALLY);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getClientSideStatementType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ClientSideStatementType.SHOW_RETRY_ABORTS_INTERNALLY)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().getLongArray("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 2L, 3L})));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStringResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.resultSet((String)"foo", (String)"bar", (StatementResult.ClientSideStatementType)StatementResult.ClientSideStatementType.SHOW_READ_ONLY_STALENESS);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getClientSideStatementType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ClientSideStatementType.SHOW_READ_ONLY_STALENESS)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().getString("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"bar")));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testEnumResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.resultSet((String)"foo", (Enum)TransactionMode.READ_ONLY_TRANSACTION, (StatementResult.ClientSideStatementType)StatementResult.ClientSideStatementType.SHOW_READONLY);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getClientSideStatementType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ClientSideStatementType.SHOW_READONLY)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().getString("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION.toString())));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testTimestampResultSetGetResultSet() {
        StatementResult subject = StatementResultImpl.resultSet((String)"foo", (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)10), (StatementResult.ClientSideStatementType)StatementResult.ClientSideStatementType.SHOW_READ_TIMESTAMP);
        MatcherAssert.assertThat((Object)subject.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
        MatcherAssert.assertThat((Object)subject.getClientSideStatementType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ClientSideStatementType.SHOW_READ_TIMESTAMP)));
        MatcherAssert.assertThat((Object)subject.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)subject.getResultSet().getTimestamp("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)10))));
        MatcherAssert.assertThat((Object)subject.getResultSet().next(), (Matcher)CoreMatchers.is((Object)false));
    }
}

