/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TaggingTest
extends AbstractMockServerTest {
    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testStatementTagNotAllowedForCommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setStatementTag("tag-1");
            try {
                connection.commit();
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
        }
    }

    @Test
    public void testStatementTagNotAllowedForRollback() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setStatementTag("tag-1");
            try {
                connection.rollback();
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
        }
    }

    @Test
    public void testStatementTagNotAllowedInsideBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.startBatchDml();
                try {
                    connection.setStatementTag("tag-1");
                    Assert.fail((String)"missing expected exception");
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
                }
                connection.abortBatch();
            }
        }
    }

    @Test
    public void testQuery_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                ResultSet rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                Throwable throwable = null;
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        rs.close();
                    }
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testUpdate_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testPartitionedUpdate_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.executeBatchUpdate(Arrays.asList(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testQuery_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("tag-1");
                ResultSet rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                Throwable throwable = null;
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        rs.close();
                    }
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
                rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                throwable = null;
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testUpdate_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("tag-2");
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testPartitionedUpdate_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.setStatementTag("tag-4");
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"tag-4", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("tag-3");
                connection.executeBatchUpdate(Arrays.asList(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
                connection.executeBatchUpdate(Arrays.asList(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testQuery_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("tag-1");
            ResultSet rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            Throwable throwable = null;
            if (rs != null) {
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    rs.close();
                }
            }
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            rs = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            throwable = null;
            if (rs != null) {
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    rs.close();
                }
            }
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testUpdate_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("tag-2");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("tag-3");
            connection.executeBatchUpdate(Arrays.asList(INSERT_STATEMENT));
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            connection.executeBatchUpdate(Arrays.asList(INSERT_STATEMENT));
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testDmlBatch_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("batch-tag");
                connection.startBatchDml();
                connection.execute(INSERT_STATEMENT);
                connection.execute(INSERT_STATEMENT);
                connection.runBatch();
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"batch-tag", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testRunBatch_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("batch-tag");
            connection.startBatchDml();
            connection.execute(INSERT_STATEMENT);
            connection.execute(INSERT_STATEMENT);
            connection.runBatch();
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"batch-tag", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"batch-tag", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testShowSetTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"SET STATEMENT_TAG='tag1'"));
            try (ResultSet rs = connection.execute(Statement.of((String)"SHOW VARIABLE STATEMENT_TAG")).getResultSet();){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"tag1", (Object)rs.getString("STATEMENT_TAG"));
                Assert.assertFalse((boolean)rs.next());
            }
            connection.execute(Statement.of((String)"SET STATEMENT_TAG=''"));
            rs = connection.execute(Statement.of((String)"SHOW VARIABLE STATEMENT_TAG")).getResultSet();
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"", (Object)rs.getString("STATEMENT_TAG"));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            connection.execute(Statement.of((String)"SET TRANSACTION_TAG='tag2'"));
            rs = connection.execute(Statement.of((String)"SHOW VARIABLE TRANSACTION_TAG")).getResultSet();
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"tag2", (Object)rs.getString("TRANSACTION_TAG"));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            connection.execute(Statement.of((String)"SET TRANSACTION_TAG=''"));
            rs = connection.execute(Statement.of((String)"SHOW VARIABLE TRANSACTION_TAG")).getResultSet();
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"", (Object)rs.getString("TRANSACTION_TAG"));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }
}

