/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.MethodSorters;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ITReadWriteAutocommitSpannerTest
extends ITAbstractSpannerTest {
    @Override
    protected void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=true");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Test
    public void test01_SqlScript() throws Exception {
        SqlScriptVerifier verifier = new SqlScriptVerifier(new ITAbstractSpannerTest.ITConnectionProvider());
        verifier.verifyStatementsInFile("ITReadWriteAutocommitSpannerTest.sql", SqlScriptVerifier.class, false);
    }

    @Test
    public void test02_WriteMutation() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(9999L)).set("NAME").to("FOO")).build());
            MatcherAssert.assertThat((Object)connection.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void test03_MultipleStatements_WithTimeouts() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            MatcherAssert.assertThat((Object)connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1000, 'test')")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST WHERE ID=1000"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"test")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.setStatementTimeout(1L, TimeUnit.NANOSECONDS);
            try {
                connection.executeUpdate(Statement.of((String)"UPDATE TEST SET NAME='test18' WHERE ID=1000"));
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.DEADLINE_EXCEEDED)));
            }
            connection.clearStatementTimeout();
            connection.executeUpdate(Statement.of((String)"DELETE FROM TEST WHERE ID=1000"));
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST WHERE ID=1000"), new Options.QueryOption[0]);
            var4_7 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (Throwable throwable) {
                var4_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void test04_BatchUpdate() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            long[] updateCounts = connection.executeBatchUpdate(Arrays.asList(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (10, 'Batch value 1')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (11, 'Batch value 2')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (12, 'Batch value 3')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (13, 'Batch value 4')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (14, 'Batch value 5')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (15, 'Batch value 6')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (16, 'Batch value 7')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (17, 'Batch value 8')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (18, 'Batch value 9')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (19, 'Batch value 10')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (20, 'Batch value 11')")));
            MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L})));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) FROM TEST WHERE ID>=10 AND ID<=20"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)11L)));
            }
        }
    }

    @Test
    public void test05_BatchUpdateWithException() {
        try (ITAbstractSpannerTest.ITConnection con1 = this.createConnection();
             ITAbstractSpannerTest.ITConnection con2 = this.createConnection();){
            try {
                con1.executeBatchUpdate(Arrays.asList(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (21, 'Batch value 1')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (22, 'Batch value 2')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (23, 'Batch value 3')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (24, 'Batch value 4')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (25, 'Batch value 5')"), Statement.of((String)"INSERT INTO TEST_NOT_FOUND (ID, NAME) VALUES (26, 'Batch value 6')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (27, 'Batch value 7')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (28, 'Batch value 8')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (29, 'Batch value 9')"), Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (30, 'Batch value 10')")));
                Assert.fail((String)"Missing batch update exception");
            }
            catch (SpannerBatchUpdateException e) {
                MatcherAssert.assertThat((Object)e.getUpdateCounts(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L, 1L, 1L, 1L})));
            }
            try (ResultSet rs = con1.executeQuery(Statement.of((String)"SELECT COUNT(*) FROM TEST WHERE ID>=21 AND ID<=30"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
            }
            rs = con2.executeQuery(Statement.of((String)"SELECT COUNT(*) FROM TEST WHERE ID>=21 AND ID<=30"), new Options.QueryOption[0]);
            var6_11 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var6_11 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var6_11.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }
}

