/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.MethodSorters;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ITSqlMusicScriptTest
extends ITAbstractSpannerTest {
    private static final String SCRIPT_FILE = "ITSqlMusicScriptTest.sql";

    @Test
    public void test01_RunScript() throws Exception {
        SqlScriptVerifier verifier = new SqlScriptVerifier();
        try (SqlScriptVerifier.SpannerGenericConnection connection = SqlScriptVerifier.SpannerGenericConnection.of(this.createConnection());){
            verifier.verifyStatementsInFile(connection, SCRIPT_FILE, SqlScriptVerifier.class, false);
        }
    }

    @Test
    public void test02_RunAbortedTest() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        long SINGER_ID = 2L;
        long VENUE_ID = 68L;
        long NUMBER_OF_SINGERS = 30L;
        long NUMBER_OF_ALBUMS = 60L;
        long NUMBER_OF_SONGS = 149L;
        long NUMBER_OF_CONCERTS = 100L;
        long numberOfSongs = 0L;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor);){
            ArrayList<Long> newPrices;
            connection.setAutocommit(false);
            connection.setRetryAbortsInternally(true);
            long expectedId = 3L;
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM Singers ORDER BY SingerId"), new Options.QueryOption[0]);){
                while (rs.next()) {
                    MatcherAssert.assertThat((Object)rs.getLong("SingerId"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedId)));
                    ++expectedId;
                }
            }
            MatcherAssert.assertThat((Object)expectedId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)31L)));
            expectedId = 3L;
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM Albums ORDER BY AlbumId"), new Options.QueryOption[0]);
            var21_15 = null;
            try {
                while (rs.next()) {
                    MatcherAssert.assertThat((Object)rs.getLong("AlbumId"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedId)));
                    if (++expectedId != 31L && expectedId != 32L) continue;
                    expectedId = 33L;
                }
            }
            catch (Throwable throwable) {
                var21_15 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var21_15 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var21_15.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            MatcherAssert.assertThat((Object)expectedId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)61L)));
            expectedId = 1L;
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM Songs ORDER BY TrackId"), new Options.QueryOption[0]);
            var21_15 = null;
            try {
                while (rs.next()) {
                    MatcherAssert.assertThat((Object)rs.getLong("TrackId"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedId)));
                    ++numberOfSongs;
                    if (++expectedId != 40L && expectedId != 64L && expectedId != 76L && expectedId != 86L && expectedId != 96L) continue;
                    ++expectedId;
                }
            }
            catch (Throwable throwable) {
                var21_15 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var21_15 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var21_15.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            MatcherAssert.assertThat((Object)expectedId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)150L)));
            expectedId = 1L;
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM Concerts ORDER BY VenueId"), new Options.QueryOption[0]);
            var21_15 = null;
            try {
                while (rs.next()) {
                    MatcherAssert.assertThat((Object)rs.getLong("VenueId"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedId)));
                    ++expectedId;
                }
            }
            catch (Throwable throwable) {
                var21_15 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var21_15 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var21_15.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            MatcherAssert.assertThat((Object)expectedId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)101L)));
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                MatcherAssert.assertThat((Object)connection2.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
                try (ResultSet rs = connection2.executeQuery(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TicketPrices FROM Concerts WHERE SingerId=@singer AND VenueId=@venue").bind("singer").to(2L)).bind("venue").to(68L)).build(), new Options.QueryOption[0]);){
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    List originalPrices = rs.getLongList(0);
                    newPrices = new ArrayList<Long>(originalPrices);
                    newPrices.set(1, (Long)originalPrices.get(1) + 1L);
                    connection2.executeUpdate(((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"UPDATE Concerts SET TicketPrices=@prices WHERE SingerId=@singer AND VenueId=@venue").bind("prices").toInt64Array(newPrices)).bind("singer").to(2L)).bind("venue").to(68L)).build());
                }
            }
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"Songs").set("SingerId").to(3L)).set("AlbumId").to(3L)).set("TrackId").to(1L)).set("SongName").to("Aborted")).set("Duration").to(1L)).set("SongGenre").to("Unknown")).build());
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.commit();
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            connection.rollback();
            try (ResultSet rs = connection.executeQuery(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT TicketPrices FROM Concerts WHERE SingerId=@singer AND VenueId=@venue").bind("singer").to(2L)).bind("venue").to(68L)).build(), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLongList(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(newPrices)));
            }
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) FROM Songs"), new Options.QueryOption[0]);
            var24_30 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)numberOfSongs)));
            }
            catch (Throwable throwable) {
                var24_30 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var24_30 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var24_30.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }
}

