/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.cloud.spanner.encryption.EncryptionInfo;
import com.google.rpc.Status;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import org.junit.Assert;
import org.junit.Test;

public class EncryptionInfoTest {
    private static final String KMS_KEY_VERSION = "kms-key-version";
    private static final EncryptionInfo.Type CUSTOMER_MANAGED_ENCRYPTION = EncryptionInfo.Type.CUSTOMER_MANAGED_ENCRYPTION;
    private static final Status OK_STATUS = Status.newBuilder().setCode(0).build();

    @Test
    public void testEncryptionInfoFromProtoDefaultInstance() {
        EncryptionInfo encryptionInfo = EncryptionInfo.fromProtoOrNull((com.google.spanner.admin.database.v1.EncryptionInfo)com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance());
        Assert.assertNull((Object)encryptionInfo);
    }

    @Test
    public void testEncryptionInfoFromProto() {
        EncryptionInfo actualEncryptionInfo = EncryptionInfo.fromProtoOrNull((com.google.spanner.admin.database.v1.EncryptionInfo)com.google.spanner.admin.database.v1.EncryptionInfo.newBuilder().setEncryptionStatus(OK_STATUS).setEncryptionTypeValue(CUSTOMER_MANAGED_ENCRYPTION.getNumber()).setKmsKeyVersion(KMS_KEY_VERSION).build());
        EncryptionInfo expectedEncryptionInfo = new EncryptionInfo(KMS_KEY_VERSION, CUSTOMER_MANAGED_ENCRYPTION, OK_STATUS);
        Assert.assertEquals((Object)expectedEncryptionInfo, (Object)actualEncryptionInfo);
    }

    @Test
    public void testEqualsAndHashCode() {
        EncryptionInfo encryptionInfo1 = EncryptionInfo.fromProtoOrNull((com.google.spanner.admin.database.v1.EncryptionInfo)com.google.spanner.admin.database.v1.EncryptionInfo.newBuilder().setEncryptionStatus(OK_STATUS).setEncryptionTypeValue(CUSTOMER_MANAGED_ENCRYPTION.getNumber()).setKmsKeyVersion(KMS_KEY_VERSION).build());
        EncryptionInfo encryptionInfo2 = EncryptionInfo.fromProtoOrNull((com.google.spanner.admin.database.v1.EncryptionInfo)com.google.spanner.admin.database.v1.EncryptionInfo.newBuilder().setEncryptionStatus(OK_STATUS).setEncryptionTypeValue(CUSTOMER_MANAGED_ENCRYPTION.getNumber()).setKmsKeyVersion(KMS_KEY_VERSION).build());
        Assert.assertEquals((Object)encryptionInfo1, (Object)encryptionInfo2);
        Assert.assertEquals((long)encryptionInfo1.hashCode(), (long)encryptionInfo2.hashCode());
    }
}

