/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public final class ITDMLTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static DatabaseClient client;
    private static int seq;
    private static int id;
    private static final String INSERT_DML = "INSERT INTO T (k, v) VALUES ('%d-boo1', 1), ('%d-boo2', 2), ('%d-boo3', 3), ('%d-boo4', 4);";
    private static final String UPDATE_DML = "UPDATE T SET T.V = 100 WHERE T.K LIKE '%d-boo%%';";
    private static final String DELETE_DML = "DELETE FROM T WHERE T.K like '%d-boo%%';";
    private static final long DML_COUNT = 4L;
    private static boolean throwAbortOnce;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K    STRING(MAX) NOT NULL,  V    INT64,) PRIMARY KEY (K)"});
        client = env.getTestHelper().getDatabaseClient(db);
    }

    @Before
    public void increaseTestIdAndDeleteTestData() {
        client.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)"T", (KeySet)KeySet.all())));
        ++id;
    }

    private static String uniqueKey() {
        return "k" + seq++;
    }

    private String insertDml() {
        return String.format(INSERT_DML, id, id, id, id);
    }

    private String updateDml() {
        return String.format(UPDATE_DML, id);
    }

    private String deleteDml() {
        return String.format(DELETE_DML, id);
    }

    private void executeUpdate(long expectedCount, String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = 0L;
            for (String stmt : stmts) {
                if (throwAbortOnce) {
                    throwAbortOnce = false;
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"Abort in test");
                }
                rowCount += transaction.executeUpdate(Statement.of((String)stmt), new Options.UpdateOption[0]);
            }
            return rowCount;
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        Long rowCount = (Long)runner.run(callable);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)expectedCount);
    }

    @Test
    public void abortOnceShouldSucceedAfterRetry() {
        try {
            throwAbortOnce = true;
            this.executeUpdate(4L, this.insertDml());
            Truth.assertThat((Boolean)throwAbortOnce).isFalse();
        }
        catch (AbortedException e) {
            Assert.fail((String)"Abort Exception not caught and retried");
        }
    }

    @Test
    public void partitionedDML() {
        this.executeUpdate(4L, this.insertDml());
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)1);
        long rowCount = client.executePartitionedUpdate(Statement.of((String)this.updateDml()), new Options.UpdateOption[0]);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)4L);
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)100);
        rowCount = client.executePartitionedUpdate(Statement.of((String)this.deleteDml()), new Options.UpdateOption[0]);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)4L);
        Truth.assertThat((Object)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V"))).isNull();
    }

    @Test
    public void standardDML() {
        this.executeUpdate(4L, this.insertDml());
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)1);
        this.executeUpdate(4L, this.updateDml());
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)100);
        this.executeUpdate(4L, this.deleteDml());
        Truth.assertThat((Object)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V"))).isNull();
    }

    @Test
    public void standardDMLWithError() {
        try {
            this.executeUpdate(0L, "SELECT * FROM T;");
            Assert.fail((String)"Expected illegal argument exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"DML response missing stats possibly due to non-DML statement as input");
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void standardDMLWithDuplicates() {
        this.executeUpdate(4L, this.insertDml());
        this.executeUpdate(4L, String.format("UPDATE T SET v = 200 WHERE k = '%d-boo1';", id), String.format("UPDATE T SET v = 300 WHERE k = '%d-boo1';", id), String.format("UPDATE T SET v = 400 WHERE k = '%d-boo1';", id), String.format("UPDATE T SET v = 500 WHERE k = '%d-boo1';", id));
        Truth.assertThat((Long)client.singleUse(TimestampBound.strong()).readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0)).isEqualTo((Object)500);
        this.executeUpdate(4L, this.deleteDml(), this.deleteDml());
    }

    @Test
    public void standardDMLReadYourWrites() {
        this.executeUpdate(4L, this.insertDml());
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)String.format("UPDATE T SET v = v * 2 WHERE k = '%d-boo2';", id)), new Options.UpdateOption[0]);
            Truth.assertThat((Long)rowCount).isEqualTo((Object)1);
            Truth.assertThat((Long)transaction.readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo2", id)}), Collections.singletonList("v")).getLong(0)).isEqualTo((Object)4);
            return null;
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(callable);
        this.executeUpdate(4L, this.deleteDml());
    }

    @Test
    public void standardDMLRollback() {
        class UserException
        extends Exception {
            UserException(String message) {
                super(message);
            }
        }
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)this.insertDml()), new Options.UpdateOption[0]);
            Truth.assertThat((Long)rowCount).isEqualTo((Object)4L);
            throw new UserException("failing to commit");
        };
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(callable);
            Assert.fail((String)"Expected user exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"failing to commit");
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(UserException.class);
        }
        ResultSet resultSet = client.singleUse(TimestampBound.strong()).read("T", KeySet.range((KeyRange)KeyRange.prefix((Key)Key.of((Object[])new Object[]{String.format("%d-boo", id)}))), Collections.singletonList("K"), new Options.ReadOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
    }

    @Test
    public void standardDMLAndMutations() {
        String key1 = ITDMLTest.uniqueKey();
        String key2 = ITDMLTest.uniqueKey();
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)("INSERT INTO T (k, v) VALUES ('" + key1 + "', 1)")), new Options.UpdateOption[0]);
            Truth.assertThat((Long)rowCount).isEqualTo((Object)1);
            transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to(key2)).set("V").to(2L)).build());
            return null;
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(callable);
        KeySet.Builder keys = KeySet.newBuilder();
        keys.addKey(Key.of((Object[])new Object[]{key1})).addKey(Key.of((Object[])new Object[]{key2}));
        ResultSet resultSet = client.singleUse(TimestampBound.strong()).read("T", keys.build(), Collections.singletonList("K"), new Options.ReadOption[0]);
        int rowCount = 0;
        while (resultSet.next()) {
            ++rowCount;
        }
        Truth.assertThat((Integer)rowCount).isEqualTo((Object)2);
    }

    private void executeQuery(long expectedCount, String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = 0L;
            for (String stmt : stmts) {
                ResultSet resultSet = transaction.executeQuery(Statement.of((String)stmt), new Options.QueryOption[0]);
                Truth.assertThat((Boolean)resultSet.next()).isFalse();
                Truth.assertThat((Object)resultSet.getStats()).isNotNull();
                rowCount += resultSet.getStats().getRowCountExact();
            }
            return rowCount;
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        Long rowCount = (Long)runner.run(callable);
        Truth.assertThat((Long)rowCount).isEqualTo((Object)expectedCount);
    }

    @Test
    public void standardDMLWithExecuteSQL() {
        this.executeQuery(4L, this.insertDml());
        this.executeQuery(8L, this.updateDml(), this.deleteDml());
    }

    static {
        throwAbortOnce = false;
    }
}

