/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ParallelIntegrationTest.class})
public class ITTransactionManagerAsyncTest {
    @Parameterized.Parameter(value=0)
    public Executor executor;
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static Spanner spanner;
    private static DatabaseClient client;

    @Parameterized.Parameters(name="executor = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MoreExecutors.directExecutor()}, {Executors.newSingleThreadExecutor()}, {Executors.newFixedThreadPool(4)});
    }

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K                   STRING(MAX) NOT NULL,  BoolValue           BOOL,) PRIMARY KEY (K)"});
        spanner = env.getTestHelper().getClient();
        client = spanner.getDatabaseClient(db.getId());
    }

    @Before
    public void clearTable() {
        client.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"T", (KeySet)KeySet.all())));
    }

    @Test
    public void testSimpleInsert() throws ExecutionException, InterruptedException {
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.STARTED);
                try {
                    txn.then((transaction, ignored) -> {
                        transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key1")).set("BoolValue").to(true)).build());
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync().get();
                    Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMITTED);
                    Struct row = client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key1"}), Arrays.asList("K", "BoolValue"));
                    Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"Key1");
                    Truth.assertThat((Boolean)row.getBoolean(1)).isTrue();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testInvalidInsert() throws InterruptedException {
        AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);
        Throwable throwable = null;
        try {
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                try {
                    while (true) {
                        txn.then((transaction, ignored) -> {
                            transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"InvalidTable").set("K").to("Key1")).set("BoolValue").to(true)).build());
                            return ApiFutures.immediateFuture(null);
                        }, this.executor).commitAsync().get();
                        Assert.fail((String)"Expected exception");
                    }
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                catch (ExecutionException e) {
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
                    Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.COMMIT_FAILED);
                    try {
                        manager.resetForRetryAsync();
                        Assert.fail((String)"Expected exception");
                    }
                    catch (IllegalStateException ex) {
                        Assert.assertNotNull((Object)ex.getMessage());
                    }
                    if (manager != null) {
                        if (throwable != null) {
                            try {
                                manager.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            manager.close();
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (manager != null) {
                    if (throwable != null) {
                        try {
                            manager.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        manager.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    @Test
    public void testRollback() throws InterruptedException {
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                txn.then((transaction, ignored) -> {
                    transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key2")).set("BoolValue").to(true)).build());
                    return ApiFutures.immediateFuture(null);
                }, this.executor);
                try {
                    manager.rollbackAsync();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
            Truth.assertThat((Comparable)manager.getState()).isEqualTo((Object)TransactionManager.TransactionState.ROLLED_BACK);
            Truth.assertThat((Object)client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key2"}), Arrays.asList("K", "BoolValue"))).isNull();
        }
    }

    @Ignore(value="Cloud Spanner now seems to return CANCELLED instead of ABORTED when a transaction is invalidated by a later transaction in the same session")
    @Test
    public void testAbortAndRetry() throws InterruptedException, ExecutionException {
        Assume.assumeFalse((String)"Emulator does not support more than 1 simultaneous transaction. This test would therefore loop indefinitely on the emulator.", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(true)).build()));
        try (AsyncTransactionManager manager1 = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.AsyncTransactionStep txn2Step1;
            AsyncTransactionManager.TransactionContextFuture txn2;
            AsyncTransactionManager manager2;
            AsyncTransactionManager.TransactionContextFuture txn1 = manager1.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep txn1Step1 = txn1.then((transaction, ignored) -> transaction.readRowAsync("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue")), this.executor);
                    manager2 = client.transactionManagerAsync(new Options.TransactionOption[0]);
                    txn2 = manager2.beginAsync();
                    txn2Step1 = txn2.then((transaction, ignored) -> transaction.readRowAsync("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue")), this.executor);
                    AsyncTransactionManager.AsyncTransactionStep txn1Step2 = txn1Step1.then((transaction, ignored) -> {
                        transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(false)).build());
                        return ApiFutures.immediateFuture(null);
                    }, this.executor);
                    txn2Step1.get();
                    txn1Step2.commitAsync().get();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    if (manager1.getState() != TransactionManager.TransactionState.ABORTED) continue;
                    txn1 = manager1.resetForRetryAsync();
                    continue;
                }
                break;
            }
            try {
                txn2Step1.commitAsync().get();
                Assert.fail((String)"Expected to abort");
            }
            catch (AbortedException e) {
                Truth.assertThat((Comparable)manager2.getState()).isEqualTo((Object)TransactionManager.TransactionState.ABORTED);
                txn2 = manager2.resetForRetryAsync();
            }
            AsyncTransactionManager.AsyncTransactionStep txn2Step2 = txn2.then((transaction, ignored) -> {
                transaction.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("K").to("Key3")).set("BoolValue").to(true)).build());
                return ApiFutures.immediateFuture(null);
            }, this.executor);
            txn2Step2.commitAsync().get();
            Struct row = client.singleUse().readRow("T", Key.of((Object[])new Object[]{"Key3"}), Arrays.asList("K", "BoolValue"));
            Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"Key3");
            Truth.assertThat((Boolean)row.getBoolean(1)).isTrue();
            manager2.close();
        }
    }
}

