/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.cloud.spanner.spi.v1.SpannerMetadataProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import io.grpc.Metadata;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class SpannerMetadataProviderTest {
    @Test
    public void testGetHeadersAsMetadata() {
        ImmutableMap headers = ImmutableMap.of((Object)"header1", (Object)"value1", (Object)"header2", (Object)"value2");
        SpannerMetadataProvider metadataProvider = SpannerMetadataProvider.create((Map)headers, (String)"header3");
        Metadata metadata = metadataProvider.newMetadata(null, "stuff");
        Assert.assertEquals((long)(headers.size() + 1), (long)metadata.keys().size());
        Assert.assertEquals(headers.get("header1"), (Object)metadata.get(Metadata.Key.of((String)"header1", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
        Assert.assertEquals(headers.get("header2"), (Object)metadata.get(Metadata.Key.of((String)"header2", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
        Assert.assertEquals((Object)"stuff", (Object)metadata.get(Metadata.Key.of((String)"header3", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
    }

    @Test
    public void testGetResourceHeaderValue() {
        SpannerMetadataProvider metadataProvider = SpannerMetadataProvider.create((Map)ImmutableMap.of(), (String)"header3");
        Assert.assertEquals((Object)"projects/p", (Object)this.getResourceHeaderValue(metadataProvider, "garbage"));
        Assert.assertEquals((Object)"projects/p", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p"));
        Assert.assertEquals((Object)"projects/p/instances/i", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i"));
        Assert.assertEquals((Object)"projects/p/instances/i/databases/d", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i/databases/d"));
        Assert.assertEquals((Object)"projects/p/instances/i/databases/d", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i/databases/d/sessions/s"));
        Assert.assertEquals((Object)"projects/p/instances/i", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i/operations/op"));
        Assert.assertEquals((Object)"projects/p/instances/i/databases/d", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i/databases/d/operations/op"));
        Assert.assertEquals((Object)"projects/p/instances/i", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i/operations"));
        Assert.assertEquals((Object)"projects/p/instances/i/databases/d", (Object)this.getResourceHeaderValue(metadataProvider, "projects/p/instances/i/databases/d/operations"));
    }

    @Test
    public void testNewExtraHeaders() {
        SpannerMetadataProvider metadataProvider = SpannerMetadataProvider.create((Map)ImmutableMap.of(), (String)"header1");
        Map extraHeaders = metadataProvider.newExtraHeaders(null, "value1");
        Truth.assertThat((Map)extraHeaders).containsExactlyEntriesIn((Map)ImmutableMap.of((Object)"header1", (Object)ImmutableList.of((Object)"value1")));
    }

    private String getResourceHeaderValue(SpannerMetadataProvider headerProvider, String resourceTokenTemplate) {
        Metadata metadata = headerProvider.newMetadata(resourceTokenTemplate, "projects/p");
        Assert.assertEquals((long)1L, (long)metadata.keys().size());
        return (String)metadata.get(Metadata.Key.of((String)"header3", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
    }
}

