/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.RandomResultSetGenerator;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactoryTest;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RequestOptions;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class DatabaseClientImplTest {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static final String INSTANCE_NAME = String.format("projects/%s/instances/%s", "my-project", "my-instance");
    private static final String DATABASE_NAME = String.format("projects/%s/instances/%s/databases/%s", "my-project", "my-instance", "my-database");
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private Spanner spanner;
    private Spanner spannerWithEmptySessionPool;
    private static ExecutorService executor;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.SELECT1, MockSpannerTestUtil.SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_ONE_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        executor = Executors.newSingleThreadExecutor();
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
        executor.shutdown();
    }

    @Before
    public void setUp() {
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().build()).build().getService();
        this.spannerWithEmptySessionPool = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setFailOnSessionLeak().build()).build().getService();
    }

    @After
    public void tearDown() {
        mockSpanner.unfreeze();
        this.spanner.close();
        this.spannerWithEmptySessionPool.close();
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void testWrite() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Timestamp timestamp = client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteWithOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        List<CommitRequest> commits = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commits).hasSize(1);
        CommitRequest commit = commits.get(0);
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteWithCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        CommitResponse response = client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
    }

    @Test
    public void testWriteAtLeastOnce() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Timestamp timestamp = client.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
    }

    @Test
    public void testWriteAtLeastOnceWithCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        CommitResponse response = client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteAtLeastOnceWithOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void writeAtLeastOnceWithTagOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Truth.assertThat((String)commit.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test");
        Truth.assertThat((String)commit.getRequestOptions().getRequestTag()).isEmpty();
    }

    @Test
    public void testExecuteQueryWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.tag((String)"app=spanner,env=test,action=query")});){
            while (resultSet.next()) {
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=query");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testExecuteReadWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.tag((String)"app=spanner,env=test,action=read")});){
            while (resultSet.next()) {
            }
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=read");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testReadWriteExecuteQueryWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=txn")});
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.tag((String)"app=spanner,env=test,action=query")});){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=query");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=txn");
    }

    @Test
    public void testReadWriteExecuteReadWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=txn")});
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.tag((String)"app=spanner,env=test,action=read")});){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=read");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=txn");
    }

    @Test
    public void testExecuteUpdateWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=update")}));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=update");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testBatchUpdateWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=txn")});
        runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=batch")}));
        List<ExecuteBatchDmlRequest> requests = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteBatchDmlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=batch");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=txn");
    }

    @Test
    public void testPartitionedDMLWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=dml")});
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=dml");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=commit")});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=commit");
    }

    @Test
    public void testTransactionManagerCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=manager")});
        TransactionContext transaction = manager.begin();
        transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
        manager.commit();
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=manager");
    }

    @Test
    public void testAsyncRunnerCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=runner")});
        SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor));
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=runner");
    }

    @Test
    public void testAsyncTransactionManagerCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=manager")});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            SpannerApiFutures.get((ApiFuture)transaction.then((txn, input) -> {
                txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor).commitAsync());
        }
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=manager");
    }

    @Test
    public void singleUse() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Iterable)checkedOut).hasSize(1);
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void singleUseIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseAsync() throws Exception {
        ApiFuture res;
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AtomicInteger rowCount = new AtomicInteger();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            res = rs.setCallback((Executor)executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case OK: {
                            rowCount.incrementAndGet();
                            break;
                        }
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                    }
                }
            });
        }
        res.get();
        Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)1);
    }

    @Test
    public void singleUseAsyncWithoutCallback() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        int rowCount = 0;
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            while (rs.next()) {
                ++rowCount;
            }
        }
        Truth.assertThat((Integer)rowCount).isEqualTo((Object)1);
    }

    @Test
    public void singleUseBound() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseBoundIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseBoundAsync() throws Exception {
        ApiFuture res;
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AtomicInteger rowCount = new AtomicInteger();
        try (AsyncResultSet rs = client.singleUse(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            res = rs.setCallback((Executor)executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case OK: {
                            rowCount.incrementAndGet();
                            break;
                        }
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                    }
                }
            });
        }
        res.get();
        Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)1);
    }

    @Test
    public void singleUseTransaction() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseTransactionIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseTransactionBound() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseTransactionBoundIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransaction() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransactionIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransactionBound() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS));
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransactionBoundIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS));
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testReadWriteTransaction() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return null;
        });
        Assert.assertNotNull((Object)runner.getCommitTimestamp());
    }

    @Test
    public void testReadWriteTransaction_returnsCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.commitStats()});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})));
            return null;
        });
        Assert.assertNotNull((Object)runner.getCommitResponse());
        Assert.assertNotNull((Object)runner.getCommitResponse().getCommitStats());
        Assert.assertEquals((long)1L, (long)runner.getCommitResponse().getCommitStats().getMutationCount());
    }

    @Test
    public void readWriteTransactionIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        mockSpanner.unfreeze();
        runner.run(transaction -> {
            transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return null;
        });
    }

    @Test
    public void testRunAsync() throws Exception {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture result = runner.runAsync(txn -> ApiFutures.immediateFuture((Object)txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])), (Executor)executor);
        Assert.assertEquals((long)1L, (long)((Long)result.get()));
        Assert.assertNotNull((Object)runner.getCommitTimestamp().get());
        executor.shutdown();
    }

    @Test
    public void testRunAsync_returnsCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.commitStats()});
        ApiFuture result = runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        Assert.assertNull((Object)SpannerApiFutures.get((ApiFuture)result));
        Assert.assertNotNull((Object)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse()));
        Assert.assertNotNull((Object)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitStats());
        Assert.assertEquals((long)1L, (long)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitStats().getMutationCount());
        executor.shutdown();
    }

    @Test
    public void runAsyncIsNonBlocking() throws Exception {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture fut = runner.runAsync(txn -> ApiFutures.immediateFuture((Object)txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])), (Executor)executor);
        mockSpanner.unfreeze();
        Truth.assertThat((Long)((Long)fut.get())).isEqualTo((Object)1L);
        executor.shutdown();
    }

    @Test
    public void runAsyncWithException() throws Exception {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture fut = runner.runAsync(txn -> ApiFutures.immediateFuture((Object)txn.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0])), (Executor)executor);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            Long cfr_ignored_0 = (Long)fut.get();
        });
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
        SpannerException se = (SpannerException)e.getCause();
        Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        executor.shutdown();
    }

    @Test
    public void testTransactionManager() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    manager.commit();
                    Assert.assertNotNull((Object)manager.getCommitTimestamp());
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testTransactionManager_returnsCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.commitStats()});){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    transaction.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})));
                    manager.commit();
                    Assert.assertNotNull((Object)manager.getCommitResponse());
                    Assert.assertNotNull((Object)manager.getCommitResponse().getCommitStats());
                    Assert.assertEquals((long)1L, (long)manager.getCommitResponse().getCommitStats().getMutationCount());
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerIsNonBlocking() throws Exception {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager txManager = client.transactionManager(new Options.TransactionOption[0]);){
            mockSpanner.unfreeze();
            TransactionContext transaction = txManager.begin();
            while (true) {
                try {
                    transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    txManager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerExecuteQueryAsync() throws Exception {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AtomicInteger rowCount = new AtomicInteger();
        try (TransactionManager txManager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = txManager.begin();
            while (true) {
                try {
                    try (AsyncResultSet rs = transaction.executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                        rs.setCallback((Executor)executor, resultSet -> {
                            try {
                                while (true) {
                                    switch (resultSet.tryNext()) {
                                        case OK: {
                                            rowCount.incrementAndGet();
                                            break;
                                        }
                                        case DONE: {
                                            return AsyncResultSet.CallbackResponse.DONE;
                                        }
                                        case NOT_READY: {
                                            return AsyncResultSet.CallbackResponse.CONTINUE;
                                        }
                                    }
                                }
                            }
                            catch (Throwable t) {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                        });
                    }
                    txManager.commit();
                }
                catch (AbortedException e) {
                    transaction = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)1);
    }

    @Test
    public void testExecutePartitionedDml() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
    }

    @Test
    public void testExecutePartitionedDmlAborted() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        mockSpanner.abortNextTransaction();
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
    }

    @Test(expected=SpannerException.class)
    public void testExecutePartitionedDmlWithQuery() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(MockSpannerTestUtil.SELECT1, new Options.UpdateOption[0]);
    }

    @Test(expected=SpannerException.class)
    public void testExecutePartitionedDmlWithException() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
    }

    @Test
    public void testPartitionedDmlDoesNotTimeout() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)1L)).setMaxRpcTimeout(Duration.ofMillis((long)1L)).setMaxAttempts(1).setTotalTimeout(Duration.ofMillis((long)1L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getSpannerStubSettingsBuilder().executeSqlSettings().setRetrySettings(retrySettings);
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Truth.assertThat((Comparable)((SpannerOptions)spanner.getOptions()).getPartitionedDmlTimeout()).isEqualTo((Object)Duration.ofHours((long)2L));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testPartitionedDmlWithLowerTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setPartitionedDmlTimeout(Duration.ofMillis((long)10L));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Truth.assertThat((Comparable)((SpannerOptions)spanner.getOptions()).getPartitionedDmlTimeout()).isEqualTo((Object)Duration.ofMillis((long)10L));
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
            long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        }
    }

    @Test
    public void testPartitionedDmlWithHigherTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(100, 0));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setPartitionedDmlTimeout(Duration.ofMillis((long)5000L));
        builder.getSpannerStubSettingsBuilder().executeSqlSettings().setRetrySettings(builder.getSpannerStubSettingsBuilder().executeSqlSettings().getRetrySettings().toBuilder().setInitialRpcTimeout(Duration.ofMillis((long)10L)).setMaxRpcTimeout(Duration.ofMillis((long)10L)).setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).build());
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(100, 0));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
                Long cfr_ignored_0 = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            });
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        }
    }

    @Test
    public void testPartitionedDmlRetriesOnUnavailable() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNAVAILABLE.asRuntimeException())));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        }
    }

    @Test
    public void testDatabaseOrInstanceDoesNotExistOnInitialization() throws Exception {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)exception)));
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Stopwatch watch = Stopwatch.createStarted();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsInPool()).isEqualTo((Object)0);
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsBeingCreated()).isEqualTo((Object)0);
                mockSpanner.reset();
                mockSpanner.removeAllExecutionTimes();
            }
        }
    }

    @Test
    public void testDatabaseOrInstanceDoesNotExistOnCreate() {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)exception)));
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                try (ResultSet rs = dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> rs.next());
                    Truth.assertThat(mockSpanner.getRequests()).hasSize(1);
                }
                Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.readWriteTransaction(new Options.TransactionOption[0]));
                Truth.assertThat(mockSpanner.getRequests()).hasSize(1);
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testDatabaseOrInstanceDoesNotExistOnReplenish() throws Exception {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)exception)));
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Stopwatch watch = Stopwatch.createStarted();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsInPool()).isEqualTo((Object)0);
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsBeingCreated()).isEqualTo((Object)0);
                dbClient.pool.poolMaintainer.maintainPool();
                watch = watch.reset().start();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsInPool()).isEqualTo((Object)0);
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsBeingCreated()).isEqualTo((Object)0);
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testDatabaseOrInstanceIsDeletedAndThenRecreated() throws Exception {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Stopwatch watch = Stopwatch.createStarted();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                mockSpanner.setStickyGlobalExceptions(true);
                mockSpanner.addException((Exception)((Object)exception));
                try (ResultSet rs = dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> rs.next());
                }
                Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> null));
                mockSpanner.reset();
                Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]));
                Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> null));
                Truth.assertThat(mockSpanner.getRequests()).isEmpty();
                DatabaseClientImpl newClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Truth.assertThat((Object)newClient).isNotSameInstanceAs((Object)dbClient);
                try (ResultSet rs = newClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                    }
                }
                Truth.assertThat(mockSpanner.getRequests()).isNotEmpty();
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testGetInvalidatedClientMultipleTimes() {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)exception)));
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
                for (int run = 0; run < 2; ++run) {
                    DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                    for (int useClient = 0; useClient < 2; ++useClient) {
                        Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]).next());
                        Truth.assertThat(mockSpanner.getRequests()).hasSize(run + 1);
                        Truth.assertThat((Boolean)dbClient.pool.isValid()).isFalse();
                    }
                }
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testAllowNestedTransactions() throws InterruptedException {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(TimeUnit.SECONDS) < 5L && client.pool.getNumberOfSessionsInPool() < minSessions) {
            Thread.sleep(1L);
        }
        Truth.assertThat((Integer)client.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        Long res = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).allowNestedTransaction().run(transaction -> {
            Truth.assertThat((Integer)client.pool.getNumberOfSessionsInPool()).isEqualTo((Object)(minSessions - 1));
            return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        });
        Truth.assertThat((Long)res).isEqualTo((Object)1L);
        Truth.assertThat((Integer)client.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
    }

    @Test
    public void testNestedTransactionsUsingTwoDatabases() throws InterruptedException {
        DatabaseClientImpl client1 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)"my-database-1"));
        DatabaseClientImpl client2 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)"my-database-2"));
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(TimeUnit.SECONDS) < 5L && (client1.pool.getNumberOfSessionsInPool() < minSessions || client2.pool.getNumberOfSessionsInPool() < minSessions)) {
            Thread.sleep(1L);
        }
        Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        Long res = (Long)client1.readWriteTransaction(new Options.TransactionOption[0]).allowNestedTransaction().run(transaction -> {
            Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)(minSessions - 1));
            Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
            Long add = (Long)client2.readWriteTransaction(new Options.TransactionOption[0]).run(transaction1 -> {
                Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)(minSessions - 1));
                Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)(minSessions - 1));
                try (ResultSet rs = transaction1.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                    Long l = 0L;
                    return l;
                }
            });
            try (ResultSet rs = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                if (rs.next()) {
                    Long l = add + rs.getLong(0);
                    return l;
                }
                Long l = add;
                return l;
            }
        });
        Truth.assertThat((Long)res).isEqualTo((Object)2L);
        Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
    }

    @Test
    public void testBackendQueryOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            try (ResultSet rs = client.singleUse().executeQuery(Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            Truth.assertThat(requests).isNotEmpty();
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest request = (ExecuteSqlRequest)requests.get(requests.size() - 1);
            Truth.assertThat((Object)request.getQueryOptions()).isNotNull();
            Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
        }
    }

    @Test
    public void testBackendQueryOptionsWithAnalyzeQuery() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            try (ReadOnlyTransaction tx = client.readOnlyTransaction();
                 ResultSet rs = tx.analyzeQuery(Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), ReadContext.QueryAnalyzeMode.PROFILE);){
                while (rs.next()) {
                }
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            Truth.assertThat(requests).isNotEmpty();
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest request = (ExecuteSqlRequest)requests.get(requests.size() - 1);
            Truth.assertThat((Object)request.getQueryOptions()).isNotNull();
            Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
            Truth.assertThat((Comparable)request.getQueryMode()).isEqualTo((Object)ExecuteSqlRequest.QueryMode.PROFILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendPartitionQueryOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
            BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());
            List partitions = transaction.partitionQuery(PartitionOptions.newBuilder().setMaxPartitions(10L).build(), Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.QueryOption[0]);
            try (ResultSet rs = transaction.execute((Partition)partitions.get(0));){
                while (rs.next()) {
                }
            }
            finally {
                transaction.cleanup();
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            assert (requests.size() >= 2) : "required to have at least 2 requests";
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(DeleteSessionRequest.class);
            Truth.assertThat((Object)requests.get(requests.size() - 2)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest executeSqlRequest = (ExecuteSqlRequest)requests.get(requests.size() - 2);
            Truth.assertThat((Object)executeSqlRequest.getQueryOptions()).isNotNull();
            Truth.assertThat((String)executeSqlRequest.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)executeSqlRequest.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
        }
    }

    @Test
    public void testAsyncQuery() throws Exception {
        ApiFuture resultSetClosed;
        int EXPECTED_ROW_COUNT = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(10);
        com.google.spanner.v1.ResultSet resultSet = generator.generate();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT * FROM RANDOM"), resultSet));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        SettableFuture finished = SettableFuture.create();
        ArrayList receivedResults = new ArrayList();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(Statement.of((String)"SELECT * FROM RANDOM"), new Options.QueryOption[0]);){
            resultSetClosed = rs.setCallback((Executor)executor, asyncResultSet -> {
                try {
                    block7: while (true) {
                        switch (rs.tryNext()) {
                            case DONE: {
                                finished.set((Object)true);
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                receivedResults.add(asyncResultSet.getCurrentRowAsStruct());
                                continue block7;
                            }
                        }
                        break;
                    }
                    throw new IllegalStateException("Unknown cursor state");
                }
                catch (Throwable t) {
                    finished.setException(t);
                    return AsyncResultSet.CallbackResponse.DONE;
                }
            });
        }
        Truth.assertThat((Boolean)((Boolean)finished.get())).isTrue();
        Truth.assertThat((Integer)receivedResults.size()).isEqualTo((Object)10);
        resultSetClosed.get();
    }

    @Test
    public void testClientIdReusedOnDatabaseNotFound() {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)SpannerExceptionFactoryTest.newStatusResourceNotFoundException(TEST_DATABASE, "type.googleapis.com/google.spanner.admin.database.v1.Database", "project/my-project/instances/my-instance/databases/my-database"))));
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE);
            String prevClientId = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(databaseId);
                    if (prevClientId != null) {
                        Truth.assertThat((String)client.clientId).isEqualTo((Object)prevClientId);
                    }
                    prevClientId = client.clientId;
                    client.singleUse().readRow("MyTable", Key.of((Object[])new Object[]{0}), Collections.singletonList("MyColumn"));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testBatchCreateSessionsPermissionDenied() {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)Status.PERMISSION_DENIED.withDescription("Not permitted").asRuntimeException())));
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE);
            DatabaseClient client = spanner.getDatabaseClient(databaseId);
            ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Assert.assertEquals((Object)ErrorCode.PERMISSION_DENIED, (Object)e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionIncludesStatement() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.INVALID_ARGUMENT.withDescription("Invalid query").asRuntimeException())));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse().executeQuery(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM FOO WHERE ID=@id").bind("id").to(1L)).build(), new Options.QueryOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Statement: 'SELECT * FROM FOO WHERE ID=@id'");
            Truth.assertThat((String)e.getMessage()).doesNotContain((CharSequence)"id: 1");
        }
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.INVALID_ARGUMENT.withDescription("Invalid query").asRuntimeException())));
        Logger logger = Logger.getLogger(AbstractResultSet.GrpcStreamIterator.class.getName());
        Level currentLevel = logger.getLevel();
        try (ResultSet rs = client.singleUse().executeQuery(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM FOO WHERE ID=@id").bind("id").to(1L)).build(), new Options.QueryOption[0]);){
            logger.setLevel(Level.FINEST);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Statement: 'SELECT * FROM FOO WHERE ID=@id {id: 1}'");
        }
        finally {
            logger.setLevel(currentLevel);
        }
    }

    @Test
    public void testReadDoesNotIncludeStatement() {
        mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.INVALID_ARGUMENT.withDescription("Invalid read").asRuntimeException())));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse().read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), (Iterable)ImmutableList.of((Object)"BAR"), new Options.ReadOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).doesNotContain((CharSequence)"Statement:");
        }
    }

    @Test
    public void testSpecificTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Context.current().withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)SpannerOptions.SpannerCallContextTimeoutConfigurator.create().withExecuteQueryTimeout(Duration.ofNanos((long)1L))).run(() -> {
            try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            }
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchCreateSessionsFailure_shouldNotPropagateToCloseMethod() {
        try {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)((Object)Status.RESOURCE_EXHAUSTED.asRuntimeException())));
            DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
            }
        }
        finally {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.none());
        }
    }

    @Test
    public void testReadWriteTransaction_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool);
        client.readWriteTransaction(new Options.TransactionOption[]{option});
        ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).readWriteTransaction(new Options.TransactionOption[]{option});
    }

    @Test
    public void testTransactionManager_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool);
        client.transactionManager(new Options.TransactionOption[]{option});
        ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).transactionManager(new Options.TransactionOption[]{option});
    }

    @Test
    public void testRunAsync_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool);
        client.runAsync(new Options.TransactionOption[]{option});
        ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).runAsync(new Options.TransactionOption[]{option});
    }

    @Test
    public void testTransactionManagerAsync_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool);
        client.transactionManagerAsync(new Options.TransactionOption[]{option});
        ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).transactionManagerAsync(new Options.TransactionOption[]{option});
    }

    @Test
    public void testExecuteQueryWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            while (resultSet.next()) {
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testExecuteReadWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            while (resultSet.next()) {
            }
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testReadWriteExecuteQueryWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testReadWriteExecuteReadWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testExecuteUpdateWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)}));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testBatchUpdateWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)}));
        List<ExecuteBatchDmlRequest> requests = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteBatchDmlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testPartitionedDMLWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testTransactionManagerCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        TransactionContext transaction = manager.begin();
        transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
        manager.commit();
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testAsyncRunnerCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor));
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testAsyncTransactionManagerCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            SpannerApiFutures.get((ApiFuture)transaction.then((txn, input) -> {
                txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor).commitAsync());
        }
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void singleUseNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.singleUse().close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void singleUseReadOnlyTransactionNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.singleUseReadOnlyTransaction().close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void readWriteTransactionNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.readWriteTransaction(new Options.TransactionOption[0]);
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void readOnlyTransactionNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.readOnlyTransaction().close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void transactionManagerNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.transactionManager(new Options.TransactionOption[0]).close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void transactionContextFailsIfUsedMultipleTimes() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Function<TransactionContext, Long> function = new Function<TransactionContext, Long>(){
            TransactionContext ctx;

            @Override
            public Long apply(TransactionContext transactionContext) {
                if (this.ctx == null) {
                    this.ctx = transactionContext;
                }
                try (ResultSet rs = this.ctx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                    }
                }
                return 1L;
            }
        };
        Assert.assertEquals((Object)1L, (Object)client.readWriteTransaction(new Options.TransactionOption[0]).run(tx -> (Long)function.apply(tx)));
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
            Long cfr_ignored_0 = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(tx -> (Long)function.apply(tx));
        });
        Assert.assertTrue((boolean)exception.getMessage().contains("Context has been closed"));
    }

    @Test
    public void testGetDialectDefault() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)client.getDialect());
    }

    @Test
    public void testGetDialectDefaultPreloaded() {
        try (Spanner spanner = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)client.getDialect());
        }
    }

    @Test
    public void testGetDialectPostgreSQL() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
        try {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)client.getDialect());
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDialectPostgreSQLPreloaded() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
        try (Spanner spanner = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)client.getDialect());
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
        }
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
    }
}

