/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.opencensus.common.Clock;
import io.opencensus.internal.ZeroTimeClock;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceComponent;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracestate;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.config.TraceParams;
import io.opencensus.trace.export.ExportComponent;
import io.opencensus.trace.export.RunningSpanStore;
import io.opencensus.trace.export.SampledSpanStore;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.propagation.BinaryFormat;
import io.opencensus.trace.propagation.PropagationComponent;
import io.opencensus.trace.propagation.TextFormat;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class FailOnOverkillTraceComponentImpl
extends TraceComponent {
    private static final Random RANDOM = new Random();
    private final Tracer tracer = new TestTracer();
    private final PropagationComponent propagationComponent = new TestPropagationComponent();
    private final Clock clock = ZeroTimeClock.getInstance();
    private final ExportComponent exportComponent = new TestExportComponent();
    private final TraceConfig traceConfig = new TestTraceConfig();
    private static final Map<String, Boolean> spans = new LinkedHashMap<String, Boolean>();

    public Tracer getTracer() {
        return this.tracer;
    }

    Map<String, Boolean> getSpans() {
        return spans;
    }

    void clearSpans() {
        spans.clear();
    }

    public PropagationComponent getPropagationComponent() {
        return this.propagationComponent;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ExportComponent getExportComponent() {
        return this.exportComponent;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }

    public static class TestTraceConfig
    extends TraceConfig {
        private volatile TraceParams activeTraceParams = TraceParams.DEFAULT;

        public TraceParams getActiveTraceParams() {
            return this.activeTraceParams;
        }

        public void updateActiveTraceParams(TraceParams traceParams) {
            this.activeTraceParams = traceParams;
        }
    }

    public static class TestExportComponent
    extends ExportComponent {
        private final SpanExporter spanExporter = new TestSpanExporter();

        public SpanExporter getSpanExporter() {
            return this.spanExporter;
        }

        public RunningSpanStore getRunningSpanStore() {
            return null;
        }

        public SampledSpanStore getSampledSpanStore() {
            return null;
        }
    }

    public static class TestSpanExporter
    extends SpanExporter {
        public void registerHandler(String name, SpanExporter.Handler handler) {
        }

        public void unregisterHandler(String name) {
        }
    }

    public static class TestPropagationComponent
    extends PropagationComponent {
        public BinaryFormat getBinaryFormat() {
            return null;
        }

        public TextFormat getB3Format() {
            return null;
        }

        public TextFormat getTraceContextFormat() {
            return null;
        }
    }

    public static class TestTracer
    extends Tracer {
        public SpanBuilder spanBuilderWithExplicitParent(String spanName, Span parent) {
            return new TestSpanBuilder(spanName);
        }

        public SpanBuilder spanBuilderWithRemoteParent(String spanName, SpanContext remoteParentSpanContext) {
            return new TestSpanBuilder(spanName);
        }
    }

    public static class TestSpanBuilder
    extends SpanBuilder {
        private String spanName;

        TestSpanBuilder(String spanName) {
            this.spanName = spanName;
        }

        public SpanBuilder setSampler(Sampler sampler) {
            return this;
        }

        public SpanBuilder setParentLinks(List<Span> parentLinks) {
            return this;
        }

        public SpanBuilder setRecordEvents(boolean recordEvents) {
            return this;
        }

        public Span startSpan() {
            return new TestSpan(this.spanName, SpanContext.create((TraceId)TraceId.generateRandomId((Random)RANDOM), (SpanId)SpanId.generateRandomId((Random)RANDOM), (TraceOptions)TraceOptions.builder().setIsSampled(true).build(), (Tracestate)Tracestate.builder().build()), EnumSet.of(Span.Options.RECORD_EVENTS));
        }
    }

    public static class TestSpan
    extends Span {
        @GuardedBy(value="this")
        private volatile boolean ended = false;
        private String spanName;

        private TestSpan(String spanName, SpanContext context, EnumSet<Span.Options> options) {
            super(context, options);
            this.spanName = spanName;
            spans.put(this.spanName, false);
        }

        public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        }

        public void addAnnotation(Annotation annotation) {
        }

        public void addLink(Link link) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end(EndSpanOptions options) {
            TestSpan testSpan = this;
            synchronized (testSpan) {
                if (this.ended) {
                    throw new IllegalStateException(this.spanName + " already ended");
                }
                spans.put(this.spanName, true);
                this.ended = true;
            }
        }
    }
}

