/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.StandardBenchmarkMockServer;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, warmups=0)
@Measurement(batchSize=1, iterations=1, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(batchSize=0, iterations=0)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class InlineBeginBenchmark {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static final int HOLD_SESSION_TIME = 100;
    private static final int RND_WAIT_TIME_BETWEEN_REQUESTS = 10;
    private static final Random RND = new Random();

    @Benchmark
    public void burstRead(BenchmarkState server) throws Exception {
        int totalQueries = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 8;
        int parallelThreads = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 2;
        SessionPool pool = ((BenchmarkState)server).client.pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalQueries);
        for (int i = 0; i < totalQueries; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(10));
                try (ResultSet rs = server.client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        Thread.sleep(RND.nextInt(100));
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @Benchmark
    public void burstWrite(BenchmarkState server) throws Exception {
        int totalWrites = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 8;
        int parallelThreads = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 2;
        SessionPool pool = ((BenchmarkState)server).client.pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalWrites);
        for (int i = 0; i < totalWrites; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(10));
                TransactionRunner runner = server.client.readWriteTransaction(new Options.TransactionOption[0]);
                return (Long)runner.run(transaction -> transaction.executeUpdate(StandardBenchmarkMockServer.UPDATE_STATEMENT, new Options.UpdateOption[0]));
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @Benchmark
    public void burstReadAndWrite(BenchmarkState server) throws Exception {
        int i;
        int totalWrites = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 4;
        int totalReads = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 4;
        int parallelThreads = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions() * 2;
        SessionPool pool = ((BenchmarkState)server).client.pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalReads + totalWrites);
        for (i = 0; i < totalWrites; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(10));
                TransactionRunner runner = server.client.readWriteTransaction(new Options.TransactionOption[0]);
                return (Long)runner.run(transaction -> transaction.executeUpdate(StandardBenchmarkMockServer.UPDATE_STATEMENT, new Options.UpdateOption[0]));
            }));
        }
        for (i = 0; i < totalReads; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(10));
                try (ResultSet rs = server.client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        Thread.sleep(RND.nextInt(100));
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        private final boolean useRealServer = Boolean.parseBoolean(System.getProperty("useRealServer"));
        private final String instance = System.getProperty("instance", "my-instance");
        private final String database = System.getProperty("database", "my-database");
        private StandardBenchmarkMockServer mockServer;
        private Spanner spanner;
        private DatabaseClientImpl client;
        @Param(value={"true"})
        boolean inlineBegin;
        @Param(value={"0.2"})
        float writeFraction;

        @Setup(value=Level.Invocation)
        public void setup() throws Exception {
            SpannerOptions options;
            System.out.println("useRealServer: " + System.getProperty("useRealServer"));
            System.out.println("instance: " + System.getProperty("instance"));
            if (this.useRealServer) {
                System.out.println("running benchmark with **REAL** server");
                System.out.println("instance: " + this.instance);
                System.out.println("database: " + this.database);
                options = this.createRealServerOptions();
            } else {
                System.out.println("running benchmark with **MOCK** server");
                this.mockServer = new StandardBenchmarkMockServer();
                TransportChannelProvider channelProvider = this.mockServer.start();
                options = this.createBenchmarkServerOptions(channelProvider);
            }
            this.spanner = (Spanner)options.getService();
            this.client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)this.instance, (String)this.database));
            Stopwatch watch = Stopwatch.createStarted();
            while (this.client.pool.getNumberOfSessionsInPool() < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions()) {
                Thread.sleep(1L);
                if (watch.elapsed(TimeUnit.SECONDS) <= 10L) continue;
                break;
            }
        }

        SpannerOptions createBenchmarkServerOptions(TransportChannelProvider channelProvider) {
            return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(InlineBeginBenchmark.TEST_PROJECT)).setChannelProvider(channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWriteSessionsFraction(this.writeFraction).build()).build();
        }

        SpannerOptions createRealServerOptions() {
            return SpannerOptions.newBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setWriteSessionsFraction(this.writeFraction).build()).build();
        }

        @TearDown(value=Level.Invocation)
        public void teardown() throws Exception {
            this.spanner.close();
            if (this.mockServer != null) {
                this.mockServer.shutdown();
            }
        }
    }
}

