/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerExceptionFactoryTest;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Value;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.Partition;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import io.grpc.Metadata;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import io.grpc.stub.StreamObserver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.threeten.bp.Instant;

public class MockSpannerServiceImpl
extends SpannerGrpc.SpannerImplBase
implements MockGrpcService {
    public static final SimulatedExecutionTime NO_EXECUTION_TIME = SimulatedExecutionTime.none();
    private final Random random = new Random();
    private double abortProbability = 0.001;
    private boolean includeDetermineDialectStatementInRequests = false;
    private final Object lock = new Object();
    private Deque<AbstractMessage> requests = new ConcurrentLinkedDeque<AbstractMessage>();
    private volatile CountDownLatch freezeLock = new CountDownLatch(0);
    private Queue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();
    private boolean stickyGlobalExceptions = false;
    private ConcurrentMap<Statement, StatementResult> statementResults = new ConcurrentHashMap<Statement, StatementResult>();
    private ConcurrentMap<Statement, Long> statementGetCounts = new ConcurrentHashMap<Statement, Long>();
    private ConcurrentMap<String, StatementResult> partialStatementResults = new ConcurrentHashMap<String, StatementResult>();
    private ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private ConcurrentMap<String, Instant> sessionLastUsed = new ConcurrentHashMap<String, Instant>();
    private ConcurrentMap<ByteString, Transaction> transactions = new ConcurrentHashMap<ByteString, Transaction>();
    private final Queue<ByteString> transactionsStarted = new ConcurrentLinkedQueue<ByteString>();
    private ConcurrentMap<ByteString, Boolean> isPartitionedDmlTransaction = new ConcurrentHashMap<ByteString, Boolean>();
    private ConcurrentMap<ByteString, Boolean> abortedTransactions = new ConcurrentHashMap<ByteString, Boolean>();
    private final AtomicBoolean abortNextTransaction = new AtomicBoolean();
    private final AtomicBoolean abortNextStatement = new AtomicBoolean();
    private final AtomicBoolean ignoreNextInlineBeginRequest = new AtomicBoolean();
    private ConcurrentMap<String, AtomicLong> transactionCounters = new ConcurrentHashMap<String, AtomicLong>();
    private ConcurrentMap<String, List<ByteString>> partitionTokens = new ConcurrentHashMap<String, List<ByteString>>();
    private ConcurrentMap<ByteString, Instant> transactionLastUsed = new ConcurrentHashMap<ByteString, Instant>();
    private int maxNumSessionsInOneBatch = 100;
    private int maxTotalSessions = Integer.MAX_VALUE;
    private AtomicInteger numSessionsCreated = new AtomicInteger();
    private SimulatedExecutionTime beginTransactionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime commitExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime batchCreateSessionsExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime createSessionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime deleteSessionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime executeBatchDmlExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime executeSqlExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime executeStreamingSqlExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime getSessionExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime listSessionsExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime partitionQueryExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime partitionReadExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime readExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime rollbackExecutionTime = NO_EXECUTION_TIME;
    private SimulatedExecutionTime streamingReadExecutionTime = NO_EXECUTION_TIME;

    public MockSpannerServiceImpl() {
        this.putStatementResult(StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
    }

    private String generateSessionName(String database) {
        return String.format("%s/sessions/%s", database, UUID.randomUUID().toString());
    }

    private ByteString generateTransactionName(String session) {
        AtomicLong counter = (AtomicLong)this.transactionCounters.get(session);
        if (counter == null) {
            counter = new AtomicLong();
            this.transactionCounters.put(session, counter);
        }
        return ByteString.copyFromUtf8((String)String.format("%s/transactions/%d", session, counter.incrementAndGet()));
    }

    private ByteString generatePartitionToken(String session, ByteString transactionId) {
        ByteString token = ByteString.copyFromUtf8((String)UUID.randomUUID().toString());
        String key = this.partitionKey(session, transactionId);
        List tokens = this.partitionTokens.computeIfAbsent(key, k -> new ArrayList(5));
        tokens.add(token);
        return token;
    }

    private String partitionKey(String session, ByteString transactionId) {
        return String.format("%s/transactions/%s", session, transactionId.toStringUtf8());
    }

    private com.google.protobuf.Timestamp getCurrentGoogleTimestamp() {
        long current = System.currentTimeMillis();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(current);
        int nanos = (int)TimeUnit.MILLISECONDS.toNanos(current - TimeUnit.SECONDS.toMillis(seconds));
        return com.google.protobuf.Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStatementResult(StatementResult result) {
        Preconditions.checkNotNull((Object)result);
        Object object = this.lock;
        synchronized (object) {
            this.statementResults.put(result.statement, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStatementResults(StatementResult ... results) {
        Object object = this.lock;
        synchronized (object) {
            for (StatementResult result : results) {
                this.statementResults.put(result.statement, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPartialStatementResult(StatementResult result) {
        Object object = this.lock;
        synchronized (object) {
            this.partialStatementResults.put(result.statement.getSql(), result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementResult getResult(Statement statement) {
        StatementResult res;
        Object object = this.lock;
        synchronized (object) {
            res = (StatementResult)this.statementResults.get(statement);
            if (this.statementGetCounts.containsKey(statement)) {
                this.statementGetCounts.put(statement, (Long)this.statementGetCounts.get(statement) + 1L);
            } else {
                this.statementGetCounts.put(statement, 1L);
            }
            if (res == null) {
                for (String partialSql : this.partialStatementResults.keySet()) {
                    if (!statement.getSql().startsWith(partialSql)) continue;
                    res = (StatementResult)this.partialStatementResults.get(partialSql);
                }
            }
        }
        if (res == null) {
            throw Status.INTERNAL.withDescription(String.format("There is no result registered for the statement: %s\nCall TestSpannerImpl#addStatementResult(StatementResult) before executing the statement.", statement.toString())).asRuntimeException();
        }
        return res;
    }

    public void setAbortProbability(double probability) {
        Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (Object)"Probability must be >= 0 and <= 1");
        this.abortProbability = probability;
    }

    public void setIncludeDetermineDialectStatementInRequests(boolean include) {
        this.includeDetermineDialectStatementInRequests = include;
    }

    public void abortTransaction(TransactionContext transactionContext) {
        Preconditions.checkNotNull((Object)transactionContext);
        if (transactionContext instanceof SessionPool.SessionPoolTransactionContext) {
            transactionContext = ((SessionPool.SessionPoolTransactionContext)transactionContext).delegate;
        }
        if (transactionContext instanceof TransactionRunnerImpl.TransactionContextImpl) {
            ByteString id;
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transactionContext;
            ByteString byteString = id = impl.getTransactionSelector() == null ? null : impl.getTransactionSelector().getId();
            if (id != null) {
                this.markAbortedTransaction(id);
            }
        } else {
            throw new IllegalArgumentException("Unsupported TransactionContext type: " + transactionContext.getClass().getName());
        }
    }

    public void abortNextTransaction() {
        this.abortNextTransaction.set(true);
    }

    public void abortNextStatement() {
        this.abortNextStatement.set(true);
    }

    public void abortAllTransactions() {
        for (ByteString id : this.transactions.keySet()) {
            this.markAbortedTransaction(id);
        }
    }

    public void ignoreNextInlineBeginRequest() {
        this.ignoreNextInlineBeginRequest.set(true);
    }

    public void freeze() {
        this.freezeLock = new CountDownLatch(1);
    }

    public void unfreeze() {
        this.freezeLock.countDown();
    }

    public void setMaxSessionsInOneBatch(int max) {
        this.maxNumSessionsInOneBatch = max;
    }

    public void setMaxTotalSessions(int max) {
        this.maxTotalSessions = max;
    }

    public void batchCreateSessions(BatchCreateSessionsRequest request, StreamObserver<BatchCreateSessionsResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getDatabase());
        String name = null;
        try {
            if (request.getSessionCount() <= 0) {
                throw Status.INVALID_ARGUMENT.withDescription("Session count must be >= 0").asRuntimeException();
            }
            this.batchCreateSessionsExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            if (this.sessions.size() >= this.maxTotalSessions) {
                throw Status.RESOURCE_EXHAUSTED.withDescription("Maximum number of sessions reached").asRuntimeException();
            }
            com.google.protobuf.Timestamp now = this.getCurrentGoogleTimestamp();
            BatchCreateSessionsResponse.Builder response = BatchCreateSessionsResponse.newBuilder();
            int maxSessionsToCreate = Math.min(this.maxNumSessionsInOneBatch, request.getSessionCount());
            for (int i = 0; i < Math.min(this.maxTotalSessions - this.sessions.size(), maxSessionsToCreate); ++i) {
                Session session;
                name = this.generateSessionName(request.getDatabase());
                Session prev = this.sessions.putIfAbsent(name, session = Session.newBuilder().setCreateTime(now).setName(name).setApproximateLastUseTime(now).build());
                if (prev == null) {
                    if (this.sessions.size() <= this.maxTotalSessions) {
                        this.sessionLastUsed.put(name, Instant.now());
                        response.addSession(session);
                        this.numSessionsCreated.incrementAndGet();
                        continue;
                    }
                    this.sessions.remove(name);
                    continue;
                }
                throw Status.ALREADY_EXISTS.asRuntimeException();
            }
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (name != null) {
                this.sessions.remove(name);
            }
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable e) {
            if (name != null) {
                this.sessions.remove(name);
            }
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Batch create sessions failed: " + e.getMessage()).asRuntimeException());
        }
    }

    public void createSession(CreateSessionRequest request, StreamObserver<Session> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getDatabase());
        String name = this.generateSessionName(request.getDatabase());
        try {
            this.createSessionExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            com.google.protobuf.Timestamp now = this.getCurrentGoogleTimestamp();
            Session session = Session.newBuilder().setCreateTime(now).setName(name).setApproximateLastUseTime(now).build();
            Session prev = this.sessions.putIfAbsent(name, session);
            if (prev == null) {
                this.sessionLastUsed.put(name, Instant.now());
                this.numSessionsCreated.incrementAndGet();
                responseObserver.onNext((Object)session);
                responseObserver.onCompleted();
            } else {
                responseObserver.onError((Throwable)Status.ALREADY_EXISTS.asRuntimeException());
            }
        }
        catch (StatusRuntimeException e) {
            this.sessions.remove(name);
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable e) {
            this.sessions.remove(name);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Create session failed: " + e.getMessage()).asRuntimeException());
        }
    }

    public void getSession(GetSessionRequest request, StreamObserver<Session> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getName());
        try {
            this.getSessionExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            Session session = (Session)this.sessions.get(request.getName());
            if (session == null) {
                this.setSessionNotFound(request.getName(), responseObserver);
            } else {
                session = session.toBuilder().setApproximateLastUseTime(this.getCurrentGoogleTimestamp()).build();
                responseObserver.onNext((Object)session);
                responseObserver.onCompleted();
            }
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private <T> void setSessionNotFound(String name, StreamObserver<T> responseObserver) {
        ResourceInfo resourceInfo = ResourceInfo.newBuilder().setResourceType("type.googleapis.com/google.spanner.v1.Session").setResourceName(name).build();
        Metadata.Key key = Metadata.Key.of((String)(resourceInfo.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)resourceInfo));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)resourceInfo);
        responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(String.format("Session not found: Session with id %s not found", name)).asRuntimeException(trailers));
    }

    public void listSessions(ListSessionsRequest request, StreamObserver<ListSessionsResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        try {
            this.listSessionsExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            ArrayList<Session> res = new ArrayList<Session>();
            for (Session session : this.sessions.values()) {
                if (!session.getName().startsWith(request.getDatabase())) continue;
                res.add(session.toBuilder().setApproximateLastUseTime(this.getCurrentGoogleTimestamp()).build());
            }
            res.sort(Comparator.comparing(Session::getName));
            responseObserver.onNext((Object)ListSessionsResponse.newBuilder().addAllSessions(res).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void deleteSession(DeleteSessionRequest request, StreamObserver<Empty> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getName());
        try {
            this.deleteSessionExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            Session session = (Session)this.sessions.get(request.getName());
            if (session != null) {
                try {
                    this.doDeleteSession(session);
                }
                catch (Throwable e) {
                    responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
                    return;
                }
            }
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    void doDeleteSession(Session session) {
        this.sessions.remove(session.getName());
        this.transactionCounters.remove(session.getName());
        this.sessionLastUsed.remove(session.getName());
    }

    public void executeSql(ExecuteSqlRequest request, StreamObserver<ResultSet> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.executeSqlExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            this.simulateAbort(session, transactionId);
            Statement statement = this.buildStatement(request.getSql(), request.getParamTypesMap(), request.getParams());
            StatementResult result = this.getResult(statement);
            switch (result.getType()) {
                case EXCEPTION: {
                    throw result.getException();
                }
                case RESULT_SET: {
                    this.returnResultSet(result.getResultSet(), transactionId, request.getTransaction(), responseObserver);
                    break;
                }
                case UPDATE_COUNT: {
                    if (this.isPartitionedDmlTransaction(transactionId)) {
                        this.commitTransaction(transactionId);
                        responseObserver.onNext((Object)ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountLowerBound(result.getUpdateCount().longValue()).build()).build());
                        break;
                    }
                    responseObserver.onNext((Object)ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(result.getUpdateCount().longValue()).build()).setMetadata(ResultSetMetadata.newBuilder().setTransaction(this.ignoreNextInlineBeginRequest.getAndSet(false) ? Transaction.getDefaultInstance() : Transaction.newBuilder().setId(transactionId).build()).build()).build());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown result type: " + (Object)((Object)result.getType()));
                }
            }
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void returnResultSet(ResultSet resultSet, ByteString transactionId, TransactionSelector transactionSelector, StreamObserver<ResultSet> responseObserver) {
        ResultSetMetadata metadata = resultSet.getMetadata();
        if (transactionId != null) {
            metadata = metadata.toBuilder().setTransaction(this.ignoreNextInlineBeginRequest.getAndSet(false) ? Transaction.getDefaultInstance() : Transaction.newBuilder().setId(transactionId).build()).build();
        } else if (transactionSelector.hasBegin() || transactionSelector.hasSingleUse()) {
            Transaction transaction = this.getTemporaryTransactionOrNull(transactionSelector);
            metadata = metadata.toBuilder().setTransaction(transaction).build();
        }
        resultSet = resultSet.toBuilder().setMetadata(metadata).build();
        responseObserver.onNext((Object)resultSet);
    }

    public void executeBatchDml(ExecuteBatchDmlRequest request, StreamObserver<ExecuteBatchDmlResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.executeBatchDmlExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            if (this.isPartitionedDmlTransaction(transactionId)) {
                throw Status.FAILED_PRECONDITION.withDescription("This transaction is a partitioned DML transaction and cannot be used for batch DML updates.").asRuntimeException();
            }
            this.simulateAbort(session, transactionId);
            ArrayList<StatementResult> results = new ArrayList<StatementResult>();
            com.google.rpc.Status status = com.google.rpc.Status.newBuilder().setCode(0).build();
            block11: for (ExecuteBatchDmlRequest.Statement statement : request.getStatementsList()) {
                try {
                    Statement spannerStatement = this.buildStatement(statement.getSql(), statement.getParamTypesMap(), statement.getParams());
                    StatementResult res = this.getResult(spannerStatement);
                    switch (res.getType()) {
                        case EXCEPTION: {
                            status = com.google.rpc.Status.newBuilder().setCode(res.getException().getStatus().getCode().value()).setMessage(res.getException().getMessage()).build();
                            break block11;
                        }
                        case RESULT_SET: {
                            throw Status.INVALID_ARGUMENT.withDescription("Not a DML statement: " + statement.getSql()).asRuntimeException();
                        }
                        case UPDATE_COUNT: {
                            results.add(res);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown result type: " + (Object)((Object)res.getType()));
                        }
                    }
                }
                catch (StatusRuntimeException e) {
                    status = com.google.rpc.Status.newBuilder().setCode(e.getStatus().getCode().value()).setMessage(e.getMessage()).build();
                    break;
                }
                catch (Exception e) {
                    status = com.google.rpc.Status.newBuilder().setCode(2).setMessage(e.getMessage()).build();
                    break;
                }
            }
            ExecuteBatchDmlResponse.Builder builder = ExecuteBatchDmlResponse.newBuilder();
            for (StatementResult res : results) {
                builder.addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(res.getUpdateCount().longValue()).build()).setMetadata(ResultSetMetadata.newBuilder().setTransaction(this.ignoreNextInlineBeginRequest.getAndSet(false) ? Transaction.getDefaultInstance() : Transaction.newBuilder().setId(transactionId).build()).build()).build());
            }
            builder.setStatus(status);
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void executeStreamingSql(ExecuteSqlRequest request, StreamObserver<PartialResultSet> responseObserver) {
        if (this.includeDetermineDialectStatementInRequests || !request.getSql().equals(SessionPool.DETERMINE_DIALECT_STATEMENT.getSql())) {
            this.requests.add((AbstractMessage)request);
        }
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            List tokens;
            Statement statement = this.buildStatement(request.getSql(), request.getParamTypesMap(), request.getParams());
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            boolean isPartitioned = this.isPartitionedDmlTransaction(transactionId);
            if (isPartitioned) {
                StatementResult firstRes = this.getResult(statement);
                switch (firstRes.getType()) {
                    case EXCEPTION: {
                        throw firstRes.getException();
                    }
                    case UPDATE_COUNT: {
                        this.returnPartialResultSet(session, 0L, !isPartitioned, responseObserver, request.getTransaction(), false);
                        break;
                    }
                }
            }
            this.executeStreamingSqlExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            if (!(request.getPartitionToken().isEmpty() || (tokens = (List)this.partitionTokens.get(this.partitionKey(session.getName(), transactionId))) != null && tokens.contains(request.getPartitionToken()))) {
                throw Status.INVALID_ARGUMENT.withDescription(String.format("Partition token %s is not a valid token for this transaction", request.getPartitionToken())).asRuntimeException();
            }
            this.simulateAbort(session, transactionId);
            StatementResult res = this.getResult(statement);
            switch (res.getType()) {
                case EXCEPTION: {
                    throw res.getException();
                }
                case RESULT_SET: {
                    this.returnPartialResultSet(res.getResultSet(), transactionId, request.getTransaction(), responseObserver, this.getExecuteStreamingSqlExecutionTime());
                    break;
                }
                case UPDATE_COUNT: {
                    if (isPartitioned) {
                        this.commitTransaction(transactionId);
                    }
                    this.returnPartialResultSet(session, res.getUpdateCount(), !isPartitioned, responseObserver, request.getTransaction());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown result type: " + (Object)((Object)res.getType()));
                }
            }
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.withCause(t).asRuntimeException());
        }
    }

    private Statement buildStatement(String sql, Map<String, com.google.spanner.v1.Type> paramTypes, com.google.protobuf.Struct params) {
        Statement.Builder builder = Statement.newBuilder((String)sql);
        block48: for (Map.Entry<String, com.google.spanner.v1.Type> entry : paramTypes.entrySet()) {
            String fieldName = entry.getKey();
            com.google.spanner.v1.Type fieldType = entry.getValue();
            com.google.spanner.v1.Type elementType = fieldType.getArrayElementType();
            com.google.protobuf.Value value = params.getFieldsOrThrow(fieldName);
            if (value.getKindCase() == Value.KindCase.NULL_VALUE) {
                switch (fieldType.getCode()) {
                    case ARRAY: {
                        switch (elementType.getCode()) {
                            case BOOL: {
                                builder.bind(fieldName).toBoolArray((Iterable)null);
                                continue block48;
                            }
                            case BYTES: {
                                builder.bind(fieldName).toBytesArray(null);
                                continue block48;
                            }
                            case DATE: {
                                builder.bind(fieldName).toDateArray(null);
                                continue block48;
                            }
                            case FLOAT64: {
                                builder.bind(fieldName).toFloat64Array((Iterable)null);
                                continue block48;
                            }
                            case INT64: {
                                builder.bind(fieldName).toInt64Array((Iterable)null);
                                continue block48;
                            }
                            case STRING: {
                                builder.bind(fieldName).toStringArray(null);
                                continue block48;
                            }
                            case NUMERIC: {
                                if (elementType.getTypeAnnotation() == TypeAnnotationCode.PG_NUMERIC) {
                                    builder.bind(fieldName).toPgNumericArray(null);
                                    continue block48;
                                }
                                builder.bind(fieldName).toNumericArray(null);
                                continue block48;
                            }
                            case TIMESTAMP: {
                                builder.bind(fieldName).toTimestampArray(null);
                                continue block48;
                            }
                            case JSON: {
                                builder.bind(fieldName).toJsonArray(null);
                                continue block48;
                            }
                        }
                        throw new IllegalArgumentException("Unknown or invalid array parameter type: " + elementType.getCode());
                    }
                    case BOOL: {
                        builder.bind(fieldName).to((Boolean)null);
                        continue block48;
                    }
                    case BYTES: {
                        builder.bind(fieldName).to((ByteArray)null);
                        continue block48;
                    }
                    case DATE: {
                        builder.bind(fieldName).to((Date)null);
                        continue block48;
                    }
                    case FLOAT64: {
                        builder.bind(fieldName).to((Double)null);
                        continue block48;
                    }
                    case INT64: {
                        builder.bind(fieldName).to((Long)null);
                        continue block48;
                    }
                    case STRING: {
                        builder.bind(fieldName).to((String)null);
                        continue block48;
                    }
                    case NUMERIC: {
                        if (fieldType.getTypeAnnotation() == TypeAnnotationCode.PG_NUMERIC) {
                            builder.bind(fieldName).to(Value.pgNumeric(null));
                            continue block48;
                        }
                        builder.bind(fieldName).to((BigDecimal)null);
                        continue block48;
                    }
                    case STRUCT: {
                        builder.bind(fieldName).to((Struct)null);
                        continue block48;
                    }
                    case TIMESTAMP: {
                        builder.bind(fieldName).to((Timestamp)null);
                        continue block48;
                    }
                    case JSON: {
                        builder.bind(fieldName).to(Value.json(null));
                        continue block48;
                    }
                }
                throw new IllegalArgumentException("Unknown parameter type: " + fieldType.getCode());
            }
            switch (fieldType.getCode()) {
                case ARRAY: {
                    switch (elementType.getCode()) {
                        case BOOL: {
                            builder.bind(fieldName).toBoolArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.bool(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case BYTES: {
                            builder.bind(fieldName).toBytesArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.bytes(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case DATE: {
                            builder.bind(fieldName).toDateArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.date(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case FLOAT64: {
                            builder.bind(fieldName).toFloat64Array((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.float64(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case INT64: {
                            builder.bind(fieldName).toInt64Array((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.int64(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case STRING: {
                            builder.bind(fieldName).toStringArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.string(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case NUMERIC: {
                            if (elementType.getTypeAnnotation() == TypeAnnotationCode.PG_NUMERIC) {
                                builder.bind(fieldName).toPgNumericArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.pgNumeric(), (ListValue)value.getListValue()));
                                continue block48;
                            }
                            builder.bind(fieldName).toNumericArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.numeric(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case TIMESTAMP: {
                            builder.bind(fieldName).toTimestampArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.timestamp(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                        case JSON: {
                            builder.bind(fieldName).toJsonArray((Iterable)AbstractResultSet.GrpcStruct.decodeArrayValue((Type)Type.json(), (ListValue)value.getListValue()));
                            continue block48;
                        }
                    }
                    throw new IllegalArgumentException("Unknown or invalid array parameter type: " + elementType.getCode());
                }
                case BOOL: {
                    builder.bind(fieldName).to(value.getBoolValue());
                    continue block48;
                }
                case BYTES: {
                    builder.bind(fieldName).to(ByteArray.fromBase64((String)value.getStringValue()));
                    continue block48;
                }
                case DATE: {
                    builder.bind(fieldName).to(Date.parseDate((String)value.getStringValue()));
                    continue block48;
                }
                case FLOAT64: {
                    builder.bind(fieldName).to(value.getNumberValue());
                    continue block48;
                }
                case INT64: {
                    builder.bind(fieldName).to(Long.valueOf(value.getStringValue()));
                    continue block48;
                }
                case STRING: {
                    builder.bind(fieldName).to(value.getStringValue());
                    continue block48;
                }
                case NUMERIC: {
                    if (fieldType.getTypeAnnotation() == TypeAnnotationCode.PG_NUMERIC) {
                        builder.bind(fieldName).to(Value.pgNumeric((String)value.getStringValue()));
                        continue block48;
                    }
                    builder.bind(fieldName).to(new BigDecimal(value.getStringValue()));
                    continue block48;
                }
                case STRUCT: {
                    throw new IllegalArgumentException("Struct parameters not (yet) supported");
                }
                case TIMESTAMP: {
                    builder.bind(fieldName).to(Timestamp.parseTimestamp((String)value.getStringValue()));
                    continue block48;
                }
                case JSON: {
                    builder.bind(fieldName).to(Value.json((String)value.getStringValue()));
                    continue block48;
                }
            }
            throw new IllegalArgumentException("Unknown parameter type: " + fieldType.getCode());
        }
        return builder.build();
    }

    private <T> void setTransactionNotFound(ByteString transactionId, StreamObserver<T> responseObserver) {
        responseObserver.onError((Throwable)Status.ABORTED.withDescription(String.format("Transaction with id %s not found and has probably been aborted", transactionId.toStringUtf8())).asRuntimeException());
    }

    private <T> void throwTransactionNotFound(ByteString transactionId) {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos((int)TimeUnit.MILLISECONDS.toNanos(1L)).setSeconds(0L)).build();
        trailers.put(key, (Object)retryInfo);
        throw Status.ABORTED.withDescription(String.format("Transaction with id %s not found and has probably been aborted", transactionId.toStringUtf8())).asRuntimeException(trailers);
    }

    private <T> void throwTransactionAborted(ByteString transactionId) {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos((int)TimeUnit.MILLISECONDS.toNanos(1L)).setSeconds(0L)).build();
        trailers.put(key, (Object)retryInfo);
        throw Status.ABORTED.withDescription(String.format("Transaction with id %s has been aborted", transactionId.toStringUtf8())).asRuntimeException(trailers);
    }

    public void read(ReadRequest request, StreamObserver<ResultSet> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.readExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            this.simulateAbort(session, transactionId);
            Iterable<String> cols = () -> request.getColumnsList().iterator();
            Statement statement = StatementResult.createReadStatement(request.getTable(), request.getKeySet().getAll() ? KeySet.all() : KeySet.singleKey((Key)Key.of((Object[])new Object[0])), cols);
            StatementResult res = this.getResult(statement);
            this.returnResultSet(res.getResultSet(), transactionId, request.getTransaction(), responseObserver);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void streamingRead(ReadRequest request, StreamObserver<PartialResultSet> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            List tokens;
            this.streamingReadExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            ByteString transactionId = this.getTransactionId(session, request.getTransaction());
            if (!(request.getPartitionToken().isEmpty() || (tokens = (List)this.partitionTokens.get(this.partitionKey(session.getName(), transactionId))) != null && tokens.contains(request.getPartitionToken()))) {
                throw Status.INVALID_ARGUMENT.withDescription(String.format("Partition token %s is not a valid token for this transaction", request.getPartitionToken())).asRuntimeException();
            }
            this.simulateAbort(session, transactionId);
            Iterable<String> cols = () -> request.getColumnsList().iterator();
            Statement statement = StatementResult.createReadStatement(request.getTable(), request.getKeySet().getAll() ? KeySet.all() : KeySet.singleKey((Key)Key.of((Object[])new Object[0])), cols);
            StatementResult res = this.getResult(statement);
            if (res == null) {
                throw Status.NOT_FOUND.withDescription("No result found for " + statement.toString()).asRuntimeException();
            }
            if (res.getType() == StatementResult.StatementResultType.EXCEPTION) {
                throw res.getException();
            }
            this.returnPartialResultSet(res.getResultSet(), transactionId, request.getTransaction(), responseObserver, this.getStreamingReadExecutionTime());
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void returnPartialResultSet(ResultSet resultSet, ByteString transactionId, TransactionSelector transactionSelector, StreamObserver<PartialResultSet> responseObserver, SimulatedExecutionTime executionTime) {
        ResultSetMetadata metadata = resultSet.getMetadata();
        if (transactionId == null) {
            Transaction transaction = this.getTemporaryTransactionOrNull(transactionSelector);
            metadata = metadata.toBuilder().setTransaction(transaction).build();
        } else {
            metadata = metadata.toBuilder().setTransaction(this.ignoreNextInlineBeginRequest.getAndSet(false) ? Transaction.getDefaultInstance() : Transaction.newBuilder().setId(transactionId).build()).build();
        }
        resultSet = resultSet.toBuilder().setMetadata(metadata).build();
        PartialResultSetsIterator iterator = new PartialResultSetsIterator(resultSet);
        long index = 0L;
        while (iterator.hasNext()) {
            SimulatedExecutionTime.checkStreamException(index, executionTime.exceptions, executionTime.streamIndices);
            responseObserver.onNext((Object)iterator.next());
            ++index;
        }
        responseObserver.onCompleted();
    }

    private void returnPartialResultSet(Session session, Long updateCount, boolean exact, StreamObserver<PartialResultSet> responseObserver, TransactionSelector transaction) {
        this.returnPartialResultSet(session, updateCount, exact, responseObserver, transaction, true);
    }

    private void returnPartialResultSet(Session session, Long updateCount, boolean exact, StreamObserver<PartialResultSet> responseObserver, TransactionSelector transaction, boolean complete) {
        StructType.Field field = StructType.Field.newBuilder().setName("UPDATE_COUNT").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.INT64).build()).build();
        if (exact) {
            responseObserver.onNext((Object)PartialResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(field).build()).setTransaction(this.ignoreNextInlineBeginRequest.getAndSet(false) ? Transaction.getDefaultInstance() : Transaction.newBuilder().setId(transaction.getId()).build()).build()).setStats(ResultSetStats.newBuilder().setRowCountExact(updateCount.longValue()).build()).build());
        } else {
            responseObserver.onNext((Object)PartialResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(field).build()).setTransaction(this.ignoreNextInlineBeginRequest.getAndSet(false) ? Transaction.getDefaultInstance() : Transaction.newBuilder().setId(transaction.getId()).build()).build()).setStats(ResultSetStats.newBuilder().setRowCountLowerBound(updateCount.longValue()).build()).build());
        }
        if (complete) {
            responseObserver.onCompleted();
        }
    }

    private boolean isPartitionedDmlTransaction(ByteString transactionId) {
        return transactionId != null && this.isPartitionedDmlTransaction.get(transactionId) != null && (Boolean)this.isPartitionedDmlTransaction.get(transactionId) != false;
    }

    private boolean isReadWriteTransaction(ByteString transactionId) {
        return transactionId != null && this.transactions.get(transactionId) != null && ((Transaction)this.transactions.get(transactionId)).getReadTimestamp().getSeconds() == 0L;
    }

    private ByteString getTransactionId(Session session, TransactionSelector tx) {
        ByteString transactionId = null;
        switch (tx.getSelectorCase()) {
            case SELECTOR_NOT_SET: 
            case SINGLE_USE: {
                transactionId = null;
                break;
            }
            case BEGIN: {
                transactionId = this.beginTransaction(session, tx.getBegin()).getId();
                break;
            }
            case ID: {
                Transaction transaction = (Transaction)this.transactions.get(tx.getId());
                if (transaction == null) {
                    Optional aborted = Optional.fromNullable(this.abortedTransactions.get(tx.getId()));
                    if (((Boolean)aborted.or((Object)Boolean.FALSE)).booleanValue()) {
                        this.throwTransactionAborted(tx.getId());
                        break;
                    }
                    this.throwTransactionNotFound(tx.getId());
                    break;
                }
                transactionId = transaction.getId();
                this.transactionLastUsed.put(transactionId, Instant.now());
                break;
            }
            default: {
                throw Status.UNIMPLEMENTED.asRuntimeException();
            }
        }
        return transactionId;
    }

    private Transaction getTemporaryTransactionOrNull(TransactionSelector tx) {
        switch (tx.getSelectorCase()) {
            case SELECTOR_NOT_SET: 
            case SINGLE_USE: {
                Transaction.Builder builder = Transaction.newBuilder();
                this.setReadTimestamp(tx.getSingleUse(), builder);
                return builder.build();
            }
            case BEGIN: {
                Transaction.Builder builder = Transaction.newBuilder();
                this.setReadTimestamp(tx.getBegin(), builder);
                return builder.build();
            }
            case ID: {
                return (Transaction)this.transactions.get(tx.getId());
            }
        }
        return null;
    }

    public void beginTransaction(BeginTransactionRequest request, StreamObserver<Transaction> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.beginTransactionExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            Transaction transaction = this.beginTransaction(session, request.getOptions());
            responseObserver.onNext((Object)transaction);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private Transaction beginTransaction(Session session, TransactionOptions options) {
        Transaction.Builder builder = Transaction.newBuilder().setId(this.generateTransactionName(session.getName()));
        if (options != null && options.getModeCase() == TransactionOptions.ModeCase.READ_ONLY) {
            this.setReadTimestamp(options, builder);
        }
        Transaction transaction = builder.build();
        this.transactions.put(transaction.getId(), transaction);
        this.transactionsStarted.add(transaction.getId());
        this.isPartitionedDmlTransaction.put(transaction.getId(), options.getModeCase() == TransactionOptions.ModeCase.PARTITIONED_DML);
        if (this.abortNextTransaction.getAndSet(false)) {
            this.markAbortedTransaction(transaction.getId());
        }
        return transaction;
    }

    private void setReadTimestamp(TransactionOptions options, Transaction.Builder builder) {
        if (options.getReadOnly().getStrong()) {
            builder.setReadTimestamp(this.getCurrentGoogleTimestamp());
        } else if (options.getReadOnly().hasReadTimestamp()) {
            builder.setReadTimestamp(options.getReadOnly().getReadTimestamp());
        } else if (options.getReadOnly().hasMinReadTimestamp()) {
            builder.setReadTimestamp(options.getReadOnly().getMinReadTimestamp());
        } else if (options.getReadOnly().hasExactStaleness() || options.getReadOnly().hasMaxStaleness()) {
            com.google.protobuf.Timestamp timestamp = this.getCurrentGoogleTimestamp();
            Duration staleness = options.getReadOnly().hasExactStaleness() ? options.getReadOnly().getExactStaleness() : options.getReadOnly().getMaxStaleness();
            long seconds = timestamp.getSeconds() - staleness.getSeconds();
            int nanos = timestamp.getNanos() - staleness.getNanos();
            if (nanos < 0) {
                --seconds;
                nanos = 1000000000 + nanos;
            }
            timestamp = com.google.protobuf.Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
            builder.setReadTimestamp(timestamp);
        }
    }

    private void simulateAbort(Session session, ByteString transactionId) {
        this.ensureMostRecentTransaction(session, transactionId);
        if (this.isReadWriteTransaction(transactionId) && (this.abortNextStatement.getAndSet(false) || this.abortProbability > this.random.nextDouble())) {
            this.rollbackTransaction(transactionId);
            throw this.createAbortedException(transactionId);
        }
    }

    public StatusRuntimeException createAbortedException(ByteString transactionId) {
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1).build()).build();
        Metadata.Key key = Metadata.Key.of((String)(retryInfo.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)retryInfo));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)retryInfo);
        return Status.ABORTED.withDescription(String.format("Transaction with id %s has been aborted", transactionId.toStringUtf8())).asRuntimeException(trailers);
    }

    private void ensureMostRecentTransaction(Session session, ByteString transactionId) {
        long id;
        int index;
        AtomicLong counter = (AtomicLong)this.transactionCounters.get(session.getName());
        if (transactionId != null && transactionId.toStringUtf8() != null && counter != null && (index = transactionId.toStringUtf8().lastIndexOf(47)) > -1 && (id = Long.parseLong(transactionId.toStringUtf8().substring(index + 1))) != counter.get()) {
            throw Status.FAILED_PRECONDITION.withDescription(String.format("This transaction has been invalidated by a later transaction in the same session.\nTransaction id: " + id + "\nExpected: " + counter.get(), session.getName())).asRuntimeException();
        }
    }

    public void commit(CommitRequest request, StreamObserver<CommitResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getSession());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            Transaction transaction;
            this.commitExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            if (request.hasSingleUseTransaction()) {
                transaction = this.beginTransaction(session, TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance()).build());
            } else if (request.getTransactionId() != null) {
                transaction = (Transaction)this.transactions.get(request.getTransactionId());
                Optional aborted = Optional.fromNullable(this.abortedTransactions.get(request.getTransactionId()));
                if (((Boolean)aborted.or((Object)Boolean.FALSE)).booleanValue()) {
                    this.throwTransactionAborted(request.getTransactionId());
                }
            } else {
                responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("No transaction mode specified").asRuntimeException());
                return;
            }
            if (transaction == null) {
                this.setTransactionNotFound(request.getTransactionId(), responseObserver);
                return;
            }
            this.simulateAbort(session, request.getTransactionId());
            this.commitTransaction(transaction.getId());
            CommitResponse.Builder responseBuilder = CommitResponse.newBuilder().setCommitTimestamp(this.getCurrentGoogleTimestamp());
            if (request.getReturnCommitStats()) {
                responseBuilder.setCommitStats(CommitResponse.CommitStats.newBuilder().setMutationCount((long)request.getMutationsCount()).build());
            }
            responseObserver.onNext((Object)responseBuilder.build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void commitTransaction(ByteString transactionId) {
        this.transactions.remove(transactionId);
        this.isPartitionedDmlTransaction.remove(transactionId);
        this.transactionLastUsed.remove(transactionId);
    }

    public void rollback(RollbackRequest request, StreamObserver<Empty> responseObserver) {
        this.requests.add((AbstractMessage)request);
        Preconditions.checkNotNull((Object)request.getTransactionId());
        Session session = (Session)this.sessions.get(request.getSession());
        if (session == null) {
            this.setSessionNotFound(request.getSession(), responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            this.rollbackExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            Transaction transaction = (Transaction)this.transactions.get(request.getTransactionId());
            if (transaction != null) {
                this.rollbackTransaction(transaction.getId());
            }
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    void rollbackTransaction(ByteString transactionId) {
        this.transactions.remove(transactionId);
        this.isPartitionedDmlTransaction.remove(transactionId);
        this.transactionLastUsed.remove(transactionId);
    }

    void markAbortedTransaction(ByteString transactionId) {
        this.abortedTransactions.put(transactionId, Boolean.TRUE);
        this.transactions.remove(transactionId);
        this.isPartitionedDmlTransaction.remove(transactionId);
        this.transactionLastUsed.remove(transactionId);
    }

    public void partitionQuery(PartitionQueryRequest request, StreamObserver<PartitionResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        try {
            this.partitionQueryExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            this.partition(request.getSession(), request.getTransaction(), responseObserver);
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public void partitionRead(PartitionReadRequest request, StreamObserver<PartitionResponse> responseObserver) {
        this.requests.add((AbstractMessage)request);
        try {
            this.partitionReadExecutionTime.simulateExecutionTime(this.exceptions, this.stickyGlobalExceptions, this.freezeLock);
            this.partition(request.getSession(), request.getTransaction(), responseObserver);
        }
        catch (StatusRuntimeException t) {
            responseObserver.onError((Throwable)t);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    private void partition(String sessionName, TransactionSelector transactionSelector, StreamObserver<PartitionResponse> responseObserver) {
        Session session = (Session)this.sessions.get(sessionName);
        if (session == null) {
            this.setSessionNotFound(sessionName, responseObserver);
            return;
        }
        this.sessionLastUsed.put(session.getName(), Instant.now());
        try {
            ByteString transactionId = this.getTransactionId(session, transactionSelector);
            responseObserver.onNext((Object)PartitionResponse.newBuilder().addPartitions(Partition.newBuilder().setPartitionToken(this.generatePartitionToken(session.getName(), transactionId)).build()).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable t) {
            responseObserver.onError((Throwable)Status.INTERNAL.asRuntimeException());
        }
    }

    public int numSessionsCreated() {
        return this.numSessionsCreated.get();
    }

    public List<AbstractMessage> getRequests() {
        return new ArrayList<AbstractMessage>(this.requests);
    }

    public void clearRequests() {
        this.requests.clear();
    }

    public <T extends AbstractMessage> List<T> getRequestsOfType(Class<T> type) {
        ArrayList<AbstractMessage> result = new ArrayList<AbstractMessage>();
        for (AbstractMessage message : this.requests) {
            if (!message.getClass().equals(type)) continue;
            result.add(message);
        }
        return result;
    }

    public Iterable<Class<? extends AbstractMessage>> getRequestTypes() {
        LinkedList<Class<? extends AbstractMessage>> res = new LinkedList<Class<? extends AbstractMessage>>();
        for (AbstractMessage m : this.requests) {
            res.add(m.getClass());
        }
        return res;
    }

    public int countRequestsOfType(Class<? extends AbstractMessage> type) {
        int c = 0;
        for (AbstractMessage m : this.requests) {
            if (!m.getClass().equals(type)) continue;
            ++c;
        }
        return c;
    }

    public void waitForLastRequestToBe(Class<? extends AbstractMessage> type, long timeoutMillis) throws InterruptedException, TimeoutException {
        Stopwatch watch = Stopwatch.createStarted();
        while (this.requests.peekLast() == null || !this.requests.peekLast().getClass().equals(type)) {
            Thread.sleep(1L);
            if (watch.elapsed(TimeUnit.MILLISECONDS) <= timeoutMillis) continue;
            throw new TimeoutException("Timeout while waiting for last request to become " + type.getName());
        }
    }

    public List<ByteString> getTransactionsStarted() {
        return new ArrayList<ByteString>(this.transactionsStarted);
    }

    public void waitForRequestsToContain(Class<? extends AbstractMessage> type, long timeoutMillis) throws InterruptedException, TimeoutException {
        Stopwatch watch = Stopwatch.createStarted();
        while (this.countRequestsOfType(type) == 0) {
            Thread.sleep(1L);
            if (watch.elapsed(TimeUnit.MILLISECONDS) <= timeoutMillis) continue;
            throw new TimeoutException("Timeout while waiting for requests to contain " + type.getName());
        }
    }

    public void waitForRequestsToContain(Predicate<? super AbstractMessage> predicate, long timeoutMillis) throws InterruptedException, TimeoutException {
        Iterable msg;
        Stopwatch watch = Stopwatch.createStarted();
        while (!(msg = Iterables.filter(this.getRequests(), predicate)).iterator().hasNext()) {
            Thread.sleep(1L);
            if (watch.elapsed(TimeUnit.MILLISECONDS) <= timeoutMillis) continue;
            throw new TimeoutException("Timeout while waiting for requests to contain the wanted request");
        }
    }

    public void addResponse(AbstractMessage response) {
        throw new UnsupportedOperationException();
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    public void clearExceptions() {
        this.exceptions.clear();
    }

    public void setStickyGlobalExceptions(boolean sticky) {
        this.stickyGlobalExceptions = sticky;
    }

    public ServerServiceDefinition getServiceDefinition() {
        return this.bindService();
    }

    public void reset() {
        this.requests = new ConcurrentLinkedDeque<AbstractMessage>();
        this.exceptions = new ConcurrentLinkedQueue<Exception>();
        this.statementGetCounts = new ConcurrentHashMap<Statement, Long>();
        this.sessions = new ConcurrentHashMap<String, Session>();
        this.sessionLastUsed = new ConcurrentHashMap<String, Instant>();
        this.transactions = new ConcurrentHashMap<ByteString, Transaction>();
        this.transactionsStarted.clear();
        this.isPartitionedDmlTransaction = new ConcurrentHashMap<ByteString, Boolean>();
        this.abortedTransactions = new ConcurrentHashMap<ByteString, Boolean>();
        this.transactionCounters = new ConcurrentHashMap<String, AtomicLong>();
        this.partitionTokens = new ConcurrentHashMap<String, List<ByteString>>();
        this.transactionLastUsed = new ConcurrentHashMap<ByteString, Instant>();
        this.numSessionsCreated.set(0);
        this.stickyGlobalExceptions = false;
        this.freezeLock.countDown();
    }

    public void removeAllExecutionTimes() {
        this.batchCreateSessionsExecutionTime = NO_EXECUTION_TIME;
        this.beginTransactionExecutionTime = NO_EXECUTION_TIME;
        this.commitExecutionTime = NO_EXECUTION_TIME;
        this.createSessionExecutionTime = NO_EXECUTION_TIME;
        this.deleteSessionExecutionTime = NO_EXECUTION_TIME;
        this.executeBatchDmlExecutionTime = NO_EXECUTION_TIME;
        this.executeSqlExecutionTime = NO_EXECUTION_TIME;
        this.executeStreamingSqlExecutionTime = NO_EXECUTION_TIME;
        this.getSessionExecutionTime = NO_EXECUTION_TIME;
        this.listSessionsExecutionTime = NO_EXECUTION_TIME;
        this.partitionQueryExecutionTime = NO_EXECUTION_TIME;
        this.partitionReadExecutionTime = NO_EXECUTION_TIME;
        this.readExecutionTime = NO_EXECUTION_TIME;
        this.rollbackExecutionTime = NO_EXECUTION_TIME;
        this.streamingReadExecutionTime = NO_EXECUTION_TIME;
    }

    public SimulatedExecutionTime getBeginTransactionExecutionTime() {
        return this.beginTransactionExecutionTime;
    }

    public void setBeginTransactionExecutionTime(SimulatedExecutionTime beginTransactionExecutionTime) {
        this.beginTransactionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)beginTransactionExecutionTime);
    }

    public SimulatedExecutionTime getCommitExecutionTime() {
        return this.commitExecutionTime;
    }

    public void setCommitExecutionTime(SimulatedExecutionTime commitExecutionTime) {
        this.commitExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)commitExecutionTime);
    }

    public SimulatedExecutionTime getBatchCreateSessionsExecutionTime() {
        return this.batchCreateSessionsExecutionTime;
    }

    public void setBatchCreateSessionsExecutionTime(SimulatedExecutionTime batchCreateSessionsExecutionTime) {
        this.batchCreateSessionsExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)batchCreateSessionsExecutionTime);
    }

    public SimulatedExecutionTime getCreateSessionExecutionTime() {
        return this.createSessionExecutionTime;
    }

    public void setCreateSessionExecutionTime(SimulatedExecutionTime createSessionExecutionTime) {
        this.createSessionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)createSessionExecutionTime);
    }

    public SimulatedExecutionTime getDeleteSessionExecutionTime() {
        return this.deleteSessionExecutionTime;
    }

    public void setDeleteSessionExecutionTime(SimulatedExecutionTime deleteSessionExecutionTime) {
        this.deleteSessionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)deleteSessionExecutionTime);
    }

    public SimulatedExecutionTime getExecuteBatchDmlExecutionTime() {
        return this.executeBatchDmlExecutionTime;
    }

    public void setExecuteBatchDmlExecutionTime(SimulatedExecutionTime executeBatchDmlExecutionTime) {
        this.executeBatchDmlExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)executeBatchDmlExecutionTime);
    }

    public SimulatedExecutionTime getExecuteSqlExecutionTime() {
        return this.executeSqlExecutionTime;
    }

    public void setExecuteSqlExecutionTime(SimulatedExecutionTime executeSqlExecutionTime) {
        this.executeSqlExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)executeSqlExecutionTime);
    }

    public SimulatedExecutionTime getExecuteStreamingSqlExecutionTime() {
        return this.executeStreamingSqlExecutionTime;
    }

    public void setExecuteStreamingSqlExecutionTime(SimulatedExecutionTime executeStreamingSqlExecutionTime) {
        this.executeStreamingSqlExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)executeStreamingSqlExecutionTime);
    }

    public SimulatedExecutionTime getGetSessionExecutionTime() {
        return this.getSessionExecutionTime;
    }

    public void setGetSessionExecutionTime(SimulatedExecutionTime getSessionExecutionTime) {
        this.getSessionExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)getSessionExecutionTime);
    }

    public SimulatedExecutionTime getListSessionsExecutionTime() {
        return this.listSessionsExecutionTime;
    }

    public void setListSessionsExecutionTime(SimulatedExecutionTime listSessionsExecutionTime) {
        this.listSessionsExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)listSessionsExecutionTime);
    }

    public SimulatedExecutionTime getPartitionQueryExecutionTime() {
        return this.partitionQueryExecutionTime;
    }

    public void setPartitionQueryExecutionTime(SimulatedExecutionTime partitionQueryExecutionTime) {
        this.partitionQueryExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)partitionQueryExecutionTime);
    }

    public SimulatedExecutionTime getPartitionReadExecutionTime() {
        return this.partitionReadExecutionTime;
    }

    public void setPartitionReadExecutionTime(SimulatedExecutionTime partitionReadExecutionTime) {
        this.partitionReadExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)partitionReadExecutionTime);
    }

    public SimulatedExecutionTime getReadExecutionTime() {
        return this.readExecutionTime;
    }

    public void setReadExecutionTime(SimulatedExecutionTime readExecutionTime) {
        this.readExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)readExecutionTime);
    }

    public SimulatedExecutionTime getRollbackExecutionTime() {
        return this.rollbackExecutionTime;
    }

    public void setRollbackExecutionTime(SimulatedExecutionTime rollbackExecutionTime) {
        this.rollbackExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)rollbackExecutionTime);
    }

    public SimulatedExecutionTime getStreamingReadExecutionTime() {
        return this.streamingReadExecutionTime;
    }

    public void setStreamingReadExecutionTime(SimulatedExecutionTime streamingReadExecutionTime) {
        this.streamingReadExecutionTime = (SimulatedExecutionTime)Preconditions.checkNotNull((Object)streamingReadExecutionTime);
    }

    public static class SimulatedExecutionTime {
        private static final Random RANDOM = new Random();
        private final int minimumExecutionTime;
        private final int randomExecutionTime;
        private final Queue<Exception> exceptions;
        private final boolean stickyException;
        private final Queue<Long> streamIndices;

        public static SimulatedExecutionTime ofMinimumAndRandomTime(int minimumExecutionTime, int randomExecutionTime) {
            return new SimulatedExecutionTime(minimumExecutionTime, randomExecutionTime);
        }

        public static SimulatedExecutionTime none() {
            return new SimulatedExecutionTime(0, 0);
        }

        public static SimulatedExecutionTime ofException(Exception exception) {
            return new SimulatedExecutionTime(0, 0, Collections.singletonList(exception), false, Collections.emptySet());
        }

        public static SimulatedExecutionTime ofStickyException(Exception exception) {
            return new SimulatedExecutionTime(0, 0, Collections.singletonList(exception), true, Collections.emptySet());
        }

        public static SimulatedExecutionTime ofStreamException(Exception exception, long streamIndex) {
            return new SimulatedExecutionTime(0, 0, Collections.singletonList(exception), false, Collections.singleton(streamIndex));
        }

        public static SimulatedExecutionTime stickyDatabaseNotFoundException(String name) {
            return SimulatedExecutionTime.ofStickyException((Exception)SpannerExceptionFactoryTest.newStatusDatabaseNotFoundException(name));
        }

        public static SimulatedExecutionTime ofExceptions(Collection<? extends Exception> exceptions) {
            return new SimulatedExecutionTime(0, 0, exceptions, false, Collections.emptySet());
        }

        public static SimulatedExecutionTime ofMinimumAndRandomTimeAndExceptions(int minimumExecutionTime, int randomExecutionTime, Collection<? extends Exception> exceptions) {
            return new SimulatedExecutionTime(minimumExecutionTime, randomExecutionTime, exceptions, false, Collections.emptySet());
        }

        private SimulatedExecutionTime(int minimum, int random) {
            this(minimum, random, Collections.emptyList(), false, Collections.emptySet());
        }

        private SimulatedExecutionTime(int minimum, int random, Collection<? extends Exception> exceptions, boolean stickyException, Collection<Long> streamIndices) {
            Preconditions.checkArgument((minimum >= 0 ? 1 : 0) != 0, (Object)"Minimum execution time must be >= 0");
            Preconditions.checkArgument((random >= 0 ? 1 : 0) != 0, (Object)"Random execution time must be >= 0");
            this.minimumExecutionTime = minimum;
            this.randomExecutionTime = random;
            this.exceptions = new LinkedList<Exception>(exceptions);
            this.stickyException = stickyException;
            this.streamIndices = new LinkedList<Long>(streamIndices);
        }

        void simulateExecutionTime(Queue<Exception> globalExceptions, boolean stickyGlobalExceptions, CountDownLatch freezeLock) {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)freezeLock);
            SimulatedExecutionTime.checkException(globalExceptions, stickyGlobalExceptions);
            if (this.streamIndices.isEmpty()) {
                SimulatedExecutionTime.checkException(this.exceptions, this.stickyException);
            }
            if (this.minimumExecutionTime > 0 || this.randomExecutionTime > 0) {
                Uninterruptibles.sleepUninterruptibly((long)((this.randomExecutionTime == 0 ? 0 : RANDOM.nextInt(this.randomExecutionTime)) + this.minimumExecutionTime), (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        private static void checkException(Queue<Exception> exceptions, boolean keepException) {
            Exception e;
            Exception exception = e = keepException ? exceptions.peek() : exceptions.poll();
            if (e != null) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw Status.INTERNAL.withDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException();
            }
        }

        private static void checkStreamException(long streamIndex, Queue<Exception> exceptions, Queue<Long> streamIndices) {
            Exception e = exceptions.peek();
            Long index = streamIndices.peek();
            if (e != null && index != null && index == streamIndex) {
                exceptions.poll();
                streamIndices.poll();
                Throwables.throwIfUnchecked((Throwable)e);
                throw Status.INTERNAL.withDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException();
            }
        }
    }

    public static class StatementResult {
        private final StatementResultType type;
        private final Statement statement;
        private final Long updateCount;
        private final Deque<ResultSet> resultSets;
        private final StatusRuntimeException exception;

        public static StatementResult query(Statement statement, ResultSet resultSet) {
            return new StatementResult(statement, resultSet);
        }

        public static StatementResult queryAndThen(Statement statement, ResultSet resultSet, ResultSet next) {
            return new StatementResult(statement, resultSet);
        }

        public static StatementResult read(String table, KeySet keySet, Iterable<String> columns, ResultSet resultSet) {
            return new StatementResult(table, keySet, columns, resultSet);
        }

        public static StatementResult update(Statement statement, long updateCount) {
            return new StatementResult(statement, updateCount);
        }

        public static StatementResult exception(Statement statement, StatusRuntimeException exception) {
            return new StatementResult(statement, exception);
        }

        public static StatementResult detectDialectResult(Dialect resultDialect) {
            return StatementResult.query(SessionPool.DETERMINE_DIALECT_STATEMENT, ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("DIALECT").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build()).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(resultDialect.toString()).build()).build()).build());
        }

        public static Statement createReadStatement(String table, KeySet keySet, Iterable<String> columns) {
            Preconditions.checkNotNull((Object)table);
            Preconditions.checkNotNull((Object)keySet);
            Preconditions.checkNotNull(columns);
            Preconditions.checkArgument((boolean)StatementResult.isValidKeySet(keySet), (Object)"Currently only KeySet.all() and KeySet.singleKey(Key.of()) are supported for read statements");
            StringBuilder builder = new StringBuilder("SELECT ");
            boolean first = true;
            for (String col : columns) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(col);
                first = false;
            }
            builder.append(" FROM ").append(table);
            if (keySet.isAll()) {
                builder.append(" WHERE 1=1");
            } else {
                builder.append(" WHERE ID=1");
            }
            return Statement.of((String)builder.toString());
        }

        private static boolean isValidKeySet(KeySet keySet) {
            if (keySet.isAll()) {
                return true;
            }
            int keys = 0;
            for (Key key : keySet.getKeys()) {
                ++keys;
                if (key.size() == 0) continue;
                return false;
            }
            return keys == 1;
        }

        private StatementResult(Statement statement, Long updateCount) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.updateCount = (Long)Preconditions.checkNotNull((Object)updateCount);
            this.resultSets = null;
            this.exception = null;
            this.type = StatementResultType.UPDATE_COUNT;
        }

        private StatementResult(Statement statement, ResultSet resultSet) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.resultSets = KeepLastElementDeque.singleton(Preconditions.checkNotNull((Object)resultSet));
            this.updateCount = null;
            this.exception = null;
            this.type = StatementResultType.RESULT_SET;
        }

        private StatementResult(Statement statement, ResultSet resultSet, ResultSet andThen) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.resultSets = KeepLastElementDeque.of(Preconditions.checkNotNull((Object)resultSet), Preconditions.checkNotNull((Object)andThen));
            this.updateCount = null;
            this.exception = null;
            this.type = StatementResultType.RESULT_SET;
        }

        private StatementResult(String table, KeySet keySet, Iterable<String> columns, ResultSet resultSet) {
            this.statement = StatementResult.createReadStatement(table, keySet, columns);
            this.resultSets = KeepLastElementDeque.singleton(Preconditions.checkNotNull((Object)resultSet));
            this.updateCount = null;
            this.exception = null;
            this.type = StatementResultType.RESULT_SET;
        }

        private StatementResult(Statement statement, StatusRuntimeException exception) {
            this.statement = (Statement)Preconditions.checkNotNull((Object)statement);
            this.exception = (StatusRuntimeException)Preconditions.checkNotNull((Object)exception);
            this.resultSets = null;
            this.updateCount = null;
            this.type = StatementResultType.EXCEPTION;
        }

        private StatementResultType getType() {
            return this.type;
        }

        private ResultSet getResultSet() {
            Preconditions.checkState((this.type == StatementResultType.RESULT_SET ? 1 : 0) != 0, (Object)"This statement result does not contain a result set");
            return this.resultSets.pop();
        }

        private Long getUpdateCount() {
            Preconditions.checkState((this.type == StatementResultType.UPDATE_COUNT ? 1 : 0) != 0, (Object)"This statement result does not contain an update count");
            return this.updateCount;
        }

        private StatusRuntimeException getException() {
            Preconditions.checkState((this.type == StatementResultType.EXCEPTION ? 1 : 0) != 0, (Object)"This statement result does not contain an exception");
            return this.exception;
        }

        private static class KeepLastElementDeque<E>
        extends LinkedList<E> {
            private static <E> KeepLastElementDeque<E> singleton(E item) {
                return new KeepLastElementDeque<E>(Collections.singleton(item));
            }

            private static <E> KeepLastElementDeque<E> of(E first, E second) {
                return new KeepLastElementDeque<Object>((Collection<Object>)Arrays.asList(first, second));
            }

            private KeepLastElementDeque(Collection<E> coll) {
                super(coll);
            }

            @Override
            public E pop() {
                return this.size() == 1 ? super.peek() : super.pop();
            }
        }

        private static enum StatementResultType {
            RESULT_SET,
            UPDATE_COUNT,
            EXCEPTION;

        }
    }

    private static class PartialResultSetsIterator
    implements Iterator<PartialResultSet> {
        private static final int MAX_ROWS_IN_CHUNK = 1;
        private final ResultSet resultSet;
        private boolean hasNext;
        private boolean first = true;
        private int currentRow = 0;

        private PartialResultSetsIterator(ResultSet resultSet) {
            this.resultSet = resultSet;
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public PartialResultSet next() {
            PartialResultSet.Builder builder = PartialResultSet.newBuilder();
            if (this.first) {
                builder.setMetadata(this.resultSet.getMetadata());
                this.first = false;
            }
            int recordCount = 0;
            while (recordCount < 1 && this.currentRow < this.resultSet.getRowsCount()) {
                builder.addAllValues((Iterable)this.resultSet.getRows(this.currentRow).getValuesList());
                builder.setResumeToken(ByteString.copyFromUtf8((String)String.format("%010d", this.currentRow)));
                ++recordCount;
                ++this.currentRow;
            }
            builder.setResumeToken(ByteString.copyFromUtf8((String)String.format("%09d", this.currentRow)));
            this.hasNext = this.currentRow < this.resultSet.getRowsCount();
            return builder.build();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

