/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Strings;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValueTest {
    private static final String NULL_STRING = "NULL";

    private static ByteArray newByteArray(String data) {
        return ByteArray.copyFrom((String)data);
    }

    @SafeVarargs
    private static <T> Iterable<T> plainIterable(T ... values) {
        return Lists.newArrayList((Object[])values);
    }

    @Test
    public void bool() {
        Value v = Value.bool((boolean)true);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bool());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.getBool()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"true");
    }

    @Test
    public void boolWrapper() {
        Value v = Value.bool((Boolean)Boolean.FALSE);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bool());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.getBool()).isFalse();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"false");
    }

    @Test
    public void boolWrapperNull() {
        Value v = Value.bool(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bool());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getBool());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void int64() {
        Value v = Value.int64((long)123L);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Long)v.getInt64()).isEqualTo((Object)123);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"123");
    }

    @Test
    public void int64TryGetBool() {
        Value value = Value.int64((long)1234L);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getBool());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: BOOL actual: INT64");
    }

    @Test
    public void int64NullTryGetBool() {
        Value value = Value.int64(null);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getBool());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: BOOL actual: INT64");
    }

    @Test
    public void int64TryGetInt64Array() {
        Value value = Value.int64((long)1234L);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getInt64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: ARRAY<INT64> actual: INT64");
    }

    @Test
    public void int64Wrapper() {
        Value v = Value.int64((Long)123L);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Long)v.getInt64()).isEqualTo((Object)123);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"123");
    }

    @Test
    public void int64WrapperNull() {
        Value v = Value.int64(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getInt64());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void float64() {
        Value v = Value.float64((double)1.23);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.float64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Double)v.getFloat64()).isWithin(1.0E-4).of(1.23);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"1.23");
    }

    @Test
    public void float64Wrapper() {
        Value v = Value.float64((Double)1.23);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.float64());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Double)v.getFloat64()).isWithin(1.0E-4).of(1.23);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"1.23");
    }

    @Test
    public void float64WrapperNull() {
        Value v = Value.float64(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.float64());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getFloat64());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void numeric() {
        Value v = Value.numeric((BigDecimal)new BigDecimal("1.23"));
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.numeric());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((BigDecimal)v.getNumeric()).isEqualTo((Object)BigDecimal.valueOf(123L, 2));
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"1.23");
    }

    @Test
    public void pgNumeric() {
        Value value = Value.pgNumeric((String)"1234.5678");
        Assert.assertEquals((Object)Type.pgNumeric(), (Object)value.getType());
        Assert.assertFalse((String)"pgNumeric value should not be null", (boolean)value.isNull());
        Assert.assertEquals((Object)"1234.5678", (Object)value.getString());
        Assert.assertEquals((Object)BigDecimal.valueOf(12345678L, 4), (Object)value.getNumeric());
        Assert.assertEquals((double)1234.5678, (double)value.getFloat64(), (double)1.0E-5);
        Assert.assertEquals((Object)"1234.5678", (Object)value.toString());
    }

    @Test
    public void pgNumericNaN() {
        Value value = Value.pgNumeric((String)"NaN");
        Assert.assertEquals((Object)Type.pgNumeric(), (Object)value.getType());
        Assert.assertFalse((String)"pgNumeric value should not be null", (boolean)value.isNull());
        Assert.assertEquals((Object)"NaN", (Object)value.getString());
        Assert.assertThrows(NumberFormatException.class, () -> ((Value)value).getNumeric());
        Assert.assertEquals((double)Double.NaN, (double)value.getFloat64(), (double)1.0E-5);
        Assert.assertEquals((Object)"NaN", (Object)value.toString());
    }

    @Test
    public void testNumericFormats() {
        Truth.assertThat((String)new BigDecimal("1").toString()).isEqualTo((Object)"1");
        Truth.assertThat((String)new BigDecimal("01").toString()).isEqualTo((Object)"1");
        Truth.assertThat((String)new BigDecimal("1.").toString()).isEqualTo((Object)"1");
        Truth.assertThat((String)new BigDecimal("+1").toString()).isEqualTo((Object)"1");
        Truth.assertThat((String)new BigDecimal("+1.").toString()).isEqualTo((Object)"1");
        Truth.assertThat((String)new BigDecimal("-1").toString()).isEqualTo((Object)"-1");
        Truth.assertThat((String)new BigDecimal("-1.").toString()).isEqualTo((Object)"-1");
        Truth.assertThat((String)new BigDecimal("0.1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("00.1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal(".1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("+0.1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("+.1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("-0.1").toString()).isEqualTo((Object)"-0.1");
        Truth.assertThat((String)new BigDecimal("-.1").toString()).isEqualTo((Object)"-0.1");
        Truth.assertThat((String)new BigDecimal("1E+1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1e+1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1E1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1e1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("01E+1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("01e+1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("01E1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("01e1").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1E+01").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1e+01").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1E01").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1e01").toString()).isEqualTo((Object)"1E+1");
        Truth.assertThat((String)new BigDecimal("1E-1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("1e-1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("01E-1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("01e-1").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("1E-01").toString()).isEqualTo((Object)"0.1");
        Truth.assertThat((String)new BigDecimal("1e-01").toString()).isEqualTo((Object)"0.1");
    }

    @Test
    public void numericPrecisionAndScale() {
        for (long s : new long[]{1L, -1L}) {
            BigDecimal sign = new BigDecimal(s);
            Truth.assertThat((String)Value.numeric((BigDecimal)new BigDecimal(Strings.repeat((String)"9", (int)29)).multiply(sign)).toString()).isEqualTo((Object)((s == -1L ? "-" : "") + Strings.repeat((String)"9", (int)29)));
            SpannerException e1 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal(Strings.repeat((String)"9", (int)30)).multiply(sign)));
            Truth.assertThat((Comparable)e1.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            SpannerException e2 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal("1" + Strings.repeat((String)"0", (int)29)).multiply(sign)));
            Truth.assertThat((Comparable)e2.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            Truth.assertThat((String)Value.numeric((BigDecimal)new BigDecimal("0." + Strings.repeat((String)"9", (int)9)).multiply(sign)).toString()).isEqualTo((Object)((s == -1L ? "-" : "") + "0." + Strings.repeat((String)"9", (int)9)));
            Truth.assertThat((String)Value.numeric((BigDecimal)new BigDecimal("0.1" + Strings.repeat((String)"0", (int)8)).multiply(sign)).toString()).isEqualTo((Object)((s == -1L ? "-" : "") + "0.1" + Strings.repeat((String)"0", (int)8)));
            Truth.assertThat((String)Value.numeric((BigDecimal)new BigDecimal("0.1" + Strings.repeat((String)"0", (int)20)).multiply(sign)).toString()).isEqualTo((Object)((s == -1L ? "-" : "") + "0.1" + Strings.repeat((String)"0", (int)20)));
            SpannerException e3 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal("0." + Strings.repeat((String)"9", (int)10)).multiply(sign)));
            Truth.assertThat((Comparable)e3.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            Truth.assertThat((String)Value.numeric((BigDecimal)new BigDecimal(Strings.repeat((String)"9", (int)29) + "." + Strings.repeat((String)"9", (int)9)).multiply(sign)).toString()).isEqualTo((Object)((s == -1L ? "-" : "") + Strings.repeat((String)"9", (int)29) + "." + Strings.repeat((String)"9", (int)9)));
            SpannerException e4 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal(Strings.repeat((String)"9", (int)30) + "." + Strings.repeat((String)"9", (int)9)).multiply(sign)));
            Truth.assertThat((Comparable)e4.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            SpannerException e5 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal("1" + Strings.repeat((String)"0", (int)29) + "." + Strings.repeat((String)"9", (int)9)).multiply(sign)));
            Truth.assertThat((Comparable)e5.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            SpannerException e6 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal(Strings.repeat((String)"9", (int)29) + "." + Strings.repeat((String)"9", (int)10)).multiply(sign)));
            Truth.assertThat((Comparable)e6.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            SpannerException e7 = (SpannerException)Assert.assertThrows(SpannerException.class, () -> Value.numeric((BigDecimal)new BigDecimal("1." + Strings.repeat((String)"9", (int)10)).multiply(sign)));
            Truth.assertThat((Comparable)e7.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
        }
    }

    @Test
    public void numericNull() {
        Value v = Value.numeric(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.numeric());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getNumeric());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void pgNumericNull() {
        Value value = Value.pgNumeric(null);
        Assert.assertEquals((Object)Type.pgNumeric(), (Object)value.getType());
        Assert.assertTrue((String)"pgNumeric value should be null", (boolean)value.isNull());
        Assert.assertEquals((Object)NULL_STRING, (Object)value.toString());
        IllegalStateException e1 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getString());
        Assert.assertTrue((String)"exception should mention value is null", (boolean)e1.getMessage().contains("null value"));
        IllegalStateException e2 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getNumeric());
        Assert.assertTrue((String)"exception should mention value is null", (boolean)e2.getMessage().contains("null value"));
        IllegalStateException e3 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getFloat64());
        Assert.assertTrue((String)"exception should mention value is null", (boolean)e3.getMessage().contains("null value"));
    }

    @Test
    public void pgNumericInvalid() {
        Value value = Value.pgNumeric((String)"INVALID");
        Assert.assertEquals((Object)Type.pgNumeric(), (Object)value.getType());
        Assert.assertFalse((String)"pgNumeric value should not be null", (boolean)value.isNull());
        Assert.assertEquals((Object)"INVALID", (Object)value.toString());
        Assert.assertEquals((Object)"INVALID", (Object)value.getString());
        Assert.assertThrows(NumberFormatException.class, () -> ((Value)value).getNumeric());
        Assert.assertThrows(NumberFormatException.class, () -> ((Value)value).getFloat64());
    }

    @Test
    public void string() {
        Value v = Value.string((String)"abc");
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.string());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((String)v.getString()).isEqualTo((Object)"abc");
    }

    @Test
    public void stringNull() {
        Value v = Value.string(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.string());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getString());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void stringLong() {
        String str = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeee";
        Value v = Value.string((String)str);
        Truth.assertThat((String)v.getString()).isEqualTo((Object)str);
        Truth.assertThat((String)v.toString()).hasLength(36);
        Truth.assertThat((String)v.toString()).startsWith(str.substring(0, 33));
        Truth.assertThat((String)v.toString()).endsWith("...");
    }

    @Test
    public void json() {
        String json = "{\"color\":\"red\",\"value\":\"#f00\"}";
        Value v = Value.json((String)json);
        Assert.assertEquals((Object)Type.json(), (Object)v.getType());
        Assert.assertFalse((boolean)v.isNull());
        Assert.assertEquals((Object)json, (Object)v.getJson());
    }

    @Test
    public void jsonNull() {
        Value v = Value.json(null);
        Assert.assertEquals((Object)Type.json(), (Object)v.getType());
        Assert.assertTrue((boolean)v.isNull());
        Assert.assertEquals((Object)NULL_STRING, (Object)v.toString());
        try {
            v.getJson();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((Boolean)e.getMessage().contains("null value"));
        }
    }

    @Test
    public void jsonEmpty() {
        String json = "{}";
        Value v = Value.json((String)json);
        Assert.assertEquals((Object)json, (Object)v.getJson());
    }

    @Test
    public void jsonWithEmptyArray() {
        String json = "[]";
        Value v = Value.json((String)json);
        Assert.assertEquals((Object)json, (Object)v.getJson());
    }

    @Test
    public void jsonWithArray() {
        String json = "[{\"color\":\"red\",\"value\":\"#f00\"},{\"color\":\"green\",\"value\":\"#0f0\"},{\"color\":\"blue\",\"value\":\"#00f\"},{\"color\":\"cyan\",\"value\":\"#0ff\"},{\"color\":\"magenta\",\"value\":\"#f0f\"},{\"color\":\"yellow\",\"value\":\"#ff0\"},{\"color\":\"black\",\"value\":\"#000\"}]";
        Value v = Value.json((String)json);
        Assert.assertEquals((Object)json, (Object)v.getJson());
    }

    @Test
    public void jsonNested() {
        String json = "[{\"id\":\"0001\",\"type\":\"donut\",\"name\":\"Cake\",\"ppu\":0.55,\"batters\":{\"batter\":[{\"id\":\"1001\",\"type\":\"Regular\"},{\"id\":\"1002\",\"type\":\"Chocolate\"},{\"id\":\"1003\",\"type\":\"Blueberry\"},{\"id\":\"1004\",\"type\":\"Devil's Food\"}]},\"topping\":[{\"id\":\"5001\",\"type\":\"None\"},{\"id\":\"5002\",\"type\":\"Glazed\"},{\"id\":\"5005\",\"type\":\"Sugar\"},{\"id\":\"5007\",\"type\":\"Powdered Sugar\"},{\"id\":\"5006\",\"type\":\"Chocolate with Sprinkles\"},{\"id\":\"5003\",\"type\":\"Chocolate\"},{\"id\":\"5004\",\"type\":\"Maple\"}]},{\"id\":\"0002\",\"type\":\"donut\",\"name\":\"Raised\",\"ppu\":0.55,\"batters\":{\"batter\":[{\"id\":\"1001\",\"type\":\"Regular\"}]},\"topping\":[{\"id\":\"5001\",\"type\":\"None\"},{\"id\":\"5002\",\"type\":\"Glazed\"},{\"id\":\"5005\",\"type\":\"Sugar\"},{\"id\":\"5003\",\"type\":\"Chocolate\"},{\"id\":\"5004\",\"type\":\"Maple\"}]},{\"id\":\"0003\",\"type\":\"donut\",\"name\":\"Old Fashioned\",\"ppu\":0.55,\"batters\":{\"batter\":[{\"id\":\"1001\",\"type\":\"Regular\"},{\"id\":\"1002\",\"type\":\"Chocolate\"}]},\"topping\":[{\"id\":\"5001\",\"type\":\"None\"},{\"id\":\"5002\",\"type\":\"Glazed\"},{\"id\":\"5003\",\"type\":\"Chocolate\"},{\"id\":\"5004\",\"type\":\"Maple\"}]}]";
        Value v = Value.json((String)json);
        Assert.assertEquals((Object)json, (Object)v.getJson());
    }

    @Test
    public void bytes() {
        ByteArray bytes = ValueTest.newByteArray("abc");
        Value v = Value.bytes((ByteArray)bytes);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bytes());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBytes()).isSameInstanceAs((Object)bytes);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)bytes.toString());
    }

    @Test
    public void bytesUnprintable() {
        ByteArray bytes = ByteArray.copyFrom((byte[])new byte[]{97, 0, 15, -1, 101});
        Value v = Value.bytes((ByteArray)bytes);
        Truth.assertThat((Iterable)v.getBytes()).isSameInstanceAs((Object)bytes);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)bytes.toString());
    }

    @Test
    public void bytesNull() {
        Value v = Value.bytes(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.bytes());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getBytes());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void timestamp() {
        String timestamp = "2016-09-15T00:00:00Z";
        Timestamp t = Timestamp.parseTimestamp((String)timestamp);
        Value v = Value.timestamp((Timestamp)t);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.timestamp());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.isCommitTimestamp()).isFalse();
        Truth.assertThat((Comparable)v.getTimestamp()).isSameInstanceAs((Object)t);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)timestamp);
    }

    @Test
    public void timestampNull() {
        Value v = Value.timestamp(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.timestamp());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        Truth.assertThat((Boolean)v.isCommitTimestamp()).isFalse();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getTimestamp());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void commitTimestamp() {
        Value v = Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.timestamp());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Boolean)v.isCommitTimestamp()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"spanner.commit_timestamp()");
        Truth.assertThat((Object)v.toProto()).isEqualTo((Object)com.google.protobuf.Value.newBuilder().setStringValue("spanner.commit_timestamp()").build());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getTimestamp());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Commit timestamp value");
    }

    @Test
    public void date() {
        String date = "2016-09-15";
        Date t = Date.parseDate((String)date);
        Value v = Value.date((Date)t);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.date());
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Comparable)v.getDate()).isSameInstanceAs((Object)t);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)date);
    }

    @Test
    public void dateNull() {
        Value v = Value.date(null);
        Truth.assertThat((Object)v.getType()).isEqualTo((Object)Type.date());
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getDate());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void boolArray() {
        Value v = Value.boolArray((boolean[])new boolean[]{true, false});
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBoolArray()).containsExactly(new Object[]{true, false}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[true,false]");
    }

    @Test
    public void boolArrayRange() {
        Value v = Value.boolArray((boolean[])new boolean[]{true, false, false, true, false}, (int)1, (int)3);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBoolArray()).containsExactly(new Object[]{false, false, true}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[false,false,true]");
    }

    @Test
    public void boolArrayNull() {
        Value v = Value.boolArray((boolean[])null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getBoolArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void boolArrayFromList() {
        Value v = Value.boolArray(Arrays.asList(true, null, false));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBoolArray()).containsExactly(new Object[]{true, null, false}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[true,NULL,false]");
    }

    @Test
    public void boolArrayFromListNull() {
        Value v = Value.boolArray((Iterable)null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getBoolArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void boolArrayFromPlainIterable() {
        for (int i = 0; i < 50; ++i) {
            Boolean[] data = new Boolean[i];
            for (int j = 0; j < data.length; ++j) {
                data[j] = j % 3 == 2 ? null : Boolean.valueOf(j % 3 == 1);
            }
            String name = "boolArray() of length " + i;
            Value v = Value.boolArray(ValueTest.plainIterable(data));
            Truth.assertWithMessage((String)name).that(Boolean.valueOf(v.isNull())).isFalse();
            Truth.assertWithMessage((String)name).that((Iterable)v.getBoolArray()).containsExactly((Object[])data).inOrder();
        }
    }

    @Test
    public void boolArrayTryGetInt64Array() {
        Value value = Value.boolArray(Collections.singletonList(true));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getInt64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: ARRAY<INT64> actual: ARRAY<BOOL>");
    }

    @Test
    public void int64Array() {
        Value v = Value.int64Array((long[])new long[]{1L, 2L});
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getInt64Array()).containsExactly(new Object[]{1L, 2L}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[1,2]");
    }

    @Test
    public void int64ArrayRange() {
        Value v = Value.int64Array((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int)1, (int)3);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getInt64Array()).containsExactly(new Object[]{2L, 3L, 4L}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[2,3,4]");
    }

    @Test
    public void int64ArrayNull() {
        Value v = Value.int64Array((long[])null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getInt64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void int64ArrayWrapper() {
        Value v = Value.int64Array(Arrays.asList(1L, null, 3L));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getInt64Array()).containsExactly(new Object[]{1L, null, 3L}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[1,NULL,3]");
    }

    @Test
    public void int64ArrayWrapperNull() {
        Value v = Value.int64Array((Iterable)null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getInt64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void int64ArrayTryGetBool() {
        Value value = Value.int64Array(Collections.singletonList(1234L));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getBool());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: BOOL actual: ARRAY<INT64>");
    }

    @Test
    public void int64ArrayNullTryGetBool() {
        Value value = Value.int64Array((Iterable)null);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getBool());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: BOOL actual: ARRAY<INT64>");
    }

    @Test
    public void float64Array() {
        Value v = Value.float64Array((double[])new double[]{0.1, 0.2});
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getFloat64Array()).containsExactly(new Object[]{0.1, 0.2}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.1,0.2]");
    }

    @Test
    public void float64ArrayRange() {
        Value v = Value.float64Array((double[])new double[]{0.1, 0.2, 0.3, 0.4, 0.5}, (int)1, (int)3);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getFloat64Array()).containsExactly(new Object[]{0.2, 0.3, 0.4}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.2,0.3,0.4]");
    }

    @Test
    public void float64ArrayNull() {
        Value v = Value.float64Array((double[])null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getFloat64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void float64ArrayWrapper() {
        Value v = Value.float64Array(Arrays.asList(0.1, null, 0.3));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getFloat64Array()).containsExactly(new Object[]{0.1, null, 0.3}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.1,NULL,0.3]");
    }

    @Test
    public void float64ArrayWrapperNull() {
        Value v = Value.float64Array((Iterable)null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getFloat64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void float64ArrayTryGetInt64Array() {
        Value value = Value.float64Array(Collections.singletonList(0.1));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getInt64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: ARRAY<INT64> actual: ARRAY<FLOAT64>");
    }

    @Test
    public void numericArray() {
        Value v = Value.numericArray(Arrays.asList(BigDecimal.valueOf(1L, 1), null, BigDecimal.valueOf(3L, 1)));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getNumericArray()).containsExactly(new Object[]{new BigDecimal("0.1"), null, new BigDecimal("0.3")}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[0.1,NULL,0.3]");
    }

    @Test
    public void pgNumericArray() {
        Value value = Value.pgNumericArray(Arrays.asList("1.23", null, "1.24"));
        Assert.assertFalse((String)"pgNumericArray value should not be null", (boolean)value.isNull());
        Assert.assertEquals(Arrays.asList("1.23", null, "1.24"), (Object)value.getStringArray());
        Assert.assertEquals(Arrays.asList(new BigDecimal("1.23"), null, new BigDecimal("1.24")), (Object)value.getNumericArray());
        List float64Array = value.getFloat64Array();
        Assert.assertEquals((double)1.23, (double)((Double)float64Array.get(0)), (double)0.001);
        Assert.assertNull(float64Array.get(1));
        Assert.assertEquals((double)1.24, (double)((Double)float64Array.get(2)), (double)0.001);
    }

    @Test
    public void pgNumericArrayWithNaNs() {
        Value value = Value.pgNumericArray(Arrays.asList("1.23", null, "NaN"));
        Assert.assertFalse((String)"pgNumericArray value should not be null", (boolean)value.isNull());
        Assert.assertEquals(Arrays.asList("1.23", null, "NaN"), (Object)value.getStringArray());
        Assert.assertThrows(NumberFormatException.class, () -> ((Value)value).getNumericArray());
        List float64Array = value.getFloat64Array();
        Assert.assertEquals((double)1.23, (double)((Double)float64Array.get(0)), (double)0.001);
        Assert.assertNull(float64Array.get(1));
        Assert.assertEquals((double)Double.NaN, (double)((Double)float64Array.get(2)), (double)0.001);
    }

    @Test
    public void numericArrayNull() {
        Value v = Value.numericArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getNumericArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void pgNumericArrayNull() {
        Value value = Value.pgNumericArray(null);
        Assert.assertTrue((String)"pgNumericArray value should be null", (boolean)value.isNull());
        Assert.assertEquals((Object)NULL_STRING, (Object)value.toString());
        IllegalStateException e1 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getStringArray());
        Assert.assertTrue((String)"exception should mention value is null", (boolean)e1.getMessage().contains("null value"));
        IllegalStateException e2 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getNumericArray());
        Assert.assertTrue((String)"exception should mention value is null", (boolean)e2.getMessage().contains("null value"));
        IllegalStateException e3 = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getFloat64Array());
        Assert.assertTrue((String)"exception should mention value is null", (boolean)e3.getMessage().contains("null value"));
    }

    @Test
    public void numericArrayTryGetInt64Array() {
        Value value = Value.numericArray(Collections.singletonList(BigDecimal.valueOf(1L, 1)));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getInt64Array());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: ARRAY<INT64> actual: ARRAY<NUMERIC>");
    }

    @Test
    public void pgNumericArrayTryGetInt64Array() {
        Value value = Value.pgNumericArray(Collections.singletonList("1.23"));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getInt64Array());
        Assert.assertTrue((String)"exception should mention type expectation", (boolean)e.getMessage().contains("Expected: ARRAY<INT64> actual: ARRAY<NUMERIC<PG_NUMERIC>>"));
    }

    @Test
    public void stringArray() {
        Value v = Value.stringArray(Arrays.asList("a", null, "c"));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getStringArray()).containsExactly(new Object[]{"a", null, "c"}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[a,NULL,c]");
    }

    @Test
    public void stringArrayNull() {
        Value v = Value.stringArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getStringArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void stringArrayTryGetBytesArray() {
        Value value = Value.stringArray(Collections.singletonList("a"));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getBytesArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: ARRAY<BYTES> actual: ARRAY<STRING>");
    }

    @Test
    public void jsonArray() {
        String one = "{}";
        Object two = null;
        String three = "{\"color\":\"red\",\"value\":\"#f00\"}";
        Value v = Value.jsonArray(Arrays.asList(one, two, three));
        Assert.assertFalse((boolean)v.isNull());
        Truth.assertThat((Iterable)v.getJsonArray()).containsExactly(new Object[]{one, two, three}).inOrder();
        Assert.assertEquals((Object)"[{},NULL,{\"color\":\"red\",\"value\":\"#f00\"}]", (Object)v.toString());
    }

    @Test
    public void jsonArrayNull() {
        Value v = Value.jsonArray(null);
        Assert.assertTrue((boolean)v.isNull());
        Assert.assertEquals((Object)NULL_STRING, (Object)v.toString());
        try {
            v.getJsonArray();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((Boolean)e.getMessage().contains("null value"));
        }
    }

    @Test
    public void jsonArrayTryGetBytesArray() {
        Value value = Value.jsonArray(Arrays.asList("{}"));
        try {
            value.getBytesArray();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((Boolean)e.getMessage().contains("Expected: ARRAY<BYTES> actual: ARRAY<JSON>"));
        }
    }

    @Test
    public void jsonArrayTryGetStringArray() {
        Value value = Value.jsonArray(Arrays.asList("{}"));
        try {
            value.getStringArray();
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((Boolean)e.getMessage().contains("Expected: ARRAY<STRING> actual: ARRAY<JSON>"));
        }
    }

    @Test
    public void bytesArray() {
        ByteArray a = ValueTest.newByteArray("a");
        ByteArray c = ValueTest.newByteArray("c");
        Value v = Value.bytesArray(Arrays.asList(a, null, c));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getBytesArray()).containsExactly(new Object[]{a, null, c}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)String.format("[%s,NULL,%s]", a, c));
    }

    @Test
    public void bytesArrayNull() {
        Value v = Value.bytesArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getBytesArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void bytesArrayTryGetStringArray() {
        Value value = Value.bytesArray(Collections.singletonList(ValueTest.newByteArray("a")));
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)value).getStringArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Expected: ARRAY<STRING> actual: ARRAY<BYTES>");
    }

    @Test
    public void timestampArray() {
        String t1 = "2015-09-15T00:00:00Z";
        String t2 = "2015-09-14T00:00:00Z";
        Value v = Value.timestampArray(Arrays.asList(Timestamp.parseTimestamp((String)t1), null, Timestamp.parseTimestamp((String)t2)));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getTimestampArray()).containsExactly(new Object[]{Timestamp.parseTimestamp((String)t1), null, Timestamp.parseTimestamp((String)t2)}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)("[" + t1 + ",NULL," + t2 + "]"));
    }

    @Test
    public void timestampArrayNull() {
        Value v = Value.timestampArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getTimestampArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void dateArray() {
        String d1 = "2016-09-15";
        String d2 = "2016-09-14";
        Value v = Value.dateArray(Arrays.asList(Date.parseDate((String)d1), null, Date.parseDate((String)d2)));
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Iterable)v.getDateArray()).containsExactly(new Object[]{Date.parseDate((String)d1), null, Date.parseDate((String)d2)}).inOrder();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)("[" + d1 + ",NULL," + d2 + "]"));
    }

    @Test
    public void dateArrayNull() {
        Value v = Value.dateArray(null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getDateArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"null value");
    }

    @Test
    public void struct() {
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("v1")).set("f2").to(30L)).build();
        Value v1 = Value.struct((Struct)struct);
        Truth.assertThat((Object)v1.getType()).isEqualTo((Object)struct.getType());
        Truth.assertThat((Boolean)v1.isNull()).isFalse();
        Truth.assertThat((Object)v1.getStruct()).isEqualTo((Object)struct);
        Truth.assertThat((String)v1.toString()).isEqualTo((Object)"[v1, 30]");
        Value v2 = Value.struct((Type)struct.getType(), (Struct)struct);
        Truth.assertThat((Object)v2).isEqualTo((Object)v1);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Value.struct((Type)Type.struct(Collections.singletonList(Type.StructField.of((String)"f3", (Type)Type.string()))), (Struct)struct));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Mismatch between struct value and type.");
    }

    @Test
    public void nullStruct() {
        List<Type.StructField> fieldTypes = Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()));
        Value v = Value.struct((Type)Type.struct(fieldTypes), null);
        Truth.assertThat((Iterable)v.getType().getStructFields()).isEqualTo(fieldTypes);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> Value.struct(null));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Illegal call to create a NULL struct value.");
    }

    @Test
    public void nullStructGetter() {
        List<Type.StructField> fieldTypes = Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.int64()));
        Value v = Value.struct((Type)Type.struct(fieldTypes), null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getStruct());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Illegal call to getter of null value.");
    }

    @Test
    public void structArrayField() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v1")).set("ff2").to(1L)).build(), null, ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v3")).set("ff2").to(3L)).build());
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").toStructArray(elementType, arrayElements)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.array((Type)elementType))}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isFalse();
        Truth.assertThat((String)struct.getString(0)).isEqualTo((Object)"x");
        Truth.assertThat((Iterable)struct.getStructList(1)).isEqualTo(arrayElements);
    }

    @Test
    public void structArrayFieldNull() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        Struct struct = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to("x")).set("f2").toStructArray(elementType, null)).build();
        Truth.assertThat((Object)struct.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.array((Type)elementType))}));
        Truth.assertThat((Boolean)struct.isNull(0)).isFalse();
        Truth.assertThat((Boolean)struct.isNull(1)).isTrue();
    }

    @Test
    public void structArray() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v1")).set("ff2").to(1L)).build(), null, null, ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("v3")).set("ff2").to(3L)).build());
        Value v = Value.structArray((Type)elementType, arrayElements);
        Truth.assertThat((Boolean)v.isNull()).isFalse();
        Truth.assertThat((Object)v.getType().getArrayElementType()).isEqualTo((Object)elementType);
        Truth.assertThat((Iterable)v.getStructArray()).isEqualTo(arrayElements);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)"[[v1, 1],NULL,NULL,[v3, 3]]");
    }

    @Test
    public void structArrayNull() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        Value v = Value.structArray((Type)elementType, null);
        Truth.assertThat((Boolean)v.isNull()).isTrue();
        Truth.assertThat((Object)v.getType().getArrayElementType()).isEqualTo((Object)elementType);
        Truth.assertThat((String)v.toString()).isEqualTo((Object)NULL_STRING);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Value)v).getStructArray());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Illegal call to getter of null value");
    }

    @Test
    public void structArrayInvalidType() {
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"ff1", (Type)Type.string()), Type.StructField.of((String)"ff2", (Type)Type.int64())));
        List<Struct> arrayElements = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to("1")).set("ff2").to(1L)).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ff1").to(2L)).set("ff2").to(3L)).build());
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Value.structArray((Type)elementType, (Iterable)arrayElements));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"must have type STRUCT<ff1 STRING, ff2 INT64>");
    }

    @Test
    public void testValueToProto() {
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setBoolValue(true).build(), (Object)Value.bool((boolean)true).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setBoolValue(false).build(), (Object)Value.bool((boolean)false).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.bool(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("1").build(), (Object)Value.int64((long)1L).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.int64(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNumberValue(3.14).build(), (Object)Value.float64((double)3.14).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.float64(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("test").build(), (Object)Value.string((String)"test").toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.string(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("{}").build(), (Object)Value.json((String)"{}").toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.json(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue(ByteArray.copyFrom((String)"test").toBase64()).build(), (Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)"test")).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.bytes(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("3.14").build(), (Object)Value.numeric((BigDecimal)new BigDecimal("3.14")).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.numeric(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("1234.5678").build(), (Object)Value.pgNumeric((String)"1234.5678").toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.pgNumeric(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("2010-02-28").build(), (Object)Value.date((Date)Date.fromYearMonthDay((int)2010, (int)2, (int)28)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.date(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setStringValue("2012-04-10T15:16:17.123456789Z").build(), (Object)Value.timestamp((Timestamp)Timestamp.parseTimestamp((String)"2012-04-10T15:16:17.123456789Z")).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), (Object)Value.timestamp(null).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setBoolValue(true).build(), com.google.protobuf.Value.newBuilder().setBoolValue(false).build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.boolArray(Arrays.asList(true, false, null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("1").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.int64Array(Arrays.asList(1L, null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setNumberValue(3.14).build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.float64Array(Arrays.asList(3.14, null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("test").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.stringArray(Arrays.asList("test", null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("{}").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.jsonArray(Arrays.asList("{}", null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue(ByteArray.copyFrom((String)"test").toBase64()).build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"test"), null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("3.14").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.numericArray(Arrays.asList(new BigDecimal("3.14"), null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("1.23").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), com.google.protobuf.Value.newBuilder().setStringValue("NaN").build()))).build(), (Object)Value.pgNumericArray(Arrays.asList("1.23", null, "NaN")).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("2010-02-28").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2010, (int)2, (int)28), null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("2012-04-10T15:16:17.123456789Z").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), (Object)Value.timestampArray(Arrays.asList(Timestamp.parseTimestamp((String)"2012-04-10T15:16:17.123456789Z"), null)).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setBoolValue(true).build(), com.google.protobuf.Value.newBuilder().setBoolValue(false).build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.boolArray(Arrays.asList(true, false, null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("1").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.int64Array(Arrays.asList(1L, null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setNumberValue(3.14).build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.float64Array(Arrays.asList(3.14, null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("test").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.stringArray(Arrays.asList("test", null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue(ByteArray.copyFrom((String)"test").toBase64()).build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"test"), null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("3.14").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.numericArray(Arrays.asList(new BigDecimal("3.14"), null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("2010-02-28").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2010, (int)2, (int)28), null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setStringValue("2012-04-10T15:16:17.123456789Z").build(), com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.timestampArray(Arrays.asList(Timestamp.parseTimestamp((String)"2012-04-10T15:16:17.123456789Z"), null))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("1.23").build()).build()).build(), (Object)Value.struct((Struct)((Struct.Builder)Struct.newBuilder().set("x").to(Value.pgNumeric((String)"1.23"))).build()).toProto());
        Assert.assertEquals((Object)com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(Arrays.asList(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), com.google.protobuf.Value.newBuilder().setStringValue("1.23").build(), com.google.protobuf.Value.newBuilder().setStringValue("NaN").build())).build()).build()).build()).build(), (Object)Value.struct((Struct)Struct.newBuilder().add(Value.pgNumericArray(Arrays.asList(null, "1.23", "NaN"))).build()).toProto());
    }

    @Test
    public void testEqualsHashCode() {
        EqualsTester tester = new EqualsTester();
        String emptyJson = "{}";
        String simpleJson = "{\"color\":\"red\",\"value\":\"#f00\"}";
        tester.addEqualityGroup(new Object[]{Value.bool((boolean)true), Value.bool((Boolean)Boolean.TRUE)});
        tester.addEqualityGroup(new Object[]{Value.bool((boolean)false)});
        tester.addEqualityGroup(new Object[]{Value.bool(null)});
        tester.addEqualityGroup(new Object[]{Value.int64((long)123L), Value.int64((Long)123L)});
        tester.addEqualityGroup(new Object[]{Value.int64((long)456L)});
        tester.addEqualityGroup(new Object[]{Value.int64(null)});
        tester.addEqualityGroup(new Object[]{Value.float64((double)1.23), Value.float64((Double)1.23)});
        tester.addEqualityGroup(new Object[]{Value.float64((double)4.56)});
        tester.addEqualityGroup(new Object[]{Value.float64(null)});
        tester.addEqualityGroup(new Object[]{Value.numeric((BigDecimal)BigDecimal.valueOf(123L, 2)), Value.numeric((BigDecimal)new BigDecimal("1.23"))});
        tester.addEqualityGroup(new Object[]{Value.numeric((BigDecimal)BigDecimal.valueOf(456L, 2))});
        tester.addEqualityGroup(new Object[]{Value.numeric(null)});
        tester.addEqualityGroup(new Object[]{Value.pgNumeric((String)"1234.5678"), Value.pgNumeric((String)"1234.5678")});
        tester.addEqualityGroup(new Object[]{Value.pgNumeric((String)"NaN"), Value.pgNumeric((String)"NaN")});
        tester.addEqualityGroup(new Object[]{Value.pgNumeric((String)"8765.4321")});
        tester.addEqualityGroup(new Object[]{Value.pgNumeric(null)});
        tester.addEqualityGroup(new Object[]{Value.string((String)"abc"), Value.string((String)"abc")});
        tester.addEqualityGroup(new Object[]{Value.string((String)"def")});
        tester.addEqualityGroup(new Object[]{Value.string(null)});
        tester.addEqualityGroup(new Object[]{Value.json((String)simpleJson), Value.json((String)simpleJson)});
        tester.addEqualityGroup(new Object[]{Value.json((String)"{}")});
        tester.addEqualityGroup(new Object[]{Value.json((String)"[]")});
        tester.addEqualityGroup(new Object[]{Value.json(null)});
        tester.addEqualityGroup(new Object[]{Value.bytes((ByteArray)ValueTest.newByteArray("abc")), Value.bytes((ByteArray)ValueTest.newByteArray("abc"))});
        tester.addEqualityGroup(new Object[]{Value.bytes((ByteArray)ValueTest.newByteArray("def"))});
        tester.addEqualityGroup(new Object[]{Value.bytes(null)});
        tester.addEqualityGroup(new Object[]{Value.timestamp(null), Value.timestamp(null)});
        tester.addEqualityGroup(new Object[]{Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP), Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP)});
        Timestamp now = Timestamp.now();
        tester.addEqualityGroup(new Object[]{Value.timestamp((Timestamp)now), Value.timestamp((Timestamp)now)});
        tester.addEqualityGroup(new Object[]{Value.timestamp((Timestamp)Timestamp.ofTimeMicroseconds((long)0L))});
        tester.addEqualityGroup(new Object[]{Value.date(null), Value.date(null)});
        tester.addEqualityGroup(new Object[]{Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)26)), Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)26))});
        tester.addEqualityGroup(new Object[]{Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)27))});
        Struct structValue1 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(20L)).set("f2").to("def")).build();
        Struct structValue2 = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(20L)).set("f2").to("def")).build();
        Truth.assertThat((Boolean)Value.struct((Struct)structValue1).equals(Value.struct((Struct)structValue2))).isTrue();
        tester.addEqualityGroup(new Object[]{Value.struct((Struct)structValue1), Value.struct((Struct)structValue2)});
        Type structType1 = structValue1.getType();
        Type structType2 = Type.struct(Collections.singletonList(Type.StructField.of((String)"f1", (Type)Type.string())));
        tester.addEqualityGroup(new Object[]{Value.struct((Type)structType1, null), Value.struct((Type)structType1, null)});
        tester.addEqualityGroup(new Object[]{Value.struct((Type)structType2, null), Value.struct((Type)structType2, null)});
        tester.addEqualityGroup(new Object[]{Value.boolArray(Arrays.asList(false, true)), Value.boolArray((boolean[])new boolean[]{false, true}), Value.boolArray((boolean[])new boolean[]{true, false, true, false}, (int)1, (int)2), Value.boolArray(ValueTest.plainIterable(false, true))});
        tester.addEqualityGroup(new Object[]{Value.boolArray(Collections.singletonList(false))});
        tester.addEqualityGroup(new Object[]{Value.boolArray((Iterable)null)});
        tester.addEqualityGroup(new Object[]{Value.int64Array(Arrays.asList(1L, 2L)), Value.int64Array((long[])new long[]{1L, 2L}), Value.int64Array((long[])new long[]{0L, 1L, 2L, 3L}, (int)1, (int)2), Value.int64Array(ValueTest.plainIterable(1L, 2L))});
        tester.addEqualityGroup(new Object[]{Value.int64Array(Collections.singletonList(3L))});
        tester.addEqualityGroup(new Object[]{Value.int64Array((Iterable)null)});
        tester.addEqualityGroup(new Object[]{Value.float64Array(Arrays.asList(0.1, 0.2)), Value.float64Array((double[])new double[]{0.1, 0.2}), Value.float64Array((double[])new double[]{0.0, 0.1, 0.2, 0.3}, (int)1, (int)2), Value.float64Array(ValueTest.plainIterable(0.1, 0.2))});
        tester.addEqualityGroup(new Object[]{Value.float64Array(Collections.singletonList(0.3))});
        tester.addEqualityGroup(new Object[]{Value.float64Array((Iterable)null)});
        tester.addEqualityGroup(new Object[]{Value.numericArray(Arrays.asList(BigDecimal.valueOf(1L, 1), BigDecimal.valueOf(2L, 1)))});
        tester.addEqualityGroup(new Object[]{Value.numericArray(Collections.singletonList(BigDecimal.valueOf(3L, 1)))});
        tester.addEqualityGroup(new Object[]{Value.numericArray(null)});
        tester.addEqualityGroup(new Object[]{Value.pgNumericArray(Arrays.asList("1.23", null, "NaN")), Value.pgNumericArray(Arrays.asList("1.23", null, "NaN"))});
        tester.addEqualityGroup(new Object[]{Value.pgNumericArray(Collections.singletonList("1.25"))});
        tester.addEqualityGroup(new Object[]{Value.pgNumericArray(null), Value.pgNumericArray(null)});
        tester.addEqualityGroup(new Object[]{Value.stringArray(Arrays.asList("a", "b")), Value.stringArray(Arrays.asList("a", "b"))});
        tester.addEqualityGroup(new Object[]{Value.stringArray(Collections.singletonList("c"))});
        tester.addEqualityGroup(new Object[]{Value.stringArray(null)});
        tester.addEqualityGroup(new Object[]{Value.jsonArray(Arrays.asList(emptyJson, simpleJson)), Value.jsonArray(Arrays.asList(emptyJson, simpleJson))});
        tester.addEqualityGroup(new Object[]{Value.jsonArray(Arrays.asList("[]"))});
        tester.addEqualityGroup(new Object[]{Value.jsonArray(null)});
        tester.addEqualityGroup(new Object[]{Value.bytesArray(Arrays.asList(ValueTest.newByteArray("a"), ValueTest.newByteArray("b"))), Value.bytesArray(Arrays.asList(ValueTest.newByteArray("a"), ValueTest.newByteArray("b")))});
        tester.addEqualityGroup(new Object[]{Value.bytesArray(Collections.singletonList(ValueTest.newByteArray("c")))});
        tester.addEqualityGroup(new Object[]{Value.bytesArray(null)});
        tester.addEqualityGroup(new Object[]{Value.timestampArray(Arrays.asList(null, now)), Value.timestampArray(Arrays.asList(null, now))});
        tester.addEqualityGroup(new Object[]{Value.timestampArray(null)});
        tester.addEqualityGroup(new Object[]{Value.dateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2018, (int)2, (int)26))), Value.dateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2018, (int)2, (int)26)))});
        tester.addEqualityGroup(new Object[]{Value.dateArray(null)});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, Arrays.asList(structValue1, null)), Value.structArray((Type)structType1, Arrays.asList(structValue2, null))});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, Collections.singletonList(null)), Value.structArray((Type)structType1, Collections.singletonList(null))});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, null), Value.structArray((Type)structType1, null)});
        tester.addEqualityGroup(new Object[]{Value.structArray((Type)structType1, new ArrayList()), Value.structArray((Type)structType1, new ArrayList())});
        tester.testEquals();
    }

    @Test
    public void serialization() {
        SerializableTester.reserializeAndAssert((Object)Value.bool((boolean)true));
        SerializableTester.reserializeAndAssert((Object)Value.bool((boolean)false));
        SerializableTester.reserializeAndAssert((Object)Value.bool(null));
        SerializableTester.reserializeAndAssert((Object)Value.int64((long)123L));
        SerializableTester.reserializeAndAssert((Object)Value.int64(null));
        SerializableTester.reserializeAndAssert((Object)Value.float64((double)1.23));
        SerializableTester.reserializeAndAssert((Object)Value.float64(null));
        SerializableTester.reserializeAndAssert((Object)Value.numeric((BigDecimal)BigDecimal.valueOf(123L, 2)));
        SerializableTester.reserializeAndAssert((Object)Value.numeric(null));
        SerializableTester.reserializeAndAssert((Object)Value.pgNumeric((String)"1.23"));
        SerializableTester.reserializeAndAssert((Object)Value.pgNumeric((String)"NaN"));
        SerializableTester.reserializeAndAssert((Object)Value.pgNumeric(null));
        SerializableTester.reserializeAndAssert((Object)Value.string((String)"abc"));
        SerializableTester.reserializeAndAssert((Object)Value.string(null));
        SerializableTester.reserializeAndAssert((Object)Value.json((String)"{\"color\":\"red\",\"value\":\"#f00\"}"));
        SerializableTester.reserializeAndAssert((Object)Value.json(null));
        SerializableTester.reserializeAndAssert((Object)Value.bytes((ByteArray)ValueTest.newByteArray("abc")));
        SerializableTester.reserializeAndAssert((Object)Value.bytes(null));
        SerializableTester.reserializeAndAssert((Object)Value.struct((Struct)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f").to(3L)).set("f").to((Date)null)).build()));
        SerializableTester.reserializeAndAssert((Object)Value.struct((Type)Type.struct(Arrays.asList(Type.StructField.of((String)"a", (Type)Type.string()), Type.StructField.of((String)"b", (Type)Type.int64()))), null));
        SerializableTester.reserializeAndAssert((Object)Value.boolArray((boolean[])new boolean[]{false, true}));
        SerializableTester.reserializeAndAssert((Object)Value.boolArray(BrokenSerializationList.of(true, false)));
        SerializableTester.reserializeAndAssert((Object)Value.boolArray((Iterable)null));
        SerializableTester.reserializeAndAssert((Object)Value.int64Array(BrokenSerializationList.of(1L, 2L)));
        SerializableTester.reserializeAndAssert((Object)Value.int64Array((long[])new long[]{1L, 2L}));
        SerializableTester.reserializeAndAssert((Object)Value.int64Array((Iterable)null));
        SerializableTester.reserializeAndAssert((Object)Value.float64Array((double[])new double[]{0.1, 0.2}));
        SerializableTester.reserializeAndAssert((Object)Value.float64Array(BrokenSerializationList.of(0.1, 0.2, 0.3)));
        SerializableTester.reserializeAndAssert((Object)Value.float64Array((Iterable)null));
        SerializableTester.reserializeAndAssert((Object)Value.numericArray(Arrays.asList(BigDecimal.valueOf(1L, 1), null, BigDecimal.valueOf(2L, 1))));
        SerializableTester.reserializeAndAssert((Object)Value.numericArray(BrokenSerializationList.of(BigDecimal.valueOf(1L, 1), BigDecimal.valueOf(2L, 1), BigDecimal.valueOf(3L, 1))));
        SerializableTester.reserializeAndAssert((Object)Value.numericArray(null));
        SerializableTester.reserializeAndAssert((Object)Value.pgNumericArray(Arrays.asList("1.23", null, "NaN")));
        SerializableTester.reserializeAndAssert((Object)Value.pgNumericArray(BrokenSerializationList.of("1.23", "1.24", "NaN")));
        SerializableTester.reserializeAndAssert((Object)Value.pgNumericArray(null));
        SerializableTester.reserializeAndAssert((Object)Value.timestamp(null));
        SerializableTester.reserializeAndAssert((Object)Value.timestamp((Timestamp)Value.COMMIT_TIMESTAMP));
        SerializableTester.reserializeAndAssert((Object)Value.timestamp((Timestamp)Timestamp.now()));
        SerializableTester.reserializeAndAssert((Object)Value.timestampArray(Arrays.asList(null, Timestamp.now())));
        SerializableTester.reserializeAndAssert((Object)Value.date(null));
        SerializableTester.reserializeAndAssert((Object)Value.date((Date)Date.fromYearMonthDay((int)2018, (int)2, (int)26)));
        SerializableTester.reserializeAndAssert((Object)Value.dateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2018, (int)2, (int)26))));
        BrokenSerializationList<String> of = BrokenSerializationList.of("a", "b");
        SerializableTester.reserializeAndAssert((Object)Value.stringArray(of));
        SerializableTester.reserializeAndAssert((Object)Value.stringArray(null));
        BrokenSerializationList<String> json = BrokenSerializationList.of("{}", "{\"color\":\"red\",\"value\":\"#f00\"}");
        SerializableTester.reserializeAndAssert((Object)Value.jsonArray(json));
        SerializableTester.reserializeAndAssert((Object)Value.jsonArray(null));
        SerializableTester.reserializeAndAssert((Object)Value.bytesArray(BrokenSerializationList.of(ValueTest.newByteArray("a"), ValueTest.newByteArray("b"))));
        SerializableTester.reserializeAndAssert((Object)Value.bytesArray(null));
        Struct s1 = ((Struct.Builder)Struct.newBuilder().set("f1").to(1L)).build();
        Struct s2 = ((Struct.Builder)Struct.newBuilder().set("f1").to(2L)).build();
        SerializableTester.reserializeAndAssert((Object)Value.structArray((Type)s1.getType(), BrokenSerializationList.of(s1, null, s2)));
        SerializableTester.reserializeAndAssert((Object)Value.structArray((Type)s1.getType(), null));
    }

    @Test(expected=IllegalStateException.class)
    public void verifyBrokenSerialization() {
        SerializableTester.reserializeAndAssert(BrokenSerializationList.of(1, 2, 3));
    }

    private static class BrokenSerializationList<T>
    extends ForwardingList<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<T> delegate;

        public static <T> BrokenSerializationList<T> of(T ... values) {
            return new BrokenSerializationList<T>(Arrays.asList(values));
        }

        private BrokenSerializationList(List<T> delegate) {
            this.delegate = delegate;
        }

        protected List<T> delegate() {
            return this.delegate;
        }

        private void readObject(ObjectInputStream unusedStream) {
            throw new IllegalStateException("Serialization disabled");
        }

        private void writeObject(ObjectOutputStream unusedStream) {
            throw new IllegalStateException("Serialization disabled");
        }
    }
}

