/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.AbstractSqlScriptVerifier;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImplTest;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import com.google.common.base.Preconditions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractSqlScriptTest {
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    static class TestConnectionProvider
    implements AbstractSqlScriptVerifier.GenericConnectionProvider {
        final Dialect dialect;

        TestConnectionProvider(Dialect dialect) {
            this.dialect = (Dialect)Preconditions.checkNotNull((Object)dialect);
        }

        @Override
        public AbstractSqlScriptVerifier.GenericConnection getConnection() {
            return SqlScriptVerifier.SpannerGenericConnection.of((Connection)ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;dialect=" + this.dialect.name()).build()));
        }
    }
}

