/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractConnectionImplTest;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionImplTest;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.TransactionMode;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class ConnectionImplAutocommitReadWriteTest {

    public static class ConnectionImplAutocommitReadWriteAfterStartDdlBatchTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("START BATCH DDL;");
            connection.startBatchDdl();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            throw new IllegalStateException();
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            throw new IllegalStateException();
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            throw new IllegalStateException();
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return false;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return false;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return false;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return false;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return false;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return type == AbstractStatementParser.StatementType.CLIENT_SIDE || type == AbstractStatementParser.StatementType.DDL;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return true;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return true;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterBeginReadOnlyTransactionTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("BEGIN TRANSACTION;");
            connection.beginTransaction();
            this.log("SET TRANSACTION READ ONLY;");
            connection.setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return false;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return false;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return false;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return true;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return true;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return mode == TimestampBound.Mode.STRONG || mode == TimestampBound.Mode.EXACT_STALENESS || mode == TimestampBound.Mode.READ_TIMESTAMP;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return true;
        }

        @Override
        boolean isRollbackAllowed() {
            return true;
        }

        @Override
        boolean expectedIsInTransaction() {
            return true;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return type == AbstractStatementParser.StatementType.CLIENT_SIDE || type == AbstractStatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterTemporaryTransactionTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("BEGIN TRANSACTION;");
            connection.beginTransaction();
            this.log("UPDATE foo SET bar=1;");
            connection.execute(Statement.of((String)"UPDATE foo SET bar=1"));
            this.log("COMMIT;");
            connection.commit();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return true;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return true;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return true;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterBeginTransactionTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("BEGIN TRANSACTION;");
            connection.beginTransaction();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return false;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return false;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return false;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return true;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return true;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return true;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return mode == TimestampBound.Mode.STRONG || mode == TimestampBound.Mode.EXACT_STALENESS || mode == TimestampBound.Mode.READ_TIMESTAMP;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return true;
        }

        @Override
        boolean isRollbackAllowed() {
            return true;
        }

        @Override
        boolean expectedIsInTransaction() {
            return true;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return type == AbstractStatementParser.StatementType.CLIENT_SIDE || type == AbstractStatementParser.StatementType.QUERY || type == AbstractStatementParser.StatementType.UPDATE;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterDdlTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id);");
            connection.execute(Statement.of((String)"CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id)"));
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return true;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return true;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterUpdateTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("UPDATE foo SET bar=1;");
            connection.execute(Statement.of((String)"UPDATE foo SET bar=1"));
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return true;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return true;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return true;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterSelectAndResultSetNextTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("@EXPECT RESULT_SET 'TEST',1");
            this.log("SELECT 1 AS TEST;");
            connection.execute(Statement.of((String)"SELECT 1 AS TEST")).getResultSet().next();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return true;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return true;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return true;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteAfterSelectTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("SELECT 1 AS TEST;");
            connection.execute(Statement.of((String)"SELECT 1 AS TEST"));
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return true;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return true;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return true;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadWriteNoActionsTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=FALSE;");
            connection.setReadOnly(false);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isSetTransactionTagAllowed() {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(AbstractStatementParser.StatementType type) {
            return true;
        }

        @Override
        boolean isWriteAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return true;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return true;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }
}

