/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.EmulatorUtil;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class EmulatorUtilTest {
    @Test
    public void testCreateInstanceAndDatabase_bothSucceed() throws InterruptedException, ExecutionException {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)spanner.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)options.getCredentials()).thenReturn((Object)NoCredentials.getInstance());
        InstanceAdminClient instanceClient = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
        OperationFuture instanceOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getInstanceAdminClient()).thenReturn((Object)instanceClient);
        Mockito.when((Object)instanceClient.createInstance((InstanceInfo)Mockito.any(InstanceInfo.class))).thenReturn((Object)instanceOperationFuture);
        Mockito.when((Object)instanceOperationFuture.get()).thenReturn(Mockito.mock(Instance.class));
        DatabaseAdminClient databaseClient = (DatabaseAdminClient)Mockito.mock(DatabaseAdminClient.class);
        OperationFuture databaseOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getDatabaseAdminClient()).thenReturn((Object)databaseClient);
        Mockito.when((Object)databaseClient.createDatabase((String)Mockito.eq((Object)"test-instance"), (String)Mockito.eq((Object)"test-database"), (Iterable)Mockito.eq((Object)ImmutableList.of()))).thenReturn((Object)databaseOperationFuture);
        Mockito.when((Object)databaseOperationFuture.get()).thenReturn(Mockito.mock(Database.class));
        EmulatorUtil.maybeCreateInstanceAndDatabase((Spanner)spanner, (DatabaseId)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"));
        ((InstanceAdminClient)Mockito.verify((Object)instanceClient)).createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)"test-project", (String)"test-instance")).setDisplayName("Automatically Generated Test Instance").setInstanceConfigId(InstanceConfigId.of((String)"test-project", (String)"emulator-config")).setNodeCount(1).build());
        ((DatabaseAdminClient)Mockito.verify((Object)databaseClient)).createDatabase("test-instance", "test-database", (Iterable)ImmutableList.of());
    }

    @Test
    public void testCreateInstanceAndDatabase_bothFailWithAlreadyExists() throws InterruptedException, ExecutionException {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)spanner.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)options.getCredentials()).thenReturn((Object)NoCredentials.getInstance());
        InstanceAdminClient instanceClient = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
        OperationFuture instanceOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getInstanceAdminClient()).thenReturn((Object)instanceClient);
        Mockito.when((Object)instanceClient.createInstance((InstanceInfo)Mockito.any(InstanceInfo.class))).thenReturn((Object)instanceOperationFuture);
        Mockito.when((Object)instanceOperationFuture.get()).thenThrow(new Throwable[]{new ExecutionException(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ALREADY_EXISTS, (String)"Instance already exists"))});
        DatabaseAdminClient databaseClient = (DatabaseAdminClient)Mockito.mock(DatabaseAdminClient.class);
        OperationFuture databaseOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getDatabaseAdminClient()).thenReturn((Object)databaseClient);
        Mockito.when((Object)databaseClient.createDatabase((String)Mockito.eq((Object)"test-instance"), (String)Mockito.eq((Object)"test-database"), (Iterable)Mockito.eq((Object)ImmutableList.of()))).thenReturn((Object)databaseOperationFuture);
        Mockito.when((Object)databaseOperationFuture.get()).thenThrow(new Throwable[]{new ExecutionException(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ALREADY_EXISTS, (String)"Database already exists"))});
        EmulatorUtil.maybeCreateInstanceAndDatabase((Spanner)spanner, (DatabaseId)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"));
        ((InstanceAdminClient)Mockito.verify((Object)instanceClient)).createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)"test-project", (String)"test-instance")).setDisplayName("Automatically Generated Test Instance").setInstanceConfigId(InstanceConfigId.of((String)"test-project", (String)"emulator-config")).setNodeCount(1).build());
        ((DatabaseAdminClient)Mockito.verify((Object)databaseClient)).createDatabase("test-instance", "test-database", (Iterable)ImmutableList.of());
    }

    @Test
    public void testCreateInstanceAndDatabase_propagatesOtherErrorsOnInstanceCreation() throws InterruptedException, ExecutionException {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)spanner.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)options.getCredentials()).thenReturn((Object)NoCredentials.getInstance());
        InstanceAdminClient instanceClient = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
        OperationFuture instanceOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getInstanceAdminClient()).thenReturn((Object)instanceClient);
        Mockito.when((Object)instanceClient.createInstance((InstanceInfo)Mockito.any(InstanceInfo.class))).thenReturn((Object)instanceOperationFuture);
        Mockito.when((Object)instanceOperationFuture.get()).thenThrow(new Throwable[]{new ExecutionException(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Invalid instance options"))});
        try {
            EmulatorUtil.maybeCreateInstanceAndDatabase((Spanner)spanner, (DatabaseId)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testCreateInstanceAndDatabase_propagatesInterruptsOnInstanceCreation() throws InterruptedException, ExecutionException {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)spanner.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)options.getCredentials()).thenReturn((Object)NoCredentials.getInstance());
        InstanceAdminClient instanceClient = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
        OperationFuture instanceOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getInstanceAdminClient()).thenReturn((Object)instanceClient);
        Mockito.when((Object)instanceClient.createInstance((InstanceInfo)Mockito.any(InstanceInfo.class))).thenReturn((Object)instanceOperationFuture);
        Mockito.when((Object)instanceOperationFuture.get()).thenThrow(new Throwable[]{new InterruptedException()});
        try {
            EmulatorUtil.maybeCreateInstanceAndDatabase((Spanner)spanner, (DatabaseId)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testCreateInstanceAndDatabase_propagatesOtherErrorsOnDatabaseCreation() throws InterruptedException, ExecutionException {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)spanner.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)options.getCredentials()).thenReturn((Object)NoCredentials.getInstance());
        InstanceAdminClient instanceClient = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
        OperationFuture instanceOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getInstanceAdminClient()).thenReturn((Object)instanceClient);
        Mockito.when((Object)instanceClient.createInstance((InstanceInfo)Mockito.any(InstanceInfo.class))).thenReturn((Object)instanceOperationFuture);
        Mockito.when((Object)instanceOperationFuture.get()).thenReturn(Mockito.mock(Instance.class));
        DatabaseAdminClient databaseClient = (DatabaseAdminClient)Mockito.mock(DatabaseAdminClient.class);
        OperationFuture databaseOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getDatabaseAdminClient()).thenReturn((Object)databaseClient);
        Mockito.when((Object)databaseClient.createDatabase((String)Mockito.eq((Object)"test-instance"), (String)Mockito.eq((Object)"test-database"), (Iterable)Mockito.eq((Object)ImmutableList.of()))).thenReturn((Object)databaseOperationFuture);
        Mockito.when((Object)databaseOperationFuture.get()).thenThrow(new Throwable[]{new ExecutionException(SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Invalid database options"))});
        try {
            EmulatorUtil.maybeCreateInstanceAndDatabase((Spanner)spanner, (DatabaseId)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testCreateInstanceAndDatabase_propagatesInterruptsOnDatabaseCreation() throws InterruptedException, ExecutionException {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)spanner.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)options.getCredentials()).thenReturn((Object)NoCredentials.getInstance());
        InstanceAdminClient instanceClient = (InstanceAdminClient)Mockito.mock(InstanceAdminClient.class);
        OperationFuture instanceOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getInstanceAdminClient()).thenReturn((Object)instanceClient);
        Mockito.when((Object)instanceClient.createInstance((InstanceInfo)Mockito.any(InstanceInfo.class))).thenReturn((Object)instanceOperationFuture);
        Mockito.when((Object)instanceOperationFuture.get()).thenReturn(Mockito.mock(Instance.class));
        DatabaseAdminClient databaseClient = (DatabaseAdminClient)Mockito.mock(DatabaseAdminClient.class);
        OperationFuture databaseOperationFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)spanner.getDatabaseAdminClient()).thenReturn((Object)databaseClient);
        Mockito.when((Object)databaseClient.createDatabase((String)Mockito.eq((Object)"test-instance"), (String)Mockito.eq((Object)"test-database"), (Iterable)Mockito.eq((Object)ImmutableList.of()))).thenReturn((Object)databaseOperationFuture);
        Mockito.when((Object)databaseOperationFuture.get()).thenThrow(new Throwable[]{new InterruptedException()});
        try {
            EmulatorUtil.maybeCreateInstanceAndDatabase((Spanner)spanner, (DatabaseId)DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database"));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
        }
    }
}

