/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITBatchReadTest {
    private static int numRows;
    private static final int WRITE_BATCH_SIZE = 0x100000;
    private static final String TABLE_NAME = "BatchTestTable";
    private static final String INDEX_NAME = "TestIndexByValue";
    private static final long STALENESS_MILLISEC = 1000L;
    @ClassRule
    public static IntegrationTestEnv env;
    private static HashFunction hasher;
    private static BatchClient googleStandardSQLBatchClient;
    private static BatchClient postgreSQLBatchClient;
    private static final Random RANDOM;
    private BatchReadOnlyTransaction batchTxn;
    @Parameterized.Parameter
    public DialectTestParameter dialect;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    private static List<Integer> manyRows() {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        rows.addAll(Collections.nCopies(1000, 4096));
        rows.addAll(Collections.nCopies(100, 40960));
        rows.addAll(Collections.nCopies(25, 409600));
        rows.addAll(Collections.nCopies(10, 0x400000));
        return rows;
    }

    @BeforeClass
    public static void setUpDatabase() throws Exception {
        Database googleStandardDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE BatchTestTable (  Key           INT64 NOT NULL,  Data          BYTES(MAX),  Fingerprint   INT64,  Size          INT64,) PRIMARY KEY (Key)", "CREATE INDEX TestIndexByValue ON BatchTestTable(Fingerprint)"});
        hasher = Hashing.goodFastHash((int)64);
        googleStandardSQLBatchClient = env.getTestHelper().getBatchClient(googleStandardDatabase);
        ArrayList<DatabaseClient> databaseClients = new ArrayList<DatabaseClient>();
        databaseClients.add(env.getTestHelper().getDatabaseClient(googleStandardDatabase));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.emptyList());
            env.getTestHelper().getClient().getDatabaseAdminClient().updateDatabaseDdl(env.getTestHelper().getInstanceId().getInstance(), postgreSQLDatabase.getId().getDatabase(), (Iterable)ImmutableList.of((Object)"CREATE TABLE BatchTestTable (  Key           bigint not null primary key,  Data          bytea,  Fingerprint   bigint,  Size          bigint)", (Object)"CREATE INDEX TestIndexByValue ON BatchTestTable(Fingerprint)"), null).get();
            postgreSQLBatchClient = env.getTestHelper().getBatchClient(postgreSQLDatabase);
            databaseClients.add(env.getTestHelper().getDatabaseClient(postgreSQLDatabase));
        }
        List<Integer> rows = ITBatchReadTest.manyRows();
        numRows = rows.size();
        for (DatabaseClient dbClient : databaseClients) {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            int totalSize = 0;
            int i = 0;
            for (int row : rows) {
                byte[] data = new byte[row];
                RANDOM.nextBytes(data);
                mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to((long)i)).set("Data").to(ByteArray.copyFrom((byte[])data))).set("Fingerprint").to(hasher.hashBytes(data).asLong())).set("Size").to((long)row)).build());
                ++i;
                if ((totalSize += row) < 0x100000) continue;
                dbClient.write(mutations);
                mutations.clear();
                totalSize = 0;
            }
            dbClient.write(mutations);
        }
        Thread.sleep(2000L);
    }

    private BatchClient getBatchClient() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return postgreSQLBatchClient;
        }
        return googleStandardSQLBatchClient;
    }

    @Test
    public void read() {
        Assume.assumeFalse((String)"PostgreSQL does not support the PartitionRead RPC", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        BitSet seenRows = new BitSet(numRows);
        TimestampBound bound = this.getRandomBound();
        PartitionOptions partitionParams = this.getRandomPartitionOptions();
        this.batchTxn = this.getBatchClient().batchReadOnlyTransaction(bound);
        List partitions = this.batchTxn.partitionRead(partitionParams, TABLE_NAME, KeySet.all(), Arrays.asList("Key", "Data", "Fingerprint", "Size"), new Options.ReadOption[0]);
        BatchTransactionId txnID = this.batchTxn.getBatchTransactionId();
        this.fetchAndValidateRows(partitions, txnID, seenRows);
    }

    @Test
    public void readUsingIndex() {
        Assume.assumeFalse((String)"PostgreSQL does not support the PartitionRead RPC", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        TimestampBound bound = this.getRandomBound();
        PartitionOptions partitionParams = this.getRandomPartitionOptions();
        this.batchTxn = this.getBatchClient().batchReadOnlyTransaction(bound);
        List partitions = this.batchTxn.partitionReadUsingIndex(partitionParams, TABLE_NAME, INDEX_NAME, KeySet.all(), Collections.singletonList("Fingerprint"), new Options.ReadOption[0]);
        BatchTransactionId txnID = this.batchTxn.getBatchTransactionId();
        int numRowsRead = 0;
        for (Partition p : partitions) {
            BatchReadOnlyTransaction batchTxnOnEachWorker = this.getBatchClient().batchReadOnlyTransaction(txnID);
            ResultSet result = batchTxnOnEachWorker.execute(p);
            Throwable throwable = null;
            try {
                while (result.next()) {
                    ++numRowsRead;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (result == null) continue;
                if (throwable != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                result.close();
            }
        }
        Truth.assertThat((Integer)numRowsRead).isEqualTo((Object)numRows);
    }

    @After
    public void tearDown() {
        if (this.batchTxn != null) {
            this.batchTxn.close();
        }
    }

    @Test
    public void query() {
        BitSet seenRows = new BitSet(numRows);
        TimestampBound bound = this.getRandomBound();
        PartitionOptions partitionParams = this.getRandomPartitionOptions();
        this.batchTxn = this.getBatchClient().batchReadOnlyTransaction(bound);
        List partitions = this.batchTxn.partitionQuery(partitionParams, Statement.of((String)"SELECT Key, Data, Fingerprint, Size FROM BatchTestTable"), new Options.QueryOption[0]);
        BatchTransactionId txnID = this.batchTxn.getBatchTransactionId();
        this.fetchAndValidateRows(partitions, txnID, seenRows);
    }

    private PartitionOptions getRandomPartitionOptions() {
        int desiredBytesPerBatch = 0x40000000;
        int maxPartitionCount = 100;
        PartitionOptions parameters = PartitionOptions.newBuilder().setPartitionSizeBytes((long)desiredBytesPerBatch).setMaxPartitions((long)maxPartitionCount).build();
        if (RANDOM.nextInt(2) == 1) {
            parameters = PartitionOptions.getDefaultInstance();
        }
        return parameters;
    }

    private TimestampBound getRandomBound() {
        Date date = new Date();
        switch (RANDOM.nextInt(3)) {
            case 0: {
                return TimestampBound.strong();
            }
            case 1: {
                return TimestampBound.ofExactStaleness((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        return TimestampBound.ofReadTimestamp((Timestamp)Timestamp.of((Date)new Date(date.getTime() - 1000L)));
    }

    private void fetchAndValidateRows(List<Partition> partitions, BatchTransactionId txnID, BitSet seenRows) {
        for (Partition p : partitions) {
            BatchReadOnlyTransaction batchTxnOnEachWorker = this.getBatchClient().batchReadOnlyTransaction(txnID);
            ResultSet result = batchTxnOnEachWorker.execute(p);
            Throwable throwable = null;
            try {
                this.validate(result, seenRows);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (result == null) continue;
                if (throwable != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                result.close();
            }
        }
        Truth.assertThat((Integer)seenRows.nextClearBit(0)).isEqualTo((Object)numRows);
    }

    private void validate(ResultSet resultSet, BitSet seenRows) {
        while (resultSet.next()) {
            Truth.assertThat((Boolean)seenRows.get((int)resultSet.getLong(0))).isFalse();
            seenRows.set((int)resultSet.getLong(0));
            ByteArray data = resultSet.getBytes(1);
            Truth.assertThat((Integer)data.length()).isEqualTo((Object)resultSet.getLong(3));
            Truth.assertThat((Long)resultSet.getLong(2)).isEqualTo((Object)hasher.hashBytes(data.toByteArray()).asLong());
        }
    }

    static {
        env = new IntegrationTestEnv();
        RANDOM = new Random();
    }
}

