/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ResultSetStats;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITQueryTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private String selectValueQuery;
    @Parameterized.Parameter(value=0)
    public DialectTestParameter dialect;

    @BeforeClass
    public static void setUpDatabase() {
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[0]);
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.emptyList());
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Before
    public void initSelectValueQuery() {
        this.selectValueQuery = "SELECT @p1";
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            this.selectValueQuery = "SELECT $1";
        }
    }

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    private DatabaseClient getClient(Dialect dialect) {
        if (dialect == Dialect.POSTGRESQL) {
            return postgreSQLClient;
        }
        return googleStandardSQLClient;
    }

    @Test
    public void simple() {
        Struct row = this.execute(Statement.of((String)"SELECT 1"), Type.int64());
        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1);
    }

    @Test
    public void badQuery() {
        try {
            this.execute(Statement.of((String)"SELECT Apples AND Oranges"), Type.int64());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            if (this.dialect.dialect == Dialect.POSTGRESQL) {
                Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"column \"apples\" does not exist");
            }
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Unrecognized name: Apples");
        }
    }

    @Test
    public void arrayOfStruct() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Type structType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C1", (Type)Type.string()), Type.StructField.of((String)"C2", (Type)Type.int64())});
        Struct row = this.execute(Statement.of((String)"SELECT ARRAY(SELECT AS STRUCT C1, C2 FROM (SELECT 'a' AS C1, 1 AS C2 UNION ALL SELECT 'b' AS C1, 2 AS C2) ORDER BY C1 ASC)"), Type.array((Type)structType));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        List value = row.getStructList(0);
        Truth.assertThat((Integer)value.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((Struct)value.get(0)).getType()).isEqualTo((Object)structType);
        Truth.assertThat((String)((Struct)value.get(0)).getString(0)).isEqualTo((Object)"a");
        Truth.assertThat((Long)((Struct)value.get(0)).getLong(1)).isEqualTo((Object)1);
        Truth.assertThat((Object)((Struct)value.get(1)).getType()).isEqualTo((Object)structType);
        Truth.assertThat((String)((Struct)value.get(1)).getString(0)).isEqualTo((Object)"b");
        Truth.assertThat((Long)((Struct)value.get(1)).getLong(1)).isEqualTo((Object)2);
        Struct expectedRow = ((Struct.Builder)Struct.newBuilder().set("").toStructArray(Type.struct(Arrays.asList(Type.StructField.of((String)"C1", (Type)Type.string()), Type.StructField.of((String)"C2", (Type)Type.int64()))), Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("C1").to("a")).set("C2").to(1L)).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("C1").to("b")).set("C2").to(2L)).build()))).build();
        Truth.assertThat((Object)row).isEqualTo((Object)expectedRow);
    }

    @Test
    public void arrayOfStructEmpty() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Type structType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.string()), Type.StructField.of((String)"", (Type)Type.int64())});
        Struct row = this.execute(Statement.of((String)"SELECT ARRAY(SELECT AS STRUCT * FROM (SELECT 'a', 1) WHERE 0 = 1)"), Type.array((Type)structType));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        List value = row.getStructList(0);
        Truth.assertThat((Integer)value.size()).isEqualTo((Object)0);
    }

    @Ignore
    @Test
    public void arrayOfStructNull() {
        Type structType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.string()), Type.StructField.of((String)"", (Type)Type.int64())});
        Struct row = this.execute(Statement.of((String)"SELECT CAST (NULL AS ARRAY<STRUCT<string,int64>>)"), Type.array((Type)structType));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Ignore
    @Test
    public void arrayOfStructNullElement() {
        Type structType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.string()), Type.StructField.of((String)"", (Type)Type.int64())});
        Struct row = this.execute(Statement.of((String)"SELECT ARRAY(SELECT AS STRUCT 'a', 1 UNION ALL SELECT CAST (NULL AS STRUCT<string,int64>))"), Type.array((Type)structType));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        List value = row.getStructList(0);
        Truth.assertThat((Integer)value.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((Struct)value.get(0)).getType()).isEqualTo((Object)structType);
        Truth.assertThat((String)((Struct)value.get(0)).getString(0)).isEqualTo((Object)"a");
        Truth.assertThat((Long)((Struct)value.get(0)).getLong(1)).isEqualTo((Object)1);
        Truth.assertThat(value.get(1)).isNull();
    }

    @Test
    public void bindBool() {
        Struct row = this.execute(((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(true)).build(), Type.bool());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Boolean)row.getBoolean(0)).isEqualTo((Object)true);
    }

    @Test
    public void bindBoolNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((Boolean)null), Type.bool());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindInt64() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(1234L), Type.int64());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1234);
    }

    @Test
    public void bindInt64Null() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((Long)null), Type.int64());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindFloat64() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(2.0), Type.float64());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Double)row.getDouble(0)).isWithin(0.0).of(2.0);
    }

    @Test
    public void bindFloat64Null() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((Double)null), Type.float64());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindString() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to("abc"), Type.string());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"abc");
    }

    @Test
    public void bindStringNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((String)null), Type.string());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindJson() {
        Assume.assumeFalse((String)"JSON are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(Value.json((String)"{\"rating\":9,\"open\":true}")), Type.json());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getJson(0)).isEqualTo((Object)"{\"open\":true,\"rating\":9}");
    }

    @Test
    public void bindJsonEmpty() {
        Assume.assumeFalse((String)"JSON are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(Value.json((String)"{}")), Type.json());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((String)row.getJson(0)).isEqualTo((Object)"{}");
    }

    @Test
    public void bindJsonNull() {
        Assume.assumeFalse((String)"JSON is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(Value.json(null)), Type.json());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindBytes() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(ByteArray.copyFrom((String)"xyz")), Type.bytes());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytes(0)).isEqualTo((Object)ByteArray.copyFrom((String)"xyz"));
    }

    @Test
    public void bindBytesNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((ByteArray)null), Type.bytes());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindTimestamp() {
        Timestamp t = Timestamp.parseTimestamp((String)"2016-09-18T00:00:00Z");
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(t), Type.timestamp());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Comparable)row.getTimestamp(0)).isEqualTo((Object)t);
    }

    @Test
    public void bindTimestampNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((Timestamp)null), Type.timestamp());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindDate() {
        Assume.assumeFalse((String)"date type is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Date d = Date.parseDate((String)"2016-09-18");
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(d), Type.date());
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Comparable)row.getDate(0)).isEqualTo((Object)d);
    }

    @Test
    public void bindDateNull() {
        Assume.assumeFalse((String)"date type is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to((Date)null), Type.date());
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindNumeric() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        BigDecimal b = new BigDecimal("1.1");
        Statement.Builder statement = Statement.newBuilder((String)this.selectValueQuery);
        Type expectedType = Type.numeric();
        BigDecimal expectedValue = b;
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            expectedType = Type.pgNumeric();
            expectedValue = Value.pgNumeric((String)b.toString());
            statement.bind("p1").to(Value.pgNumeric((String)b.toString()));
        } else {
            statement.bind("p1").to(b);
        }
        Struct row = this.execute(statement, expectedType);
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Object got = this.dialect.dialect == Dialect.POSTGRESQL ? row.getValue(0) : row.getBigDecimal(0);
        Truth.assertThat((Object)got).isEqualTo((Object)expectedValue);
    }

    @Test
    public void bindNumericNull() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Statement.Builder statement = Statement.newBuilder((String)this.selectValueQuery);
        Type expectedType = Type.numeric();
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            expectedType = Type.pgNumeric();
            statement.bind("p1").to(Value.pgNumeric(null));
        } else {
            statement.bind("p1").to((BigDecimal)null);
        }
        Struct row = this.execute(statement, expectedType);
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindNumeric_doesNotPreservePrecision() {
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        BigDecimal b = new BigDecimal("1.10");
        Statement.Builder statement = Statement.newBuilder((String)this.selectValueQuery);
        Type expectedType = Type.numeric();
        BigDecimal expectedValue = b.stripTrailingZeros();
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            expectedType = Type.pgNumeric();
            expectedValue = Value.pgNumeric((String)b.toString());
            statement.bind("p1").to(Value.pgNumeric((String)b.toString()));
        } else {
            statement.bind("p1").to(b);
        }
        Struct row = this.execute(statement, expectedType);
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Object got = this.dialect.dialect == Dialect.POSTGRESQL ? row.getValue(0) : row.getBigDecimal(0);
        Truth.assertThat((Object)got).isNotEqualTo((Object)b);
        Truth.assertThat((Object)got).isEqualTo((Object)expectedValue);
    }

    @Test
    public void bindBoolArray() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toBoolArray(Arrays.asList(true, null, false)), Type.array((Type)Type.bool()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBooleanList(0)).containsExactly(new Object[]{true, null, false}).inOrder();
    }

    @Test
    public void bindBoolArrayEmpty() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toBoolArray(Collections.emptyList()), Type.array((Type)Type.bool()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBooleanList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindBoolArrayNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toBoolArray((boolean[])null), Type.array((Type)Type.bool()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindInt64Array() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toInt64Array(Arrays.asList(null, 1L, 2L)), Type.array((Type)Type.int64()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getLongList(0)).containsExactly(new Object[]{null, 1L, 2L}).inOrder();
    }

    @Test
    public void bindInt64ArrayEmpty() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toInt64Array(Collections.emptyList()), Type.array((Type)Type.int64()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getLongList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindInt64ArrayNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toInt64Array((long[])null), Type.array((Type)Type.int64()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindFloat64Array() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toFloat64Array(Arrays.asList(null, 1.0, 2.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN)), Type.array((Type)Type.float64()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDoubleList(0)).containsExactly(new Object[]{null, 1.0, 2.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN}).inOrder();
    }

    @Test
    public void bindFloat64ArrayEmpty() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toFloat64Array(Collections.emptyList()), Type.array((Type)Type.float64()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDoubleList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindFloat64ArrayNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toFloat64Array((double[])null), Type.array((Type)Type.float64()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindStringArray() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toStringArray(Arrays.asList("a", "b", null)), Type.array((Type)Type.string()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[]{"a", "b", null}).inOrder();
    }

    @Test
    public void bindStringArrayEmpty() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toStringArray(Collections.emptyList()), Type.array((Type)Type.string()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getStringList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindStringArrayNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toStringArray(null), Type.array((Type)Type.string()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindJsonArray() {
        Assume.assumeFalse((String)"array JSON binding is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toJsonArray(Arrays.asList("{}", "[]", "{\"rating\":9,\"open\":true}", null)), Type.array((Type)Type.json()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getJsonList(0)).containsExactly(new Object[]{"{}", "[]", "{\"open\":true,\"rating\":9}", null}).inOrder();
    }

    @Test
    public void bindJsonArrayEmpty() {
        Assume.assumeFalse((String)"JSON is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toJsonArray(Collections.emptyList()), Type.array((Type)Type.json()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getJsonList(0)).isEqualTo(Collections.emptyList());
    }

    @Test
    public void bindJsonArrayNull() {
        Assume.assumeFalse((String)"JSON is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support JSON", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toJsonArray(null), Type.array((Type)Type.json()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindBytesArray() {
        ByteArray e1 = ByteArray.copyFrom((String)"x");
        ByteArray e2 = ByteArray.copyFrom((String)"y");
        Object e3 = null;
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toBytesArray(Arrays.asList(e1, e2, e3)), Type.array((Type)Type.bytes()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytesList(0)).containsExactly(new Object[]{e1, e2, e3}).inOrder();
    }

    @Test
    public void bindBytesArrayEmpty() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toBytesArray(Collections.emptyList()), Type.array((Type)Type.bytes()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBytesList(0)).isEmpty();
    }

    @Test
    public void bindBytesArrayNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toBytesArray(null), Type.array((Type)Type.bytes()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindTimestampArray() {
        Timestamp t1 = Timestamp.parseTimestamp((String)"2016-09-18T00:00:00Z");
        Timestamp t2 = Timestamp.parseTimestamp((String)"2016-09-19T00:00:00Z");
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toTimestampArray(Arrays.asList(t1, t2, null)), Type.array((Type)Type.timestamp()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getTimestampList(0)).containsExactly(new Object[]{t1, t2, null}).inOrder();
    }

    @Test
    public void bindTimestampArrayEmpty() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toTimestampArray(Collections.emptyList()), Type.array((Type)Type.timestamp()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getTimestampList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindTimestampArrayNull() {
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toTimestampArray(null), Type.array((Type)Type.timestamp()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindDateArray() {
        Assume.assumeFalse((String)"date type is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Date d1 = Date.parseDate((String)"2016-09-18");
        Date d2 = Date.parseDate((String)"2016-09-19");
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)"SELECT @v").bind("v").toDateArray(Arrays.asList(d1, d2, null)), Type.array((Type)Type.date()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDateList(0)).containsExactly(new Object[]{d1, d2, null}).inOrder();
    }

    @Test
    public void bindDateArrayEmpty() {
        Assume.assumeFalse((String)"date type is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)"SELECT @v").bind("v").toDateArray(Collections.emptyList()), Type.array((Type)Type.date()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getDateList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindDateArrayNull() {
        Assume.assumeFalse((String)"date type is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)"SELECT @v").bind("v").toDateArray(null), Type.array((Type)Type.date()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindNumericArray() {
        Assume.assumeFalse((String)"array numeric binding is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        BigDecimal b1 = new BigDecimal("3.14");
        BigDecimal b2 = new BigDecimal("6.626");
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toNumericArray(Arrays.asList(b1, b2, null)), Type.array((Type)Type.numeric()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBigDecimalList(0)).containsExactly(new Object[]{b1, b2, null}).inOrder();
    }

    @Test
    public void bindNumericArrayEmpty() {
        Assume.assumeFalse((String)"array numeric binding is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toNumericArray(Collections.emptyList()), Type.array((Type)Type.numeric()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBigDecimalList(0)).containsExactly(new Object[0]);
    }

    @Test
    public void bindNumericArrayNull() {
        Assume.assumeFalse((String)"array numeric binding is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").toNumericArray(null), Type.array((Type)Type.numeric()));
        Truth.assertThat((Boolean)row.isNull(0)).isTrue();
    }

    @Test
    public void bindNumericArray_doesNotPreservePrecision() {
        Assume.assumeFalse((String)"array numeric binding is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator does not yet support NUMERIC", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        BigDecimal b1 = new BigDecimal("3.14");
        BigDecimal b2 = new BigDecimal("6.626070");
        Struct row = this.execute((Statement.Builder)Statement.newBuilder((String)"SELECT @v").bind("v").toNumericArray(Arrays.asList(b1, b2, null)), Type.array((Type)Type.numeric()));
        Truth.assertThat((Boolean)row.isNull(0)).isFalse();
        Truth.assertThat((Iterable)row.getBigDecimalList(0)).containsExactly(new Object[]{b1.stripTrailingZeros(), b2.stripTrailingZeros(), null}).inOrder();
    }

    @Test
    public void unsupportedSelectStructValue() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"The emulator accepts this query", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct p = this.structValue();
        try {
            this.execute(((Statement.Builder)Statement.newBuilder((String)this.selectValueQuery).bind("p1").to(p)).build(), p.getType());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.UNIMPLEMENTED);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Unsupported query shape: A struct value cannot be returned as a column value.");
        }
    }

    @Test
    public void unsupportedSelectArrayStructValue() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Assume.assumeFalse((String)"Emulator evaluates this expression differently than Cloud Spanner", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Struct p = this.structValue();
        try {
            this.execute(((Statement.Builder)Statement.newBuilder((String)"SELECT @p").bind("p").toStructArray(p.getType(), Collections.singletonList(p))).build(), p.getType());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.UNIMPLEMENTED);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Unsupported query shape: This query can return a null-valued array of struct, which is not supported by Spanner.");
        }
    }

    @Test
    public void invalidAmbiguousFieldAccess() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(20L)).set("f1").to("abc")).build();
        try {
            this.execute(((Statement.Builder)Statement.newBuilder((String)"SELECT @p.f1").bind("p").to(p)).build(), Type.int64());
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Struct field name f1 is ambiguous");
        }
    }

    private Struct structValue() {
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f_int").to(10L)).set("f_bool").to(false)).set("f_double").to(3.4)).set("f_timestamp").to(Timestamp.ofTimeMicroseconds((long)20L))).set("f_date").to(Date.fromYearMonthDay((int)1, (int)3, (int)1))).set("f_string").to("hello")).set("f_bytes").to(ByteArray.copyFrom((String)"bytes"))).build();
    }

    @Test
    public void bindStruct() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = this.structValue();
        String query = "SELECT @p.f_int,@p.f_bool,@p.f_double,@p.f_timestamp,@p.f_date,@p.f_string,@p.f_bytes";
        Struct row = this.executeWithRowResultType(((Statement.Builder)Statement.newBuilder((String)query).bind("p").to(p)).build(), p.getType());
        Truth.assertThat((Object)row).isEqualTo((Object)p);
    }

    @Test
    public void bindArrayOfStruct() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct arrayElement = this.structValue();
        List<Struct> p = Arrays.asList(arrayElement, null);
        List<Struct> rows = this.resultRows(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST(@p)").bind("p").toStructArray(arrayElement.getType(), p)).build(), arrayElement.getType());
        Truth.assertThat(rows).hasSize(p.size());
        Truth.assertThat((Object)rows.get(0)).isEqualTo((Object)p.get(0));
        Struct structElementFromNull = rows.get(1);
        for (int i = 0; i < arrayElement.getType().getStructFields().size(); ++i) {
            Truth.assertThat((Boolean)structElementFromNull.isNull(i)).isTrue();
        }
    }

    @Test
    public void bindStructNull() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute(((Statement.Builder)Statement.newBuilder((String)"SELECT @p IS NULL").bind("p").to(Type.struct(Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.float64()))), null)).build(), Type.bool());
        Truth.assertThat((Boolean)row.getBoolean(0)).isTrue();
    }

    @Test
    public void bindArrayOfStructNull() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Type elementType = Type.struct(Arrays.asList(Type.StructField.of((String)"f1", (Type)Type.string()), Type.StructField.of((String)"f2", (Type)Type.float64())));
        Struct row = this.execute(((Statement.Builder)Statement.newBuilder((String)"SELECT @p IS NULL").bind("p").toStructArray(elementType, null)).build(), Type.bool());
        Truth.assertThat((Boolean)row.getBoolean(0)).isTrue();
    }

    @Test
    public void bindEmptyStruct() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = Struct.newBuilder().build();
        Struct row = this.execute(((Statement.Builder)Statement.newBuilder((String)"SELECT @p IS NULL").bind("p").to(p)).build(), Type.bool());
        Truth.assertThat((Boolean)row.getBoolean(0)).isFalse();
    }

    @Test
    public void bindStructWithUnnamedFields() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = Struct.newBuilder().add(Value.int64((long)1337L)).add(Value.int64((long)7331L)).build();
        Struct row = this.executeWithRowResultType(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST([@p])").bind("p").to(p)).build(), p.getType());
        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1337);
        Truth.assertThat((Long)row.getLong(1)).isEqualTo((Object)7331);
    }

    @Test
    public void bindStructWithDuplicateFieldNames() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f1").to(Value.int64((long)1337L))).set("f1").to(Value.string((String)"1337"))).build();
        Struct row = this.executeWithRowResultType(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST([@p])").bind("p").to(p)).build(), p.getType());
        Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1337);
        Truth.assertThat((String)row.getString(1)).isEqualTo((Object)"1337");
    }

    @Test
    public void bindEmptyArrayOfStruct() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Type elementType = Type.struct(Collections.singletonList(Type.StructField.of((String)"f1", (Type)Type.date())));
        List p = Collections.emptyList();
        Truth.assertThat(p).isEmpty();
        List<Struct> rows = this.resultRows(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST(@p)").bind("p").toStructArray(elementType, p)).build(), elementType);
        Truth.assertThat(rows).isEmpty();
    }

    @Test
    public void bindStructWithNullStructField() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Type emptyStructType = Type.struct(new ArrayList());
        Struct p = ((Struct.Builder)Struct.newBuilder().set("f1").to(emptyStructType, null)).build();
        Struct row = this.execute(((Statement.Builder)Statement.newBuilder((String)"SELECT @p.f1 IS NULL").bind("p").to(p)).build(), Type.bool());
        Truth.assertThat((Boolean)row.getBoolean(0)).isTrue();
    }

    @Test
    public void bindStructWithBoolArrayFieldThatContainsNulls() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = ((Struct.Builder)Struct.newBuilder().set("boolArray").to(Value.boolArray(Arrays.asList(true, false, null)))).build();
        List<Struct> rows = this.resultRows(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST(@p.boolArray) ORDER BY 1").bind("p").to(p)).build(), Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.bool())}));
        Assert.assertTrue((boolean)rows.get(0).isNull(0));
        Assert.assertFalse((boolean)rows.get(1).getBoolean(0));
        Assert.assertTrue((boolean)rows.get(2).getBoolean(0));
    }

    @Test
    public void bindStructWithInt64ArrayFieldThatContainsNulls() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = ((Struct.Builder)Struct.newBuilder().set("int64Array").to(Value.int64Array(Arrays.asList(1L, 100L, null)))).build();
        List<Struct> rows = this.resultRows(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST(@p.int64Array) ORDER BY 1").bind("p").to(p)).build(), Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.int64())}));
        Assert.assertTrue((boolean)rows.get(0).isNull(0));
        Assert.assertEquals((long)1L, (long)rows.get(1).getLong(0));
        Assert.assertEquals((long)100L, (long)rows.get(2).getLong(0));
    }

    @Test
    public void bindStructWithFloat64ArrayFieldThatContainsNulls() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct p = ((Struct.Builder)Struct.newBuilder().set("float64Array").to(Value.float64Array(Arrays.asList(1.0, 3.14, null)))).build();
        List<Struct> rows = this.resultRows(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST(@p.float64Array) ORDER BY 1").bind("p").to(p)).build(), Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)Type.float64())}));
        Assert.assertTrue((boolean)rows.get(0).isNull(0));
        Assert.assertEquals((double)1.0, (double)rows.get(1).getDouble(0), (double)0.0);
        Assert.assertEquals((double)3.14, (double)rows.get(2).getDouble(0), (double)0.0);
    }

    @Test
    public void bindStructWithStructField() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct nestedStruct = ((Struct.Builder)Struct.newBuilder().set("ff1").to("abc")).build();
        Struct p = ((Struct.Builder)Struct.newBuilder().set("f1").to(nestedStruct)).build();
        Struct row = this.executeWithRowResultType(((Statement.Builder)Statement.newBuilder((String)"SELECT @p.f1.ff1").bind("p").to(p)).build(), nestedStruct.getType());
        Truth.assertThat((String)row.getString(0)).isEqualTo((Object)"abc");
    }

    @Test
    public void bindStructWithArrayOfStructField() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct arrayElement1 = ((Struct.Builder)Struct.newBuilder().set("ff1").to("abc")).build();
        Struct arrayElement2 = ((Struct.Builder)Struct.newBuilder().set("ff1").to("def")).build();
        Struct p = ((Struct.Builder)Struct.newBuilder().set("f1").toStructArray(arrayElement1.getType(), Arrays.asList(arrayElement1, arrayElement2))).build();
        List<Struct> rows = this.resultRows(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM UNNEST(@p.f1)").bind("p").to(p)).build(), arrayElement1.getType());
        Truth.assertThat((String)rows.get(0).getString(0)).isEqualTo((Object)"abc");
        Truth.assertThat((String)rows.get(1).getString(0)).isEqualTo((Object)"def");
    }

    @Test
    public void unboundParameter() {
        String query = "SELECT @v";
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            query = "SELECT $1";
        }
        ResultSet resultSet = Statement.of((String)query).executeQuery(this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()), new Options.QueryOption[0]);
        try {
            resultSet.next();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
    }

    @Test
    public void positiveInfinity() {
        Assume.assumeFalse((String)"function ieee_divide not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute(Statement.newBuilder((String)"SELECT IEEE_DIVIDE(1, 0)"), Type.float64());
        Truth.assertThat((Double)row.getDouble(0)).isPositiveInfinity();
    }

    @Test
    public void negativeInfinity() {
        Assume.assumeFalse((String)"function ieee_divide not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute(Statement.newBuilder((String)"SELECT IEEE_DIVIDE(-1, 0)"), Type.float64());
        Truth.assertThat((Double)row.getDouble(0)).isNegativeInfinity();
    }

    @Test
    public void notANumber() {
        Assume.assumeFalse((String)"function ieee_divide not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute(Statement.newBuilder((String)"SELECT IEEE_DIVIDE(0, 0)"), Type.float64());
        Truth.assertThat((Double)row.getDouble(0)).isNaN();
    }

    @Test
    public void nonNumberArray() {
        Assume.assumeFalse((String)"function ieee_divide not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        Struct row = this.execute(Statement.newBuilder((String)"SELECT [IEEE_DIVIDE(1, 0), IEEE_DIVIDE(-1, 0), IEEE_DIVIDE(0, 0)]"), Type.array((Type)Type.float64()));
        Truth.assertThat((Iterable)row.getDoubleList(0)).hasSize(3);
        Truth.assertThat((Double)((Double)row.getDoubleList(0).get(0))).isPositiveInfinity();
        Truth.assertThat((Double)((Double)row.getDoubleList(0).get(1))).isNegativeInfinity();
        Truth.assertThat((Double)((Double)row.getDoubleList(0).get(2))).isNaN();
    }

    @Test
    public void largeErrorText() {
        Assume.assumeFalse((String)"regexp_contains is not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        String veryLongString = Joiner.on((String)"").join(Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{"x"}), (int)8000));
        Statement statement = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT REGEXP_CONTAINS(@value, @regexp)").bind("value").to("")).bind("regexp").to("(" + veryLongString)).build();
        ResultSet resultSet = statement.executeQuery(this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()), new Options.QueryOption[0]);
        try {
            resultSet.next();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.OUT_OF_RANGE);
            Truth.assertThat((String)ex.getMessage()).contains((CharSequence)"Cannot parse regular expression");
        }
    }

    @Test
    public void queryRealTable() {
        Database populatedDb = this.dialect.dialect == Dialect.POSTGRESQL ? env.getTestHelper().createTestDatabase(this.dialect.dialect, Arrays.asList("CREATE TABLE T ( K VARCHAR PRIMARY KEY, V VARCHAR )")) : env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T ( K STRING(MAX) NOT NULL, V STRING(MAX) ) PRIMARY KEY (K)"});
        DatabaseClient client = env.getTestHelper().getDatabaseClient(populatedDb);
        client.writeAtLeastOnce(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("k1")).set("V").to("v1")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("k2")).set("V").to("v2")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("k3")).set("V").to("v3")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("K").to("k4")).set("V").to("v4")).build()));
        String query = "SELECT k, v FROM T WHERE k >= @p1 AND k < @p2 ORDER BY K ASC";
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            query = "SELECT k, v FROM T WHERE k >= $1 AND k < $2 ORDER BY K ASC";
        }
        Statement statement = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)query).bind("p1").to("k13")).bind("p2").to("k32")).build();
        ResultSet resultSet = statement.executeQuery(client.singleUse(TimestampBound.strong()), new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"k", (Type)Type.string()), Type.StructField.of((String)"v", (Type)Type.string())}));
        Truth.assertThat((String)resultSet.getString(0)).isEqualTo((Object)"k2");
        Truth.assertThat((String)resultSet.getString(1)).isEqualTo((Object)"v2");
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((String)resultSet.getString("k")).isEqualTo((Object)"k3");
        Truth.assertThat((String)resultSet.getString("v")).isEqualTo((Object)"v3");
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
    }

    @Test
    public void analyzePlan() {
        Assume.assumeFalse((String)"Emulator does not support Analyze Plan", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Statement statement = Statement.of((String)"SELECT 1 AS data UNION ALL SELECT 2");
        ResultSet resultSet = statement.analyzeQuery(this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()), ReadContext.QueryAnalyzeMode.PLAN);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"data", (Type)Type.int64())}));
        ResultSetStats receivedStats = resultSet.getStats();
        Truth.assertThat((Object)receivedStats).isNotNull();
        Truth.assertThat((Boolean)receivedStats.hasQueryPlan()).isTrue();
        Truth.assertThat((Boolean)receivedStats.hasQueryStats()).isFalse();
    }

    @Test
    public void analyzeProfile() {
        Assume.assumeFalse((String)"Emulator does not support Analyze Profile", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        String query = "SELECT 1 AS data UNION ALL SELECT 2 AS data ORDER BY data";
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            query = "SELECT 1 AS data UNION ALL SELECT 2 AS data";
        }
        Statement statement = Statement.of((String)query);
        ResultSet resultSet = statement.analyzeQuery(this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()), ReadContext.QueryAnalyzeMode.PROFILE);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"data", (Type)Type.int64())}));
        Truth.assertThat((Long)resultSet.getLong(0)).isEqualTo((Object)1);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((Long)resultSet.getLong(0)).isEqualTo((Object)2);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        ResultSetStats receivedStats = resultSet.getStats();
        Truth.assertThat((Object)receivedStats).isNotNull();
        Truth.assertThat((Boolean)receivedStats.hasQueryPlan()).isTrue();
        Truth.assertThat((Boolean)receivedStats.hasQueryStats()).isTrue();
    }

    @Test
    public void testSelectArrayOfStructs() {
        Assume.assumeFalse((String)"structs are not supported on POSTGRESQL", (this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        try (ResultSet resultSet = this.getClient(this.dialect.dialect).singleUse().executeQuery(Statement.of((String)"WITH points AS\n  (SELECT [1, 5] as point\n   UNION ALL SELECT [2, 8] as point\n   UNION ALL SELECT [3, 7] as point\n   UNION ALL SELECT [4, 1] as point\n   UNION ALL SELECT [5, 7] as point)\nSELECT ARRAY(\n  SELECT STRUCT(point)\n  FROM points)\n  AS coordinates"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)resultSet.getColumnCount(), (long)1L);
            Truth.assertThat((Iterable)resultSet.getStructList(0)).containsExactly(new Object[]{((Struct.Builder)Struct.newBuilder().set("point").to(Value.int64Array((long[])new long[]{1L, 5L}))).build(), ((Struct.Builder)Struct.newBuilder().set("point").to(Value.int64Array((long[])new long[]{2L, 8L}))).build(), ((Struct.Builder)Struct.newBuilder().set("point").to(Value.int64Array((long[])new long[]{3L, 7L}))).build(), ((Struct.Builder)Struct.newBuilder().set("point").to(Value.int64Array((long[])new long[]{4L, 1L}))).build(), ((Struct.Builder)Struct.newBuilder().set("point").to(Value.int64Array((long[])new long[]{5L, 7L}))).build()});
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    private List<Struct> resultRows(Statement statement, Type expectedRowType) {
        ArrayList<Struct> results = new ArrayList<Struct>();
        ResultSet resultSet = statement.executeQuery(this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()), new Options.QueryOption[0]);
        while (resultSet.next()) {
            Struct row = resultSet.getCurrentRowAsStruct();
            results.add(row);
        }
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)expectedRowType);
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        return results;
    }

    private Struct executeWithRowResultType(Statement statement, Type expectedRowType) {
        ResultSet resultSet = statement.executeQuery(this.getClient(this.dialect.dialect).singleUse(TimestampBound.strong()), new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
        Truth.assertThat((Object)resultSet.getType()).isEqualTo((Object)expectedRowType);
        Struct row = resultSet.getCurrentRowAsStruct();
        Truth.assertThat((Boolean)resultSet.next()).isFalse();
        return row;
    }

    private Struct execute(Statement statement, Type expectedColumnType) {
        Type rowType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"", (Type)expectedColumnType)});
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            rowType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"?column?", (Type)expectedColumnType)});
        }
        return this.executeWithRowResultType(statement, rowType);
    }

    private Struct execute(Statement.Builder builder, Type expectedColumnType) {
        return this.execute(builder.build(), expectedColumnType);
    }
}

