/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpcViews;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.opencensus.common.Function;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GfeLatencyTest {
    private static final String STATIC_OAUTH_TOKEN = "STATIC_TEST_OAUTH_TOKEN";
    private static final String VARIABLE_OAUTH_TOKEN = "VARIABLE_TEST_OAUTH_TOKEN";
    private static final OAuth2Credentials STATIC_CREDENTIALS = OAuth2Credentials.create((AccessToken)new AccessToken("STATIC_TEST_OAUTH_TOKEN", new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS))));
    private static final OAuth2Credentials VARIABLE_CREDENTIALS = OAuth2Credentials.create((AccessToken)new AccessToken("VARIABLE_TEST_OAUTH_TOKEN", new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS))));
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private static Spanner spanner;
    private static DatabaseClient databaseClient;
    private static final Map<SpannerRpc.Option, Object> optionsMap;
    private static MockSpannerServiceImpl mockSpannerNoHeader;
    private static Server serverNoHeader;
    private static InetSocketAddress addressNoHeader;
    private static Spanner spannerNoHeader;
    private static DatabaseClient databaseClientNoHeader;
    private static String instanceId;
    private static String databaseId;
    private static String projectId;
    private static final long WAIT_FOR_METRICS_TIME_MS = 1000L;
    private static final int MAXIMUM_RETRIES = 5;
    private static AtomicInteger fakeServerTiming;
    private static final Statement SELECT1AND2;
    private static final ResultSetMetadata SELECT1AND2_METADATA;
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET;
    private static final Statement UPDATE_FOO_STATEMENT;

    @BeforeClass
    public static void startServer() throws IOException {
        SpannerRpcViews.registerGfeLatencyAndHeaderMissingCountViews();
        Assume.assumeFalse((boolean)EmulatorSpannerHelper.isUsingEmulator());
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_FOO_STATEMENT, 1L));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata headers) {
                        headers.put(Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.format("gfet4t7; dur=%d", fakeServerTiming.get()));
                        super.sendHeaders(headers);
                    }
                }, headers);
            }
        })).build().start();
        optionsMap.put(SpannerRpc.Option.CHANNEL_HINT, 1L);
        spanner = (Spanner)GfeLatencyTest.createSpannerOptions(address, server).getService();
        databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
        mockSpannerNoHeader = new MockSpannerServiceImpl();
        mockSpannerNoHeader.setAbortProbability(0.0);
        mockSpannerNoHeader.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpannerNoHeader.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_FOO_STATEMENT, 1L));
        addressNoHeader = new InetSocketAddress("localhost", 0);
        serverNoHeader = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)addressNoHeader).addService((BindableService)mockSpannerNoHeader)).build().start();
        spannerNoHeader = (Spanner)GfeLatencyTest.createSpannerOptions(addressNoHeader, serverNoHeader).getService();
        databaseClientNoHeader = spannerNoHeader.getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        if (spanner != null) {
            spanner.close();
            server.shutdown();
            server.awaitTermination();
        }
        if (spannerNoHeader != null) {
            spannerNoHeader.close();
            serverNoHeader.shutdown();
            serverNoHeader.awaitTermination();
        }
    }

    @After
    public void reset() {
        mockSpanner.reset();
        mockSpannerNoHeader.reset();
    }

    @Test
    public void testGfeLatencyExecuteStreamingSql() throws InterruptedException {
        try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            rs.next();
        }
        long latency = this.getMetric(SpannerRpcViews.SPANNER_GFE_LATENCY_VIEW, projectId, instanceId, databaseId, "google.spanner.v1.Spanner/ExecuteStreamingSql", false);
        Assert.assertEquals((long)fakeServerTiming.get(), (long)latency);
    }

    @Test
    public void testGfeLatencyExecuteSql() throws InterruptedException {
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        long latency = this.getMetric(SpannerRpcViews.SPANNER_GFE_LATENCY_VIEW, projectId, instanceId, databaseId, "google.spanner.v1.Spanner/ExecuteSql", false);
        Assert.assertEquals((long)fakeServerTiming.get(), (long)latency);
    }

    @Test
    public void testGfeMissingHeaderCountExecuteStreamingSql() throws InterruptedException {
        try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            rs.next();
        }
        long count = this.getMetric(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT_VIEW, projectId, instanceId, databaseId, "google.spanner.v1.Spanner/ExecuteStreamingSql", false);
        Assert.assertEquals((long)0L, (long)count);
        try (ResultSet rs = databaseClientNoHeader.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            rs.next();
        }
        long count1 = this.getMetric(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT_VIEW, projectId, instanceId, databaseId, "google.spanner.v1.Spanner/ExecuteStreamingSql", true);
        Assert.assertEquals((long)1L, (long)count1);
    }

    @Test
    public void testGfeMissingHeaderExecuteSql() throws InterruptedException {
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        long count = this.getMetric(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT_VIEW, projectId, instanceId, databaseId, "google.spanner.v1.Spanner/ExecuteSql", false);
        Assert.assertEquals((long)0L, (long)count);
        databaseClientNoHeader.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        long count1 = this.getMetric(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT_VIEW, projectId, instanceId, databaseId, "google.spanner.v1.Spanner/ExecuteSql", true);
        Assert.assertEquals((long)1L, (long)count1);
    }

    private static SpannerOptions createSpannerOptions(InetSocketAddress address, Server server) {
        String endpoint = address.getHostString() + ":" + server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setHost("http://" + endpoint).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(() -> MoreCallCredentials.from((Credentials)VARIABLE_CREDENTIALS)).build();
    }

    private long getAggregationValueAsLong(AggregationData aggregationData) {
        return (Long)aggregationData.match((Function)new Function<AggregationData.SumDataDouble, Long>(){

            public Long apply(AggregationData.SumDataDouble arg) {
                return (long)arg.getSum();
            }
        }, (Function)new Function<AggregationData.SumDataLong, Long>(){

            public Long apply(AggregationData.SumDataLong arg) {
                return arg.getSum();
            }
        }, (Function)new Function<AggregationData.CountData, Long>(){

            public Long apply(AggregationData.CountData arg) {
                return arg.getCount();
            }
        }, (Function)new Function<AggregationData.DistributionData, Long>(){

            public Long apply(AggregationData.DistributionData arg) {
                return (long)arg.getMean();
            }
        }, (Function)new Function<AggregationData.LastValueDataDouble, Long>(){

            public Long apply(AggregationData.LastValueDataDouble arg) {
                return (long)arg.getLastValue();
            }
        }, (Function)new Function<AggregationData.LastValueDataLong, Long>(){

            public Long apply(AggregationData.LastValueDataLong arg) {
                return arg.getLastValue();
            }
        }, (Function)new Function<AggregationData, Long>(){

            public Long apply(AggregationData arg) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private long getMetric(View view, String projectId, String instanceId, String databaseId, String method, boolean withOverride) throws InterruptedException {
        ArrayList<TagValue> tagValues = new ArrayList<TagValue>();
        for (TagKey column : view.getColumns()) {
            if (column == SpannerRpcViews.INSTANCE_ID) {
                tagValues.add(TagValue.create((String)instanceId));
                continue;
            }
            if (column == SpannerRpcViews.DATABASE_ID) {
                tagValues.add(TagValue.create((String)databaseId));
                continue;
            }
            if (column == SpannerRpcViews.METHOD) {
                tagValues.add(TagValue.create((String)method));
                continue;
            }
            if (column != SpannerRpcViews.PROJECT_ID) continue;
            tagValues.add(TagValue.create((String)projectId));
        }
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            ViewData viewData = SpannerRpcViews.viewManager.getView(view.getName());
            if (viewData.getAggregationMap() == null) continue;
            Map aggregationMap = viewData.getAggregationMap();
            AggregationData aggregationData = (AggregationData)aggregationMap.get(tagValues);
            if (withOverride && this.getAggregationValueAsLong(aggregationData) == 0L) continue;
            return this.getAggregationValueAsLong(aggregationData);
        }
        return -1L;
    }

    static {
        optionsMap = new HashMap<SpannerRpc.Option, Object>();
        instanceId = "fake-instance";
        databaseId = "fake-database";
        projectId = "fake-project";
        fakeServerTiming = new AtomicInteger(new Random().nextInt(1000) + 1);
        SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
        SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
        UPDATE_FOO_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    }
}

