/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

-- Test valid values for strong
SET READ_ONLY_STALENESS='strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET READ_ONLY_STALENESS='STRONG';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET READ_ONLY_STALENESS='Strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET READ_ONLY_STALENESS = 'strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET READ_ONLY_STALENESS		=		'strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET READ_ONLY_STALENESS
=
'strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET		READ_ONLY_STALENESS='strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;
SET READ_ONLY_STALENESS='strong';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','STRONG'
SHOW VARIABLE READ_ONLY_STALENESS;

-- Test invalid values for strong
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='strongg';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='sstrong';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='strng';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' strong';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='strong ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' strong ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	strong';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='strong		';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	strong	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=strong;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS="strong";
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=`strong`;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='''strong''';


-- Test valid values for min_read_timestamp
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='Min_Read_Timestamp 2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='MIN_READ_TIMESTAMP 2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp    2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp		2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2000-02-29T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2000-02-29T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2004-02-29T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2004-02-29T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2019-01-01T00:00:00Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2019-01-01T00:00:00Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp  2019-01-01T00:00:00Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2019-01-01T00:00:00Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp		2019-01-01T00:00:00Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2019-01-01T00:00:00Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+01:00';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T12:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01-01:00';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T14:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+06:30';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-07T07:06:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+24:00';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MIN_READ_TIMESTAMP 2018-12-06T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;


-- Test invalid values for min_read_timestamp
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestampp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='mmin_read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_red_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min read timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min-read-timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min%read%timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' min_read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01Z ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' min_read_timestamp 2018-12-07T13:36:00.01Z ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	min_read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01Z	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	min_read_timestamp 2018-12-07T13:36:00.01Z	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=min_read_timestamp 2018-12-07T13:36:00.01Z;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS="min_read_timestamp 2018-12-07T13:36:00.01Z";
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=`min_read_timestamp 2018-12-07T13:36:00.01Z`;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='''min_read_timestamp 2018-12-07T13:36:00.01Z''';

@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07 13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T3:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.9999999999Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-7T13:36:00.01Z';

@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+8';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+08';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+08:0';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.0108:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+08:00.0';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+08:000';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01+100:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01*08:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01%08:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01 08:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='min_read_timestamp 2018-12-07T13:36:00.01Z+08:00';




-- Test valid values for read_timestamp
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='Read_Timestamp 2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='READ_TIMESTAMP 2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp    2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp		2018-12-07T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2000-02-29T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2000-02-29T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2004-02-29T13:36:00.01Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2004-02-29T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2019-01-01T00:00:00Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2019-01-01T00:00:00Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp  2019-01-01T00:00:00Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2019-01-01T00:00:00Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp		2019-01-01T00:00:00Z';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2019-01-01T00:00:00Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+01:00';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T12:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01-01:00';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T14:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+06:30';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-07T07:06:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+24:00';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','READ_TIMESTAMP 2018-12-06T13:36:00.010000000Z'
SHOW VARIABLE READ_ONLY_STALENESS;


-- Test invalid values for read_timestamp
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestampp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='mread_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='red_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read-timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read%timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01Z ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' read_timestamp 2018-12-07T13:36:00.01Z ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	read_timestamp 2018-12-07T13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01Z	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	read_timestamp 2018-12-07T13:36:00.01Z	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=read_timestamp 2018-12-07T13:36:00.01Z;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS="read_timestamp 2018-12-07T13:36:00.01Z";
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=`read_timestamp 2018-12-07T13:36:00.01Z`;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='''read_timestamp 2018-12-07T13:36:00.01Z''';

@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07 13:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T3:36:00.01Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.9999999999Z';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-7T13:36:00.01Z';

@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+8';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+08';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+08:0';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.0108:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+08:00.0';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+08:000';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01+100:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01*08:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01%08:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01 08:00';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='read_timestamp 2018-12-07T13:36:00.01Z+08:00';


-- Test valid values for exact_staleness
SET READ_ONLY_STALENESS='exact_staleness 10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='Exact_Staleness 10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='EXACT_STALENESS 10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness    10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness		10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1ns';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1ns'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1us';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1us'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1ms';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1ms'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 9999s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 9999s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness  10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness	10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1000ms';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1001ms';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1001ms'
SHOW VARIABLE READ_ONLY_STALENESS;


SET READ_ONLY_STALENESS='exact_staleness 1000us';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1ms'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1001us';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1001us'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1000ns';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1us'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='exact_staleness 1001ns';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','EXACT_STALENESS 1001ns'
SHOW VARIABLE READ_ONLY_STALENESS;


-- Test invalid values for exact_staleness
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_stalenesss 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='eexact_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exct_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact-staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact%staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' exact_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness 10s ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' exact_staleness 10s ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	exact_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness 10s	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	exact_staleness 10s	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=exact_staleness 10s;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS="exact_staleness 10s";
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=`exact_staleness 10s`;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='''exact_staleness 10s''';

@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness 10';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness 10mus';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness 999999999999s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness not_a_number';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='exact_staleness';



-- Test valid values for max_staleness
SET READ_ONLY_STALENESS='max_staleness 10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_Staleness 10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_STALENESS 10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness    10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness		10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1ns';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1ns'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1us';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1us'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1ms';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1ms'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 9999s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 9999s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness  10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness	10s';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 10s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1000ms';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1s'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1001ms';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1001ms'
SHOW VARIABLE READ_ONLY_STALENESS;


SET READ_ONLY_STALENESS='max_staleness 1000us';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1ms'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1001us';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1001us'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1000ns';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1us'
SHOW VARIABLE READ_ONLY_STALENESS;

SET READ_ONLY_STALENESS='max_staleness 1001ns';
@EXPECT RESULT_SET 'READ_ONLY_STALENESS','MAX_STALENESS 1001ns'
SHOW VARIABLE READ_ONLY_STALENESS;


-- Test invalid values for max_staleness
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_stalenesss 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='emax_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='mx_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max-staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max%staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' max_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness 10s ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=' max_staleness 10s ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	max_staleness 10s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness 10s	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='	max_staleness 10s	';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=max_staleness 10s;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS="max_staleness 10s";
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS=`max_staleness 10s`;
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='''max_staleness 10s''';

@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness 10';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness 10mus';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness 999999999999s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness not_a_number';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET READ_ONLY_STALENESS='max_staleness';

