/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Type
implements Serializable {
    private static final Type TYPE_BOOL = new Type(Code.BOOL, null, null);
    private static final Type TYPE_INT64 = new Type(Code.INT64, null, null);
    private static final Type TYPE_FLOAT64 = new Type(Code.FLOAT64, null, null);
    private static final Type TYPE_NUMERIC = new Type(Code.NUMERIC, null, null);
    private static final Type TYPE_PG_NUMERIC = new Type(Code.PG_NUMERIC, null, null);
    private static final Type TYPE_STRING = new Type(Code.STRING, null, null);
    private static final Type TYPE_JSON = new Type(Code.JSON, null, null);
    private static final Type TYPE_BYTES = new Type(Code.BYTES, null, null);
    private static final Type TYPE_TIMESTAMP = new Type(Code.TIMESTAMP, null, null);
    private static final Type TYPE_DATE = new Type(Code.DATE, null, null);
    private static final Type TYPE_ARRAY_BOOL = new Type(Code.ARRAY, TYPE_BOOL, null);
    private static final Type TYPE_ARRAY_INT64 = new Type(Code.ARRAY, TYPE_INT64, null);
    private static final Type TYPE_ARRAY_FLOAT64 = new Type(Code.ARRAY, TYPE_FLOAT64, null);
    private static final Type TYPE_ARRAY_NUMERIC = new Type(Code.ARRAY, TYPE_NUMERIC, null);
    private static final Type TYPE_ARRAY_PG_NUMERIC = new Type(Code.ARRAY, TYPE_PG_NUMERIC, null);
    private static final Type TYPE_ARRAY_STRING = new Type(Code.ARRAY, TYPE_STRING, null);
    private static final Type TYPE_ARRAY_JSON = new Type(Code.ARRAY, TYPE_JSON, null);
    private static final Type TYPE_ARRAY_BYTES = new Type(Code.ARRAY, TYPE_BYTES, null);
    private static final Type TYPE_ARRAY_TIMESTAMP = new Type(Code.ARRAY, TYPE_TIMESTAMP, null);
    private static final Type TYPE_ARRAY_DATE = new Type(Code.ARRAY, TYPE_DATE, null);
    private static final int AMBIGUOUS_FIELD = -1;
    private static final long serialVersionUID = -3076152125004114582L;
    private final Code code;
    private final Type arrayElementType;
    private final ImmutableList<StructField> structFields;
    private Map<String, Integer> fieldsByName;

    public static Type bool() {
        return TYPE_BOOL;
    }

    public static Type int64() {
        return TYPE_INT64;
    }

    public static Type float64() {
        return TYPE_FLOAT64;
    }

    public static Type numeric() {
        return TYPE_NUMERIC;
    }

    public static Type pgNumeric() {
        return TYPE_PG_NUMERIC;
    }

    public static Type string() {
        return TYPE_STRING;
    }

    public static Type json() {
        return TYPE_JSON;
    }

    public static Type bytes() {
        return TYPE_BYTES;
    }

    public static Type timestamp() {
        return TYPE_TIMESTAMP;
    }

    public static Type date() {
        return TYPE_DATE;
    }

    public static Type array(Type elementType) {
        Preconditions.checkNotNull((Object)elementType);
        switch (elementType.getCode()) {
            case BOOL: {
                return TYPE_ARRAY_BOOL;
            }
            case INT64: {
                return TYPE_ARRAY_INT64;
            }
            case FLOAT64: {
                return TYPE_ARRAY_FLOAT64;
            }
            case NUMERIC: {
                return TYPE_ARRAY_NUMERIC;
            }
            case PG_NUMERIC: {
                return TYPE_ARRAY_PG_NUMERIC;
            }
            case STRING: {
                return TYPE_ARRAY_STRING;
            }
            case JSON: {
                return TYPE_ARRAY_JSON;
            }
            case BYTES: {
                return TYPE_ARRAY_BYTES;
            }
            case TIMESTAMP: {
                return TYPE_ARRAY_TIMESTAMP;
            }
            case DATE: {
                return TYPE_ARRAY_DATE;
            }
        }
        return new Type(Code.ARRAY, elementType, null);
    }

    public static Type struct(Iterable<StructField> fields) {
        return new Type(Code.STRUCT, null, (ImmutableList<StructField>)ImmutableList.copyOf(fields));
    }

    public static Type struct(StructField ... fields) {
        return new Type(Code.STRUCT, null, (ImmutableList<StructField>)ImmutableList.copyOf((Object[])fields));
    }

    private Type(Code code, @Nullable Type arrayElementType, @Nullable ImmutableList<StructField> structFields) {
        this.code = code;
        this.arrayElementType = arrayElementType;
        this.structFields = structFields;
    }

    public Code getCode() {
        return this.code;
    }

    public Type getArrayElementType() {
        Preconditions.checkState((this.code == Code.ARRAY ? 1 : 0) != 0, (Object)"Illegal call for non-ARRAY type");
        return this.arrayElementType;
    }

    public List<StructField> getStructFields() {
        Preconditions.checkState((this.code == Code.STRUCT ? 1 : 0) != 0, (Object)"Illegal call for non-STRUCT type");
        return this.structFields;
    }

    public int getFieldIndex(String fieldName) {
        Integer index;
        Preconditions.checkState((this.code == Code.STRUCT ? 1 : 0) != 0, (Object)"Illegal call for non-STRUCT type");
        if (this.fieldsByName == null) {
            TreeMap<String, Integer> tmp = new TreeMap<String, Integer>();
            for (int i = 0; i < this.getStructFields().size(); ++i) {
                StructField field = this.getStructFields().get(i);
                if (tmp.put(field.getName(), i) == null) continue;
                tmp.put(field.getName(), -1);
            }
            this.fieldsByName = ImmutableMap.copyOf(tmp);
        }
        if ((index = this.fieldsByName.get(fieldName)) == null) {
            throw new IllegalArgumentException("Field not found: " + fieldName);
        }
        if (index == -1) {
            throw new IllegalArgumentException("Ambiguous field name: " + fieldName);
        }
        return index;
    }

    void toString(StringBuilder b) {
        if (this.code == Code.ARRAY) {
            b.append("ARRAY<");
            this.arrayElementType.toString(b);
            b.append('>');
        } else if (this.code == Code.STRUCT) {
            b.append("STRUCT<");
            for (int i = 0; i < this.structFields.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                StructField f = (StructField)this.structFields.get(i);
                b.append(f.getName()).append(' ');
                f.getType().toString(b);
            }
            b.append('>');
        } else {
            b.append(this.code.toString());
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type that = (Type)o;
        return this.code == that.code && Objects.equals(this.arrayElementType, that.arrayElementType) && Objects.equals(this.structFields, that.structFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.arrayElementType, this.structFields});
    }

    com.google.spanner.v1.Type toProto() {
        Type.Builder proto = com.google.spanner.v1.Type.newBuilder();
        proto.setCode(this.code.getTypeCode());
        proto.setTypeAnnotation(this.code.getTypeAnnotationCode());
        if (this.code == Code.ARRAY) {
            proto.setArrayElementType(this.arrayElementType.toProto());
        } else if (this.code == Code.STRUCT) {
            StructType.Builder fields = proto.getStructTypeBuilder();
            for (StructField field : this.structFields) {
                fields.addFieldsBuilder().setName(field.getName()).setType(field.getType().toProto());
            }
        }
        return proto.build();
    }

    static Type fromProto(com.google.spanner.v1.Type proto) {
        Code type = Code.fromProto(proto.getCode(), proto.getTypeAnnotation());
        switch (type) {
            case BOOL: {
                return Type.bool();
            }
            case INT64: {
                return Type.int64();
            }
            case FLOAT64: {
                return Type.float64();
            }
            case NUMERIC: {
                return Type.numeric();
            }
            case PG_NUMERIC: {
                return Type.pgNumeric();
            }
            case STRING: {
                return Type.string();
            }
            case JSON: {
                return Type.json();
            }
            case BYTES: {
                return Type.bytes();
            }
            case TIMESTAMP: {
                return Type.timestamp();
            }
            case DATE: {
                return Type.date();
            }
            case ARRAY: {
                Type elementType;
                Preconditions.checkArgument((boolean)proto.hasArrayElementType(), (String)"Missing expected 'array_element_type' field in 'Type' message: %s", (Object)proto);
                try {
                    elementType = Type.fromProto(proto.getArrayElementType());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Could not parse 'array_element_type' attribute in 'Type' message: " + proto, e);
                }
                return Type.array(elementType);
            }
            case STRUCT: {
                Preconditions.checkArgument((boolean)proto.hasStructType(), (String)"Missing expected 'struct_type' field in 'Type' message: %s", (Object)proto);
                ArrayList<StructField> fields = new ArrayList<StructField>(proto.getStructType().getFieldsCount());
                for (StructType.Field field : proto.getStructType().getFieldsList()) {
                    Preconditions.checkArgument((boolean)field.hasType(), (String)"Missing expected 'type' attribute in 'Field': %s", (Object)proto);
                    String name = Strings.nullToEmpty((String)field.getName());
                    fields.add(StructField.of(name, Type.fromProto(field.getType())));
                }
                return Type.struct(fields);
            }
        }
        throw new AssertionError((Object)("Unimplemented case: " + (Object)((Object)type)));
    }

    public static final class StructField
    implements Serializable {
        private static final long serialVersionUID = 8640511292704408210L;
        private final String name;
        private final Type type;

        public static StructField of(String name, Type type) {
            return new StructField(name, type);
        }

        private StructField(String name, Type type) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.type = (Type)Preconditions.checkNotNull((Object)type);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructField that = (StructField)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }

    public static enum Code {
        BOOL(TypeCode.BOOL),
        INT64(TypeCode.INT64),
        NUMERIC(TypeCode.NUMERIC),
        PG_NUMERIC(TypeCode.NUMERIC, TypeAnnotationCode.PG_NUMERIC),
        FLOAT64(TypeCode.FLOAT64),
        STRING(TypeCode.STRING),
        JSON(TypeCode.JSON),
        BYTES(TypeCode.BYTES),
        TIMESTAMP(TypeCode.TIMESTAMP),
        DATE(TypeCode.DATE),
        ARRAY(TypeCode.ARRAY),
        STRUCT(TypeCode.STRUCT);

        private static final Map<Map.Entry<TypeCode, TypeAnnotationCode>, Code> protoToCode;
        private final TypeCode typeCode;
        private final TypeAnnotationCode typeAnnotationCode;

        private Code(TypeCode typeCode) {
            this(typeCode, TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED);
        }

        private Code(TypeCode typeCode, TypeAnnotationCode typeAnnotationCode) {
            this.typeCode = typeCode;
            this.typeAnnotationCode = typeAnnotationCode;
        }

        TypeCode getTypeCode() {
            return this.typeCode;
        }

        TypeAnnotationCode getTypeAnnotationCode() {
            return this.typeAnnotationCode;
        }

        static Code fromProto(TypeCode typeCode, TypeAnnotationCode typeAnnotationCode) {
            Code code = protoToCode.get(new AbstractMap.SimpleEntry<TypeCode, TypeAnnotationCode>(typeCode, typeAnnotationCode));
            Preconditions.checkArgument((code != null ? 1 : 0) != 0, (String)"Invalid code: %s<%s>", (Object)typeCode, (Object)typeAnnotationCode);
            return code;
        }

        public String toString() {
            if (this.typeAnnotationCode == TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED) {
                return this.typeCode.toString();
            }
            return this.typeCode.toString() + "<" + this.typeAnnotationCode.toString() + ">";
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Code code : Code.values()) {
                builder.put(new AbstractMap.SimpleEntry<TypeCode, TypeAnnotationCode>(code.getTypeCode(), code.getTypeAnnotationCode()), (Object)code);
            }
            protoToCode = builder.build();
        }
    }
}

