/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import java.math.BigDecimal;
import javax.annotation.Nullable;

public abstract class ValueBinder<R> {
    ValueBinder() {
    }

    abstract R handle(Value var1);

    public R to(Value value) {
        return this.handle(value);
    }

    public R to(boolean value) {
        return this.handle(Value.bool(value));
    }

    public R to(@Nullable Boolean value) {
        return this.handle(Value.bool(value));
    }

    public R to(long value) {
        return this.handle(Value.int64(value));
    }

    public R to(@Nullable Long value) {
        return this.handle(Value.int64(value));
    }

    public R to(double value) {
        return this.handle(Value.float64(value));
    }

    public R to(@Nullable Double value) {
        return this.handle(Value.float64(value));
    }

    public R to(BigDecimal value) {
        return this.handle(Value.numeric(value));
    }

    public R to(@Nullable String value) {
        return this.handle(Value.string(value));
    }

    public R to(@Nullable ByteArray value) {
        return this.handle(Value.bytes(value));
    }

    public R to(@Nullable Timestamp value) {
        return this.handle(Value.timestamp(value));
    }

    public R to(@Nullable Date value) {
        return this.handle(Value.date(value));
    }

    public R to(Struct value) {
        return this.handle(Value.struct(value));
    }

    public R to(Type type, @Nullable Struct value) {
        return this.handle(Value.struct(type, value));
    }

    public R toBoolArray(@Nullable boolean[] values) {
        return this.handle(Value.boolArray(values));
    }

    public R toBoolArray(@Nullable boolean[] values, int pos, int length) {
        return this.handle(Value.boolArray(values, pos, length));
    }

    public R toBoolArray(@Nullable Iterable<Boolean> values) {
        return this.handle(Value.boolArray(values));
    }

    public R toInt64Array(@Nullable long[] values) {
        return this.handle(Value.int64Array(values));
    }

    public R toInt64Array(@Nullable long[] values, int pos, int length) {
        return this.handle(Value.int64Array(values, pos, length));
    }

    public R toInt64Array(@Nullable Iterable<Long> values) {
        return this.handle(Value.int64Array(values));
    }

    public R toFloat64Array(@Nullable double[] values) {
        return this.handle(Value.float64Array(values));
    }

    public R toFloat64Array(@Nullable double[] values, int pos, int length) {
        return this.handle(Value.float64Array(values, pos, length));
    }

    public R toFloat64Array(@Nullable Iterable<Double> values) {
        return this.handle(Value.float64Array(values));
    }

    public R toNumericArray(@Nullable Iterable<BigDecimal> values) {
        return this.handle(Value.numericArray(values));
    }

    public R toPgNumericArray(@Nullable Iterable<String> values) {
        return this.handle(Value.pgNumericArray(values));
    }

    public R toStringArray(@Nullable Iterable<String> values) {
        return this.handle(Value.stringArray(values));
    }

    public R toJsonArray(@Nullable Iterable<String> values) {
        return this.handle(Value.jsonArray(values));
    }

    public R toBytesArray(@Nullable Iterable<ByteArray> values) {
        return this.handle(Value.bytesArray(values));
    }

    public R toTimestampArray(@Nullable Iterable<Timestamp> values) {
        return this.handle(Value.timestampArray(values));
    }

    public R toDateArray(@Nullable Iterable<Date> values) {
        return this.handle(Value.dateArray(values));
    }

    public R toStructArray(Type elementType, @Nullable Iterable<Struct> values) {
        return this.handle(Value.structArray(elementType, values));
    }
}

