/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatements;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@InternalApi
public class PostgreSQLStatementParser
extends AbstractStatementParser {
    PostgreSQLStatementParser() throws ClientSideStatementImpl.CompileException {
        super(Collections.unmodifiableSet(ClientSideStatements.getInstance(Dialect.POSTGRESQL).getCompiledStatements()));
    }

    @Override
    protected boolean supportsExplain() {
        return false;
    }

    @Override
    @InternalApi
    String removeCommentsAndTrimInternal(String sql) {
        Preconditions.checkNotNull((Object)sql);
        boolean isInSingleLineComment = false;
        int multiLineCommentLevel = 0;
        StringBuilder res = new StringBuilder(sql.length());
        int index = 0;
        while (index < sql.length()) {
            block7: {
                char c;
                block8: {
                    block9: {
                        block6: {
                            c = sql.charAt(index);
                            if (!isInSingleLineComment) break block6;
                            if (c == '\n') {
                                isInSingleLineComment = false;
                                res.append(c);
                            }
                            break block7;
                        }
                        if (multiLineCommentLevel <= 0) break block8;
                        if (sql.length() <= index + 1 || c != '*' || sql.charAt(index + 1) != '/') break block9;
                        --multiLineCommentLevel;
                        ++index;
                        break block7;
                    }
                    if (sql.length() <= index + 1 || c != '/' || sql.charAt(index + 1) != '*') break block7;
                    ++multiLineCommentLevel;
                    ++index;
                    break block7;
                }
                if (sql.length() > index + 1 && c == '-' && sql.charAt(index + 1) == '-') {
                    isInSingleLineComment = true;
                    index += 2;
                    continue;
                }
                if (sql.length() > index + 1 && c == '/' && sql.charAt(index + 1) == '*') {
                    ++multiLineCommentLevel;
                    index += 2;
                    continue;
                }
                index = this.skip(sql, index, res);
                continue;
            }
            ++index;
        }
        if (multiLineCommentLevel > 0) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unterminated block comment: " + sql);
        }
        if (res.length() > 0 && res.charAt(res.length() - 1) == ';') {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString().trim();
    }

    String parseDollarQuotedString(String sql, int index) {
        StringBuilder tag = new StringBuilder();
        while (index < sql.length()) {
            char c = sql.charAt(index);
            if (c == '$') {
                return tag.toString();
            }
            if (!Character.isJavaIdentifierPart(c)) break;
            tag.append(c);
            ++index;
        }
        return null;
    }

    @Override
    String removeStatementHint(String sql) {
        return sql;
    }

    @Override
    @InternalApi
    AbstractStatementParser.ParametersInfo convertPositionalParametersToNamedParametersInternal(char paramChar, String sql) {
        Preconditions.checkNotNull((Object)sql);
        String namedParamPrefix = "$";
        StringBuilder named = new StringBuilder(sql.length() + PostgreSQLStatementParser.countOccurrencesOf(paramChar, sql));
        int index = 0;
        int paramIndex = 1;
        while (index < sql.length()) {
            char c = sql.charAt(index);
            if (c == paramChar) {
                named.append("$").append(paramIndex);
                ++paramIndex;
                ++index;
                continue;
            }
            index = this.skip(sql, index, named);
        }
        return new AbstractStatementParser.ParametersInfo(paramIndex - 1, named.toString());
    }

    @InternalApi
    public Set<String> getQueryParameters(String sql) {
        Preconditions.checkNotNull((Object)sql);
        int maxCount = PostgreSQLStatementParser.countOccurrencesOf('$', sql);
        HashSet<String> parameters = new HashSet<String>(maxCount);
        int currentIndex = 0;
        while (currentIndex < sql.length() - 1) {
            char c = sql.charAt(currentIndex);
            if (c == '$' && Character.isDigit(sql.charAt(currentIndex + 1))) {
                int endIndex;
                for (endIndex = currentIndex + 2; endIndex < sql.length() && Character.isDigit(sql.charAt(endIndex)); ++endIndex) {
                }
                parameters.add(sql.substring(currentIndex, endIndex));
                currentIndex = endIndex;
                continue;
            }
            currentIndex = this.skip(sql, currentIndex, null);
        }
        return parameters;
    }

    private int skip(String sql, int currentIndex, @Nullable StringBuilder result) {
        String dollarTag;
        char currentChar = sql.charAt(currentIndex);
        if (currentChar == '\'' || currentChar == '\"') {
            this.appendIfNotNull(result, currentChar);
            return this.skipQuoted(sql, currentIndex, currentChar, result);
        }
        if (currentChar == '$' && (dollarTag = this.parseDollarQuotedString(sql, currentIndex + 1)) != null) {
            this.appendIfNotNull(result, currentChar, dollarTag, currentChar);
            return this.skipQuoted(sql, currentIndex + dollarTag.length() + 1, currentChar, dollarTag, result);
        }
        this.appendIfNotNull(result, currentChar);
        return currentIndex + 1;
    }

    private int skipQuoted(String sql, int startIndex, char startQuote, @Nullable StringBuilder result) {
        return this.skipQuoted(sql, startIndex, startQuote, null, result);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int skipQuoted(String sql, int startIndex, char startQuote, String dollarTag, @Nullable StringBuilder result) {
        boolean lastCharWasEscapeChar = false;
        int currentIndex = startIndex + 1;
        while (true) {
            char currentChar;
            block8: {
                block9: {
                    if (currentIndex >= sql.length()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
                    }
                    currentChar = sql.charAt(currentIndex);
                    if (currentChar != startQuote) break block9;
                    if (currentChar == '$') {
                        String tag = this.parseDollarQuotedString(sql, currentIndex + 1);
                        if (tag != null && tag.equals(dollarTag)) {
                            this.appendIfNotNull(result, currentChar, dollarTag, currentChar);
                            return currentIndex + tag.length() + 2;
                        }
                        break block8;
                    } else if (lastCharWasEscapeChar) {
                        lastCharWasEscapeChar = false;
                        break block8;
                    } else {
                        if (sql.length() > currentIndex + 1 && sql.charAt(currentIndex + 1) == startQuote) {
                            this.appendIfNotNull(result, currentChar);
                            this.appendIfNotNull(result, currentChar);
                            currentIndex += 2;
                            continue;
                        }
                        this.appendIfNotNull(result, currentChar);
                        return currentIndex + 1;
                    }
                }
                lastCharWasEscapeChar = currentChar == '\\';
            }
            ++currentIndex;
            this.appendIfNotNull(result, currentChar);
        }
    }

    private void appendIfNotNull(@Nullable StringBuilder result, char currentChar) {
        if (result != null) {
            result.append(currentChar);
        }
    }

    private void appendIfNotNull(@Nullable StringBuilder result, char prefix, String tag, char suffix) {
        if (result != null) {
            result.append(prefix).append(tag).append(suffix);
        }
    }
}

