/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.common.annotations.VisibleForTesting;
import com.google.rpc.Status;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import java.util.Objects;

public class EncryptionInfo {
    private final String kmsKeyVersion;
    private final EncryptionInfo.Type encryptionType;
    private final Status encryptionStatus;

    public EncryptionInfo(com.google.spanner.admin.database.v1.EncryptionInfo proto) {
        this(proto.getKmsKeyVersion(), proto.getEncryptionType(), proto.getEncryptionStatus());
    }

    @VisibleForTesting
    public EncryptionInfo(String kmsKeyVersion, EncryptionInfo.Type encryptionType, Status encryptionStatus) {
        this.kmsKeyVersion = kmsKeyVersion;
        this.encryptionType = encryptionType;
        this.encryptionStatus = encryptionStatus;
    }

    public static EncryptionInfo fromProtoOrNull(com.google.spanner.admin.database.v1.EncryptionInfo proto) {
        return proto.equals((Object)com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance()) ? null : new EncryptionInfo(proto);
    }

    public String getKmsKeyVersion() {
        return this.kmsKeyVersion;
    }

    public EncryptionInfo.Type getEncryptionType() {
        return this.encryptionType;
    }

    public Status getEncryptionStatus() {
        return this.encryptionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionInfo that = (EncryptionInfo)o;
        return Objects.equals(this.kmsKeyVersion, that.kmsKeyVersion) && this.encryptionType == that.encryptionType && Objects.equals(this.encryptionStatus, that.encryptionStatus);
    }

    public int hashCode() {
        return Objects.hash(this.kmsKeyVersion, this.encryptionType, this.encryptionStatus);
    }

    public String toString() {
        return String.format("EncryptionInfo[kmsKeyVersion=%s,encryptionType=%s,encryptionStatus=%s]", this.kmsKeyVersion, this.encryptionType, this.encryptionStatus);
    }
}

