/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractAsyncTransactionTest;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.TransactionSelector;
import io.grpc.Status;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AsyncTransactionManagerTest
extends AbstractAsyncTransactionTest {
    @Parameterized.Parameter
    public Executor executor;

    @Parameterized.Parameters(name="executor = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MoreExecutors.directExecutor()}, {Executors.newSingleThreadExecutor()}, {Executors.newFixedThreadPool(4)});
    }

    @Test
    public void asyncTransactionManager_shouldRollbackOnCloseAsync() throws Exception {
        AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);
        TransactionContext txn = (TransactionContext)manager.beginAsync().get();
        txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]).get();
        final TransactionSelector selector = ((TransactionRunnerImpl.TransactionContextImpl)((SessionPool.SessionPoolTransactionContext)txn).delegate).getTransactionSelector();
        SpannerApiFutures.get((ApiFuture)manager.closeAsync());
        mockSpanner.waitForRequestsToContain((Predicate<? super AbstractMessage>)new Predicate<AbstractMessage>(){

            public boolean apply(AbstractMessage input) {
                if (input instanceof RollbackRequest) {
                    RollbackRequest request = (RollbackRequest)input;
                    return request.getTransactionId().equals((Object)selector.getId());
                }
                return false;
            }
        }, 0L);
    }

    @Test
    public void testAsyncTransactionManager_returnsCommitStats() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[]{Options.commitStats()});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = transaction.then(AsyncTransactionManagerHelper.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"}))), this.executor).commitAsync();
                    Assert.assertNotNull((Object)commitTimestamp.get());
                    Assert.assertNotNull((Object)manager.getCommitResponse().get());
                    Assert.assertNotNull((Object)((CommitResponse)manager.getCommitResponse().get()).getCommitStats());
                    Assert.assertEquals((long)1L, (long)((CommitResponse)manager.getCommitResponse().get()).getCommitStats().getMutationCount());
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerUpdate() throws Exception {
        SettableApiFuture updateCount = SettableApiFuture.create();
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = txn.then(AsyncTransactionManagerHelper.executeUpdateAsync((SettableApiFuture<Long>)updateCount, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync();
                    Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                    Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                }
                catch (AbortedException e) {
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerIsNonBlocking() throws Exception {
        SettableApiFuture updateCount = SettableApiFuture.create();
        mockSpanner.freeze();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = txn.then(AsyncTransactionManagerHelper.executeUpdateAsync((SettableApiFuture<Long>)updateCount, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync();
                    mockSpanner.unfreeze();
                    Truth.assertThat((Long)((Long)updateCount.get(10L, TimeUnit.SECONDS))).isEqualTo((Object)1L);
                    Truth.assertThat((Comparable)commitTimestamp.get(10L, TimeUnit.SECONDS)).isNotNull();
                }
                catch (AbortedException e) {
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerInvalidUpdate() throws Exception {
        AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);
        Throwable throwable = null;
        try {
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                try {
                    while (true) {
                        AsyncTransactionManager.CommitTimestampFuture commitTimestamp = txn.then(AsyncTransactionManagerHelper.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), this.executor).commitAsync();
                        commitTimestamp.get();
                        Assert.fail((String)"missing expected exception");
                    }
                }
                catch (AbortedException e) {
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                catch (ExecutionException e) {
                    manager.rollbackAsync();
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                    Truth.assertThat((String)se.getMessage()).contains((CharSequence)"invalid statement");
                    if (manager != null) {
                        if (throwable != null) {
                            try {
                                manager.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            manager.close();
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (manager != null) {
                    if (throwable != null) {
                        try {
                            manager.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        manager.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    @Test
    public void asyncTransactionManagerCommitAborted() throws Exception {
        SettableApiFuture updateCount = SettableApiFuture.create();
        final AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                try {
                    attempt.incrementAndGet();
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = txn.then(AsyncTransactionManagerHelper.executeUpdateAsync((SettableApiFuture<Long>)updateCount, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Long, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Long input) throws Exception {
                            if (attempt.get() == 1) {
                                AbstractAsyncTransactionTest.mockSpanner.abortTransaction(txn);
                            }
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync();
                    Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                    Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                    Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
                }
                catch (AbortedException e) {
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerFireAndForgetInvalidUpdate() throws Exception {
        final SettableApiFuture updateCount = SettableApiFuture.create();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture ts = txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Long>(){

                        public ApiFuture<Long> apply(TransactionContext txn, Void input) throws Exception {
                            txn.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                            ApiFutures.addCallback((ApiFuture)txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), (ApiFutureCallback)new ApiFutureCallback<Long>(){

                                public void onFailure(Throwable t) {
                                    updateCount.setException(t);
                                }

                                public void onSuccess(Long result) {
                                    updateCount.set((Object)result);
                                }
                            }, (Executor)MoreExecutors.directExecutor());
                            return updateCount;
                        }
                    }, this.executor).commitAsync();
                    Truth.assertThat((Comparable)ts.get()).isNotNull();
                    Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, BeginTransactionRequest.class, ExecuteSqlRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncTransactionManagerChain() throws Exception {
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture ts = txn.then(AsyncTransactionManagerHelper.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).then(AsyncTransactionManagerHelper.readRowAsync("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES), this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Struct, String>(){

                        public ApiFuture<String> apply(TransactionContext txn, Struct input) throws Exception {
                            return ApiFutures.immediateFuture((Object)input.getString("Value"));
                        }
                    }, this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<String, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, String input) throws Exception {
                            Truth.assertThat((String)input).isEqualTo((Object)"v1");
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync();
                    Truth.assertThat((Comparable)ts.get()).isNotNull();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerChainWithErrorInTheMiddle() throws Exception {
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture ts = txn.then(AsyncTransactionManagerHelper.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Long, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Long input) throws Exception {
                            throw new IllegalStateException("this should not be executed");
                        }
                    }, this.executor).commitAsync();
                    ts.get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                catch (ExecutionException e) {
                    mgr.rollbackAsync();
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncTransactionManagerUpdateAborted() throws Exception {
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            final AtomicInteger attempt = new AtomicInteger();
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture ts = txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            if (attempt.incrementAndGet() == 1) {
                                AbstractAsyncTransactionTest.mockSpanner.abortNextStatement();
                            } else {
                                AbstractAsyncTransactionTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                            }
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).then(AsyncTransactionManagerHelper.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync();
                    Truth.assertThat((Comparable)ts.get()).isNotNull();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
    }

    @Test
    public void asyncTransactionManagerUpdateAbortedWithoutGettingResult() throws Exception {
        final AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture ts = txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            if (attempt.incrementAndGet() == 1) {
                                AbstractAsyncTransactionTest.mockSpanner.abortNextStatement();
                            }
                            txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync();
                    Truth.assertThat((Comparable)ts.get()).isNotNull();
                    Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
                    Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeast(BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, new Object[]{BeginTransactionRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerCommitFails() throws Exception {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.RESOURCE_EXHAUSTED.withDescription("mutation limit exceeded").asRuntimeException())));
        AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);
        Throwable throwable = null;
        try {
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    while (true) {
                        txn.then(AsyncTransactionManagerHelper.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync().get();
                        Assert.fail((String)"missing expected exception");
                    }
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                catch (ExecutionException e) {
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
                    Truth.assertThat((String)se.getMessage()).contains((CharSequence)"mutation limit exceeded");
                    if (mgr != null) {
                        if (throwable != null) {
                            try {
                                mgr.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            mgr.close();
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (mgr != null) {
                    if (throwable != null) {
                        try {
                            mgr.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        mgr.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    @Test
    public void asyncTransactionManagerWaitsUntilAsyncUpdateHasFinished() throws Exception {
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync().get();
                    Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerBatchUpdate() throws Exception {
        SettableApiFuture result = SettableApiFuture.create();
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then(AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)result, MockSpannerTestUtil.UPDATE_STATEMENT, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((long[])((long[])result.get())).asList().containsExactly(new Object[]{1L, 1L});
    }

    @Test
    public void asyncTransactionManagerIsNonBlockingWithBatchUpdate() throws Exception {
        SettableApiFuture res = SettableApiFuture.create();
        mockSpanner.freeze();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture ts = txn.then(AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)res, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync();
                    mockSpanner.unfreeze();
                    Truth.assertThat((Comparable)ts.get()).isNotNull();
                    Truth.assertThat((long[])((long[])res.get())).asList().containsExactly(new Object[]{1L});
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerInvalidBatchUpdate() throws Exception {
        SettableApiFuture result = SettableApiFuture.create();
        AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);
        Throwable throwable = null;
        try {
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    while (true) {
                        txn.then(AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)result, MockSpannerTestUtil.UPDATE_STATEMENT, MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), this.executor).commitAsync().get();
                        Assert.fail((String)"missing expected exception");
                    }
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                catch (ExecutionException e) {
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                    Truth.assertThat((String)se.getMessage()).contains((CharSequence)"invalid statement");
                    if (mgr != null) {
                        if (throwable != null) {
                            try {
                                mgr.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            mgr.close();
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (mgr != null) {
                    if (throwable != null) {
                        try {
                            mgr.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        mgr.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    @Test
    public void asyncTransactionManagerFireAndForgetInvalidBatchUpdate() throws Exception {
        SettableApiFuture result = SettableApiFuture.create();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), new Options.UpdateOption[0]);
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).then(AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)result, MockSpannerTestUtil.UPDATE_STATEMENT, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((long[])((long[])result.get())).asList().containsExactly(new Object[]{1L, 1L});
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAborted() throws Exception {
        final AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, long[]>(){

                        public ApiFuture<long[]> apply(TransactionContext txn, Void input) throws Exception {
                            if (attempt.incrementAndGet() == 1) {
                                return txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_ABORTED_STATEMENT), new Options.UpdateOption[0]);
                            }
                            return txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                        }
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAbortedBeforeFirstStatement() throws Exception {
        final AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, long[]>(){

                        public ApiFuture<long[]> apply(TransactionContext txn, Void input) throws Exception {
                            if (attempt.incrementAndGet() == 1) {
                                AbstractAsyncTransactionTest.mockSpanner.abortNextStatement();
                            }
                            return txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                        }
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncTransactionManagerWithBatchUpdateCommitAborted() throws Exception {
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            final AtomicInteger attempt = new AtomicInteger();
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                SettableApiFuture result = SettableApiFuture.create();
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            if (attempt.get() > 0) {
                                AbstractAsyncTransactionTest.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                            }
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).then(AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)result, MockSpannerTestUtil.UPDATE_STATEMENT, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<long[], Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, long[] input) throws Exception {
                            if (attempt.incrementAndGet() == 1) {
                                AbstractAsyncTransactionTest.mockSpanner.abortTransaction(txn);
                            }
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync().get();
                    Truth.assertThat((long[])((long[])result.get())).asList().containsExactly(new Object[]{1L, 1L});
                    Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAbortedWithoutGettingResult() throws Exception {
        final AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            if (attempt.incrementAndGet() == 1) {
                                AbstractAsyncTransactionTest.mockSpanner.abortNextStatement();
                            }
                            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Iterable<Class<? extends AbstractMessage>> requests = mockSpanner.getRequestTypes();
        int size = Iterables.size(requests);
        Truth.assertThat((Integer)size).isIn(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(6)));
        if (size == 5) {
            Truth.assertThat(requests).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
        } else {
            Truth.assertThat(requests).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
        }
    }

    @Test
    public void asyncTransactionManagerWithBatchUpdateCommitFails() throws Exception {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.RESOURCE_EXHAUSTED.withDescription("mutation limit exceeded").asRuntimeException())));
        AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);
        Throwable throwable = null;
        try {
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    while (true) {
                        txn.then(AsyncTransactionManagerHelper.batchUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync().get();
                        Assert.fail((String)"missing expected exception");
                    }
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                catch (ExecutionException e) {
                    Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
                    SpannerException se = (SpannerException)e.getCause();
                    Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
                    Truth.assertThat((String)se.getMessage()).contains((CharSequence)"mutation limit exceeded");
                    if (mgr != null) {
                        if (throwable != null) {
                            try {
                                mgr.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            mgr.close();
                        }
                    }
                }
                break;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (mgr != null) {
                    if (throwable != null) {
                        try {
                            mgr.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        mgr.close();
                    }
                }
                throw throwable4;
            }
        }
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncTransactionManagerWaitsUntilAsyncBatchUpdateHasFinished() throws Exception {
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Void>(){

                        public ApiFuture<Void> apply(TransactionContext txn, Void input) throws Exception {
                            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                            return ApiFutures.immediateFuture(null);
                        }
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncTransactionManagerReadRow() throws Exception {
        AsyncTransactionManager.AsyncTransactionStep val;
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep step;
                    val = step = txn.then(AsyncTransactionManagerHelper.readRowAsync("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES), this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Struct, String>(){

                        public ApiFuture<String> apply(TransactionContext txn, Struct input) throws Exception {
                            return ApiFutures.immediateFuture((Object)input.getString("Value"));
                        }
                    }, this.executor);
                    step.commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((String)((String)val.get())).isEqualTo((Object)"v1");
    }

    @Test
    public void asyncTransactionManagerRead() throws Exception {
        AsyncTransactionManager.AsyncTransactionStep res;
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    res = txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, List<String>>(){

                        public ApiFuture<List<String>> apply(TransactionContext txn, Void input) throws Exception {
                            return txn.readAsync("TestTable", KeySet.all(), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]).toListAsync((Function)new Function<StructReader, String>(){

                                public String apply(StructReader input) {
                                    return input.getString("Value");
                                }
                            }, MoreExecutors.directExecutor());
                        }
                    }, this.executor);
                    res.commitAsync().get();
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Iterable)((Iterable)res.get())).containsExactly(new Object[]{"v1", "v2", "v3"});
    }

    @Test
    public void asyncTransactionManagerQuery() throws Exception {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT FirstName FROM Singers WHERE ID=1"), MockSpannerTestUtil.READ_FIRST_NAME_SINGERS_RESULTSET));
        long singerId = 1L;
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                String column = "FirstName";
                AsyncTransactionManager.CommitTimestampFuture commitTimestamp = txn.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Struct>(){

                    public ApiFuture<Struct> apply(TransactionContext txn, Void input) throws Exception {
                        return txn.readRowAsync("Singers", Key.of((Object[])new Object[]{1L}), Collections.singleton("FirstName"));
                    }
                }, this.executor).then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Struct, Void>(){

                    public ApiFuture<Void> apply(TransactionContext txn, Struct input) throws Exception {
                        String name = input.getString("FirstName");
                        txn.buffer(((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"Singers").set("FirstName").to(name.toUpperCase())).build());
                        return ApiFutures.immediateFuture(null);
                    }
                }, this.executor).commitAsync();
                try {
                    commitTimestamp.get();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManager_shouldPropagateStatementFailure() throws ExecutionException, InterruptedException, TimeoutException {
        DatabaseClient dbClient = this.client();
        try (AsyncTransactionManager transactionManager = dbClient.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txnContextFuture = transactionManager.beginAsync();
            AsyncTransactionManager.AsyncTransactionStep updateFuture = txnContextFuture.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Long>(){

                public ApiFuture<Long> apply(TransactionContext txn, Void input) throws Exception {
                    return txn.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                }
            }, this.executor);
            final SettableApiFuture res = SettableApiFuture.create();
            ApiFutures.addCallback((ApiFuture)updateFuture, (ApiFutureCallback)new ApiFutureCallback<Long>(){

                public void onFailure(Throwable throwable) {
                    try {
                        Truth.assertThat((Throwable)throwable).isInstanceOf(SpannerException.class);
                        SpannerException e = (SpannerException)throwable;
                        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalid statement");
                        res.set(null);
                    }
                    catch (Throwable t) {
                        res.setException(t);
                    }
                }

                public void onSuccess(Long aLong) {
                    res.setException((Throwable)((Object)new AssertionError((Object)"Statement should not succeed.")));
                }
            }, (Executor)this.executor);
            Truth.assertThat((Object)res.get(10L, TimeUnit.SECONDS)).isNull();
        }
    }

    public static class AsyncTransactionManagerHelper {
        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, AsyncResultSet> readAsync(final String table, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return new AsyncTransactionManager.AsyncTransactionFunction<I, AsyncResultSet>(){

                public ApiFuture<AsyncResultSet> apply(TransactionContext txn, I input) throws Exception {
                    return ApiFutures.immediateFuture((Object)txn.readAsync(table, keys, columns, options));
                }
            };
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Struct> readRowAsync(final String table, final Key key, final Iterable<String> columns) {
            return new AsyncTransactionManager.AsyncTransactionFunction<I, Struct>(){

                public ApiFuture<Struct> apply(TransactionContext txn, I input) throws Exception {
                    return txn.readRowAsync(table, key, columns);
                }
            };
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Void> buffer(Mutation mutation) {
            return AsyncTransactionManagerHelper.buffer((Iterable<Mutation>)ImmutableList.of((Object)mutation));
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Void> buffer(final Iterable<Mutation> mutations) {
            return new AsyncTransactionManager.AsyncTransactionFunction<I, Void>(){

                public ApiFuture<Void> apply(TransactionContext txn, I input) throws Exception {
                    txn.buffer(mutations);
                    return ApiFutures.immediateFuture(null);
                }
            };
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Long> executeUpdateAsync(Statement statement) {
            return AsyncTransactionManagerHelper.executeUpdateAsync((SettableApiFuture<Long>)SettableApiFuture.create(), statement);
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Long> executeUpdateAsync(final SettableApiFuture<Long> result, final Statement statement) {
            return new AsyncTransactionManager.AsyncTransactionFunction<I, Long>(){

                public ApiFuture<Long> apply(TransactionContext txn, I input) throws Exception {
                    ApiFuture updateCount = txn.executeUpdateAsync(statement, new Options.UpdateOption[0]);
                    ApiFutures.addCallback((ApiFuture)updateCount, (ApiFutureCallback)new ApiFutureCallback<Long>(){

                        public void onFailure(Throwable t) {
                            result.setException(t);
                        }

                        public void onSuccess(Long input) {
                            result.set((Object)input);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                    return updateCount;
                }
            };
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, long[]> batchUpdateAsync(Statement ... statements) {
            return AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)SettableApiFuture.create(), statements);
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, long[]> batchUpdateAsync(final SettableApiFuture<long[]> result, final Statement ... statements) {
            return new AsyncTransactionManager.AsyncTransactionFunction<I, long[]>(){

                public ApiFuture<long[]> apply(TransactionContext txn, I input) throws Exception {
                    ApiFuture updateCounts = txn.batchUpdateAsync(Arrays.asList(statements), new Options.UpdateOption[0]);
                    ApiFutures.addCallback((ApiFuture)updateCounts, (ApiFutureCallback)new ApiFutureCallback<long[]>(){

                        public void onFailure(Throwable t) {
                            result.setException(t);
                        }

                        public void onSuccess(long[] input) {
                            result.set((Object)input);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                    return updateCounts;
                }
            };
        }
    }
}

