/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdminImpl;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.instance.v1.InstanceName;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.threeten.bp.Duration;

@RunWith(value=Parameterized.class)
public class DatabaseAdminGaxTest {
    private static final String PROJECT = "PROJECT";
    private static final String INSTANCE = "INSTANCE";
    private static final StatusRuntimeException UNAVAILABLE = Status.UNAVAILABLE.withDescription("Retryable test exception.").asRuntimeException();
    private static final StatusRuntimeException FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    private static MockDatabaseAdminImpl mockDatabaseAdmin;
    private static Server server;
    private static Spanner spanner;
    private static DatabaseAdminClient client;
    private static LocalChannelProvider channelProvider;
    @Parameterized.Parameter(value=0)
    public int exceptionAtCall;
    @Parameterized.Parameter(value=1)
    public ExceptionType exceptionType;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static Exception createDelayedInternal() {
        return new DelayedStatusRuntimeException(Status.INTERNAL.withDescription("Delayed test exception.").asRuntimeException(), 500L);
    }

    @Parameterized.Parameters(name="exception at call = {0}, exception type = {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int exceptionAtCall : new int[]{0, 1}) {
            for (ExceptionType exceptionType : ExceptionType.values()) {
                params.add(new Object[]{exceptionAtCall, exceptionType});
            }
        }
        return params;
    }

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockDatabaseAdmin = new MockDatabaseAdminImpl();
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockDatabaseAdmin)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws Exception {
        mockDatabaseAdmin.reset();
        RetrySettings retrySettingsWithLowTimeout = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)20L)).setMaxRpcTimeout(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxAttempts(10).setTotalTimeout(Duration.ofMillis((long)200L)).build();
        RetrySettings retrySettingsWithHighTimeout = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)2000L)).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setMaxAttempts(3).setTotalTimeout(Duration.ofMillis((long)15000L)).build();
        final RetrySettings retrySettingsToUse = this.exceptionType == ExceptionType.DELAYED ? retrySettingsWithLowTimeout : retrySettingsWithHighTimeout;
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getDatabaseAdminStubSettingsBuilder().applyToAllUnaryMethods(new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

            public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                input.setRetrySettings(retrySettingsToUse);
                return null;
            }
        });
        if (!builder.getDatabaseAdminStubSettingsBuilder().createDatabaseOperationSettings().getInitialCallSettings().getRetryableCodes().isEmpty()) {
            builder.getDatabaseAdminStubSettingsBuilder().createDatabaseOperationSettings().setInitialCallSettings(builder.getDatabaseAdminStubSettingsBuilder().createDatabaseOperationSettings().getInitialCallSettings().toBuilder().setRetrySettings(retrySettingsToUse).build());
        }
        if (!builder.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().getInitialCallSettings().getRetryableCodes().isEmpty()) {
            builder.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().setInitialCallSettings(builder.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().getInitialCallSettings().toBuilder().setRetrySettings(retrySettingsToUse).build());
        }
        spanner = (Spanner)builder.build().getService();
        client = spanner.getDatabaseAdminClient();
    }

    @After
    public void tearDown() {
        spanner.close();
    }

    private Exception setupException() {
        if (!this.exceptionType.isRetryable()) {
            this.expectedException.expect(SpannerMatchers.isSpannerException(this.exceptionType.getExpectedErrorCodeWithGax()));
        }
        return this.exceptionType.getException();
    }

    @Test
    public void listDatabasesTest() {
        int i;
        Exception exception = this.setupException();
        String nextPageToken = "token%d";
        ArrayList<com.google.spanner.admin.database.v1.Database> databases = new ArrayList<com.google.spanner.admin.database.v1.Database>(2);
        for (i = 0; i < 2; ++i) {
            databases.add(com.google.spanner.admin.database.v1.Database.newBuilder().setName(String.format("projects/%s/instances/%s/databases/test%d", PROJECT, INSTANCE, i)).build());
        }
        if (this.exceptionAtCall == 0) {
            mockDatabaseAdmin.addException(exception);
        }
        for (i = 0; i < 2; ++i) {
            ListDatabasesResponse.Builder builder = ListDatabasesResponse.newBuilder().addAllDatabases(Arrays.asList((com.google.spanner.admin.database.v1.Database)databases.get(i)));
            if (i < databases.size() - 1) {
                builder.setNextPageToken(String.format(nextPageToken, i));
            }
            if (this.exceptionAtCall == i + 1) {
                mockDatabaseAdmin.addException(exception);
            }
            mockDatabaseAdmin.addResponse((AbstractMessage)builder.build());
        }
        InstanceName parent = InstanceName.of((String)PROJECT, (String)INSTANCE);
        Page pagedListResponse = client.listDatabases(INSTANCE, new Options.ListOption[0]);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)2L, (long)resources.size());
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
        ListDatabasesRequest actualRequest = (ListDatabasesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)InstanceName.parse((String)actualRequest.getParent()));
    }

    @Test
    public void getDatabaseTest() {
        Exception exception = this.setupException();
        DatabaseName name2 = DatabaseName.of((String)PROJECT, (String)INSTANCE, (String)"DATABASE");
        com.google.spanner.admin.database.v1.Database expectedResponse = com.google.spanner.admin.database.v1.Database.newBuilder().setName(name2.toString()).build();
        if (this.exceptionAtCall == 0) {
            mockDatabaseAdmin.addException(exception);
        }
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        if (this.exceptionAtCall == 1) {
            mockDatabaseAdmin.addException(exception);
        }
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        for (int i = 0; i < 2; ++i) {
            Database actualResponse = client.getDatabase(INSTANCE, "DATABASE");
            Assert.assertEquals((Object)name2.toString(), (Object)actualResponse.getId().getName());
        }
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    @Test
    public void updateDatabaseDdlTest() throws Exception {
        Exception exception = this.setupException();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseDdlTest").setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build();
        if (this.exceptionAtCall == 0) {
            mockDatabaseAdmin.addException(exception);
        }
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        if (this.exceptionAtCall == 1) {
            mockDatabaseAdmin.addException(exception);
        }
        mockDatabaseAdmin.addResponse((AbstractMessage)resultOperation);
        for (int i = 0; i < 2; ++i) {
            OperationFuture actualResponse = client.updateDatabaseDdl(INSTANCE, "DATABASE", Arrays.asList("CREATE TABLE FOO"), "updateDatabaseDdlTest");
            try {
                actualResponse.get();
                continue;
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw e;
            }
        }
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    @Test
    public void deleteInstanceTest() {
        Exception exception = this.setupException();
        Empty expectedResponse = Empty.newBuilder().build();
        if (this.exceptionAtCall == 0) {
            mockDatabaseAdmin.addException(exception);
        }
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        if (this.exceptionAtCall == 1) {
            mockDatabaseAdmin.addException(exception);
        }
        mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
        for (int i = 0; i < 2; ++i) {
            client.dropDatabase(INSTANCE, "DATABASE");
        }
        List<AbstractMessage> actualRequests = mockDatabaseAdmin.getRequests();
        Assert.assertEquals((long)2L, (long)actualRequests.size());
    }

    public static enum ExceptionType {
        RETRYABLE{

            @Override
            public Exception getException() {
                return UNAVAILABLE;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithGax() {
                return null;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithoutGax() {
                return ErrorCode.UNAVAILABLE;
            }

            @Override
            public boolean isRetryable() {
                return true;
            }
        }
        ,
        NON_RETRYABLE{

            @Override
            public Exception getException() {
                return FAILED_PRECONDITION;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithGax() {
                return ErrorCode.FAILED_PRECONDITION;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithoutGax() {
                return ErrorCode.FAILED_PRECONDITION;
            }

            @Override
            public boolean isRetryable() {
                return false;
            }
        }
        ,
        DELAYED{

            @Override
            public Exception getException() {
                return DatabaseAdminGaxTest.createDelayedInternal();
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithGax() {
                return ErrorCode.DEADLINE_EXCEEDED;
            }

            @Override
            public ErrorCode getExpectedErrorCodeWithoutGax() {
                return ErrorCode.INTERNAL;
            }

            @Override
            public boolean isRetryable() {
                return true;
            }
        };


        public abstract Exception getException();

        public abstract ErrorCode getExpectedErrorCodeWithGax();

        public abstract ErrorCode getExpectedErrorCodeWithoutGax();

        public abstract boolean isRetryable();
    }

    public static class DelayedStatusRuntimeException
    extends RuntimeException {
        private final long millis;

        public DelayedStatusRuntimeException(StatusRuntimeException cause, long millis) {
            super((Throwable)cause);
            this.millis = millis;
        }

        @Override
        public synchronized Throwable getCause() {
            Uninterruptibles.sleepUninterruptibly((long)this.millis, (TimeUnit)TimeUnit.MILLISECONDS);
            return super.getCause();
        }
    }
}

