/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerImpl;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITSessionPoolIntegrationTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static Database db;
    private SessionPool pool;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key                STRING(MAX) NOT NULL,  StringValue        STRING(MAX),) PRIMARY KEY (Key)", "CREATE INDEX TestTableByValue ON TestTable(StringValue)"});
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 15; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k" + i)).set("StringValue").to("v" + i)).build());
        }
        env.getTestHelper().getDatabaseClient(db).write(mutations);
    }

    @Before
    public void setUp() {
        SessionPoolOptions options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(2).build();
        this.pool = SessionPool.createPool((SessionPoolOptions)options, (GrpcTransportOptions.ExecutorFactory)new GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>(){

            public void release(ScheduledExecutorService executor) {
                executor.shutdown();
            }

            public ScheduledExecutorService get() {
                return new ScheduledThreadPoolExecutor(2);
            }
        }, (SessionClient)((SpannerImpl)env.getTestHelper().getClient()).getSessionClient(db.getId()));
    }

    @Test
    public void sessionCreation() {
        try (SessionPool.PooledSessionFuture session = this.pool.getSession();){
            Truth.assertThat((Object)session.get()).isNotNull();
        }
        session = this.pool.getSession();
        var2_2 = null;
        try (SessionPool.PooledSessionFuture session2 = this.pool.getSession();){
            Truth.assertThat((Object)session.get()).isNotNull();
            Truth.assertThat((Object)session2.get()).isNotNull();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void poolExhaustion() throws Exception {
        SessionPool.PooledSession session1 = this.pool.getSession().get();
        SessionPool.PooledSession session2 = this.pool.getSession().get();
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            try (SessionPool.PooledSession session3 = this.pool.getSession().get();){
                latch.countDown();
            }
        }).start();
        Truth.assertThat((Boolean)latch.await(5L, TimeUnit.SECONDS)).isFalse();
        session1.close();
        session2.close();
        latch.await();
    }

    @Test
    public void multipleWaiters() throws Exception {
        SessionPool.PooledSession session1 = this.pool.getSession().get();
        SessionPool.PooledSession session2 = this.pool.getSession().get();
        int numSessions = 5;
        CountDownLatch latch = new CountDownLatch(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            new Thread(() -> {
                try (SessionPool.PooledSession session = this.pool.getSession().get();){
                    latch.countDown();
                }
            }).start();
        }
        session1.close();
        session2.close();
        Truth.assertThat((Boolean)latch.await(1L, TimeUnit.SECONDS)).isTrue();
    }

    @Test
    public void closeQuicklyDoesNotBlockIndefinitely() throws Exception {
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get();
    }

    @Test
    public void closeAfterInitialCreateDoesNotBlockIndefinitely() throws Exception {
        this.pool.getSession().close();
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get();
    }

    @Test
    public void closeWhenSessionsActiveFinishes() throws Exception {
        this.pool.getSession().get();
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get();
    }
}

