/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceConfigId;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstanceConfigIdTest {
    @Test
    public void basic() {
        String name = "projects/test-project/instanceConfigs/test-instance-config";
        InstanceConfigId config = InstanceConfigId.of((String)name);
        Truth.assertThat((String)config.getProject()).isEqualTo((Object)"test-project");
        Truth.assertThat((String)config.getInstanceConfig()).isEqualTo((Object)"test-instance-config");
        Truth.assertThat((String)config.getName()).isEqualTo((Object)name);
        Truth.assertThat((Object)InstanceConfigId.of((String)name)).isEqualTo((Object)config);
        Truth.assertThat((Object)InstanceConfigId.of((String)"test-project", (String)"test-instance-config")).isEqualTo((Object)config);
        Truth.assertThat((Integer)InstanceConfigId.of((String)name).hashCode()).isEqualTo((Object)config.hashCode());
    }

    @Test
    public void badName() {
        try {
            InstanceConfigId.of((String)"bad name");
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }
}

