/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionedDmlTransaction;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionSelector;
import io.grpc.Status;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class PartitionedDmlTransactionTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SessionImpl session;
    @Mock
    private Ticker ticker;
    private PartitionedDmlTransaction tx;
    private final String sessionId = "projects/p/instances/i/databases/d/sessions/s";
    private final ByteString txId = ByteString.copyFromUtf8((String)"tx");
    private final ByteString resumeToken = ByteString.copyFromUtf8((String)"resume");
    private final String sql = "UPDATE FOO SET BAR=1 WHERE TRUE";
    private final String tag = "app=spanner,env=test";
    private final ExecuteSqlRequest executeRequestWithoutResumeToken = ExecuteSqlRequest.newBuilder().setQueryMode(ExecuteSqlRequest.QueryMode.NORMAL).setSession("projects/p/instances/i/databases/d/sessions/s").setSql("UPDATE FOO SET BAR=1 WHERE TRUE").setTransaction(TransactionSelector.newBuilder().setId(this.txId)).build();
    private final ExecuteSqlRequest executeRequestWithResumeToken = this.executeRequestWithoutResumeToken.toBuilder().setResumeToken(this.resumeToken).build();
    private final ExecuteSqlRequest executeRequestWithRequestOptions = this.executeRequestWithoutResumeToken.toBuilder().setRequestOptions(RequestOptions.newBuilder().setRequestTag("app=spanner,env=test").build()).build();

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.session.getName()).thenReturn((Object)"projects/p/instances/i/databases/d/sessions/s");
        Mockito.when((Object)this.session.getOptions()).thenReturn((Object)Collections.EMPTY_MAP);
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap())).thenReturn((Object)Transaction.newBuilder().setId(this.txId).build());
        this.tx = new PartitionedDmlTransaction(this.session, this.rpc, this.ticker);
    }

    @Test
    public void testExecuteStreamingPartitionedUpdate() {
        ResultSetStats stats = ResultSetStats.newBuilder().setRowCountLowerBound(1000L).build();
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        PartialResultSet p2 = PartialResultSet.newBuilder().setStats(stats).build();
        ServerStream stream = (ServerStream)Mockito.mock(ServerStream.class);
        Mockito.when((Object)stream.iterator()).thenReturn((Object)ImmutableList.of((Object)p1, (Object)p2).iterator());
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream);
        long count = this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
        Truth.assertThat((Long)count).isEqualTo((Object)1000L);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateWithUpdateOptions() {
        ResultSetStats stats = ResultSetStats.newBuilder().setRowCountLowerBound(1000L).build();
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        PartialResultSet p2 = PartialResultSet.newBuilder().setStats(stats).build();
        ServerStream stream = (ServerStream)Mockito.mock(ServerStream.class);
        Mockito.when((Object)stream.iterator()).thenReturn((Object)ImmutableList.of((Object)p1, (Object)p2).iterator());
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithRequestOptions), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream);
        long count = this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test")});
        Truth.assertThat((Long)count).isEqualTo((Object)1000L);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithRequestOptions), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateAborted() {
        ResultSetStats stats = ResultSetStats.newBuilder().setRowCountLowerBound(1000L).build();
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        PartialResultSet p2 = PartialResultSet.newBuilder().setStats(stats).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new AbortedException("transaction aborted", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), true)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        ServerStream stream2 = (ServerStream)Mockito.mock(ServerStream.class);
        Mockito.when((Object)stream2.iterator()).thenReturn((Object)ImmutableList.of((Object)p1, (Object)p2).iterator());
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Matchers.any(ExecuteSqlRequest.class), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1, (Object[])new ServerStream[]{stream2});
        long count = this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
        Truth.assertThat((Long)count).isEqualTo((Object)1000L);
        ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.times((int)2))).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
        ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.times((int)2))).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateUnavailable() {
        ResultSetStats stats = ResultSetStats.newBuilder().setRowCountLowerBound(1000L).build();
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        PartialResultSet p2 = PartialResultSet.newBuilder().setStats(stats).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new UnavailableException("temporary unavailable", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        ServerStream stream2 = (ServerStream)Mockito.mock(ServerStream.class);
        Mockito.when((Object)stream2.iterator()).thenReturn((Object)ImmutableList.of((Object)p1, (Object)p2).iterator());
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1);
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream2);
        long count = this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
        Truth.assertThat((Long)count).isEqualTo((Object)1000L);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateUnavailableAndThenDeadlineExceeded() {
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new UnavailableException("temporary unavailable", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1);
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)0L, (Object[])new Long[]{1L, TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MINUTES)});
        try {
            this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
            Assert.fail((String)"missing expected DEADLINE_EXCEEDED exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            ((SpannerRpc)Mockito.verify((Object)this.rpc)).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
            ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
        }
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateAbortedAndThenDeadlineExceeded() {
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new AbortedException("transaction aborted", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), true)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1);
        Mockito.when((Object)this.ticker.read()).thenReturn((Object)0L, (Object[])new Long[]{1L, TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MINUTES)});
        try {
            this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
            Assert.fail((String)"missing expected DEADLINE_EXCEEDED exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.times((int)2))).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
            ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
        }
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateMultipleAbortsUntilDeadlineExceeded() {
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true);
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new AbortedException("transaction aborted", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), true)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1);
        Mockito.when((Object)this.ticker.read()).thenAnswer((Answer)new Answer<Long>(){
            long ticks = 0L;

            public Long answer(InvocationOnMock invocation) throws Throwable {
                return TimeUnit.NANOSECONDS.convert(++this.ticks, TimeUnit.MINUTES);
            }
        });
        try {
            this.tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
            Assert.fail((String)"missing expected DEADLINE_EXCEEDED exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.times((int)10))).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
            ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.times((int)9))).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
        }
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateUnexpectedEOS() {
        ResultSetStats stats = ResultSetStats.newBuilder().setRowCountLowerBound(1000L).build();
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        PartialResultSet p2 = PartialResultSet.newBuilder().setStats(stats).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new InternalException("INTERNAL: Received unexpected EOS on DATA frame from server.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), true)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        ServerStream stream2 = (ServerStream)Mockito.mock(ServerStream.class);
        Mockito.when((Object)stream2.iterator()).thenReturn((Object)ImmutableList.of((Object)p1, (Object)p2).iterator());
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1);
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream2);
        PartitionedDmlTransaction tx = new PartitionedDmlTransaction(this.session, this.rpc, this.ticker);
        long count = tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
        Truth.assertThat((Long)count).isEqualTo((Object)1000L);
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
        ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
    }

    @Test
    public void testExecuteStreamingPartitionedUpdateGenericInternalException() {
        PartialResultSet p1 = PartialResultSet.newBuilder().setResumeToken(this.resumeToken).build();
        ServerStream stream1 = (ServerStream)Mockito.mock(ServerStream.class);
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(iterator.next()).thenReturn((Object)p1).thenThrow(new Throwable[]{new InternalException("INTERNAL: Error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false)});
        Mockito.when((Object)stream1.iterator()).thenReturn((Object)iterator);
        Mockito.when((Object)this.rpc.executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class))).thenReturn((Object)stream1);
        try {
            PartitionedDmlTransaction tx = new PartitionedDmlTransaction(this.session, this.rpc, this.ticker);
            tx.executeStreamingPartitionedUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Duration.ofMinutes((long)10L), new Options.UpdateOption[0]);
            Assert.fail((String)"missing expected INTERNAL exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INTERNAL);
            ((SpannerRpc)Mockito.verify((Object)this.rpc)).beginTransaction((BeginTransactionRequest)Matchers.any(BeginTransactionRequest.class), Matchers.anyMap());
            ((SpannerRpc)Mockito.verify((Object)this.rpc)).executeStreamingPartitionedDml((ExecuteSqlRequest)Mockito.eq((Object)this.executeRequestWithoutResumeToken), Matchers.anyMap(), (Duration)Matchers.any(Duration.class));
        }
    }

    @Test
    public void testRequestWithoutPriority() {
        ExecuteSqlRequest request = this.tx.newTransactionRequestFrom(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[0]));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testRequestWithPriority() {
        ExecuteSqlRequest request = this.tx.newTransactionRequestFrom(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)}));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testRequestWithPriorityAndRequestTag() {
        ExecuteSqlRequest request = this.tx.newTransactionRequestFrom(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE TRUE"), Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW), Options.tag((String)"app=spanner,env=test")}));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)request.getRequestOptions().getPriority());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test");
    }
}

