/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.Base64;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.protobuf.Duration;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Value;
import com.google.protobuf.util.Timestamps;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.util.Random;

public class RandomResultSetGenerator {
    private static final Type[] TYPES = new Type[]{Type.newBuilder().setCode(TypeCode.BOOL).build(), Type.newBuilder().setCode(TypeCode.INT64).build(), Type.newBuilder().setCode(TypeCode.FLOAT64).build(), Type.newBuilder().setCode(TypeCode.STRING).build(), Type.newBuilder().setCode(TypeCode.BYTES).build(), Type.newBuilder().setCode(TypeCode.DATE).build(), Type.newBuilder().setCode(TypeCode.TIMESTAMP).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.BOOL)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.INT64)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.FLOAT64)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.STRING)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.BYTES)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.DATE)).build(), Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.TIMESTAMP)).build()};
    private static final ResultSetMetadata METADATA = RandomResultSetGenerator.generateMetadata();
    private final int rowCount;
    private final Random random = new Random();

    private static final ResultSetMetadata generateMetadata() {
        StructType.Builder rowTypeBuilder = StructType.newBuilder();
        for (int col = 0; col < TYPES.length; ++col) {
            rowTypeBuilder.addFields(StructType.Field.newBuilder().setName("COL" + col).setType(TYPES[col])).build();
        }
        ResultSetMetadata.Builder builder = ResultSetMetadata.newBuilder();
        builder.setRowType(rowTypeBuilder.build());
        return builder.build();
    }

    public RandomResultSetGenerator(int rowCount) {
        this.rowCount = rowCount;
    }

    public ResultSet generate() {
        ResultSet.Builder builder = ResultSet.newBuilder();
        for (int row = 0; row < this.rowCount; ++row) {
            ListValue.Builder rowBuilder = ListValue.newBuilder();
            for (Type type : TYPES) {
                Value.Builder valueBuilder = Value.newBuilder();
                this.setRandomValue(valueBuilder, type);
                rowBuilder.addValues(valueBuilder.build());
            }
            builder.addRows(rowBuilder.build());
        }
        builder.setMetadata(METADATA);
        return builder.build();
    }

    private void setRandomValue(Value.Builder builder, Type type) {
        if (this.randomNull()) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else {
            switch (type.getCode()) {
                case ARRAY: {
                    int length = this.random.nextInt(20) + 1;
                    ListValue.Builder arrayBuilder = ListValue.newBuilder();
                    for (int i = 0; i < length; ++i) {
                        Value.Builder valueBuilder = Value.newBuilder();
                        this.setRandomValue(valueBuilder, type.getArrayElementType());
                        arrayBuilder.addValues(valueBuilder.build());
                    }
                    builder.setListValue(arrayBuilder.build());
                    break;
                }
                case BOOL: {
                    builder.setBoolValue(this.random.nextBoolean());
                    break;
                }
                case STRING: 
                case BYTES: {
                    byte[] bytes = new byte[this.random.nextInt(200)];
                    this.random.nextBytes(bytes);
                    builder.setStringValue(Base64.encodeBase64String((byte[])bytes));
                    break;
                }
                case DATE: {
                    Date date = Date.fromYearMonthDay((int)(this.random.nextInt(2019) + 1), (int)(this.random.nextInt(11) + 1), (int)(this.random.nextInt(28) + 1));
                    builder.setStringValue(date.toString());
                    break;
                }
                case FLOAT64: {
                    builder.setNumberValue(this.random.nextDouble());
                    break;
                }
                case INT64: {
                    builder.setStringValue(String.valueOf(this.random.nextLong()));
                    break;
                }
                case TIMESTAMP: {
                    com.google.protobuf.Timestamp ts = Timestamps.add((com.google.protobuf.Timestamp)Timestamps.EPOCH, (Duration)Duration.newBuilder().setSeconds((long)this.random.nextInt(100000000)).setNanos(this.random.nextInt(1000000000)).build());
                    builder.setStringValue(Timestamp.fromProto((com.google.protobuf.Timestamp)ts).toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown or unsupported type: " + type.getCode());
                }
            }
        }
    }

    private boolean randomNull() {
        return this.random.nextInt(10) == 0;
    }
}

