/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RetryOnInvalidatedSessionTest {
    private static final ToLongTransformer TO_LONG = new ToLongTransformer();
    @Parameterized.Parameter(value=0)
    public boolean failOnInvalidatedSession;
    private static final ResultSetMetadata READ_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("BAR").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet READ_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(READ_METADATA).build();
    private static final com.google.spanner.v1.ResultSet READ_ROW_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(READ_METADATA).build();
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final long UPDATE_COUNT = 1L;
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static SpannerClient spannerClient;
    private static Spanner spanner;
    private static DatabaseClient client;
    private static ExecutorService executor;

    @Parameterized.Parameters(name="fail on invalidated session = {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{false});
        params.add(new Object[]{true});
        return params;
    }

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.all(), Arrays.asList("BAR"), READ_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[0])), Arrays.asList("BAR"), READ_ROW_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).directExecutor()).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        spannerClient = SpannerClient.create((SpannerSettings)settings);
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        spannerClient.close();
        server.shutdown();
        server.awaitTermination();
        executor.shutdown();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder().setFailOnSessionLeak();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
        client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
    }

    @After
    public void tearDown() {
        spanner.close();
    }

    private static void invalidateSessionPool() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
    }

    private static void invalidateSessionPool(DatabaseClient client, int minSessions) throws InterruptedException {
        Stopwatch watch = Stopwatch.createStarted();
        while (((DatabaseClientImpl)client).pool.totalSessions() < minSessions) {
            if (watch.elapsed(TimeUnit.SECONDS) > 5L) {
                Assert.fail((String)String.format("Failed to create MinSessions=%d", minSessions));
            }
            Thread.sleep(5L);
        }
        SpannerClient.ListSessionsPagedResponse response = spannerClient.listSessions("projects/[PROJECT]/instances/[INSTANCE]/databases/[DATABASE]");
        for (Session session : response.iterateAll()) {
            spannerClient.deleteSession(session.getName());
        }
    }

    @Test
    public void singleUseSelect() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            int count = 0;
            try (ReadContext context = client.singleUse();
                 ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseSelectAsync() throws Exception {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(SELECT1AND2, new Options.QueryOption[0]);){
            ApiFuture list = rs.toListAsync((Function)TO_LONG, (Executor)executor);
            Truth.assertThat((Iterable)((Iterable)list.get())).containsExactly(new Object[]{1L, 2L});
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SessionNotFoundException.class);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseRead() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadContext context = client.singleUse();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadContext context = client.singleUse();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadRow() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadContext context = client.singleUse();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadRowUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadContext context = client.singleUse();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadOnlyTransactionSelect() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            try (ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadOnlyTransactionRead() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singlUseReadOnlyTransactionReadUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadOnlyTransactionReadRow() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void singleUseReadOnlyTransactionReadRowUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.singleUseReadOnlyTransaction();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readOnlyTransactionSelect() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readOnlyTransactionRead() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readOnlyTransactionReadUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readOnlyTransactionReadRow() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readOnlyTransactionReadRowUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionSelectNonRecoverable() throws InterruptedException {
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            rs = context.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
            var5_7 = null;
            try {
                while (rs.next()) {
                    ++count;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadNonRecoverable() throws InterruptedException {
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            rs = context.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            var5_7 = null;
            try {
                while (rs.next()) {
                    ++count;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadUsingIndexNonRecoverable() throws InterruptedException {
        int count = 0;
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            try (ResultSet rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                while (rs.next()) {
                    ++count;
                }
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            rs = context.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            var5_7 = null;
            try {
                while (rs.next()) {
                    ++count;
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_7 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadRowNonRecoverable() throws InterruptedException {
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            Struct struct = context.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
        }
    }

    @Test(expected=SessionNotFoundException.class)
    public void readOnlyTransactionReadRowUsingIndexNonRecoverable() throws InterruptedException {
        try (ReadOnlyTransaction context = client.readOnlyTransaction();){
            Struct row = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            RetryOnInvalidatedSessionTest.invalidateSessionPool();
            Struct struct = context.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
        }
    }

    @Test
    public void readWriteTransactionReadOnlySessionInPool() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int count = (Integer)runner.run(transaction -> {
                int count1 = 0;
                try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        ++count1;
                    }
                }
                return count1;
            });
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionSelect() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int count = (Integer)runner.run(transaction -> {
                int count1 = 0;
                try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        ++count1;
                    }
                }
                return count1;
            });
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionRead() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int count = (Integer)runner.run(transaction -> {
                int count1 = 0;
                try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                    while (rs.next()) {
                        ++count1;
                    }
                }
                return count1;
            });
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int count = (Integer)runner.run(transaction -> {
                int count1 = 0;
                try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                    while (rs.next()) {
                        ++count1;
                    }
                }
                return count1;
            });
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadRow() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            Struct row = (Struct)runner.run(transaction -> transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR")));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadRowUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            Struct row = (Struct)runner.run(transaction -> transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR")));
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionUpdate() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            long count = (Long)runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Truth.assertThat((Long)count).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionBatchUpdate() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            long[] count = (long[])runner.run(transaction -> transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT), new Options.UpdateOption[0]));
            Truth.assertThat((Integer)count.length).isEqualTo((Object)1);
            Truth.assertThat((Long)count[0]).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionBuffer() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
                return null;
            });
            Truth.assertThat((Comparable)runner.getCommitTimestamp()).isNotNull();
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionSelectInvalidatedDuringTransaction() {
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                private int attempt = 0;

                public Integer run(TransactionContext transaction) throws Exception {
                    ++this.attempt;
                    int count = 0;
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Truth.assertThat((Integer)count).isEqualTo((Object)2);
                    if (this.attempt == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                    var4_4 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var4_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var4_4 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var4_4.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    return this.attempt;
                }
            });
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadInvalidatedDuringTransaction() {
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                private int attempt = 0;

                public Integer run(TransactionContext transaction) throws Exception {
                    ++this.attempt;
                    int count = 0;
                    try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Truth.assertThat((Integer)count).isEqualTo((Object)2);
                    if (this.attempt == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                    var4_4 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var4_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var4_4 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var4_4.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    return this.attempt;
                }
            });
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadUsingIndexInvalidatedDuringTransaction() {
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                private int attempt = 0;

                public Integer run(TransactionContext transaction) throws Exception {
                    ++this.attempt;
                    int count = 0;
                    try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Truth.assertThat((Integer)count).isEqualTo((Object)2);
                    if (this.attempt == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                    var4_4 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var4_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var4_4 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var4_4.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    return this.attempt;
                }
            });
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadRowInvalidatedDuringTransaction() {
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                private int attempt = 0;

                public Integer run(TransactionContext transaction) throws Exception {
                    ++this.attempt;
                    Struct row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
                    if (this.attempt == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    return this.attempt;
                }
            });
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void readWriteTransactionReadRowUsingIndexInvalidatedDuringTransaction() {
        try {
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            int attempts = (Integer)runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                private int attempt = 0;

                public Integer run(TransactionContext transaction) throws Exception {
                    ++this.attempt;
                    Struct row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
                    if (this.attempt == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    return this.attempt;
                }
            });
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadOnlySessionInPool() throws InterruptedException {
        SessionPoolOptions.Builder builder = SessionPoolOptions.newBuilder();
        if (this.failOnInvalidatedSession) {
            builder.setFailIfSessionNotFound();
        }
        Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setSessionPoolOption(builder.build()).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        RetryOnInvalidatedSessionTest.invalidateSessionPool(client, ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        int count = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerSelect() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int count = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerRead() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int count = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int count = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)count).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadRow() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            Struct row;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadRowUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            Struct row;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerUpdate() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.commitStats()});){
            long count;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    count = transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Assert.assertEquals((long)1L, (long)count);
            Assert.assertNotNull((Object)manager.getCommitResponse().getCommitStats());
            Assert.assertFalse((boolean)this.failOnInvalidatedSession);
        }
        catch (SessionNotFoundException e) {
            Assert.assertTrue((boolean)this.failOnInvalidatedSession);
        }
    }

    @Test
    public void transactionManagerAborted_thenSessionNotFoundOnBeginTransaction() throws InterruptedException {
        int attempt = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            long count;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    if (++attempt == 1) {
                        mockSpanner.abortNextStatement();
                    }
                    if (attempt == 2) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    count = transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Long)count).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
            Truth.assertThat((Integer)attempt).isAtLeast((Comparable)Integer.valueOf(3));
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerBatchUpdate() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            long[] count;
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    count = transaction.batchUpdate(Arrays.asList(UPDATE_STATEMENT), new Options.UpdateOption[0]);
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)count.length).isEqualTo((Object)1);
            Truth.assertThat((Long)count[0]).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerBuffer() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                transaction.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
                try {
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Comparable)manager.getCommitTimestamp()).isNotNull();
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerSelectInvalidatedDuringTransaction() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int attempts = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                int count = 0;
                try {
                    try (ResultSet rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Truth.assertThat((Integer)count).isEqualTo((Object)2);
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                    var7_11 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_11 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_11 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var7_11.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadInvalidatedDuringTransaction() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int attempts = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                int count = 0;
                try {
                    try (ResultSet rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Truth.assertThat((Integer)count).isEqualTo((Object)2);
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                    var7_11 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_11 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_11 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var7_11.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int attempts = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                int count = 0;
                try {
                    try (ResultSet rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);){
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    Truth.assertThat((Integer)count).isEqualTo((Object)2);
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    rs = transaction.readUsingIndex("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
                    var7_11 = null;
                    try {
                        while (rs.next()) {
                            ++count;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_11 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_11 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    var7_11.addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadRowInvalidatedDuringTransaction() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int attempts = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                try {
                    Struct row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    row = transaction.readRow("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void transactionManagerReadRowUsingIndexInvalidatedDuringTransaction() throws InterruptedException {
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            int attempts = 0;
            TransactionContext transaction = manager.begin();
            while (true) {
                ++attempts;
                try {
                    Struct row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    Truth.assertThat((Long)row.getLong(0)).isEqualTo((Object)1L);
                    if (attempts == 1) {
                        RetryOnInvalidatedSessionTest.invalidateSessionPool();
                    }
                    row = transaction.readRowUsingIndex("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR"));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempts).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void partitionedDml() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            Truth.assertThat((Long)client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void write() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            Timestamp timestamp = client.write(Arrays.asList(Mutation.delete((String)"FOO", (KeySet)KeySet.all())));
            Truth.assertThat((Comparable)timestamp).isNotNull();
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void writeAtLeastOnce() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            Timestamp timestamp = client.writeAtLeastOnce(Arrays.asList(Mutation.delete((String)"FOO", (KeySet)KeySet.all())));
            Truth.assertThat((Comparable)timestamp).isNotNull();
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void asyncRunnerSelect() throws InterruptedException {
        this.asyncRunner_withReadFunction(new Function<TransactionContext, AsyncResultSet>(){

            public AsyncResultSet apply(TransactionContext input) {
                return input.executeQueryAsync(SELECT1AND2, new Options.QueryOption[0]);
            }
        });
    }

    @Test
    public void asyncRunnerRead() throws InterruptedException {
        this.asyncRunner_withReadFunction(new Function<TransactionContext, AsyncResultSet>(){

            public AsyncResultSet apply(TransactionContext input) {
                return input.readAsync("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            }
        });
    }

    @Test
    public void asyncRunnerReadUsingIndex() throws InterruptedException {
        this.asyncRunner_withReadFunction(new Function<TransactionContext, AsyncResultSet>(){

            public AsyncResultSet apply(TransactionContext input) {
                return input.readUsingIndexAsync("FOO", "IDX", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRunner_withReadFunction(Function<TransactionContext, AsyncResultSet> readFunction) throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            final AtomicLong counter = new AtomicLong();
            ApiFuture count = runner.runAsync(txn -> {
                AsyncResultSet rs = (AsyncResultSet)readFunction.apply((Object)txn);
                ApiFuture fut = rs.setCallback((Executor)queryExecutor, new AsyncResultSet.ReadyCallback(){

                    public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case OK: {
                                    counter.incrementAndGet();
                                    break;
                                }
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                            }
                        }
                    }
                });
                return ApiFutures.transform((ApiFuture)fut, (ApiFunction)new ApiFunction<Void, Long>(){

                    public Long apply(Void input) {
                        return counter.get();
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }, (Executor)executor);
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)count))).isEqualTo((Object)2);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncRunnerReadRow() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            ApiFuture row = runner.runAsync(txn -> txn.readRowAsync("FOO", Key.of((Object[])new Object[0]), Arrays.asList("BAR")), (Executor)executor);
            Truth.assertThat((Long)((Struct)SpannerApiFutures.get((ApiFuture)row)).getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void asyncRunnerReadRowUsingIndex() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            ApiFuture row = runner.runAsync(txn -> txn.readRowUsingIndexAsync("FOO", "IDX", Key.of((Object[])new Object[0]), Arrays.asList("BAR")), (Executor)executor);
            Truth.assertThat((Long)((Struct)SpannerApiFutures.get((ApiFuture)row)).getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void asyncRunnerUpdate() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            ApiFuture count = runner.runAsync(txn -> txn.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]), (Executor)executor);
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)count))).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void asyncRunnerBatchUpdate() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            ApiFuture count = runner.runAsync(txn -> txn.batchUpdateAsync(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]), (Executor)executor);
            Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)count))).hasLength(2);
            Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)count))).asList().containsExactly(new Object[]{1L, 1L});
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void asyncRunnerBuffer() throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try {
            AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
            ApiFuture res = runner.runAsync(txn -> {
                txn.buffer(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("BAR").to(1L)).build());
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)res)).isNull();
            Truth.assertThat((Comparable)((Comparable)SpannerApiFutures.get((ApiFuture)runner.getCommitTimestamp()))).isNotNull();
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    @Test
    public void asyncTransactionManagerAsyncSelect() throws InterruptedException {
        this.asyncTransactionManager_readAsync(new Function<TransactionContext, AsyncResultSet>(){

            public AsyncResultSet apply(TransactionContext input) {
                return input.executeQueryAsync(SELECT1AND2, new Options.QueryOption[0]);
            }
        });
    }

    @Test
    public void asyncTransactionManagerAsyncRead() throws InterruptedException {
        this.asyncTransactionManager_readAsync(new Function<TransactionContext, AsyncResultSet>(){

            public AsyncResultSet apply(TransactionContext input) {
                return input.readAsync("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            }
        });
    }

    @Test
    public void asyncTransactionManagerAsyncReadUsingIndex() throws InterruptedException {
        this.asyncTransactionManager_readAsync(new Function<TransactionContext, AsyncResultSet>(){

            public AsyncResultSet apply(TransactionContext input) {
                return input.readUsingIndexAsync("FOO", "idx", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransactionManager_readAsync(final Function<TransactionContext, AsyncResultSet> fn) throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        final ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    final AtomicLong counter = new AtomicLong();
                    AsyncTransactionManager.AsyncTransactionStep count = context.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Long>(){

                        public ApiFuture<Long> apply(TransactionContext txn, Void input) throws Exception {
                            AsyncResultSet rs = (AsyncResultSet)fn.apply((Object)txn);
                            ApiFuture fut = rs.setCallback((Executor)queryExecutor, new AsyncResultSet.ReadyCallback(){

                                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                                    while (true) {
                                        switch (resultSet.tryNext()) {
                                            case OK: {
                                                counter.incrementAndGet();
                                                break;
                                            }
                                            case DONE: {
                                                return AsyncResultSet.CallbackResponse.DONE;
                                            }
                                            case NOT_READY: {
                                                return AsyncResultSet.CallbackResponse.CONTINUE;
                                            }
                                        }
                                    }
                                }
                            });
                            return ApiFutures.transform((ApiFuture)fut, (ApiFunction)new ApiFunction<Void, Long>(){

                                public Long apply(Void input) {
                                    return counter.get();
                                }
                            }, (Executor)MoreExecutors.directExecutor());
                        }
                    }, (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = count.commitAsync();
                    Truth.assertThat((Comparable)((Comparable)SpannerApiFutures.get((ApiFuture)ts))).isNotNull();
                    Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)count))).isEqualTo((Object)2);
                    Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
                }
                catch (AbortedException e) {
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncTransactionManagerSelect() throws InterruptedException {
        this.asyncTransactionManager_readSync(new Function<TransactionContext, ResultSet>(){

            public ResultSet apply(TransactionContext input) {
                return input.executeQuery(SELECT1AND2, new Options.QueryOption[0]);
            }
        });
    }

    @Test
    public void asyncTransactionManagerRead() throws InterruptedException {
        this.asyncTransactionManager_readSync(new Function<TransactionContext, ResultSet>(){

            public ResultSet apply(TransactionContext input) {
                return input.read("FOO", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            }
        });
    }

    @Test
    public void asyncTransactionManagerReadUsingIndex() throws InterruptedException {
        this.asyncTransactionManager_readSync(new Function<TransactionContext, ResultSet>(){

            public ResultSet apply(TransactionContext input) {
                return input.readUsingIndex("FOO", "idx", KeySet.all(), Arrays.asList("BAR"), new Options.ReadOption[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransactionManager_readSync(final Function<TransactionContext, ResultSet> fn) throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep count = context.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Long>(){

                        public ApiFuture<Long> apply(TransactionContext txn, Void input) throws Exception {
                            long counter = 0L;
                            try (ResultSet rs = (ResultSet)fn.apply((Object)txn);){
                                while (rs.next()) {
                                    ++counter;
                                }
                            }
                            return ApiFutures.immediateFuture((Object)counter);
                        }
                    }, (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = count.commitAsync();
                    Truth.assertThat((Comparable)((Comparable)SpannerApiFutures.get((ApiFuture)ts))).isNotNull();
                    Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)count))).isEqualTo((Object)2);
                    Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
                }
                catch (AbortedException e) {
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncTransactionManagerReadRow() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction(new Function<TransactionContext, ApiFuture<Struct>>(){

            public ApiFuture<Struct> apply(TransactionContext input) {
                return ApiFutures.immediateFuture((Object)input.readRow("FOO", Key.of((Object[])new Object[]{"foo"}), Arrays.asList("BAR")));
            }
        });
    }

    @Test
    public void asyncTransactionManagerReadRowUsingIndex() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction(new Function<TransactionContext, ApiFuture<Struct>>(){

            public ApiFuture<Struct> apply(TransactionContext input) {
                return ApiFutures.immediateFuture((Object)input.readRowUsingIndex("FOO", "idx", Key.of((Object[])new Object[]{"foo"}), Arrays.asList("BAR")));
            }
        });
    }

    @Test
    public void asyncTransactionManagerReadRowAsync() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction(new Function<TransactionContext, ApiFuture<Struct>>(){

            public ApiFuture<Struct> apply(TransactionContext input) {
                return input.readRowAsync("FOO", Key.of((Object[])new Object[]{"foo"}), Arrays.asList("BAR"));
            }
        });
    }

    @Test
    public void asyncTransactionManagerReadRowUsingIndexAsync() throws InterruptedException {
        this.asyncTransactionManager_readRowFunction(new Function<TransactionContext, ApiFuture<Struct>>(){

            public ApiFuture<Struct> apply(TransactionContext input) {
                return input.readRowUsingIndexAsync("FOO", "idx", Key.of((Object[])new Object[]{"foo"}), Arrays.asList("BAR"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransactionManager_readRowFunction(final Function<TransactionContext, ApiFuture<Struct>> fn) throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture context = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep row = context.then((AsyncTransactionManager.AsyncTransactionFunction)new AsyncTransactionManager.AsyncTransactionFunction<Void, Struct>(){

                        public ApiFuture<Struct> apply(TransactionContext txn, Void input) throws Exception {
                            return (ApiFuture)fn.apply((Object)txn);
                        }
                    }, (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = row.commitAsync();
                    Truth.assertThat((Comparable)((Comparable)SpannerApiFutures.get((ApiFuture)ts))).isNotNull();
                    Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)row)).isEqualTo((Object)((Struct.Builder)Struct.newBuilder().set("BAR").to(1L)).build());
                    Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
                }
                catch (AbortedException e) {
                    context = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
        finally {
            queryExecutor.shutdown();
        }
    }

    @Test
    public void asyncTransactionManagerUpdateAsync() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(new Function<TransactionContext, ApiFuture<Long>>(){

            public ApiFuture<Long> apply(TransactionContext input) {
                return input.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }
        }, 1L);
    }

    @Test
    public void asyncTransactionManagerUpdate() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(new Function<TransactionContext, ApiFuture<Long>>(){

            public ApiFuture<Long> apply(TransactionContext input) {
                return ApiFutures.immediateFuture((Object)input.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            }
        }, 1L);
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAsync() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(new Function<TransactionContext, ApiFuture<long[]>>(){

            public ApiFuture<long[]> apply(TransactionContext input) {
                return input.batchUpdateAsync(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
            }
        }, new long[]{1L, 1L});
    }

    @Test
    public void asyncTransactionManagerBatchUpdate() throws InterruptedException {
        this.asyncTransactionManager_updateFunction(new Function<TransactionContext, ApiFuture<long[]>>(){

            public ApiFuture<long[]> apply(TransactionContext input) {
                return ApiFutures.immediateFuture((Object)input.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]));
            }
        }, new long[]{1L, 1L});
    }

    private <T> void asyncTransactionManager_updateFunction(final Function<TransactionContext, ApiFuture<T>> fn, T expected) throws InterruptedException {
        RetryOnInvalidatedSessionTest.invalidateSessionPool();
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep res = transaction.then(new AsyncTransactionManager.AsyncTransactionFunction<Void, T>(){

                        public ApiFuture<T> apply(TransactionContext txn, Void input) throws Exception {
                            return (ApiFuture)fn.apply((Object)txn);
                        }
                    }, (Executor)executor);
                    AsyncTransactionManager.CommitTimestampFuture ts = res.commitAsync();
                    Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)res)).isEqualTo(expected);
                    Truth.assertThat((Comparable)((Comparable)SpannerApiFutures.get((ApiFuture)ts))).isNotNull();
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isFalse();
        }
        catch (SessionNotFoundException e) {
            Truth.assertThat((Boolean)this.failOnInvalidatedSession).isTrue();
        }
    }

    private static final class ToLongTransformer
    implements Function<StructReader, Long> {
        private ToLongTransformer() {
        }

        public Long apply(StructReader input) {
            return input.getLong(0);
        }
    }
}

