/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.StandardBenchmarkMockServer;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.threeten.bp.Duration;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, warmups=0)
@Measurement(batchSize=1, iterations=1, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(batchSize=0, iterations=0)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class SessionPoolMaintainerBenchmark {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static final int HOLD_SESSION_TIME = 10;
    private static final int RND_WAIT_TIME_BETWEEN_REQUESTS = 100;
    private static final Random RND = new Random();

    @Benchmark
    public void read(MockServer server) throws Exception {
        int min = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        int max = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions();
        int totalQueries = max * 4;
        int parallelThreads = min;
        DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)min);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalQueries);
        for (int i = 0; i < totalQueries; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(100));
                try (ResultSet rs = client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        Thread.sleep(RND.nextInt(10));
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @Benchmark
    public void write(MockServer server) throws Exception {
        int min = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        int max = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions();
        int totalWrites = max * 4;
        int parallelThreads = max;
        DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)min);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalWrites);
        for (int i = 0; i < totalWrites; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(100));
                TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
                return (Long)runner.run(transaction -> transaction.executeUpdate(StandardBenchmarkMockServer.UPDATE_STATEMENT, new Options.UpdateOption[0]));
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @Benchmark
    public void readAndWrite(MockServer server) throws Exception {
        int i;
        int min = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        int max = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMaxSessions();
        int totalWrites = max * 2;
        int totalReads = max * 2;
        int parallelThreads = max;
        DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)min);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalReads + totalWrites);
        for (i = 0; i < totalWrites; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(100));
                TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
                return (Long)runner.run(transaction -> transaction.executeUpdate(StandardBenchmarkMockServer.UPDATE_STATEMENT, new Options.UpdateOption[0]));
            }));
        }
        for (i = 0; i < totalReads; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(100));
                try (ResultSet rs = client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        Thread.sleep(RND.nextInt(10));
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        Futures.allAsList(futures).get();
        service.shutdown();
    }

    @State(value=Scope.Thread)
    @AuxCounters(value=AuxCounters.Type.EVENTS)
    public static class MockServer {
        private StandardBenchmarkMockServer mockServer;
        private Spanner spanner;
        private DatabaseClientImpl client;
        @Param(value={"100"})
        long idleTimeout;

        public int numBatchCreateSessionsRpcs() {
            return this.mockServer.countRequests(BatchCreateSessionsRequest.class);
        }

        public int numDeleteSessionRpcs() {
            return this.mockServer.countRequests(DeleteSessionRequest.class);
        }

        public int numBeginTransactionRpcs() {
            return this.mockServer.countRequests(BeginTransactionRequest.class);
        }

        @Setup(value=Level.Invocation)
        public void setup() throws Exception {
            this.mockServer = new StandardBenchmarkMockServer();
            TransportChannelProvider channelProvider = this.mockServer.start();
            SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(SessionPoolMaintainerBenchmark.TEST_PROJECT)).setChannelProvider(channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setRemoveInactiveSessionAfter(Duration.ofMillis((long)this.idleTimeout)).setLoopFrequency(this.idleTimeout / 10L).build()).build();
            this.spanner = (Spanner)options.getService();
            this.client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)SessionPoolMaintainerBenchmark.TEST_PROJECT, (String)SessionPoolMaintainerBenchmark.TEST_INSTANCE, (String)SessionPoolMaintainerBenchmark.TEST_DATABASE));
            while (this.client.pool.getNumberOfSessionsInPool() < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions()) {
                Thread.sleep(1L);
            }
        }

        @TearDown(value=Level.Invocation)
        public void teardown() throws Exception {
            this.spanner.close();
            this.mockServer.shutdown();
        }
    }
}

