/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ForwardingApiFuture;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.truth.Truth;
import java.util.concurrent.CancellationException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerApiFuturesTest {
    @Test
    public void testGet() {
        ApiFuture fut = ApiFutures.immediateFuture((Object)1L);
        Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)fut))).isEqualTo((Object)1L);
    }

    @Test
    public void testGetNull() {
        try {
            SpannerApiFutures.get(null);
            Assert.fail((String)"Missing expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOrNull() {
        Truth.assertThat((Object)SpannerApiFutures.getOrNull((ApiFuture)null)).isNull();
    }

    @Test
    public void testGetSpannerException() {
        ApiFuture fut = ApiFutures.immediateFailedFuture((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.FAILED_PRECONDITION, (String)"test exception"));
        try {
            SpannerApiFutures.get((ApiFuture)fut);
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"test exception");
        }
    }

    @Test
    public void testGetOtherException() {
        ApiFuture fut = ApiFutures.immediateFailedFuture((Throwable)new RuntimeException("test runtime exception"));
        try {
            SpannerApiFutures.get((ApiFuture)fut);
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.UNKNOWN);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"test runtime exception");
        }
    }

    @Test
    public void testGetInterruptedException() {
        ForwardingApiFuture<Void> fut = new ForwardingApiFuture<Void>(ApiFutures.immediateFuture(null)){

            public Void get() throws InterruptedException {
                throw new InterruptedException("test interrupted exception");
            }
        };
        try {
            SpannerApiFutures.get((ApiFuture)fut);
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.CANCELLED);
            Truth.assertThat((String)e.getMessage()).doesNotContain((CharSequence)"test interrupted exception");
        }
    }

    @Test
    public void testGetCancellationException() {
        ForwardingApiFuture<Void> fut = new ForwardingApiFuture<Void>(ApiFutures.immediateFuture(null)){

            public Void get() throws InterruptedException {
                throw new CancellationException("test cancellation exception");
            }
        };
        try {
            SpannerApiFutures.get((ApiFuture)fut);
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.CANCELLED);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"test cancellation exception");
        }
    }
}

