/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class SpannerGaxRetryTest {
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final long UPDATE_COUNT = 1L;
    private static final MockSpannerServiceImpl.SimulatedExecutionTime ONE_SECOND = MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0);
    private static final StatusRuntimeException UNAVAILABLE = Status.UNAVAILABLE.withDescription("Retryable test exception.").asRuntimeException();
    private static final StatusRuntimeException FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private Spanner spanner;
    private DatabaseClient client;
    private Spanner spannerWithTimeout;
    private DatabaseClient clientWithTimeout;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws Exception {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setWriteSessionsFraction(0.0f).build());
        this.spanner = (Spanner)builder.build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        final RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)75L)).setMaxRpcTimeout(Duration.ofMillis((long)75L)).setMaxAttempts(3).setTotalTimeout(Duration.ofMillis((long)200L)).build();
        RetrySettings commitRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setMaxAttempts(1).setTotalTimeout(Duration.ofMillis((long)20000L)).build();
        builder.getSpannerStubSettingsBuilder().applyToAllUnaryMethods(new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

            public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                input.setRetrySettings(retrySettings);
                return null;
            }
        });
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetrySettings(retrySettings);
        builder.getSpannerStubSettingsBuilder().commitSettings().setRetrySettings(commitRetrySettings);
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetrySettings(retrySettings);
        builder.getSpannerStubSettingsBuilder().streamingReadSettings().setRetrySettings(retrySettings);
        this.spannerWithTimeout = (Spanner)builder.build().getService();
        this.clientWithTimeout = this.spannerWithTimeout.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
    }

    @After
    public void tearDown() {
        this.spannerWithTimeout.close();
        this.spanner.close();
    }

    private void warmUpSessionPool(DatabaseClient client) {
        block2: for (int i = 0; i < 10; ++i) {
            int retryCount = 0;
            while (true) {
                try {
                    TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
                    long updateCount = (Long)runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
                    MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    continue block2;
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED && ++retryCount <= 10) continue;
                    throw e;
                }
                break;
            }
        }
    }

    @Test
    public void singleUseTimeout() {
        mockSpanner.setBatchCreateSessionsExecutionTime(ONE_SECOND);
        try (ResultSet rs = this.clientWithTimeout.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void singleUseUnavailable() {
        mockSpanner.addException((Exception)UNAVAILABLE);
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseNonRetryableError() {
        mockSpanner.addException((Exception)FAILED_PRECONDITION);
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void singleUseNonRetryableErrorOnNext() {
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            mockSpanner.addException((Exception)FAILED_PRECONDITION);
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void singleUseInternal() {
        mockSpanner.addException(new IllegalArgumentException());
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void singleUseReadOnlyTransactionTimeout() {
        mockSpanner.setBatchCreateSessionsExecutionTime(ONE_SECOND);
        try (ResultSet rs = this.clientWithTimeout.singleUseReadOnlyTransaction().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void singleUseReadOnlyTransactionUnavailable() {
        mockSpanner.addException((Exception)UNAVAILABLE);
        try (ResultSet rs = this.client.singleUseReadOnlyTransaction().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            while (rs.next()) {
            }
        }
    }

    @Test
    public void singleUseExecuteStreamingSqlTimeout() {
        try (ResultSet rs = this.clientWithTimeout.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            mockSpanner.setExecuteStreamingSqlExecutionTime(ONE_SECOND);
            while (rs.next()) {
                Assert.fail((String)"Expected exception");
            }
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void singleUseExecuteStreamingSqlUnavailable() {
        try (ResultSet rs = this.client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
            mockSpanner.addException((Exception)UNAVAILABLE);
            while (rs.next()) {
            }
        }
    }

    @Test
    public void readWriteTransactionTimeout() {
        mockSpanner.setBeginTransactionExecutionTime(ONE_SECOND);
        try {
            TransactionRunner runner = this.clientWithTimeout.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> null);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void readWriteTransactionUnavailable() {
        this.warmUpSessionPool(this.client);
        mockSpanner.addException((Exception)UNAVAILABLE);
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        long updateCount = (Long)runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
    }

    @Test
    public void readWriteTransactionStatementAborted() {
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempts = new AtomicInteger();
        long updateCount = (Long)runner.run(transaction -> {
            if (attempts.getAndIncrement() == 0) {
                mockSpanner.abortNextStatement();
            }
            return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        });
        MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        MatcherAssert.assertThat((Object)attempts.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void readWriteTransactionCommitAborted() {
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicInteger attempts = new AtomicInteger();
        long updateCount = (Long)runner.run(transaction -> {
            long res = transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            if (attempts.getAndIncrement() == 0) {
                mockSpanner.abortTransaction(transaction);
            }
            return res;
        });
        MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        MatcherAssert.assertThat((Object)attempts.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test(expected=Exception.class)
    public void readWriteTransactionCheckedException() {
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            throw new Exception("test");
        });
    }

    @Test(expected=SpannerException.class)
    public void readWriteTransactionUncheckedException() {
        TransactionRunner runner = this.client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"test");
        });
    }

    @Test
    public void transactionManagerTimeout() {
        mockSpanner.setExecuteSqlExecutionTime(ONE_SECOND);
        try (TransactionManager txManager = this.clientWithTimeout.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext tx = txManager.begin();
            while (true) {
                try {
                    MatcherAssert.assertThat((Object)tx.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    txManager.commit();
                }
                catch (AbortedException e) {
                    tx = txManager.resetForRetry();
                    continue;
                }
                break;
            }
            Assert.fail((String)"missing DEADLINE_EXCEEDED exception");
        }
        catch (SpannerException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.DEADLINE_EXCEEDED)));
        }
    }

    @Test
    public void transactionManagerUnavailable() {
        this.warmUpSessionPool(this.client);
        mockSpanner.addException((Exception)UNAVAILABLE);
        try (TransactionManager txManager = this.client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext tx = txManager.begin();
            while (true) {
                try {
                    MatcherAssert.assertThat((Object)tx.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    txManager.commit();
                }
                catch (AbortedException e) {
                    tx = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }
}

