/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceRpc;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SpannerImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SpannerOptions spannerOptions;
    private SpannerImpl impl;
    @Captor
    ArgumentCaptor<Map<SpannerRpc.Option, Object>> options;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getPrefetchChunks()).thenReturn((Object)1);
        Mockito.when((Object)this.spannerOptions.getRetrySettings()).thenReturn((Object)RetrySettings.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getClock()).thenReturn((Object)NanoClock.getDefaultClock());
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(Collections.emptyMap());
        this.impl = new SpannerImpl(this.rpc, this.spannerOptions);
    }

    @After
    public void teardown() {
        this.impl.close();
    }

    @Test
    public void getDbclientAgainGivesSame() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(labels);
        String dbName = "projects/p1/instances/i1/databases/d1";
        DatabaseId db = DatabaseId.of((String)dbName);
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)GrpcTransportOptions.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)SessionPoolOptions.newBuilder().setMinSessions(0).build());
        DatabaseClient databaseClient = this.impl.getDatabaseClient(db);
        DatabaseClient databaseClient1 = this.impl.getDatabaseClient(db);
        Truth.assertThat((Object)databaseClient1).isSameInstanceAs((Object)databaseClient);
    }

    @Test
    public void queryOptions() {
        ExecuteSqlRequest.QueryOptions queryOptions = ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("2").build();
        ExecuteSqlRequest.QueryOptions defaultOptions = ExecuteSqlRequest.QueryOptions.getDefaultInstance();
        DatabaseId db = DatabaseId.of((String)"p", (String)"i", (String)"d");
        DatabaseId otherDb = DatabaseId.of((String)"p", (String)"i", (String)"other");
        SpannerOptions optionsWithQueryOptions = new SpannerOptions.Builder(((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).build()){

            ExecuteSqlRequest.QueryOptions getEnvironmentQueryOptions() {
                return ExecuteSqlRequest.QueryOptions.getDefaultInstance();
            }
        }.setDefaultQueryOptions(db, queryOptions).build();
        SpannerOptions optionsWithoutQueryOptions = new SpannerOptions.Builder(((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)NoCredentials.getInstance())).build()){

            ExecuteSqlRequest.QueryOptions getEnvironmentQueryOptions() {
                return ExecuteSqlRequest.QueryOptions.getDefaultInstance();
            }
        }.build();
        try (SpannerImpl implWithQueryOptions = new SpannerImpl(this.rpc, optionsWithQueryOptions);
             SpannerImpl implWithoutQueryOptions = new SpannerImpl(this.rpc, optionsWithoutQueryOptions);){
            Truth.assertThat((Object)implWithQueryOptions.getDefaultQueryOptions(db)).isEqualTo((Object)queryOptions);
            Truth.assertThat((Object)implWithQueryOptions.getDefaultQueryOptions(otherDb)).isEqualTo((Object)defaultOptions);
            Truth.assertThat((Object)implWithoutQueryOptions.getDefaultQueryOptions(db)).isEqualTo((Object)defaultOptions);
            Truth.assertThat((Object)implWithoutQueryOptions.getDefaultQueryOptions(otherDb)).isEqualTo((Object)defaultOptions);
        }
    }

    @Test
    public void getDbclientAfterCloseThrows() {
        SpannerImpl imp = new SpannerImpl(this.rpc, this.spannerOptions);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("env", "dev");
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(labels);
        String dbName = "projects/p1/instances/i1/databases/d1";
        DatabaseId db = DatabaseId.of((String)dbName);
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)GrpcTransportOptions.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)SessionPoolOptions.newBuilder().build());
        imp.close();
        try {
            imp.getDatabaseClient(db);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Cloud Spanner client has been closed");
        }
    }

    @Test
    public void testSpannerClosed() {
        SpannerOptions options = this.createSpannerOptions();
        Spanner spanner1 = (Spanner)options.getService();
        Spanner spanner2 = (Spanner)options.getService();
        ServiceRpc rpc1 = options.getRpc();
        ServiceRpc rpc2 = options.getRpc();
        MatcherAssert.assertThat((Object)(spanner1 == spanner2 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(rpc1 == rpc2 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        spanner1.close();
        Spanner spanner3 = (Spanner)options.getService();
        MatcherAssert.assertThat((Object)(spanner1 == spanner3 ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
        ServiceRpc rpc3 = options.getRpc();
        MatcherAssert.assertThat((Object)(rpc1 == rpc3 ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
        options = options.toBuilder().build();
        Spanner spanner4 = (Spanner)options.getService();
        ServiceRpc rpc4 = options.getRpc();
        MatcherAssert.assertThat((Object)(spanner4 == spanner3 ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)(rpc4 == rpc3 ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
        Spanner spanner5 = (Spanner)options.getService();
        ServiceRpc rpc5 = options.getRpc();
        MatcherAssert.assertThat((Object)(spanner4 == spanner5 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(rpc4 == rpc5 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        spanner3.close();
        spanner4.close();
    }

    @Test
    public void testClientId() {
        String dbName = String.format("projects/p1/instances/i1/databases/%s", UUID.randomUUID().toString());
        DatabaseId db = DatabaseId.of((String)dbName);
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)GrpcTransportOptions.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)SessionPoolOptions.newBuilder().setMinSessions(0).build());
        DatabaseClientImpl databaseClient = (DatabaseClientImpl)this.impl.getDatabaseClient(db);
        Truth.assertThat((String)databaseClient.clientId).isEqualTo((Object)"client-1");
        DatabaseClientImpl databaseClient1 = (DatabaseClientImpl)this.impl.getDatabaseClient(db);
        Truth.assertThat((String)databaseClient1.clientId).isEqualTo((Object)databaseClient.clientId);
        String dbName2 = String.format("projects/p1/instances/i1/databases/%s", UUID.randomUUID().toString());
        DatabaseId db2 = DatabaseId.of((String)dbName2);
        DatabaseClientImpl databaseClient2 = (DatabaseClientImpl)this.impl.getDatabaseClient(db2);
        Truth.assertThat((String)databaseClient2.clientId).isEqualTo((Object)"client-1");
        databaseClient.pool.setResourceNotFoundException((SpannerException.ResourceNotFoundException)new DatabaseNotFoundException(SpannerException.DoNotConstructDirectly.ALLOWED, "not found", null, null));
        DatabaseClientImpl revalidated = (DatabaseClientImpl)this.impl.getDatabaseClient(db);
        Truth.assertThat((Object)revalidated).isNotSameInstanceAs((Object)databaseClient);
        Truth.assertThat((String)revalidated.clientId).isEqualTo((Object)databaseClient.clientId);
        revalidated.pool.setResourceNotFoundException((SpannerException.ResourceNotFoundException)new DatabaseNotFoundException(SpannerException.DoNotConstructDirectly.ALLOWED, "not found", null, null));
        DatabaseClientImpl revalidated2 = (DatabaseClientImpl)this.impl.getDatabaseClient(db);
        Truth.assertThat((Object)revalidated2).isNotSameInstanceAs((Object)revalidated);
        Truth.assertThat((String)revalidated2.clientId).isEqualTo((Object)revalidated.clientId);
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p1")).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseClientImpl databaseClient3 = (DatabaseClientImpl)spanner.getDatabaseClient(db);
            Truth.assertThat((String)databaseClient3.clientId).isEqualTo((Object)"client-2");
        }
    }

    @Test
    public void testClosedException() {
        SpannerImpl spanner = new SpannerImpl(this.rpc, this.spannerOptions);
        Truth.assertThat((Boolean)spanner.isClosed()).isFalse();
        this.closeSpannerAndIncludeStacktrace((Spanner)spanner);
        Truth.assertThat((Boolean)spanner.isClosed()).isTrue();
        try {
            spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            Assert.fail((String)"missing expected exception");
        }
        catch (IllegalStateException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerImpl.ClosedException.class);
            StringWriter sw = new StringWriter();
            e.getCause().printStackTrace(new PrintWriter(sw));
            Truth.assertThat((String)sw.toString()).contains((CharSequence)"closeSpannerAndIncludeStacktrace");
        }
    }

    private void closeSpannerAndIncludeStacktrace(Spanner spanner) {
        spanner.close();
    }

    private SpannerOptions createSpannerOptions() {
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setCredentials((Credentials)NoCredentials.getInstance())).build();
    }
}

