/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;

class StandardBenchmarkMockServer {
    private static final int NETWORK_LATENCY_TIME = 10;
    private static final int BATCH_CREATE_SESSIONS_MIN_TIME = 10;
    private static final int BATCH_CREATE_SESSIONS_RND_TIME = 10;
    private static final int BEGIN_TRANSACTION_MIN_TIME = 1;
    private static final int BEGIN_TRANSACTION_RND_TIME = 1;
    private static final int COMMIT_TRANSACTION_MIN_TIME = 5;
    private static final int COMMIT_TRANSACTION_RND_TIME = 5;
    private static final int ROLLBACK_TRANSACTION_MIN_TIME = 1;
    private static final int ROLLBACK_TRANSACTION_RND_TIME = 1;
    private static final int EXECUTE_STREAMING_SQL_MIN_TIME = 10;
    private static final int EXECUTE_STREAMING_SQL_RND_TIME = 10;
    private static final int EXECUTE_SQL_MIN_TIME = 10;
    private static final int EXECUTE_SQL_RND_TIME = 10;
    static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    static final Statement INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
    static final long UPDATE_COUNT = 1L;
    static final Statement SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
    private static final ResultSetMetadata SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final ResultSet SELECT1_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    static final Statement SELECT_RANDOM = Statement.of((String)"SELECT * FROM RANDOM_TABLE");
    private static final ResultSet SELECT_RANDOM_RESULTSET = new RandomResultSetGenerator(100).generate();
    private MockSpannerServiceImpl mockSpanner;
    private Server server;
    private LocalChannelProvider channelProvider;

    StandardBenchmarkMockServer() {
    }

    TransportChannelProvider start() throws IOException {
        this.mockSpanner = new MockSpannerServiceImpl();
        this.mockSpanner.setAbortProbability(0.0);
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM, SELECT_RANDOM_RESULTSET));
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        this.mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(20, 10));
        this.mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(11, 1));
        this.mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(15, 5));
        this.mockSpanner.setRollbackExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(11, 1));
        this.mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(20, 10));
        this.mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(20, 10));
        String uniqueName = InProcessServerBuilder.generateName();
        this.server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).addService((BindableService)this.mockSpanner)).build().start();
        this.channelProvider = LocalChannelProvider.create((String)uniqueName);
        return this.channelProvider;
    }

    void shutdown() throws InterruptedException {
        this.server.shutdown();
        this.server.awaitTermination();
    }

    MockSpannerServiceImpl getMockSpanner() {
        return this.mockSpanner;
    }

    int countRequests(final Class<? extends AbstractMessage> type) {
        return Collections2.filter(this.mockSpanner.getRequests(), (Predicate)new Predicate<AbstractMessage>(){

            public boolean apply(AbstractMessage input) {
                return input.getClass().equals(type);
            }
        }).size();
    }
}

