/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.protobuf.ByteString;
import com.google.rpc.Status;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import java.util.Arrays;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class TransactionContextImplTest {
    @Test(expected=AbortedException.class)
    public void batchDmlAborted() {
        this.batchDml(10);
    }

    @Test(expected=SpannerBatchUpdateException.class)
    public void batchDmlException() {
        this.batchDml(9);
    }

    @Test
    public void testReturnCommitStats() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"test");
        ByteString transactionId = ByteString.copyFromUtf8((String)"test");
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        Mockito.when((Object)rpc.commitAsync((CommitRequest)Matchers.any(CommitRequest.class), Matchers.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)CommitResponse.getDefaultInstance()));
        try (TransactionRunnerImpl.TransactionContextImpl context = ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(session)).setRpc(rpc)).setTransactionId(transactionId).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()})).build();){
            context.commitAsync();
            CommitRequest request = CommitRequest.newBuilder().setReturnCommitStats(true).setSession(session.getName()).setTransactionId(transactionId).build();
            ((SpannerRpc)Mockito.verify((Object)rpc)).commitAsync((CommitRequest)Mockito.eq((Object)request), Matchers.anyMap());
        }
    }

    private void batchDml(int status) {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"test");
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        ExecuteBatchDmlResponse response = ExecuteBatchDmlResponse.newBuilder().setStatus(Status.newBuilder().setCode(status).build()).build();
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1");
        Mockito.when((Object)rpc.executeBatchDml((ExecuteBatchDmlRequest)Mockito.any(ExecuteBatchDmlRequest.class), Mockito.anyMap())).thenReturn((Object)response);
        try (TransactionRunnerImpl.TransactionContextImpl impl = ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(session)).setRpc(rpc)).setTransactionId(ByteString.copyFromUtf8((String)"test")).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0])).build();){
            impl.batchUpdate(Arrays.asList(statement), new Options.UpdateOption[0]);
        }
    }
}

