/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BooleanConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.BooleanConverter.class);
        MatcherAssert.assertThat((Object)allowedValues, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ClientSideStatementValueConverters.BooleanConverter converter = new ClientSideStatementValueConverters.BooleanConverter(allowedValues);
        MatcherAssert.assertThat((Object)converter.convert("true"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)converter.convert("TRUE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)converter.convert("True"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)converter.convert("false"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE)));
        MatcherAssert.assertThat((Object)converter.convert("FALSE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE)));
        MatcherAssert.assertThat((Object)converter.convert("False"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE)));
        MatcherAssert.assertThat((Object)converter.convert(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert(" "), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("random string"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

