/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractConnectionImplTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionImplTest;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.TransactionMode;
import java.util.concurrent.TimeUnit;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class ConnectionImplAutocommitReadOnlyTest {

    public static class ConnectionImplAutocommitReadOnlyAfterSetReadOnlyMaxStalenessTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=TRUE;");
            connection.setReadOnly(true);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            TimestampBound staleness = TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS);
            this.log("SET READ_ONLY_STALENESS='" + ReadOnlyStalenessUtil.timestampBoundToString((TimestampBound)staleness) + "';");
            connection.setReadOnlyStaleness(staleness);
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(StatementParser.StatementType type) {
            return type == StatementParser.StatementType.CLIENT_SIDE || type == StatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadOnlyAfterTemporaryTransactionTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=TRUE;");
            connection.setReadOnly(true);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("BEGIN TRANSACTION;");
            connection.beginTransaction();
            this.log("SELECT 1 AS TEST;");
            connection.execute(Statement.of((String)"SELECT 1 AS TEST")).getResultSet().next();
            this.log("COMMIT;");
            connection.commit();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return true;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(StatementParser.StatementType type) {
            return type == StatementParser.StatementType.CLIENT_SIDE || type == StatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadOnlyAfterBeginTransactionTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=TRUE;");
            connection.setReadOnly(true);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("BEGIN TRANSACTION;");
            connection.beginTransaction();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return false;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return false;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return false;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return mode == TransactionMode.READ_ONLY_TRANSACTION;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return true;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return mode == TimestampBound.Mode.STRONG || mode == TimestampBound.Mode.EXACT_STALENESS || mode == TimestampBound.Mode.READ_TIMESTAMP;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return true;
        }

        @Override
        boolean isRollbackAllowed() {
            return true;
        }

        @Override
        boolean expectedIsInTransaction() {
            return true;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(StatementParser.StatementType type) {
            return type == StatementParser.StatementType.CLIENT_SIDE || type == StatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadOnlyAfterSelectAndResultSetNextTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=TRUE;");
            connection.setReadOnly(true);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("SELECT 1 AS TEST;");
            connection.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]).next();
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return true;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(StatementParser.StatementType type) {
            return type == StatementParser.StatementType.CLIENT_SIDE || type == StatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadOnlyAfterSelectTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=TRUE;");
            connection.setReadOnly(true);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            this.log("SELECT 1 AS TEST;");
            connection.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]);
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return true;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(StatementParser.StatementType type) {
            return type == StatementParser.StatementType.CLIENT_SIDE || type == StatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }

    public static class ConnectionImplAutocommitReadOnlyNoActionsTest
    extends AbstractConnectionImplTest {
        @Override
        Connection getConnection() {
            this.log("NEW_CONNECTION;");
            ConnectionImpl connection = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database").build());
            this.log("SET READONLY=TRUE;");
            connection.setReadOnly(true);
            this.log("SET AUTOCOMMIT=TRUE;");
            connection.setAutocommit(true);
            return connection;
        }

        @Override
        boolean isSelectAllowedAfterBeginTransaction() {
            return true;
        }

        @Override
        boolean isDmlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isDdlAllowedAfterBeginTransaction() {
            return false;
        }

        @Override
        boolean isSetAutocommitAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyAllowed() {
            return true;
        }

        @Override
        boolean isBeginTransactionAllowed() {
            return true;
        }

        @Override
        boolean isSetTransactionModeAllowed(TransactionMode mode) {
            return false;
        }

        @Override
        boolean isGetTransactionModeAllowed() {
            return false;
        }

        @Override
        boolean isSetAutocommitDmlModeAllowed() {
            return false;
        }

        @Override
        boolean isGetAutocommitDmlModeAllowed() {
            return true;
        }

        @Override
        boolean isSetReadOnlyStalenessAllowed(TimestampBound.Mode mode) {
            return true;
        }

        @Override
        boolean isGetReadOnlyStalenessAllowed() {
            return true;
        }

        @Override
        boolean isCommitAllowed() {
            return false;
        }

        @Override
        boolean isRollbackAllowed() {
            return false;
        }

        @Override
        boolean expectedIsInTransaction() {
            return false;
        }

        @Override
        boolean expectedIsTransactionStarted() {
            return false;
        }

        @Override
        boolean isGetReadTimestampAllowed() {
            return false;
        }

        @Override
        boolean isGetCommitTimestampAllowed() {
            return false;
        }

        @Override
        boolean isExecuteAllowed(StatementParser.StatementType type) {
            return type == StatementParser.StatementType.CLIENT_SIDE || type == StatementParser.StatementType.QUERY;
        }

        @Override
        boolean isWriteAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDmlAllowed() {
            return false;
        }

        @Override
        boolean isStartBatchDdlAllowed() {
            return false;
        }

        @Override
        boolean isRunBatchAllowed() {
            return false;
        }

        @Override
        boolean isAbortBatchAllowed() {
            return false;
        }
    }
}

