/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.protobuf.Duration;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class ConnectionStatementExecutorTest {
    private ConnectionImpl connection;
    private ConnectionStatementExecutorImpl subject;

    @Before
    public void createSubject() {
        this.connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)this.connection.getAutocommitDmlMode()).thenReturn((Object)AutocommitDmlMode.TRANSACTIONAL);
        Mockito.when((Object)this.connection.getReadOnlyStaleness()).thenReturn((Object)TimestampBound.strong());
        this.subject = new ConnectionStatementExecutorImpl(this.connection);
    }

    @Test
    public void testGetConnection() {
        MatcherAssert.assertThat((Object)this.subject.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connection)));
    }

    @Test
    public void testStatementBeginTransaction() {
        this.subject.statementBeginTransaction();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).beginTransaction();
    }

    @Test
    public void testStatementCommit() {
        this.subject.statementCommit();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).commit();
    }

    @Test
    public void testStatementGetAutocommit() {
        this.subject.statementShowAutocommit();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).isAutocommit();
    }

    @Test
    public void testStatementGetAutocommitDmlMode() {
        this.subject.statementShowAutocommitDmlMode();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).getAutocommitDmlMode();
    }

    @Test
    public void testStatementGetCommitTimestamp() {
        this.subject.statementShowCommitTimestamp();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).getCommitTimestampOrNull();
    }

    @Test
    public void testStatementGetReadOnly() {
        this.subject.statementShowReadOnly();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).isReadOnly();
    }

    @Test
    public void testStatementGetReadOnlyStaleness() {
        this.subject.statementShowReadOnlyStaleness();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).getReadOnlyStaleness();
    }

    @Test
    public void testStatementGetOptimizerVersion() {
        this.subject.statementShowOptimizerVersion();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).getOptimizerVersion();
    }

    @Test
    public void testStatementGetReadTimestamp() {
        this.subject.statementShowReadTimestamp();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).getReadTimestampOrNull();
    }

    @Test
    public void testStatementGetStatementTimeout() {
        this.subject.statementSetStatementTimeout(Duration.newBuilder().setSeconds(1L).build());
        Mockito.when((Object)this.connection.hasStatementTimeout()).thenReturn((Object)true);
        this.subject.statementShowStatementTimeout();
        ((ConnectionImpl)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.atLeastOnce())).getStatementTimeout((TimeUnit)((Object)Matchers.any(TimeUnit.class)));
        this.subject.statementSetStatementTimeout(Duration.getDefaultInstance());
        Mockito.when((Object)this.connection.hasStatementTimeout()).thenReturn((Object)false);
    }

    @Test
    public void testStatementRollback() {
        this.subject.statementRollback();
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).rollback();
    }

    @Test
    public void testStatementSetAutocommit() {
        this.subject.statementSetAutocommit(Boolean.TRUE);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setAutocommit(true);
        this.subject.statementSetAutocommit(Boolean.FALSE);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setAutocommit(false);
    }

    @Test
    public void testStatementSetAutocommitDmlMode() {
        this.subject.statementSetAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
        this.subject.statementSetAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setAutocommitDmlMode(AutocommitDmlMode.TRANSACTIONAL);
    }

    @Test
    public void testStatementSetReadOnly() {
        this.subject.statementSetReadOnly(Boolean.TRUE);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnly(true);
        this.subject.statementSetReadOnly(Boolean.FALSE);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnly(false);
    }

    @Test
    public void testStatementSetReadOnlyStaleness() {
        this.subject.statementSetReadOnlyStaleness(TimestampBound.strong());
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnlyStaleness(TimestampBound.strong());
        this.subject.statementSetReadOnlyStaleness(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-31T10:11:12.123Z")));
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnlyStaleness(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-31T10:11:12.123Z")));
        this.subject.statementSetReadOnlyStaleness(TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-31T10:11:12.123Z")));
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnlyStaleness(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-31T10:11:12.123Z")));
        this.subject.statementSetReadOnlyStaleness(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnlyStaleness(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
        this.subject.statementSetReadOnlyStaleness(TimestampBound.ofMaxStaleness((long)20L, (TimeUnit)TimeUnit.MILLISECONDS));
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setReadOnlyStaleness(TimestampBound.ofMaxStaleness((long)20L, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Test
    public void testStatementSetOptimizerVersion() {
        this.subject.statementSetOptimizerVersion("1");
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setOptimizerVersion("1");
        this.subject.statementSetOptimizerVersion("");
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setOptimizerVersion("");
        this.subject.statementSetOptimizerVersion("LATEST");
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setOptimizerVersion("LATEST");
    }

    @Test
    public void testStatementSetStatementTimeout() {
        this.subject.statementSetStatementTimeout(Duration.newBuilder().setNanos(100).build());
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setStatementTimeout(100L, TimeUnit.NANOSECONDS);
    }

    @Test
    public void testStatementSetTransactionMode() {
        this.subject.statementSetTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
        this.subject.statementSetTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
        ((ConnectionImpl)Mockito.verify((Object)this.connection)).setTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
    }
}

